/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.refractionapi.refraction.helper.registry.block.BaseHorizontalBlock;

public class WallHangingDecorBlock
extends BaseHorizontalBlock {
    public VoxelShape[] voxelShape;
    public boolean hangsOnWalls;

    public WallHangingDecorBlock(VoxelShape[] voxelShape, boolean hangsOnWalls, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.hangsOnWalls = hangsOnWalls;
        this.voxelShape = voxelShape;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.canSurvive(state, (LevelReader)level, pos) ? super.updateShape(state, direction, neighborState, level, pos, neighborPos) : Blocks.AIR.defaultBlockState();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (this.hangsOnWalls) {
            Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
            return FaceAttachedHorizontalDirectionalBlock.canAttach((LevelReader)level, (BlockPos)pos, (Direction)direction);
        }
        return super.canSurvive(state, level, pos);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.voxelShape[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
    }
}

