/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mudhut.ffpackage.level.block.WallHangingDecorBlock;
import net.mudhut.ffpackage.util.FFPVoxelShapes;

public class WoodenWallPizzaBlock
extends WallHangingDecorBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty SLICES = IntegerProperty.create((String)"slices", (int)1, (int)4);

    public WoodenWallPizzaBlock(BlockBehaviour.Properties pProperties) {
        super(FFPVoxelShapes.WOOD_CLOUD, true, pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)SLICES, (Comparable)Integer.valueOf(1))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        super.getStateForPlacement(ctx);
        Level levelaccessor = ctx.getLevel();
        BlockPos blockpos = ctx.getClickedPos();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((Integer)blockState.getValue((Property)SLICES)) {
            default -> FFPVoxelShapes.WOOD_PIZZA_1[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
            case 2 -> FFPVoxelShapes.WOOD_PIZZA_2[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
            case 3 -> FFPVoxelShapes.WOOD_PIZZA_3[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
            case 4 -> FFPVoxelShapes.WOOD_PIZZA_4[((Direction)blockState.getValue((Property)FACING)).get2DDataValue()];
        };
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if ((Integer)state.getValue((Property)SLICES) < 4 && stack.is(this.asItem())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SLICES, (Comparable)Integer.valueOf((Integer)state.getValue((Property)SLICES) + 1)), 3);
            player.playSound(SoundEvents.WOOD_PLACE);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SLICES, FACING, WATERLOGGED});
    }
}

