/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.mudhut.ffpackage.level.block.BalloonBlock;
import net.mudhut.ffpackage.registries.FFPBlockEntityRegistry;
import net.refractionapi.refraction.helper.registry.block.BaseEntityBlock;
import org.jetbrains.annotations.NotNull;

public class BalloonBlockEntity
extends BaseEntityBlock {
    public int color1;
    public int color2;
    public int color3;
    public int color4;

    public BalloonBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FFPBlockEntityRegistry.BALLOONS.get(), pPos, pBlockState);
        this.color1 = ((BalloonBlock)pBlockState.getBlock()).dyeColor.getId();
        this.color2 = ((BalloonBlock)pBlockState.getBlock()).dyeColor.getId();
        this.color3 = ((BalloonBlock)pBlockState.getBlock()).dyeColor.getId();
        this.color4 = ((BalloonBlock)pBlockState.getBlock()).dyeColor.getId();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("color1", this.color1);
        tag.putInt("color2", this.color2);
        tag.putInt("color3", this.color3);
        tag.putInt("color4", this.color4);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.color1 = tag.getInt("color1");
        this.color2 = tag.getInt("color2");
        this.color3 = tag.getInt("color3");
        this.color4 = tag.getInt("color4");
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void setColor(int color, DyeColor dyeColor) {
        switch (color) {
            case 1: {
                this.color1 = dyeColor.getId();
                break;
            }
            case 2: {
                this.color2 = dyeColor.getId();
                break;
            }
            case 3: {
                this.color3 = dyeColor.getId();
                break;
            }
            case 4: {
                this.color4 = dyeColor.getId();
            }
        }
    }

    public int getColor(int color) {
        return switch (color) {
            case 1 -> this.color1;
            case 2 -> this.color2;
            case 3 -> this.color3;
            case 4 -> this.color4;
            default -> DyeColor.WHITE.getId();
        };
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void tick() {
    }
}

