/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.mudhut.ffpackage.level.item.components.CardboardBoxItemstackComponent;
import net.mudhut.ffpackage.registries.FFPBlockEntityRegistry;
import net.mudhut.ffpackage.registries.FFPDataComponents;
import net.refractionapi.refraction.helper.registry.block.BaseEntityBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardboardBoxBlockEntity
extends BaseEntityBlock {
    private ItemStack itemStack = ItemStack.EMPTY;

    public CardboardBoxBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FFPBlockEntityRegistry.CARDBOARD_BOX.get(), pPos, pBlockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.itemStack.isEmpty()) {
            tag.put("itemStack", this.itemStack.save(registries, (Tag)tag));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemStack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("itemStack")).orElse(ItemStack.EMPTY);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        CardboardBoxItemstackComponent cardboardBoxItem = (CardboardBoxItemstackComponent)componentInput.get(FFPDataComponents.CARDBOARD_BOX_ITEM);
        if (cardboardBoxItem != null && !cardboardBoxItem.itemStack().isEmpty()) {
            this.itemStack = cardboardBoxItem.itemStack();
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (!this.itemStack.isEmpty()) {
            components.set(FFPDataComponents.CARDBOARD_BOX_ITEM, (Object)new CardboardBoxItemstackComponent(this.itemStack));
        }
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void tick() {
    }
}

