/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block.entity;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.AreaLight;
import foundry.veil.api.client.render.light.Light;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.level.block.RedstoneSpotlightBlock;
import net.mudhut.ffpackage.registries.FFPBlockEntityRegistry;
import net.refractionapi.refraction.helper.registry.block.BaseEntityBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class RedstoneSpotlightBlockEntity
extends BaseEntityBlock {
    public AreaLight areaLight;
    public int colorId = DyeColor.WHITE.getTextureDiffuseColor();

    public RedstoneSpotlightBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FFPBlockEntityRegistry.REDSTONE_SPOTLIGHT.get(), pPos, pBlockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("colorId", this.colorId);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.colorId = tag.getInt("colorId");
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void changeColor(int colorId) {
        this.colorId = colorId;
        this.setChanged();
    }

    public void setRemoved() {
        if (this.areaLight != null) {
            VeilRenderSystem.renderer().getLightRenderer().removeLight((Light)this.areaLight);
            this.areaLight = null;
        }
        super.setRemoved();
    }

    public void tick() {
        if (this.level != null && !this.level.isClientSide) {
            return;
        }
        if (((Boolean)this.getBlockState().getValue((Property)RedstoneSpotlightBlock.LIT)).booleanValue()) {
            BlockPos pos = this.getBlockPos();
            int rotation = (Integer)this.getBlockState().getValue((Property)RedstoneSpotlightBlock.ROTATION);
            Vector2f size = new Vector2f(0.13f, 0.13f);
            Vec3 position = switch (rotation) {
                default -> pos.getCenter().add(0.0, 0.0, 0.0);
                case 0 -> pos.getCenter().add(0.0, 0.0, (double)-0.2f);
                case 1 -> pos.getCenter().add((double)0.08f, 0.0, (double)-0.2f);
                case 2 -> pos.getCenter().add((double)0.15f, 0.0, (double)-0.15f);
                case 3 -> pos.getCenter().add((double)0.2f, 0.0, (double)-0.08f);
                case 4 -> pos.getCenter().add((double)0.2f, 0.0, 0.0);
                case 5 -> pos.getCenter().add((double)0.2f, 0.0, (double)0.08f);
                case 6 -> pos.getCenter().add((double)0.15f, 0.0, (double)0.15f);
                case 7 -> pos.getCenter().add((double)0.08f, 0.0, (double)0.2f);
                case 8 -> pos.getCenter().add(0.0, 0.0, (double)0.23f);
                case 9 -> pos.getCenter().add((double)-0.08f, 0.0, (double)0.2f);
                case 10 -> pos.getCenter().add((double)-0.15f, 0.0, (double)0.15f);
                case 11 -> pos.getCenter().add((double)-0.2f, 0.0, (double)0.08f);
                case 12 -> pos.getCenter().add((double)-0.23f, 0.0, 0.0);
                case 13 -> pos.getCenter().add((double)-0.2f, 0.0, (double)-0.08f);
                case 14 -> pos.getCenter().add((double)-0.15f, 0.0, (double)-0.15f);
                case 15 -> pos.getCenter().add((double)-0.08f, 0.0, (double)-0.2f);
            };
            if (this.areaLight == null) {
                this.areaLight = new AreaLight();
                VeilRenderSystem.renderer().getLightRenderer().addLight(this.areaLight.setBrightness(4.12f).setSize((double)size.x, (double)size.y).setDistance(25.0f).setColor(this.colorId));
            } else {
                this.areaLight.setColor(this.colorId);
                this.areaLight.setAngle((float)Math.toRadians(26.9f));
                this.areaLight.setOrientation((Quaternionfc)new Quaternionf().rotateXYZ((Boolean)this.getBlockState().getValue((Property)RedstoneSpotlightBlock.HANGING) != false ? -0.52f : 0.52f, (float)Math.toRadians(180.0 + (double)rotation * 22.5), 0.0f));
                this.areaLight.setPosition((Vector3dc)new Vector3d(position.x, position.y, position.z));
            }
        } else if (this.areaLight != null) {
            VeilRenderSystem.renderer().getLightRenderer().removeLight((Light)this.areaLight);
            this.areaLight = null;
        }
    }
}

