/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block.entity;

import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.level.inventory.ShowtapeTerminalMenu;
import net.mudhut.ffpackage.level.item.FazWrenchItem;
import net.mudhut.ffpackage.level.item.components.FazWrenchComponent;
import net.mudhut.ffpackage.registries.FFPBlockEntityRegistry;
import net.mudhut.ffpackage.registries.FFPBlockRegistry;
import net.mudhut.ffpackage.registries.FFPDataComponents;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.refractionapi.refraction.helper.registry.block.BaseEntityBlock;
import net.refractionapi.refraction.helper.vfx.VFXHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ShowtapeTerminalBlockEntity
extends BaseEntityBlock
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            ShowtapeTerminalBlockEntity.this.setChanged();
            if (!ShowtapeTerminalBlockEntity.this.level.isClientSide()) {
                ShowtapeTerminalBlockEntity.this.level.sendBlockUpdated(ShowtapeTerminalBlockEntity.this.getBlockPos(), ShowtapeTerminalBlockEntity.this.getBlockState(), ShowtapeTerminalBlockEntity.this.getBlockState(), 6);
            }
        }
    };
    protected final ContainerData data = new ContainerData(this){

        public int get(int i) {
            return 6;
        }

        public void set(int i, int value) {
        }

        public int getCount() {
            return 6;
        }
    };
    public boolean isActive = false;

    public ShowtapeTerminalBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FFPBlockEntityRegistry.SHOWTAPE_TERMINAL.get(), pPos, pBlockState);
    }

    public void tick() {
        if (this.getLevel() == null) {
            return;
        }
        for (Entity entity : this.getLevel().getEntities(null, new AABB(this.getBlockPos()).inflate(60.0))) {
            FazWrenchItem fazWrenchItem;
            FazWrenchComponent selectedPlayer;
            Player player;
            Item item;
            if (!(entity instanceof Player) || !((item = (player = (Player)entity).getMainHandItem().getItem()) instanceof FazWrenchItem) || (selectedPlayer = (FazWrenchComponent)(fazWrenchItem = (FazWrenchItem)item).components().get((DataComponentType)FFPDataComponents.FAZ_WRENCH.get())) == null) continue;
            BlockPos selectedPlayerPos = fazWrenchItem.getSelectedPlayer(player.getMainHandItem());
            if (selectedPlayerPos.equals((Object)BlockPos.ZERO)) {
                return;
            }
            if (this.getLevel() != null && !this.getLevel().getBlockState(selectedPlayerPos).is(FFPBlockRegistry.SHOWTAPE_TERMINAL)) {
                player.getMainHandItem().set(FFPDataComponents.FAZ_WRENCH, (Object)new FazWrenchComponent(new Vector3f()));
                return;
            }
            for (Entity endoEntity : player.level().getEntities((Entity)player, player.getBoundingBox().inflate(60.0))) {
                if (!(endoEntity instanceof Endo01)) continue;
                Endo01 endo01 = (Endo01)endoEntity;
                Level level = this.getLevel();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                Color eyeColor = new Color(255, 255, 255);
                switch (endo01.getAnimatronicType()) {
                    case 1: {
                        eyeColor = new Color(83, 79, 162);
                        break;
                    }
                    case 2: {
                        eyeColor = new Color(114, 68, 43);
                        break;
                    }
                    case 3: {
                        eyeColor = new Color(255, 213, 0);
                        break;
                    }
                    case 4: {
                        eyeColor = new Color(147, 22, 5);
                    }
                }
                if (!selectedPlayerPos.equals((Object)endo01.getShowtapePlayerPos()) || this.tickCount % 20 != 0) continue;
                VFXHelper.particleLine((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)eyeColor.getRGB()).toVector3f(), 2.0f), (Vec3)endo01.position().add(0.0, 1.0, 0.0), (Vec3)selectedPlayerPos.getCenter(), (ServerLevel)serverLevel);
            }
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.empty();
    }

    public void drops() {
        SimpleContainer container = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            container.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)container);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putBoolean("isActive", this.isActive);
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isActive = tag.getBoolean("isActive");
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @javax.annotation.Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new ShowtapeTerminalMenu(containerId, playerInventory, (BlockEntity)this, this.data);
    }
}

