/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.mudhut.ffpackage.level.inventory.SodaMachineConfigMenu;
import net.mudhut.ffpackage.level.inventory.SodaMachineFillMenu;
import net.mudhut.ffpackage.registries.FFPBlockEntityRegistry;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPSoundRegistry;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.refractionapi.refraction.helper.registry.block.BaseEntityBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SodaStandBlockEntity
extends BaseEntityBlock
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            SodaStandBlockEntity.this.setChanged();
            if (!SodaStandBlockEntity.this.level.isClientSide()) {
                SodaStandBlockEntity.this.level.sendBlockUpdated(SodaStandBlockEntity.this.getBlockPos(), SodaStandBlockEntity.this.getBlockState(), SodaStandBlockEntity.this.getBlockState(), 9);
            }
        }
    };
    protected final ContainerData data = new ContainerData(){

        public int get(int i) {
            return switch (i) {
                case 0 -> SodaStandBlockEntity.this.soda1Progress;
                case 1 -> SodaStandBlockEntity.this.soda2Progress;
                case 2 -> SodaStandBlockEntity.this.soda3Progress;
                case 3 -> SodaStandBlockEntity.this.syrup1Uses;
                case 4 -> SodaStandBlockEntity.this.syrup2Uses;
                case 5 -> SodaStandBlockEntity.this.syrup3Uses;
                case 6 -> SodaStandBlockEntity.this.water1Uses;
                case 7 -> SodaStandBlockEntity.this.water2Uses;
                case 8 -> SodaStandBlockEntity.this.water3Uses;
                default -> 0;
            };
        }

        public void set(int i, int value) {
            switch (i) {
                case 0: {
                    SodaStandBlockEntity.this.soda1Progress = value;
                }
                case 1: {
                    SodaStandBlockEntity.this.soda2Progress = value;
                }
                case 2: {
                    SodaStandBlockEntity.this.soda3Progress = value;
                }
                case 3: {
                    SodaStandBlockEntity.this.syrup1Uses = value;
                }
                case 4: {
                    SodaStandBlockEntity.this.syrup2Uses = value;
                }
                case 5: {
                    SodaStandBlockEntity.this.syrup3Uses = value;
                }
                case 6: {
                    SodaStandBlockEntity.this.water1Uses = value;
                }
                case 7: {
                    SodaStandBlockEntity.this.water2Uses = value;
                }
                case 8: {
                    SodaStandBlockEntity.this.water3Uses = value;
                }
            }
        }

        public int getCount() {
            return 9;
        }
    };
    public int water1Uses = 0;
    public int water2Uses = 0;
    public int water3Uses = 0;
    public int syrup1Uses = 0;
    public int syrup2Uses = 0;
    public int syrup3Uses = 0;
    public int soda1Progress = 0;
    public int soda2Progress = 0;
    public int soda3Progress = 0;
    public String soda1Background = "textures/gui/sprites/widget/sign_empty.png";
    public String soda2Background = "textures/gui/sprites/widget/sign_empty.png";
    public String soda3Background = "textures/gui/sprites/widget/sign_empty.png";

    public SodaStandBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FFPBlockEntityRegistry.SODA_STAND_BE.get(), pPos, pBlockState);
    }

    public void drops() {
        SimpleContainer container = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            container.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)container);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("soda1Progress", this.soda1Progress);
        tag.putInt("soda2Progress", this.soda3Progress);
        tag.putInt("soda3Progress", this.soda2Progress);
        tag.putString("soda1Background", this.soda1Background);
        tag.putString("soda2Background", this.soda2Background);
        tag.putString("soda3Background", this.soda3Background);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        this.soda1Progress = tag.getInt("soda1Progress");
        this.soda2Progress = tag.getInt("soda2Progress");
        this.soda3Progress = tag.getInt("soda3Progress");
        this.soda1Background = tag.getString("soda1Background");
        this.soda2Background = tag.getString("soda2Background");
        this.soda3Background = tag.getString("soda3Background");
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return player.getMainHandItem().is(FFPItemRegistry.FAZ_WRENCH) ? new SodaMachineConfigMenu(containerId, playerInventory, (BlockEntity)this, this.data) : new SodaMachineFillMenu(containerId, playerInventory, (BlockEntity)this, this.data);
    }

    public void fillSoda(int slot) {
        ItemStack syrupItem = this.itemHandler.getStackInSlot(slot + 6);
        if (syrupItem.is(FFPItemRegistry.FIZZY_SYRUP)) {
            this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)FFPItemRegistry.FIZZY_FAZ_CUP.asItem()));
        } else if (syrupItem.is(FFPItemRegistry.CHICA_SYRUP)) {
            this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)FFPItemRegistry.CHICA_CHUG_CUP.asItem()));
        } else if (syrupItem.is(FFPItemRegistry.FOXY_SYRUP)) {
            this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)FFPItemRegistry.COVE_COOLER_CUP.asItem()));
        } else if (syrupItem.is(FFPItemRegistry.BUTTER_SYRUP)) {
            this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)FFPItemRegistry.EXOTIC_BEVERAGE_CUP.asItem()));
        } else if (syrupItem.is(FFPItemRegistry.SODARONI_SYRUP)) {
            this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)FFPItemRegistry.SODARONI_CUP.asItem()));
        }
    }

    public String getSignTexture(int slot) {
        ItemStack syrupItem = this.itemHandler.getStackInSlot(slot + 6);
        if (syrupItem.is(FFPItemRegistry.FIZZY_SYRUP)) {
            return "textures/gui/sprites/widget/fizzy_faz_sign.png";
        }
        if (syrupItem.is(FFPItemRegistry.CHICA_SYRUP)) {
            return "textures/gui/sprites/widget/chica_chug_sign.png";
        }
        if (syrupItem.is(FFPItemRegistry.FOXY_SYRUP)) {
            return "textures/gui/sprites/widget/foxy_cove_cooler_sign.png";
        }
        if (syrupItem.is(FFPItemRegistry.BUTTER_SYRUP)) {
            return "textures/gui/sprites/widget/exotic_beverage_sign.png";
        }
        if (syrupItem.is(FFPItemRegistry.SODARONI_SYRUP)) {
            return "textures/gui/sprites/widget/sodaroni_sign.png";
        }
        return "textures/gui/sprites/widget/sign_empty.png";
    }

    public void tick() {
        if (this.itemHandler.getStackInSlot(0).is(FFPItemRegistry.EMPTY_CUP) && !this.itemHandler.getStackInSlot(6).is(Items.AIR) && !this.itemHandler.getStackInSlot(3).is(Items.AIR)) {
            if (this.soda1Progress == 1) {
                this.playPouringSound();
            }
            if (this.soda1Progress != 72) {
                ++this.soda1Progress;
            } else {
                this.fillSoda(0);
                ++this.syrup1Uses;
                ++this.water1Uses;
            }
        } else {
            this.soda1Progress = 0;
        }
        if (this.itemHandler.getStackInSlot(1).is(FFPItemRegistry.EMPTY_CUP) && !this.itemHandler.getStackInSlot(7).is(Items.AIR) && !this.itemHandler.getStackInSlot(4).is(Items.AIR)) {
            if (this.soda2Progress == 1) {
                this.playPouringSound();
            }
            if (this.soda2Progress != 72) {
                ++this.soda2Progress;
            } else {
                this.fillSoda(1);
                ++this.syrup2Uses;
                ++this.water2Uses;
            }
        } else {
            this.soda2Progress = 0;
        }
        if (this.itemHandler.getStackInSlot(2).is(FFPItemRegistry.EMPTY_CUP) && !this.itemHandler.getStackInSlot(8).is(Items.AIR) && !this.itemHandler.getStackInSlot(5).is(Items.AIR)) {
            if (this.soda3Progress == 1) {
                this.playPouringSound();
            }
            if (this.soda3Progress != 72) {
                ++this.soda3Progress;
            } else {
                this.fillSoda(2);
                ++this.syrup3Uses;
                ++this.water3Uses;
            }
        } else {
            this.soda3Progress = 0;
        }
        if (this.water1Uses >= 48) {
            this.itemHandler.setStackInSlot(3, ItemStack.EMPTY);
            this.water1Uses = 0;
        }
        if (this.syrup1Uses >= 32) {
            this.itemHandler.setStackInSlot(6, ItemStack.EMPTY);
            this.syrup1Uses = 0;
        }
        if (this.water2Uses >= 48) {
            this.itemHandler.setStackInSlot(4, ItemStack.EMPTY);
            this.water2Uses = 0;
        }
        if (this.syrup2Uses >= 32) {
            this.itemHandler.setStackInSlot(7, ItemStack.EMPTY);
            this.syrup2Uses = 0;
        }
        if (this.water3Uses >= 48) {
            this.itemHandler.setStackInSlot(5, ItemStack.EMPTY);
            this.water3Uses = 0;
        }
        if (this.syrup3Uses >= 32) {
            this.itemHandler.setStackInSlot(8, ItemStack.EMPTY);
            this.syrup3Uses = 0;
        }
    }

    public void playPouringSound() {
        this.level.playSound(null, this.getBlockPos(), (SoundEvent)FFPSoundRegistry.SODA_POURING.get(), SoundSource.BLOCKS);
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

