/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.entity;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.level.block.ClothTableBlock;
import net.mudhut.ffpackage.level.block.entity.ShowtapeTerminalBlockEntity;
import net.mudhut.ffpackage.level.entity.goals.EndoAttackGoal;
import net.mudhut.ffpackage.level.entity.goals.EndoStrollGoal;
import net.mudhut.ffpackage.level.inventory.EndoConfigMenu;
import net.mudhut.ffpackage.level.item.CPUItem;
import net.mudhut.ffpackage.level.item.FazWrenchItem;
import net.mudhut.ffpackage.level.item.PlushSuitItem;
import net.mudhut.ffpackage.level.item.components.CPUOverheatComponent;
import net.mudhut.ffpackage.level.item.components.EndoSpawnerComponents;
import net.mudhut.ffpackage.level.item.components.FazWrenchComponent;
import net.mudhut.ffpackage.networking.FFPMessages;
import net.mudhut.ffpackage.networking.S2C.OpenEndoScreenPacket;
import net.mudhut.ffpackage.registries.FFPDataComponents;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPSoundRegistry;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.fluids.FluidType;
import net.refractionapi.refraction.helper.entity.FrozenManager;
import net.refractionapi.refraction.helper.misc.RefractionMisc;
import net.refractionapi.refraction.helper.runnable.Runnabler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class Endo01
extends PathfinderMob
implements NeutralMob,
ContainerListener,
HasCustomInventoryScreen {
    private static final ResourceLocation SPEED_MODIFIER_ID = ResourceLocation.withDefaultNamespace((String)"chasing");
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(SPEED_MODIFIER_ID, 0.3, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final EntityDataAccessor<Boolean> IDLE = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ACTIVATED = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_DANCING = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> DATA_COLOR_ID = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> CURRENT_POSE = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_POSSESSED = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<BlockPos> SPAWN_POSITION = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Float> SPAWN_ROTATION = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<BlockPos> SHOWTAPE_PLAYER_POS = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Integer> EYE_DECOR = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ANIMATRONIC_TYPE = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FOXY_STATE = SynchedEntityData.defineId(Endo01.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState idleState = new AnimationState();
    public final AnimationState danceState = new AnimationState();
    public final AnimationState possessionState = new AnimationState();
    public final AnimationState crouchState = new AnimationState();
    public final AnimationState attackState = new AnimationState();
    public final AnimationState jumpscareState = new AnimationState();
    public final AnimationState glitchState = new AnimationState();
    public final AnimationState overheatState = new AnimationState();
    public final AnimationState foxy_idle_1 = new AnimationState();
    public final AnimationState foxy_idle_2 = new AnimationState();
    public SimpleContainer inventory;
    private boolean isCrouched = false;
    public int possessTick = 0;
    public boolean jumpscaring = false;
    public boolean reachedHome = true;
    public final AnimationState pose1 = new AnimationState();
    public final AnimationState pose2 = new AnimationState();
    public final AnimationState pose3 = new AnimationState();
    public final AnimationState pose4 = new AnimationState();

    public Endo01(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setPersistenceRequired();
        this.createInventory();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MAX_HEALTH, 35.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 100.0).add(Attributes.ATTACK_DAMAGE, 4.5).add(Attributes.ATTACK_KNOCKBACK, 0.1).add(Attributes.ARMOR, 2.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new EndoStrollGoal(this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new EndoAttackGoal(this, 1.0, false));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<Player>(this, (Mob)this, Player.class, true, true){

            public boolean canUse() {
                return super.canUse() && this.target != null && (!this.target.isVisuallyCrawling() || !(this.target.getInBlockState().getBlock() instanceof ClothTableBlock));
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && this.target != null && (!this.target.isVisuallyCrawling() || !(this.target.getInBlockState().getBlock() instanceof ClothTableBlock));
            }
        });
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(1);
        if (simplecontainer != null) {
            simplecontainer.removeListener((ContainerListener)this);
            int i = Math.min(simplecontainer.getContainerSize(), this.inventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.inventory.setItem(j, itemstack.copy());
            }
        }
        this.inventory.addListener((ContainerListener)this);
    }

    public Container getInventory() {
        return this.inventory;
    }

    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)FFPItemRegistry.ASSEMBLED_ENDO_01.get());
    }

    private void setupAnimationStates() {
        this.idleState.animateWhen(!this.isDancing() && !this.navigation.isInProgress() && this.getFoxyState() != 1 && this.getFoxyState() != 2 && this.getCurrentPose() <= 1 && this.getState() != EndoState.OVERHEAT && !this.isCrouched, this.tickCount);
        this.crouchState.animateWhen(this.isCrouched && this.getCurrentPose() != 2, this.tickCount);
        this.possessionState.animateWhen(this.possessTick <= 20 && this.possessTick > 0, this.tickCount);
        this.attackState.animateWhen(this.swinging && this.level().isNight() && !this.jumpscaring, this.tickCount);
        this.jumpscareState.animateWhen(this.jumpscaring, this.tickCount);
        this.danceState.animateWhen(this.isDancing() && this.isActivated() && this.shouldBeIdle(), this.tickCount);
        this.glitchState.animateWhen(this.getState() == EndoState.GLITCH, this.tickCount);
        this.overheatState.animateWhen(this.getState() == EndoState.OVERHEAT, this.tickCount);
        this.foxy_idle_1.animateWhen(this.getFoxyState() == 1, this.tickCount);
        this.foxy_idle_2.animateWhen(this.getFoxyState() == 2, this.tickCount);
        this.pose1.animateWhen(this.getCurrentPose() == 1, this.tickCount);
        this.pose2.animateWhen(this.getCurrentPose() == 2, this.tickCount);
        this.pose3.animateWhen(this.getCurrentPose() == 3, this.tickCount);
        this.pose4.animateWhen(this.getCurrentPose() == 4, this.tickCount);
    }

    public void tick() {
        super.tick();
        if (this.getTarget() == null) {
            this.jumpscaring = false;
            FrozenManager.unfreeze((LivingEntity)this);
        }
        if (!this.level().isClientSide) {
            this.entityData.set(IDLE, (Object)this.isIdle());
            ShowtapeTerminalBlockEntity showtapePlayerBlockEntity = (ShowtapeTerminalBlockEntity)this.level().getBlockEntity(this.getShowtapePlayerPos());
            if (showtapePlayerBlockEntity != null) {
                if (this.isActivated() && !this.getShowtapePlayerPos().equals((Object)BlockPos.ZERO)) {
                    this.setDancing(showtapePlayerBlockEntity.isActive);
                } else {
                    this.setDancing(false);
                }
            } else {
                this.setDancing(false);
                this.setShowtapePlayerPos(BlockPos.ZERO);
            }
            if (this.isInWaterOrRain() || this.isUnderWater()) {
                this.hurt(RefractionMisc.damageSource((ResourceKey)DamageTypes.GENERIC, (Level)this.level()), 2.5f);
            }
            if (this.getAnimatronicType() != 4) {
                this.setFoxyState(0);
            } else if (this.getTarget() == null || this.getTarget().isDeadOrDying()) {
                this.getNavigation().stop();
                Vec3 position = this.getSpawnPosition().getBottomCenter();
                this.yBodyRot = this.getSpawnRotation();
                this.yRot = this.getSpawnRotation();
                this.moveTo(position.x, position.y, position.z);
                if (this.level().isDay()) {
                    this.setFoxyState(0);
                }
            }
            ItemStack itemStack = this.getInventory().getItem(0);
            CPUOverheatComponent overheatComponent = (CPUOverheatComponent)itemStack.get((DataComponentType)FFPDataComponents.CPU_OVERHEAT.value());
            if (this.isDancing()) {
                for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                    ItemStack slotItem = this.getItemBySlot(equipmentSlot);
                    if (this.tickCount % 6000 != 0 || slotItem.isEmpty()) continue;
                    slotItem.hurtAndBreak(5, (LivingEntity)this, equipmentSlot);
                    this.hurt(RefractionMisc.damageSource((ResourceKey)DamageTypes.FELL_OUT_OF_WORLD, (Level)this.level()), 5.0f);
                }
                if (itemStack.getItem() instanceof CPUItem && overheatComponent != null) {
                    if (this.random.nextInt(0, this.isPossessed() || overheatComponent.overheat() >= 70 ? 900 : 15000) == 0) {
                        this.setState(EndoState.GLITCH);
                        Runnabler.create().delayRun(20, runnabler -> this.setState(EndoState.NORMAL));
                    }
                    if (this.tickCount % 200 == 0) {
                        int overHeat = overheatComponent.overheat();
                        itemStack.set(FFPDataComponents.CPU_OVERHEAT, (Object)new CPUOverheatComponent(++overHeat));
                    }
                    if (overheatComponent.overheat() >= 115) {
                        this.getInventory().setItem(0, new ItemStack((ItemLike)FFPItemRegistry.BURNT_CPU.get()));
                        this.setState(EndoState.OVERHEAT);
                        this.setActivated(false);
                        this.hurt(RefractionMisc.damageSource((ResourceKey)DamageTypes.FELL_OUT_OF_WORLD, (Level)this.level()), 5.0f);
                        this.playSound(SoundEvents.GENERIC_BURN);
                        Runnabler.create().delayRun(40, runnabler -> this.setState(EndoState.NORMAL));
                    }
                } else {
                    this.setActivated(false);
                }
            }
        }
        if (this.level().isNight() && this.isPossessed()) {
            this.reachedHome = false;
            this.setCurrentPose(0);
        }
        if (!this.level().isClientSide && this.getSpawnPosition().distToCenterSqr((Position)this.position()) < 0.001 && this.isIdle()) {
            this.tickHome();
            this.moveTo(this.getSpawnPosition().getCenter());
        } else if (this.level().isClientSide && ((Boolean)this.entityData.get(IDLE)).booleanValue()) {
            this.tickHome();
        }
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (!this.level().isClientSide && attributeinstance != null) {
            attributeinstance.removeModifier(SPEED_MODIFIER_ID);
            if (this.isAggressive()) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER);
            } else {
                attributeinstance.removeModifier(SPEED_MODIFIER_ID);
            }
        }
        if (this.possessTick >= 20) {
            --this.possessTick;
        }
        this.isCrouched = Block.canSupportCenter((LevelReader)this.level(), (BlockPos)this.blockPosition().offset(0, 2, 0), (Direction)Direction.DOWN);
        if (this.isActivated() && this.getCurrentPose() >= 2) {
            this.setCurrentPose(0);
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.onSpawn();
    }

    public void onSpawn() {
        this.reachedHome();
        this.yBodyRotO = this.getSpawnRotation();
        this.yBodyRot = this.getSpawnRotation();
    }

    public void tickHome() {
        this.yBodyRot = this.getSpawnRotation();
        this.yBodyRotO = this.getSpawnRotation();
        this.yHeadRot = this.getSpawnRotation();
    }

    public void reachedHome() {
        this.getNavigation().stop();
        this.yBodyRot = this.getSpawnRotation();
        this.yBodyRotO = this.getSpawnRotation();
        this.yHeadRot = this.getSpawnRotation();
        this.reachedHome = true;
    }

    public boolean isIdle() {
        return this.level().isClientSide ? (Boolean)this.entityData.get(IDLE) : this.shouldBeIdle() && this.reachedHome;
    }

    public boolean shouldBeIdle() {
        return !this.level().isNight() || !this.isPossessed() || this.isActivated() || this.getAnimatronicType() == 0;
    }

    public void onDamageTaken(DamageContainer damageContainer) {
        super.onDamageTaken(damageContainer);
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (this.getItemBySlot(equipmentSlot).isEmpty() || damageContainer.getSource().equals(RefractionMisc.damageSource((ResourceKey)DamageTypes.FELL_OUT_OF_WORLD, (Level)this.level()))) continue;
            this.getItemBySlot(equipmentSlot).hurtAndBreak(2, (LivingEntity)this, equipmentSlot);
        }
    }

    @NotNull
    public InteractionResult interactAt(Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        if (player.level().isClientSide || hand == InteractionHand.OFF_HAND || player.level().isNight() && this.isPossessed()) {
            return InteractionResult.FAIL;
        }
        EquipmentSlot interactedSlot = this.getClickedSlot(vec);
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        boolean shears = item.equals(Items.SHEARS);
        if (itemStack.is(FFPItemRegistry.FAZ_WRENCH) && !Objects.requireNonNull((FazWrenchComponent)player.getMainHandItem().get((DataComponentType)FFPDataComponents.FAZ_WRENCH.value())).blockPos().equals((Object)new Vector3f())) {
            return InteractionResult.SUCCESS;
        }
        if (!this.isActivated() && !player.isCrouching() && interactedSlot != null) {
            if (item instanceof PlushSuitItem) {
                PlushSuitItem plushSuitItem = (PlushSuitItem)item;
                if (interactedSlot.equals((Object)plushSuitItem.getType().getSlot())) {
                    if (this.getItemBySlot(interactedSlot).isEmpty()) {
                        this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value());
                        this.setItemSlot(interactedSlot, itemStack.copy());
                        itemStack.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (shears) {
                player.getInventory().add(this.getItemBySlot(interactedSlot));
                this.playSound(SoundEvents.SHEEP_SHEAR);
                this.setItemSlot(interactedSlot, ItemStack.EMPTY);
                return InteractionResult.SUCCESS;
            }
            if (interactedSlot.getType().equals((Object)EquipmentSlot.Type.HAND)) {
                InteractionHand setHand;
                InteractionHand interactionHand = setHand = interactedSlot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                if (this.getItemInHand(setHand).isEmpty()) {
                    if (!itemStack.isEmpty()) {
                        this.playSound(SoundEvents.ITEM_FRAME_ADD_ITEM);
                    }
                    this.setItemInHand(setHand, player.getMainHandItem());
                    player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    FFPackage.LOGGER.info("Gave item to {}", (Object)setHand);
                } else if (itemStack.isEmpty()) {
                    this.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM);
                    player.setItemInHand(InteractionHand.MAIN_HAND, this.getItemInHand(setHand));
                    this.setItemInHand(setHand, ItemStack.EMPTY);
                    FFPackage.LOGGER.info("Took item from {}", (Object)setHand);
                } else {
                    player.getInventory().add(this.getItemInHand(setHand));
                }
                return InteractionResult.SUCCESS;
            }
            if (itemStack.is(Items.IRON_INGOT)) {
                if (this.getHealth() < this.getMaxHealth()) {
                    this.heal(8.0f);
                    itemStack.shrink(1);
                    this.playSound(SoundEvents.IRON_GOLEM_REPAIR);
                    return InteractionResult.SUCCESS;
                }
            } else if (itemStack.is(Items.IRON_NUGGET)) {
                if (this.getHealth() < this.getMaxHealth()) {
                    this.heal(4.0f);
                    itemStack.shrink(1);
                    this.playSound(SoundEvents.IRON_GOLEM_REPAIR);
                    return InteractionResult.SUCCESS;
                }
            } else if (itemStack.is(Items.IRON_BLOCK) && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getMaxHealth());
                itemStack.shrink(1);
                this.playSound(SoundEvents.IRON_GOLEM_REPAIR);
                return InteractionResult.SUCCESS;
            }
        }
        if (itemStack.is(FFPItemRegistry.SCREWDRIVER)) {
            if (interactedSlot == EquipmentSlot.HEAD && this.getEyeDecor() > 0) {
                player.getInventory().add(this.getEyeDecor() == 1 ? new ItemStack((ItemLike)Items.GLOWSTONE_DUST) : (this.getEyeDecor() == 2 ? new ItemStack((ItemLike)Items.REDSTONE) : new ItemStack((ItemLike)Items.AMETHYST_SHARD)));
                this.setEyeDecor(0);
                this.playSound((SoundEvent)FFPSoundRegistry.SCREWDRIVER_USE.get());
                return InteractionResult.SUCCESS;
            }
            if (interactedSlot == EquipmentSlot.CHEST) {
                this.playSound((SoundEvent)FFPSoundRegistry.SCREWDRIVER_USE.get());
                this.openCustomInventoryScreen(player);
                return InteractionResult.SUCCESS;
            }
        }
        return super.interactAt(player, vec, hand);
    }

    private EquipmentSlot getClickedSlot(Vec3 vector) {
        EquipmentSlot equipmentslot = null;
        double vecY = vector.y / (double)(this.getScale() * this.getAgeScale());
        double vecX = vector.x / (double)(this.getScale() * this.getAgeScale());
        double vecZ = vector.z / (double)(this.getScale() * this.getAgeScale());
        if (vecY >= 0.1 && vecY < 0.55) {
            equipmentslot = EquipmentSlot.FEET;
        }
        if (vecY >= 0.9 && vecY < 1.6) {
            equipmentslot = EquipmentSlot.CHEST;
        }
        if (vecY >= 0.4 && vecY < 1.2000000000000002) {
            equipmentslot = EquipmentSlot.LEGS;
        }
        if (vecY >= 1.6) {
            equipmentslot = EquipmentSlot.HEAD;
        }
        if (this.getDirection() == Direction.NORTH ? vecX <= -0.15 : (this.getDirection() == Direction.SOUTH ? vecX >= 0.15 : (this.getDirection() == Direction.WEST ? vecZ >= 0.15 : vecZ <= -0.15))) {
            equipmentslot = EquipmentSlot.OFFHAND;
        }
        if (this.getDirection() == Direction.NORTH ? vecX >= 0.15 : (this.getDirection() == Direction.SOUTH ? vecX <= -0.15 : (this.getDirection() == Direction.WEST ? vecZ <= -0.15 : vecZ >= 0.15))) {
            equipmentslot = EquipmentSlot.MAINHAND;
        }
        return equipmentslot;
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (player.level().isNight() && this.isPossessed() || this.isActivated()) {
            return InteractionResult.FAIL;
        }
        if (player.isCrouching()) {
            if (item instanceof DyeItem) {
                DyeItem dyeitem = (DyeItem)item;
                DyeColor dyecolor = dyeitem.getDyeColor();
                if (dyecolor != this.getDyeColor()) {
                    this.setColor(dyecolor);
                    this.level().playSound(player, this.blockPosition(), SoundEvents.DYE_USE, SoundSource.AMBIENT);
                    if (!player.getAbilities().instabuild) {
                        itemStack.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (this.getEyeDecor() == 0 && (itemStack.is(Items.AMETHYST_SHARD) || itemStack.is(Items.GLOWSTONE_DUST) || itemStack.is(Items.REDSTONE))) {
                    if (!player.isCreative()) {
                        itemStack.shrink(1);
                    }
                    int eyeDecorType = itemStack.is(Items.AMETHYST_SHARD) ? 3 : (itemStack.is(Items.GLOWSTONE_DUST) ? 1 : 2);
                    this.setEyeDecor(eyeDecorType);
                    return InteractionResult.SUCCESS;
                }
                if (itemStack.is(FFPItemRegistry.FAZ_WRENCH)) {
                    if (!player.level().isClientSide) {
                        ItemStack endoSpawnEgg = FFPItemRegistry.ASSEMBLED_ENDO_01.toStack();
                        endoSpawnEgg.set((DataComponentType)FFPDataComponents.ENDO_SPAWNER.value(), (Object)new EndoSpawnerComponents(this.isPossessed(), this.getColor()));
                        player.getInventory().add(endoSpawnEgg);
                        player.getInventory().add(this.getInventory().getItem(0));
                        for (EquipmentSlot value : EquipmentSlot.values()) {
                            if (this.getItemBySlot(value).isEmpty()) continue;
                            player.getInventory().add(this.getItemBySlot(value));
                        }
                        this.discard();
                    }
                    return InteractionResult.SUCCESS;
                }
                if (itemStack.isEmpty()) {
                    if (this.getCurrentPose() > (this.isActivated() ? 1 : 2)) {
                        this.setCurrentPose(0);
                    } else {
                        this.setCurrentPose(this.getCurrentPose() + 1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        } else {
            Item endoSpawnEgg = itemStack.getItem();
            if (endoSpawnEgg instanceof FazWrenchItem) {
                FazWrenchItem fazWrenchItem = (FazWrenchItem)endoSpawnEgg;
                FazWrenchComponent fazWrenchComponent = (FazWrenchComponent)player.getMainHandItem().get((DataComponentType)FFPDataComponents.FAZ_WRENCH.value());
                if (fazWrenchComponent != null) {
                    BlockPos selectedPlayerPos = fazWrenchItem.getSelectedPlayer(player.getMainHandItem());
                    if (!this.getShowtapePlayerPos().equals((Object)selectedPlayerPos)) {
                        this.level().playSound(player, this.blockPosition(), (SoundEvent)FFPSoundRegistry.FAZWRENCH_DISCHARGE.get(), SoundSource.NEUTRAL);
                        this.setShowtapePlayerPos(selectedPlayerPos);
                    } else {
                        this.level().playSound(player, this.blockPosition(), (SoundEvent)FFPSoundRegistry.FAZWRENCH_DISCHARGE.get(), SoundSource.NEUTRAL, 1.0f, 0.85f);
                        this.setShowtapePlayerPos(BlockPos.ZERO);
                    }
                    itemStack.set((DataComponentType)FFPDataComponents.FAZ_WRENCH.value(), (Object)new FazWrenchComponent(Vec3.ZERO.toVector3f()));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.mobInteract(player, hand);
    }

    protected float tickHeadTurn(float yRot, float animStep) {
        return super.tickHeadTurn(yRot, animStep);
    }

    public void setYBodyRot(float offset) {
        this.yBodyRotO = this.yRotO = offset;
        this.yHeadRotO = this.yHeadRot = offset;
    }

    public void setYHeadRot(float rotation) {
        this.yBodyRotO = this.yRotO = rotation;
        this.yHeadRotO = this.yHeadRot = rotation;
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
        boolean flag = this.getItemBySlot(EquipmentSlot.FEET).isEmpty();
        this.playSound(flag ? SoundEvents.COPPER_STEP : (SoundEvent)FFPSoundRegistry.ENDO_WALK.get(), 1.0f, 1.0f);
    }

    public byte getColor() {
        return (Byte)this.entityData.get(DATA_COLOR_ID);
    }

    public DyeColor getDyeColor() {
        return DyeColor.byId((int)((Byte)this.entityData.get(DATA_COLOR_ID) & 0xF));
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IDLE, (Object)false);
        builder.define(ACTIVATED, (Object)false);
        builder.define(IS_DANCING, (Object)false);
        builder.define(SPAWN_POSITION, (Object)new BlockPos(0, 0, 0));
        builder.define(SPAWN_ROTATION, (Object)Float.valueOf(0.0f));
        builder.define(DATA_COLOR_ID, (Object)0);
        builder.define(CURRENT_POSE, (Object)0);
        builder.define(IS_POSSESSED, (Object)false);
        builder.define(SHOWTAPE_PLAYER_POS, (Object)new BlockPos(0, 0, 0));
        builder.define(EYE_DECOR, (Object)0);
        builder.define(ANIMATRONIC_TYPE, (Object)0);
        builder.define(FOXY_STATE, (Object)0);
        builder.define(STATE, (Object)0);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("Color", (byte)this.getDyeColor().getId());
        compound.putInt("CurrentPose", this.getCurrentPose());
        compound.putBoolean("IsPossessed", this.isPossessed());
        compound.putFloat("SpawnRotation", this.getSpawnRotation());
        compound.putInt("SpawnX", this.getSpawnPosition().getX());
        compound.putInt("SpawnY", this.getSpawnPosition().getY());
        compound.putInt("SpawnZ", this.getSpawnPosition().getZ());
        compound.putInt("ShowPlayerX", this.getShowtapePlayerPos().getX());
        compound.putInt("ShowPlayerY", this.getShowtapePlayerPos().getY());
        compound.putInt("ShowPlayerZ", this.getShowtapePlayerPos().getZ());
        compound.putInt("eyeDecor", this.getEyeDecor());
        compound.putBoolean("isActivated", this.isActivated());
        compound.putInt("animatronicType", this.getAnimatronicType());
        compound.putInt("endoState", this.getState().ordinal());
        compound.putInt("foxyState", this.getFoxyState());
        compound.putBoolean("isDancing", this.isDancing());
        if (!this.inventory.getItem(0).isEmpty()) {
            compound.put("CPUItem", this.inventory.getItem(0).save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        ItemStack itemstack;
        super.readAdditionalSaveData(compound);
        this.setColor(DyeColor.byId((int)compound.getByte("Color")));
        this.setCurrentPose(compound.getInt("CurrentPose"));
        this.setPossessed(compound.getBoolean("IsPossessed"));
        int spawnX = compound.getInt("SpawnX");
        int spawnY = compound.getInt("SpawnY");
        int spawnZ = compound.getInt("SpawnZ");
        this.setSpawnPosition(new BlockPos(spawnX, spawnY, spawnZ));
        this.setSpawnRotation(compound.getFloat("SpawnRotation"));
        int playerX = compound.getInt("ShowPlayerX");
        int playerY = compound.getInt("ShowPlayerY");
        int playerZ = compound.getInt("ShowPlayerZ");
        this.setShowtapePlayerPos(new BlockPos(playerX, playerY, playerZ));
        this.setEyeDecor(compound.getInt("eyeDecor"));
        this.setActivated(compound.getBoolean("isActivated"));
        this.setAnimatronicType(compound.getInt("animatronicType"));
        this.setState(EndoState.values()[compound.getInt("endoState")]);
        this.setFoxyState(compound.getInt("foxyState"));
        this.setDancing(compound.getBoolean("isDancing"));
        if (compound.contains("CPUItem", 10) && (itemstack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("CPUItem")).orElse(ItemStack.EMPTY)).getItem() instanceof CPUItem) {
            this.inventory.setItem(0, itemstack);
        }
    }

    public void setState(EndoState state) {
        this.entityData.set(STATE, (Object)state.ordinal());
    }

    public EndoState getState() {
        return EndoState.values()[(Integer)this.entityData.get(STATE)];
    }

    public void setFoxyState(int state) {
        this.entityData.set(FOXY_STATE, (Object)state);
    }

    public int getFoxyState() {
        return (Integer)this.entityData.get(FOXY_STATE);
    }

    public void setSpawnPosition(BlockPos blockPos) {
        this.entityData.set(SPAWN_POSITION, (Object)blockPos);
    }

    public BlockPos getSpawnPosition() {
        return (BlockPos)this.entityData.get(SPAWN_POSITION);
    }

    public void setSpawnRotation(float direction) {
        this.entityData.set(SPAWN_ROTATION, (Object)Float.valueOf(direction));
    }

    public float getSpawnRotation() {
        return ((Float)this.entityData.get(SPAWN_ROTATION)).floatValue();
    }

    public void setShowtapePlayerPos(BlockPos blockPos) {
        this.entityData.set(SHOWTAPE_PLAYER_POS, (Object)blockPos);
    }

    public BlockPos getShowtapePlayerPos() {
        return (BlockPos)this.entityData.get(SHOWTAPE_PLAYER_POS);
    }

    public void setColor(DyeColor dyeColor) {
        byte colorId = (Byte)this.entityData.get(DATA_COLOR_ID);
        this.entityData.set(DATA_COLOR_ID, (Object)((byte)(colorId & 0xF0 | dyeColor.getId() & 0xF)));
    }

    public void setCurrentPose(int pose) {
        this.entityData.set(CURRENT_POSE, (Object)pose);
    }

    public int getCurrentPose() {
        return (Integer)this.entityData.get(CURRENT_POSE);
    }

    public void setPossessed(boolean value) {
        this.entityData.set(IS_POSSESSED, (Object)value);
    }

    public boolean isPossessed() {
        return (Boolean)this.entityData.get(IS_POSSESSED);
    }

    public void setEyeDecor(int value) {
        this.entityData.set(EYE_DECOR, (Object)value);
    }

    public int getEyeDecor() {
        return (Integer)this.entityData.get(EYE_DECOR);
    }

    public void setAnimatronicType(int value) {
        this.entityData.set(ANIMATRONIC_TYPE, (Object)value);
    }

    public int getAnimatronicType() {
        return (Integer)this.entityData.get(ANIMATRONIC_TYPE);
    }

    public void setActivated(boolean value) {
        this.entityData.set(ACTIVATED, (Object)value);
    }

    public boolean isActivated() {
        return (Boolean)this.entityData.get(ACTIVATED);
    }

    public void setDancing(boolean value) {
        this.entityData.set(IS_DANCING, (Object)value);
    }

    public boolean isDancing() {
        return (Boolean)this.entityData.get(IS_DANCING);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    protected void onEffectAdded(@NotNull MobEffectInstance pEffectInstance, @Nullable Entity pEntity) {
        this.removeAllEffects();
        super.onEffectAdded(pEffectInstance, pEntity);
    }

    public boolean canCollideWith(@NotNull Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushedByFluid(@NotNull FluidType type) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    @NotNull
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int i) {
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
    }

    public void startPersistentAngerTimer() {
    }

    public void containerChanged(@NotNull Container container) {
    }

    public void openCustomInventoryScreen(@NotNull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.nextContainerCounter();
            FFPMessages.sendToPlayer(new OpenEndoScreenPacket(serverPlayer.containerCounter, this.getId()), serverPlayer);
            serverPlayer.containerMenu = new EndoConfigMenu(serverPlayer.containerCounter, serverPlayer.getInventory(), this.getInventory(), this);
            serverPlayer.initMenu(serverPlayer.containerMenu);
        }
    }

    public static enum EndoState {
        NORMAL,
        OVERHEAT,
        GLITCH;

    }
}

