/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.entity.goals;

import java.util.Objects;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.refractionapi.refraction.helper.entity.FrozenManager;

public class EndoAttackGoal
extends Goal {
    private static final ResourceLocation DAMAGE_MODIFIER_ID = ResourceLocation.withDefaultNamespace((String)"stuffing");
    private static final AttributeModifier DAMAGE_MODIFIER = new AttributeModifier(DAMAGE_MODIFIER_ID, -100.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    public int currentSlot = 0;
    protected final Endo01 endo;
    private final double speedModifier;
    private boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private final boolean canPenalize = false;
    public int tickCount;

    public EndoAttackGoal(Endo01 mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        this.endo = mob;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.tickCount = 0;
    }

    public void tick() {
        LivingEntity livingentity = this.endo.getTarget();
        ++this.tickCount;
        if (livingentity != null) {
            this.endo.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.endo.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.endo.getRandom().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.getX();
                this.pathedTargetY = livingentity.getY();
                this.pathedTargetZ = livingentity.getZ();
                this.ticksUntilNextPathRecalculation = 4 + this.endo.getRandom().nextInt(7);
                double d0 = this.endo.distanceToSqr((Entity)livingentity);
                Objects.requireNonNull(this);
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.endo.getNavigation().moveTo((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingentity);
        }
        if (this.endo.getAnimatronicType() == 4 && this.endo.getFoxyState() == 4) {
            Player player = this.endo.level().getNearestPlayer((Entity)this.endo, 100.0);
            if (player != null && !player.isCreative() && !player.isSpectator()) {
                this.endo.setTarget((LivingEntity)player);
                this.followingTargetEvenIfNotSeen = true;
                this.endo.getNavigation().moveTo((Entity)player, 1.5);
                if (this.endo.tickCount % 1200 == 0 && player.isAlive()) {
                    this.endo.getNavigation().stop();
                    position = this.endo.getSpawnPosition().getBottomCenter();
                    this.endo.yBodyRot = this.endo.getSpawnRotation();
                    this.endo.yRot = this.endo.getSpawnRotation();
                    this.endo.moveTo(position.x, position.y, position.z);
                    this.followingTargetEvenIfNotSeen = false;
                    this.endo.setFoxyState(0);
                }
            } else {
                this.endo.getNavigation().stop();
                position = this.endo.getSpawnPosition().getBottomCenter();
                this.endo.yBodyRot = this.endo.getSpawnRotation();
                this.endo.yRot = this.endo.getSpawnRotation();
                this.endo.moveTo(position.x, position.y, position.z);
                this.followingTargetEvenIfNotSeen = false;
                this.endo.setFoxyState(0);
            }
        } else {
            this.followingTargetEvenIfNotSeen = false;
        }
        AttributeInstance attributeinstance = this.endo.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attributeinstance == null || this.endo.level().isClientSide) {
            return;
        }
        if (livingentity != null && this.endo.getAnimatronicType() != 4) {
            if (livingentity.getHealth() <= 13.0f) {
                attributeinstance.removeModifier(DAMAGE_MODIFIER_ID);
                attributeinstance.addTransientModifier(DAMAGE_MODIFIER);
                EquipmentSlot playerSlot = EquipmentSlot.FEET;
                Item suitItem = (Item)FFPItemRegistry.FREDDY_SUIT_FEET.get();
                if (this.endo.distanceTo((Entity)livingentity) <= 1.3f) {
                    if (livingentity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)livingentity;
                        FrozenManager.setFrozenTicks((LivingEntity)livingentity, (int)20);
                        FrozenManager.setFrozen((LivingEntity)this.endo, (Vec3)this.endo.position());
                        serverPlayer.lookAt(EntityAnchorArgument.Anchor.EYES, this.endo.getEyePosition().add(0.0, (double)0.8f, 0.0));
                        this.endo.lookAt(EntityAnchorArgument.Anchor.EYES, serverPlayer.getEyePosition());
                        this.endo.jumpscaring = true;
                        if (this.tickCount % 50 == 0) {
                            this.currentSlot = this.currentSlot >= 4 ? 0 : this.currentSlot + 1;
                            FFPackage.LOGGER.info("{}", (Object)this.currentSlot);
                            if (this.currentSlot != 0) {
                                EquipmentSlot equipmentSlot = this.currentSlot == 1 ? EquipmentSlot.FEET : (this.currentSlot == 2 ? EquipmentSlot.LEGS : (playerSlot = this.currentSlot == 3 ? EquipmentSlot.CHEST : EquipmentSlot.HEAD));
                                suitItem = this.currentSlot == 1 ? (Item)FFPItemRegistry.FREDDY_SUIT_FEET.get() : (this.currentSlot == 2 ? (Item)FFPItemRegistry.FREDDY_SUIT_LEGS.get() : (this.currentSlot == 3 ? (Item)FFPItemRegistry.FREDDY_SUIT_TORSO.get() : (Item)FFPItemRegistry.FREDDY_SUIT_HEAD.get()));
                            }
                            serverPlayer.setItemSlot(playerSlot, suitItem.getDefaultInstance());
                        }
                    }
                } else {
                    this.currentSlot = 0;
                    this.endo.jumpscaring = false;
                    FrozenManager.unfreeze((LivingEntity)this.endo);
                    attributeinstance.removeModifier(DAMAGE_MODIFIER_ID);
                }
            } else {
                this.currentSlot = 0;
                this.endo.jumpscaring = false;
                FrozenManager.unfreeze((LivingEntity)this.endo);
                attributeinstance.removeModifier(DAMAGE_MODIFIER_ID);
            }
        }
    }

    public boolean canUse() {
        if (!this.endo.level().isClientSide && this.endo.shouldBeIdle()) {
            return false;
        }
        if (!this.endo.level().isClientSide && this.endo.getAnimatronicType() == 4) {
            return this.endo.getFoxyState() == 4 && !this.endo.shouldBeIdle();
        }
        if (this.endo.jumpscaring) {
            return true;
        }
        long i = this.endo.level().getGameTime();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.endo.getTarget();
        if (livingentity == null || !livingentity.isAlive()) {
            return false;
        }
        Objects.requireNonNull(this);
        this.path = this.endo.getNavigation().createPath((Entity)livingentity, 0);
        return this.path != null || this.endo.isWithinMeleeAttackRange(livingentity);
    }

    public boolean canContinueToUse() {
        if (!this.endo.level().isClientSide && this.endo.shouldBeIdle()) {
            return false;
        }
        if (!this.endo.level().isClientSide && this.endo.getAnimatronicType() == 4) {
            return this.endo.getFoxyState() == 4 && !this.endo.shouldBeIdle();
        }
        if (this.endo.jumpscaring) {
            return true;
        }
        LivingEntity livingentity = this.endo.getTarget();
        if (livingentity == null || !livingentity.isAlive()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.endo.getNavigation().isDone();
        }
        return this.endo.isWithinRestriction(livingentity.blockPosition()) && (!(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative());
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.canPerformAttack(target)) {
            this.resetAttackCooldown();
            this.endo.swing(InteractionHand.MAIN_HAND);
            this.endo.doHurtTarget((Entity)target);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity entity) {
        return this.isTimeToAttack() && this.endo.isWithinMeleeAttackRange(entity) && this.endo.getSensing().hasLineOfSight((Entity)entity);
    }
}

