/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.entity.goals;

import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.phys.Vec3;
import net.mudhut.ffpackage.level.entity.Endo01;
import net.refractionapi.refraction.helper.runnable.Runnabler;

public class EndoStrollGoal
extends RandomStrollGoal {
    protected final Endo01 endo;
    public int movementTimer = 0;

    public EndoStrollGoal(Endo01 endo, double speedModifier) {
        super((PathfinderMob)endo, speedModifier);
        this.endo = endo;
    }

    public void tick() {
        if (this.endo.getAnimatronicType() != 4 && this.endo.isAggressive()) {
            return;
        }
        if (this.endo.shouldBeIdle()) {
            this.setMovementTimer();
            this.trigger();
            Vec3 position = this.endo.getSpawnPosition().getBottomCenter();
            this.endo.moveTo(position.x, position.y, position.z);
            this.endo.yBodyRot = this.endo.getSpawnRotation();
            this.endo.yRot = this.endo.getSpawnRotation();
            this.endo.reachedHome();
            if (this.endo.getNavigation().isDone()) {
                Runnabler.create().delayRun(20, runnabler -> this.endo.reachedHome());
            }
        } else {
            --this.movementTimer;
            if (this.movementTimer <= 0) {
                this.endo.getNavigation().stop();
                this.setMovementTimer();
                RandomSource randomSource = RandomSource.create();
                if (randomSource.nextInt(0, 5) == 0) {
                    if (this.endo.getAnimatronicType() == 4) {
                        if (this.endo.getFoxyState() == 0) {
                            this.endo.setFoxyState(1);
                        } else if (this.endo.getFoxyState() == 1) {
                            this.endo.setFoxyState(2);
                        } else if (this.endo.getFoxyState() == 2) {
                            this.endo.setFoxyState(3);
                        } else if (this.endo.getFoxyState() == 3) {
                            this.endo.setFoxyState(4);
                        }
                    } else {
                        this.endo.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
                    }
                }
            }
        }
    }

    public void setMovementTimer() {
        switch (this.endo.getAnimatronicType()) {
            default: {
                this.movementTimer = 100;
                break;
            }
            case 1: {
                this.movementTimer = 99;
                break;
            }
            case 2: {
                this.movementTimer = 60;
            }
        }
    }

    public boolean canUse() {
        if (this.mob.hasControllingPassenger()) {
            return false;
        }
        Vec3 vec3 = this.getPosition();
        if (vec3 == null) {
            return false;
        }
        this.wantedX = vec3.x;
        this.wantedY = vec3.y;
        this.wantedZ = vec3.z;
        return this.endo.isPossessed();
    }

    public boolean canContinueToUse() {
        return this.endo.isPossessed() && super.canContinueToUse();
    }

    public void start() {
    }
}

