/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.mudhut.ffpackage.level.block.entity.MidnightMotorMachineBlockEntity;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPMenuTypes;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class MidnightMotoristMachineMenu
extends AbstractContainerMenu {
    public final MidnightMotorMachineBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private Slot tokenSlot;
    private Slot ticketSlot;

    public MidnightMotoristMachineMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public MidnightMotoristMachineMenu(int containerId, Inventory inventory, BlockEntity entity, ContainerData containerData) {
        super(FFPMenuTypes.MIDNIGHT_MOTOR.get(), containerId);
        int i;
        this.blockEntity = (MidnightMotorMachineBlockEntity)entity;
        this.level = inventory.player.level();
        this.data = containerData;
        this.tokenSlot = new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 0, 47, 59){

            public int getMaxStackSize(ItemStack stack) {
                return 1;
            }

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && !MidnightMotoristMachineMenu.this.blockEntity.isGameActive && itemStack.is(FFPItemRegistry.FAZ_TOKEN);
            }
        };
        this.ticketSlot = new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 1, 103, 59){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return false;
            }
        };
        this.addSlot(this.tokenSlot);
        this.addSlot(this.ticketSlot);
        this.addDataSlots(this.data);
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + i * 9 + 9, 8 + l * 18, 100 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 158));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index != 1 && index != 0 ? (itemstack1.is(FFPItemRegistry.FAZ_TOKEN) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false))) : !this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return MidnightMotoristMachineMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)FFPDecorBlockRegistry.MM_MACHINE.get()));
    }
}

