/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.inventory;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.mudhut.ffpackage.level.item.PlushSuitItem;
import net.mudhut.ffpackage.level.recipe.SewingStandRecipeInput;
import net.mudhut.ffpackage.registries.FFPBlockRegistry;
import net.mudhut.ffpackage.registries.FFPMenuTypes;
import net.mudhut.ffpackage.registries.FFPRecipeTypeRegistry;
import net.mudhut.ffpackage.registries.FFPSoundRegistry;
import org.jetbrains.annotations.NotNull;

public class SewingTableMenu
extends ItemCombinerMenu {
    private final ContainerLevelAccess containerLevelAccess;

    public SewingTableMenu(int pContainerId, Inventory inv, RegistryFriendlyByteBuf friendlyByteBuf) {
        this(pContainerId, inv, ContainerLevelAccess.NULL);
    }

    public SewingTableMenu(int containerId, Inventory inventory, ContainerLevelAccess containerLevelAccess) {
        super(FFPMenuTypes.SEWING_TABLE.get(), containerId, inventory, containerLevelAccess);
        this.containerLevelAccess = containerLevelAccess;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index != 0 && index != 1 && index != 2 && index != 3 ? (itemstack1.getItem() instanceof PlushSuitItem ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (itemstack1.is(Items.STRING) ? !this.moveItemStackTo(itemstack1, 0, 2, false) : (itemstack1.is(ItemTags.WOOL) ? !this.moveItemStackTo(itemstack1, 0, 3, false) : (index >= 4 && index < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.moveItemStackTo(itemstack1, 4, 31, false))))) : !this.moveItemStackTo(itemstack1, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    protected boolean mayPickup(Player player, boolean b) {
        return true;
    }

    protected void onTake(Player player, ItemStack itemStack) {
        ItemStack suitItem = this.inputSlots.getItem(0);
        ItemStack stringItem = this.inputSlots.getItem(1);
        ItemStack woolItem = this.inputSlots.getItem(2);
        int woolToTake = ((PlushSuitItem)suitItem.getItem()).getEquipmentSlot() == EquipmentSlot.HEAD ? 2 : (((PlushSuitItem)suitItem.getItem()).getEquipmentSlot() == EquipmentSlot.CHEST ? 6 : 4);
        Item repairItem = Arrays.stream(((PlushSuitItem)suitItem.getItem()).getRepairMaterials()).findFirst().orElseThrow().getItem();
        if (woolItem.is(repairItem)) {
            this.inputSlots.getItem(1).shrink(Math.clamp((long)(this.inputSlots.getItem(2).getCount() - 5), 1, 64));
            this.inputSlots.getItem(2).shrink(Math.clamp((long)(4 * woolToTake), 1, 64));
        } else {
            this.inputSlots.getItem(1).shrink(1);
            this.inputSlots.getItem(2).shrink(1);
        }
        this.inputSlots.setItem(0, ItemStack.EMPTY);
        this.containerLevelAccess.execute((level, blockPos) -> level.playSound(null, blockPos, (SoundEvent)FFPSoundRegistry.SEWING_STAND_USE.get(), SoundSource.BLOCKS));
    }

    protected boolean isValidBlock(BlockState blockState) {
        return blockState.is(FFPBlockRegistry.SEWING_TABLE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createResult() {
        block4: {
            block5: {
                ItemStack suitItem = this.inputSlots.getItem(0);
                ItemStack stringItem = this.inputSlots.getItem(1);
                ItemStack woolItem = this.inputSlots.getItem(2);
                Item item = suitItem.getItem();
                if (!(item instanceof PlushSuitItem)) break block5;
                PlushSuitItem plushSuitItem = (PlushSuitItem)item;
                if (stringItem.isEmpty()) break block5;
                Item repairItem = Arrays.stream(plushSuitItem.getRepairMaterials()).findFirst().orElseThrow().getItem();
                if (woolItem.is(repairItem)) {
                    if (suitItem.getDamageValue() < suitItem.getMaxDamage() && stringItem.getCount() >= Math.clamp((long)(woolItem.getCount() - 5), 0, 64)) {
                        this.resultSlots.setItem(3, new ItemStack((ItemLike)suitItem.getItem()));
                        this.resultSlots.getItem(3).setDamageValue(suitItem.getDamageValue() - woolItem.getCount() * 5);
                        break block4;
                    } else {
                        this.resultSlots.setItem(3, ItemStack.EMPTY);
                    }
                    break block4;
                } else {
                    this.containerLevelAccess.execute((level, blockPos) -> {
                        RecipeManager recipeManager = level.getRecipeManager();
                        SewingStandRecipeInput input = new SewingStandRecipeInput(suitItem, woolItem);
                        Optional recipe = recipeManager.getRecipeFor(FFPRecipeTypeRegistry.SEWING_STAND.get(), (RecipeInput)input, level);
                        ItemStack result = recipe.map(RecipeHolder::value).map(e -> e.assemble(input, (HolderLookup.Provider)level.registryAccess())).orElse(ItemStack.EMPTY);
                        if (!stringItem.isEmpty()) {
                            this.resultSlots.setItem(3, result);
                            this.resultSlots.getItem(3).setDamageValue(suitItem.getDamageValue());
                        } else {
                            this.resultSlots.setItem(3, ItemStack.EMPTY);
                        }
                    });
                }
                break block4;
            }
            this.resultSlots.setItem(3, ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 33, itemStack -> itemStack.getItem() instanceof PlushSuitItem).withSlot(1, 49, 22, itemStack -> itemStack.is(Items.STRING)).withSlot(2, 49, 44, itemStack -> itemStack.is(ItemTags.WOOL)).withResultSlot(3, 91, 33).build();
    }
}

