/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.mudhut.ffpackage.level.block.entity.SodaStandBlockEntity;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPMenuTypes;
import net.mudhut.ffpackage.registries.FFPTagsRegistry;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class SodaMachineConfigMenu
extends AbstractContainerMenu {
    public final SodaStandBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public SodaMachineConfigMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(9));
    }

    public SodaMachineConfigMenu(int containerId, Inventory inventory, BlockEntity entity, ContainerData containerData) {
        super(FFPMenuTypes.SODA_CONFIG.get(), containerId);
        int i;
        this.blockEntity = (SodaStandBlockEntity)entity;
        this.level = inventory.player.level();
        this.data = containerData;
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 3, 26, 49){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && itemStack.is(Items.WATER_BUCKET);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 4, 80, 49){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && itemStack.is(Items.WATER_BUCKET);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 5, 134, 49){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && itemStack.is(Items.WATER_BUCKET);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 6, 26, 27){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && itemStack.is(FFPTagsRegistry.SYRUP);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 7, 80, 27){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && itemStack.is(FFPTagsRegistry.SYRUP);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 8, 134, 27){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && itemStack.is(FFPTagsRegistry.SYRUP);
            }
        });
        this.addDataSlots(this.data);
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack.copy();
            if (index != 0 && index != 1 && index != 2 && index != 3 && index != 4 && index != 5 ? (itemstack1.is(Items.WATER_BUCKET) ? !this.moveItemStackTo(itemstack1, 0, 3, false) : (itemstack1.is(FFPTagsRegistry.SYRUP) ? !this.moveItemStackTo(itemstack1, 3, 6, false) : (index >= 2 && index < 33 ? !this.moveItemStackTo(itemstack1, 33, 42, false) : index >= 33 && index < 42 && !this.moveItemStackTo(itemstack1, 2, 29, false)))) : !this.moveItemStackTo(itemstack1, 6, 42, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return SodaMachineConfigMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)FFPDecorBlockRegistry.SODA_STAND.get()));
    }
}

