/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.mudhut.ffpackage.level.block.entity.SodaStandBlockEntity;
import net.mudhut.ffpackage.registries.FFPDecorBlockRegistry;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPMenuTypes;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class SodaMachineFillMenu
extends AbstractContainerMenu {
    private final Slot fizzyFazSlot;
    private Slot coveCoolerSlot;
    private Slot chicaChugSlot;
    public final SodaStandBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public SodaMachineFillMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(9));
    }

    public SodaMachineFillMenu(int containerId, Inventory inventory, BlockEntity entity, ContainerData containerData) {
        super(FFPMenuTypes.SODA_FILLER.get(), containerId);
        int i;
        this.blockEntity = (SodaStandBlockEntity)entity;
        this.level = inventory.player.level();
        this.data = containerData;
        this.fizzyFazSlot = new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 0, 26, 49){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && itemStack.is(FFPItemRegistry.EMPTY_CUP);
            }

            public int getMaxStackSize(ItemStack stack) {
                return 1;
            }
        };
        this.chicaChugSlot = new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 1, 80, 49){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && itemStack.is(FFPItemRegistry.EMPTY_CUP);
            }

            public int getMaxStackSize(ItemStack stack) {
                return 1;
            }
        };
        this.coveCoolerSlot = new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 2, 134, 49){

            public boolean mayPlace(@NotNull ItemStack itemStack) {
                return !this.hasItem() && itemStack.is(FFPItemRegistry.EMPTY_CUP);
            }

            public int getMaxStackSize(ItemStack stack) {
                return 1;
            }
        };
        this.addSlot(this.fizzyFazSlot);
        this.addSlot(this.coveCoolerSlot);
        this.addSlot(this.chicaChugSlot);
        this.addDataSlots(this.data);
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack1 = slot.getItem();
            itemstack = itemStack1.copy();
            if (index != 0 && index != 1 && index != 2 ? (itemStack1.is(FFPItemRegistry.EMPTY_CUP) ? !this.moveItemStackTo(itemStack1, 0, 3, false) : (index >= 3 && index < 30 ? !this.moveItemStackTo(itemStack1, 30, 39, false) : index >= 30 && index < 39 && !this.moveItemStackTo(itemStack1, 0, 30, false))) : !this.moveItemStackTo(itemStack1, 0, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return SodaMachineFillMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)FFPDecorBlockRegistry.SODA_STAND.get()));
    }

    public int getArrowProgress(int arrowType) {
        int currentProgress = this.data.get(0);
        int maxProgress = 72;
        switch (arrowType) {
            case 0: {
                currentProgress = this.data.get(0);
                break;
            }
            case 1: {
                currentProgress = this.data.get(1);
                break;
            }
            case 2: {
                currentProgress = this.data.get(2);
            }
        }
        return currentProgress != 0 ? currentProgress * 24 / maxProgress : 0;
    }
}

