/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.mudhut.ffpackage.level.item.components.CPUOverheatComponent;
import net.mudhut.ffpackage.registries.FFPDataComponents;

public class CPUItem
extends Item {
    public CPUItem(Item.Properties properties) {
        super(properties.component(FFPDataComponents.CPU_OVERHEAT, (Object)new CPUOverheatComponent(0)));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        CPUOverheatComponent overheatComponent = (CPUOverheatComponent)stack.get((DataComponentType)FFPDataComponents.CPU_OVERHEAT.value());
        if (overheatComponent == null) {
            return;
        }
        if (entity.tickCount % 60 == 0 && overheatComponent.overheat() > 0) {
            int overHeat = overheatComponent.overheat();
            stack.set(FFPDataComponents.CPU_OVERHEAT, (Object)new CPUOverheatComponent(--overHeat));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CPUOverheatComponent overheatComponent = (CPUOverheatComponent)stack.get((DataComponentType)FFPDataComponents.CPU_OVERHEAT.value());
        if (overheatComponent != null) {
            ChatFormatting componentColor = ChatFormatting.DARK_GREEN;
            if (overheatComponent.overheat() >= 40 && overheatComponent.overheat() <= 60) {
                componentColor = ChatFormatting.YELLOW;
            } else if (overheatComponent.overheat() >= 60 && overheatComponent.overheat() <= 80) {
                componentColor = ChatFormatting.GOLD;
            } else if (overheatComponent.overheat() >= 80) {
                componentColor = ChatFormatting.RED;
            }
            tooltipComponents.add((Component)Component.literal((String)"Overheat: %s".formatted(overheatComponent.overheat())).withStyle(componentColor));
        }
    }
}

