/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.item;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.mudhut.ffpackage.registries.FFPDamageTypes;
import net.mudhut.ffpackage.util.AnimatronicSuit;
import net.refractionapi.refraction.helper.misc.RefractionMisc;
import org.jetbrains.annotations.Nullable;

public class PlushSuitItem
extends ArmorItem {
    public Supplier<AnimatronicSuit> animatronicSuit;

    public PlushSuitItem(Supplier<AnimatronicSuit> animatronicSuit, Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties.durability(100));
        this.animatronicSuit = animatronicSuit;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ServerPlayer serverPlayer;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof ServerPlayer && this.checkSlots((Player)(serverPlayer = (ServerPlayer)entity))) {
            serverPlayer.hurt(RefractionMisc.damageSource(FFPDamageTypes.STUFFED_IN_SUIT, (Level)serverPlayer.level()), 0.4f);
        }
    }

    public ItemStack[] getRepairMaterials() {
        return ((Ingredient)((ArmorMaterial)this.getMaterial().value()).repairIngredient().get()).getItems();
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public boolean checkSlots(Player player) {
        return player.getItemBySlot(EquipmentSlot.FEET).is((Item)this) || player.getItemBySlot(EquipmentSlot.LEGS).is((Item)this) || player.getItemBySlot(EquipmentSlot.CHEST).is((Item)this) || player.getItemBySlot(EquipmentSlot.HEAD).is((Item)this);
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return stack.getDamageValue() >= 70 ? this.animatronicSuit.get().getWitheredTexture() : (stack.getDamageValue() >= 50 ? this.animatronicSuit.get().getDamagedTexture() : this.animatronicSuit.get().getSuitTexture());
    }
}

