/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.level.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.mudhut.ffpackage.registries.FFPFoods;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import org.jetbrains.annotations.Nullable;

public class SodaItem
extends Item {
    public SodaItem(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        return FFPFoods.SODA;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        Player player;
        super.finishUsingItem(stack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
        }
        if (stack.isEmpty()) {
            return new ItemStack((ItemLike)FFPItemRegistry.EMPTY_CUP.asItem());
        }
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).hasInfiniteMaterials() && !player.getInventory().add(new ItemStack((ItemLike)FFPItemRegistry.EMPTY_CUP.asItem()))) {
            player.drop(new ItemStack((ItemLike)FFPItemRegistry.EMPTY_CUP.asItem()), false);
        }
        return stack;
    }

    public DataComponentMap components() {
        return DataComponentMap.builder().set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true).build();
    }
}

