/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.minigames;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec2;
import net.mudhut.ffpackage.client.gui.components.MidnightMotorCar;
import net.refractionapi.refraction.helper.runnable.Runnabler;

public class MidnightMotorist {
    public static int timer = 0;
    public static final List<EnemyCar> enemyCars = new ArrayList<EnemyCar>();
    public static final List<PlayerCar> playerCars = new ArrayList<PlayerCar>();
    public static final List<LapGoal> lapFinishLines = new ArrayList<LapGoal>();
    public static int roadScroll = 0;
    public static int lapLineScroll = 0;
    public static int scrollSpeed = 1;
    public static int countDownOffset = 0;
    public static int playerHeight = 13;
    public static boolean completedLap = false;
    public static boolean isCounting = false;
    public static boolean gameWon = false;
    public static int currentLap = 1;
    public static int score = 0;
    public static int highScore = 0;
    static final int carWidth = 7;
    static final int carHeight = 5;
    public static int gameTick = 0;
    public static int countdownTick = 0;
    public static int playerTick = 0;
    public static int carTick = 0;
    public static int lapTick = 0;
    public static final int goalSpawn1 = 600;
    public static final int goalSpawn2 = 1200;
    public static final int goalSpawn3 = 1800;
    public static final int boundMaxX = 386;
    public static final int boundMinX = 241;
    public static final int boundMaxY = 111;
    public static final int boundMinY = 50;
    public static boolean gameActive = false;
    public static boolean isPaused = false;
    public static Vec2 playerPos = new Vec2(242.0f, 71.0f);

    public static void addPlayerCar() {
        Iterator<PlayerCar> playerCarIterator = playerCars.iterator();
        if (!playerCarIterator.hasNext()) {
            playerCars.add(new PlayerCar((int)MidnightMotorist.playerPos.x, (int)MidnightMotorist.playerPos.y));
        }
    }

    public static void spawnCars() {
        int carX;
        int carY;
        RandomSource randomSource = RandomSource.create();
        boolean spawnAtTop = randomSource.nextBoolean();
        if (spawnAtTop) {
            carY = 52;
            carX = 220;
        } else {
            carY = 91;
            carX = 403;
        }
        EnemyCar newCar = new EnemyCar(carX, carY, spawnAtTop);
        if (randomSource.nextInt(3) == 0) {
            carY += 18;
        }
        if (carTick == 40 && gameActive && !isPaused && !MidnightMotorist.hitCar(newCar, carX, carY)) {
            enemyCars.add(newCar);
            carTick = randomSource.nextInt(2, 30);
        }
    }

    public static boolean hitCar(EnemyCar car, int x, int y) {
        int enemyMinX = x - 7;
        int enemyMinY = y - 5;
        int enemyMaxX = x + 7;
        int enemyMaxY = y + 5;
        int minX = (int)(MidnightMotorist.playerPos.x - 7.0f);
        int minY = (int)(MidnightMotorist.playerPos.y - 5.0f);
        int maxX = (int)(MidnightMotorist.playerPos.x + 7.0f);
        int maxY = (int)(MidnightMotorist.playerPos.y + 5.0f);
        return enemyMaxX >= minX && enemyMinX <= maxX && enemyMaxY >= minY && enemyMinY <= maxY;
    }

    public static void enemyCarTick(SimpleSoundInstance carCrashSound) {
        Iterator<EnemyCar> enemyCarIterator = enemyCars.iterator();
        while (enemyCarIterator.hasNext()) {
            EnemyCar car = enemyCarIterator.next();
            if (car.spawnAtTop) {
                car.x = car.x + scrollSpeed - 1;
                if (car.x >= 406) {
                    enemyCarIterator.remove();
                }
            } else {
                car.x = car.x - scrollSpeed + 1;
                if (car.x <= 217) {
                    enemyCarIterator.remove();
                }
            }
            if (MidnightMotorist.hitCar(car, car.x, car.y) && playerTick >= 60) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)carCrashSound);
                enemyCarIterator.remove();
                scrollSpeed = 1;
                playerHeight = 0;
                playerTick = 0;
            }
            if (playerTick < 8) continue;
            playerHeight = 13;
        }
    }

    public static void finishLineTick(SimpleSoundInstance lapComplete, SimpleSoundInstance p240bitsPerMile) {
        Iterator<LapGoal> lapGoalIterator;
        Iterator<EnemyCar> enemyCarIterator = enemyCars.iterator();
        if (lapTick == 600 || lapTick == 1200 || lapTick == 1800) {
            lapFinishLines.add(new LapGoal(391));
        }
        if ((lapGoalIterator = lapFinishLines.iterator()).hasNext()) {
            LapGoal goal = lapGoalIterator.next();
            goal.x -= scrollSpeed;
            lapLineScroll = goal.x;
            if (goal.x <= 241 || (float)goal.x <= MidnightMotorist.playerPos.x) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)lapComplete);
                if (currentLap < 4) {
                    ++currentLap;
                    completedLap = true;
                    lapGoalIterator.remove();
                    if (enemyCarIterator.hasNext()) {
                        enemyCars.clear();
                    }
                }
            }
        }
        if (currentLap >= 4) {
            if (enemyCarIterator.hasNext()) {
                enemyCars.clear();
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)lapComplete);
            gameActive = false;
            gameWon = true;
            Runnabler.create().delayRun(290, runnabler -> {
                gameWon = false;
                MidnightMotorist.gameReset();
                Minecraft.getInstance().getSoundManager().stop((SoundInstance)p240bitsPerMile);
            });
        }
        if (completedLap) {
            Runnabler.create().delayRun(30, runnabler -> {
                completedLap = false;
            });
        }
    }

    public static void countDown() {
        if (isCounting && ++countdownTick % 30 == 0) {
            countDownOffset += 30;
        }
    }

    public static void gameTick() {
        ++timer;
        ++carTick;
        ++gameTick;
        ++playerTick;
        ++lapTick;
    }

    public static void scrollSpeedTick() {
        if (gameTick == 47) {
            if (scrollSpeed < 7) {
                scrollSpeed = Mth.lerpInt((float)scrollSpeed, (int)1, (int)2);
            }
            gameTick = 0;
        }
        roadScroll += scrollSpeed;
        if (scrollSpeed >= 5) {
            ++score;
        }
    }

    public static void gameNotActive() {
        enemyCars.clear();
        score = highScore;
    }

    public static void setHighScore() {
        if (score > highScore) {
            highScore = score;
        }
    }

    public static void gameReset() {
        timer = 0;
        gameActive = false;
        isPaused = false;
        roadScroll = 0;
        lapLineScroll = 0;
        scrollSpeed = 1;
        countDownOffset = 0;
        playerHeight = 13;
        playerPos = new Vec2(242.0f, 71.0f);
        completedLap = false;
        isCounting = false;
        gameWon = false;
        currentLap = 1;
        score = 0;
        highScore = 0;
        gameTick = 0;
        countdownTick = 0;
        playerTick = 0;
        carTick = 0;
        lapTick = 0;
    }

    public static void playerMovement(int keyCode) {
        Options key = Minecraft.getInstance().options;
        if (gameActive && !isPaused) {
            if (keyCode == key.keyDown.getKey().getValue() && MidnightMotorist.playerPos.y <= 111.0f) {
                playerPos = new Vec2(MidnightMotorist.playerPos.x, MidnightMotorist.playerPos.y + (float)scrollSpeed);
            } else if (keyCode == key.keyUp.getKey().getValue() && MidnightMotorist.playerPos.y >= 50.0f) {
                playerPos = new Vec2(MidnightMotorist.playerPos.x, MidnightMotorist.playerPos.y - (float)scrollSpeed);
            }
            if (keyCode == key.keyRight.getKey().getValue() && MidnightMotorist.playerPos.x <= 386.0f) {
                playerPos = new Vec2(MidnightMotorist.playerPos.x + (float)scrollSpeed, MidnightMotorist.playerPos.y);
            } else if (keyCode == key.keyLeft.getKey().getValue() && MidnightMotorist.playerPos.x >= 241.0f) {
                playerPos = new Vec2(MidnightMotorist.playerPos.x - (float)scrollSpeed, MidnightMotorist.playerPos.y);
            }
        }
        if (keyCode == key.keyDrop.getKey().getValue()) {
            // empty if block
        }
        if (keyCode == key.keyJump.getKey().getValue() && gameActive) {
            isPaused = !isPaused;
        }
    }

    public static class PlayerCar
    extends MidnightMotorCar {
        public PlayerCar(int x, int y) {
            super(x, y, false);
        }
    }

    public static class EnemyCar
    extends MidnightMotorCar {
        public int x;
        public int y;
        public boolean spawnAtTop;

        public EnemyCar(int x, int y, boolean spawnAtTop) {
            super(x, y, spawnAtTop);
        }
    }

    public static class LapGoal {
        public int x;

        public LapGoal(int x) {
        }
    }
}

