/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.mixins;

import net.minecraft.Optionull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.mudhut.ffpackage.client.gui.WarningScreen;
import net.mudhut.ffpackage.config.FFPClientConfig;
import net.mudhut.ffpackage.registries.FFPMusic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    public LocalPlayer player;
    @Shadow
    public Screen screen;
    @Shadow
    public final Gui gui = new Gui((Minecraft)this);
    @Shadow
    public final MusicManager musicManager = new MusicManager((Minecraft)this);

    @Inject(method={"getSituationalMusic"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSituationalMusic(CallbackInfoReturnable<Music> cir) {
        Music music = (Music)Optionull.map((Object)this.screen, Screen::getBackgroundMusic);
        if (FFPClientConfig.SPEC.isLoaded()) {
            if (music != null) {
                cir.setReturnValue((Object)music);
            } else if (this.player != null) {
                if (this.player.level().dimension() == Level.END) {
                    cir.setReturnValue((Object)(this.gui.getBossOverlay().shouldPlayMusic() ? Musics.END_BOSS : Musics.END));
                } else {
                    Holder holder = this.player.level().getBiome(this.player.blockPosition());
                    if (this.musicManager.isPlayingMusic(Musics.UNDER_WATER) || this.player.isUnderWater() && holder.is(BiomeTags.PLAYS_UNDERWATER_MUSIC)) {
                        cir.setReturnValue((Object)Musics.UNDER_WATER);
                    } else {
                        cir.setReturnValue((Object)(this.player.level().dimension() != Level.NETHER && this.player.getAbilities().instabuild && this.player.getAbilities().mayfly ? Musics.CREATIVE : ((Biome)holder.value()).getBackgroundMusic().orElse(Musics.GAME)));
                    }
                }
            } else if (!(this.screen instanceof WarningScreen)) {
                cir.setReturnValue((Object)((Boolean)FFPClientConfig.MAIN_MENU.get() != false ? FFPMusic.MENU : Musics.MENU));
            } else {
                cir.setReturnValue((Object)FFPMusic.SILENT);
            }
        }
    }
}

