/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.networking.C2S;

import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.networking.Packet;
import org.jetbrains.annotations.Nullable;

public class SetCrawlingPacket
extends Packet {
    private final boolean inCrawlingState;

    public SetCrawlingPacket(boolean crawling) {
        this.inCrawlingState = crawling;
    }

    public SetCrawlingPacket(FriendlyByteBuf friendlyByteBuf) {
        this.inCrawlingState = friendlyByteBuf.readBoolean();
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeBoolean(this.inCrawlingState);
    }

    public void handle(@Nullable Player player, Consumer<Runnable> consumer) {
        consumer.accept(() -> {
            if (player != null) {
                if (this.inCrawlingState) {
                    player.setForcedPose(Pose.SWIMMING);
                    player.setPose(Pose.SWIMMING);
                } else {
                    player.setForcedPose(null);
                    player.setPose(Pose.STANDING);
                }
            }
        });
    }
}

