/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.networking;

import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.mudhut.ffpackage.networking.C2S.MMBooleanSetPacket;
import net.mudhut.ffpackage.networking.C2S.MMCarsHitPacket;
import net.mudhut.ffpackage.networking.C2S.SetCrawlingPacket;
import net.mudhut.ffpackage.networking.C2S.SetEndoActivePacket;
import net.mudhut.ffpackage.networking.C2S.SetEndoTypePacket;
import net.mudhut.ffpackage.networking.C2S.ShowtapeTerminalPacket;
import net.mudhut.ffpackage.networking.S2C.OpenEndoScreenPacket;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.refractionapi.refraction.networking.Packet;
import net.refractionapi.refraction.networking.RefractionMessages;

public class FFPMessages {
    private static PayloadRegistrar payloadRegistrar = null;

    public static void register() {
        FFPMessages.register(SetCrawlingPacket.class, RefractionMessages.RNetworkDirection.PLAY_TO_SERVER);
        FFPMessages.register(MMBooleanSetPacket.class, RefractionMessages.RNetworkDirection.PLAY_TO_SERVER);
        FFPMessages.register(MMCarsHitPacket.class, RefractionMessages.RNetworkDirection.PLAY_TO_SERVER);
        FFPMessages.register(SetEndoActivePacket.class, RefractionMessages.RNetworkDirection.PLAY_TO_SERVER);
        FFPMessages.register(SetEndoTypePacket.class, RefractionMessages.RNetworkDirection.PLAY_TO_SERVER);
        FFPMessages.register(ShowtapeTerminalPacket.class, RefractionMessages.RNetworkDirection.PLAY_TO_SERVER);
        FFPMessages.register(OpenEndoScreenPacket.class, RefractionMessages.RNetworkDirection.PLAY_TO_CLIENT);
    }

    public static <Message extends Packet> void sendToServer(Message message) {
        PacketDistributor.sendToServer(message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <Message extends Packet> void sendToPlayer(Message message, ServerPlayer serverPlayer) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <P extends Packet> void register(Class<P> message, RefractionMessages.RNetworkDirection networkDirection) {
        CustomPacketPayload.Type packetType = Packet.getPacketType(message);
        StreamCodec streamCodec = Packet.getCodec(message);
        if (networkDirection.equals((Object)RefractionMessages.RNetworkDirection.PLAY_TO_CLIENT)) {
            payloadRegistrar.playToClient(packetType, streamCodec, (p, iPayloadContext) -> p.handle(iPayloadContext.player(), arg_0 -> ((IPayloadContext)iPayloadContext).enqueueWork(arg_0)));
        } else {
            payloadRegistrar.playToServer(packetType, streamCodec, (p, iPayloadContext) -> p.handle(iPayloadContext.player(), arg_0 -> ((IPayloadContext)iPayloadContext).enqueueWork(arg_0)));
        }
    }

    public static void init(IEventBus eventBus) {
        eventBus.addListener(event -> {
            payloadRegistrar = event.registrar("ffpackage");
            FFPMessages.register();
            payloadRegistrar = null;
        });
    }
}

