/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.server.purchase;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.mudhut.ffpackage.registries.FFPItemRegistry;
import net.mudhut.ffpackage.registries.FFPMenuTypes;
import net.mudhut.ffpackage.registries.FFPRegistries;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.refractionapi.refraction.feature.scheme.ScreenScheme;
import net.refractionapi.refraction.feature.scheme.ServerScheme;
import net.refractionapi.refraction.util.Pair;

public class PurchaseSys
extends ServerScheme {
    private final BlockPos pos;
    private final Item currencyItem;
    private static final Int2ObjectArrayMap<PurchasableItem> ITEMS = new Int2ObjectArrayMap();

    public PurchaseSys(ServerPlayer player) {
        super(FFPMenuTypes.PURCHASE, player);
        this.pos = player.blockPosition();
        this.currencyItem = (Item)FFPItemRegistry.RUBY.get();
    }

    public boolean stillValid() {
        return this.pos.distToCenterSqr((Position)this.player.position()) < 4.0 && super.stillValid();
    }

    public int buyingPower() {
        return this.player.inventoryMenu.getItems().stream().filter(is -> is.is(this.currencyItem)).mapToInt(ItemStack::getCount).sum();
    }

    public Component handlePurchase(List<Pair<PurchasableItem, Integer>> items) {
        int buyingPower;
        if (items.isEmpty()) {
            return Component.literal((String)"No Items!").withStyle(ChatFormatting.DARK_RED);
        }
        int totalPrice = items.stream().map(pair -> ((PurchasableItem)pair.first).price * (Integer)pair.second).reduce(0, Integer::sum);
        if (totalPrice > (buyingPower = this.buyingPower())) {
            return Component.literal((String)"Not Enough Funds!").withStyle(ChatFormatting.DARK_RED);
        }
        items.forEach(pair -> {
            for (int i = 0; i < (Integer)pair.second; ++i) {
                this.purchase((PurchasableItem)pair.first);
            }
        });
        return Component.literal((String)"Success!").withStyle(ChatFormatting.GREEN);
    }

    public boolean purchase(PurchasableItem item) {
        if (!this.takeFunds(item.price)) {
            return false;
        }
        this.player.addItem(new ItemStack((ItemLike)item.item(), item.count));
        return true;
    }

    public boolean takeFunds(int funds) {
        if (this.buyingPower() < funds) {
            return false;
        }
        Inventory inventory = this.player.getInventory();
        int remaining = funds;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (!inventory.getItem(i).is(this.currencyItem)) continue;
            int count = inventory.getItem(i).getCount();
            if (count > remaining) {
                inventory.getItem(i).shrink(remaining);
                return true;
            }
            remaining -= count;
            inventory.removeItem(i, count);
        }
        return true;
    }

    public static void init(MinecraftServer server) {
        FFPRegistries.CATALOG_TABS.forEach(catalogTab -> catalogTab.getTabShops().forEach(tabShop -> PurchaseSys.addItems(tabShop.literalID(), tabShop.getShopItems())));
    }

    public static Int2ObjectArrayMap<PurchasableItem> items() {
        return new Int2ObjectArrayMap(ITEMS);
    }

    public static PurchasableItem createItem(DeferredItem<Item> itemSupplier, int price, String description) {
        return new PurchasableItem((Pair<DeferredHolder<? extends ItemLike, ? extends ItemLike>, Item>)new Pair(itemSupplier, null), price, description, (Pair<Integer, String>)new Pair(null, null), 1);
    }

    public static PurchasableItem createItem(DeferredBlock<Block> blockSupplier, int price, String description) {
        return new PurchasableItem((Pair<DeferredHolder<? extends ItemLike, ? extends ItemLike>, Item>)new Pair(blockSupplier, null), price, description, (Pair<Integer, String>)new Pair(null, null), 1);
    }

    public static PurchasableItem createItem(DeferredItem<Item> itemSupplier, int price, int count, String description) {
        return new PurchasableItem((Pair<DeferredHolder<? extends ItemLike, ? extends ItemLike>, Item>)new Pair(itemSupplier, null), price, description, (Pair<Integer, String>)new Pair(null, null), count);
    }

    public static PurchasableItem createItem(DeferredBlock<Block> blockSupplier, int price, int count, String description) {
        return new PurchasableItem((Pair<DeferredHolder<? extends ItemLike, ? extends ItemLike>, Item>)new Pair(blockSupplier, null), price, description, (Pair<Integer, String>)new Pair(null, null), count);
    }

    private static void addItems(String catalog, List<PurchasableItem> items) {
        items.forEach(item -> PurchaseSys.addItem(catalog, item));
    }

    private static void addItem(String catalog, PurchasableItem item) {
        item.id.setFirst((Object)ITEMS.size());
        item.id.setSecond((Object)catalog);
        ITEMS.put(((Integer)item.id.first).intValue(), (Object)item);
    }

    public static Int2ObjectArrayMap<PurchasableItem> deserialize(CompoundTag tag) {
        Int2ObjectArrayMap ret = new Int2ObjectArrayMap();
        for (String itemTag : tag.getAllKeys()) {
            CompoundTag itemTagCompound = tag.getCompound(itemTag);
            PurchasableItem item = PurchasableItem.deserialize(itemTagCompound);
            ret.put(item.getId(), (Object)item);
        }
        return ret;
    }

    public void handleMessage(ScreenScheme.ScreenMessage message) {
        CompoundTag compoundTag = message.tag();
        if (!compoundTag.contains("items")) {
            return;
        }
        ArrayList<Pair<PurchasableItem, Integer>> purchasing = new ArrayList<Pair<PurchasableItem, Integer>>();
        for (Tag cartTag : compoundTag.getList("items", 10)) {
            CompoundTag nbt = (CompoundTag)cartTag;
            int id = nbt.getInt("id");
            int count = nbt.getInt("count");
            if (!ITEMS.containsKey(id) || count < 0) continue;
            purchasing.add((Pair<PurchasableItem, Integer>)Pair.of((Object)((PurchasableItem)ITEMS.get(id)), (Object)count));
        }
        Component component = this.handlePurchase(purchasing);
        CompoundTag response = new CompoundTag();
        response.putString("response", Component.Serializer.toJson((Component)component, (HolderLookup.Provider)this.player.level().registryAccess()));
        this.sendNbt(response);
    }

    public record PurchasableItem(Pair<DeferredHolder<? extends ItemLike, ? extends ItemLike>, Item> suppliedItem, int price, String description, Pair<Integer, String> id, int count) {
        public Item item() {
            return this.suppliedItem.first == null ? (Item)this.suppliedItem.second : ((ItemLike)((DeferredHolder)this.suppliedItem.getFirst()).get()).asItem();
        }

        public int getId() {
            return (Integer)this.id.first;
        }

        public String tabOwner() {
            return (String)this.id.second;
        }

        public int getCount() {
            return this.count;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.putString("item", ((DeferredHolder)this.suppliedItem.getFirst()).getId().toString());
            tag.putInt("price", this.price);
            tag.putString("desc", this.description);
            tag.putInt("id", ((Integer)this.id.first).intValue());
            tag.putString("tabOwner", (String)this.id.second);
            tag.putInt("count", this.count);
            return tag;
        }

        public static PurchasableItem deserialize(CompoundTag tag) {
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getString("item")));
            if (item == null) {
                throw new IllegalArgumentException("Invalid item: " + tag.getString("item"));
            }
            int price = tag.getInt("price");
            String desc = tag.getString("desc");
            int id = tag.getInt("id");
            String tabOwner = tag.getString("tabOwner");
            int count = tag.getInt("count");
            return new PurchasableItem((Pair<DeferredHolder<? extends ItemLike, ? extends ItemLike>, Item>)new Pair(null, (Object)item), price, desc, (Pair<Integer, String>)new Pair((Object)id, (Object)tabOwner), count);
        }

        public String name() {
            return Component.translatable((String)this.item().getDescriptionId()).getString();
        }
    }
}

