/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.util;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.util.CatalogTabShop;

public class CatalogTab {
    private final Supplier<ItemStack> iconGenerator;
    private final Component displayName;
    private final TabShopsGenerator tabShopsGenerator;
    private Collection<Supplier<CatalogTabShop>> tabShopsDisplay;
    private final ResourceLocation[] tabSprite;
    Supplier<List<CatalogTabShop>> memo = Suppliers.memoize(() -> this.tabShopsDisplay.stream().map(Supplier::get).toList());

    public CatalogTab(Supplier<ItemStack> iconGenerator, Component displayName, TabShopsGenerator tabShopsGenerator, ResourceLocation[] tabSprite) {
        this.iconGenerator = iconGenerator;
        this.displayName = displayName;
        this.tabShopsGenerator = tabShopsGenerator;
        this.tabShopsDisplay = new ArrayList<Supplier<CatalogTabShop>>();
        this.tabSprite = tabSprite;
        this.buildContents();
    }

    public CatalogTab(Builder builder) {
        this(builder.iconGenerator, builder.displayName, builder.tabShopsGenerator, builder.tabSprite);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public Supplier<ItemStack> getIconItem() {
        return this.iconGenerator;
    }

    public List<CatalogTabShop> getTabShops() {
        return this.memo.get();
    }

    public ResourceLocation[] getTabSprite() {
        return this.tabSprite;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void buildContents() {
        ShopDisplayBuilder shopDisplayBuilder = new ShopDisplayBuilder(this);
        this.tabShopsGenerator.accept(shopDisplayBuilder);
        this.tabShopsDisplay = shopDisplayBuilder.tabContents;
    }

    @FunctionalInterface
    public static interface TabShopsGenerator {
        public void accept(Output var1);
    }

    public static class Builder {
        private Supplier<ItemStack> iconGenerator;
        private final Function<Builder, CatalogTab> tabFactory;
        private Component displayName;
        private TabShopsGenerator tabShopsGenerator;
        private ResourceLocation[] tabSprite = new ResourceLocation[]{FFPackage.resource("catalog/catalog_tab_unselected"), FFPackage.resource("catalog/catalog_tab_selected")};

        public Builder() {
            this.tabShopsGenerator = output -> {};
            this.displayName = Component.empty();
            this.iconGenerator = () -> ItemStack.EMPTY;
            this.tabFactory = CatalogTab::new;
        }

        public Builder icon(Supplier<ItemStack> icon) {
            this.iconGenerator = icon;
            return this;
        }

        public Builder displayName(Component displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder tabShops(TabShopsGenerator tabShopsGenerator) {
            this.tabShopsGenerator = tabShopsGenerator;
            return this;
        }

        public Builder tabSprite(ResourceLocation disabledSprite, ResourceLocation enabledSprite) {
            this.tabSprite = new ResourceLocation[]{disabledSprite, enabledSprite};
            return this;
        }

        public CatalogTab build() {
            return this.tabFactory.apply(this);
        }
    }

    static class ShopDisplayBuilder
    implements Output {
        public final Collection<Supplier<CatalogTabShop>> tabContents = new ArrayList<Supplier<CatalogTabShop>>();
        private final CatalogTab tab;

        public ShopDisplayBuilder(CatalogTab tab) {
            this.tab = tab;
        }

        @Override
        public void accept(Supplier<CatalogTabShop> catalogTabShop) {
            boolean flag = this.tabContents.contains(catalogTabShop);
            if (flag) {
                throw new IllegalStateException("Duplicate registry of tab %s to catalog %s".formatted(catalogTabShop, this.tab.getDisplayName().getString()));
            }
            this.tabContents.add(catalogTabShop);
        }
    }

    public static interface Output {
        public void accept(Supplier<CatalogTabShop> var1);

        default public void acceptItem(Supplier<CatalogTabShop> tabShop) {
            this.accept(tabShop);
        }

        default public void acceptAllItems(Collection<Supplier<CatalogTabShop>> tabShops) {
            tabShops.forEach(this::accept);
        }
    }
}

