/*
 * Decompiled with CFR 0.152.
 */
package net.mudhut.ffpackage.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.mudhut.ffpackage.FFPackage;
import net.mudhut.ffpackage.server.purchase.PurchaseSys;

public final class CatalogTabShop {
    private final List<PurchaseSys.PurchasableItem> shopItems;
    private final String literalID;
    private final Component displayName;
    private final ResourceLocation[] tabSprite;

    public CatalogTabShop(String literalID, Component displayName, List<PurchaseSys.PurchasableItem> shopItems, ResourceLocation[] tabSprite) {
        this.displayName = displayName;
        this.literalID = literalID;
        this.shopItems = shopItems;
        this.tabSprite = tabSprite;
    }

    public CatalogTabShop(Builder builder) {
        this(builder.literalID, builder.displayName, builder.shopItems, builder.tabSprite);
    }

    public String literalID() {
        return this.literalID;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public List<PurchaseSys.PurchasableItem> getShopItems() {
        return this.shopItems;
    }

    public ResourceLocation[] getTabSprite() {
        return this.tabSprite;
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public static class Builder {
        private final Function<Builder, CatalogTabShop> shopFactory = CatalogTabShop::new;
        private final String literalID;
        private Component displayName;
        private final List<PurchaseSys.PurchasableItem> shopItems;
        private ResourceLocation[] tabSprite;

        public Builder(String literalID) {
            this.literalID = literalID;
            this.tabSprite = new ResourceLocation[]{FFPackage.resource("catalog/catalog_shop_unselected"), FFPackage.resource("catalog/catalog_shop_selected")};
            this.shopItems = new ArrayList<PurchaseSys.PurchasableItem>();
            this.displayName = Component.empty();
        }

        public Builder title(Component title) {
            this.displayName = title;
            return this;
        }

        public Builder shopItems(Consumer<List<PurchaseSys.PurchasableItem>> shopItems) {
            shopItems.accept(this.shopItems);
            return this;
        }

        public Builder tabSprite(ResourceLocation disabledSprite, ResourceLocation enabledSprite) {
            this.tabSprite = new ResourceLocation[]{disabledSprite, enabledSprite};
            return this;
        }

        public CatalogTabShop build() {
            return this.shopFactory.apply(this);
        }
    }
}

