/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube;

import java.io.File;
import net.pitan76.easyapi.FileControl;
import net.pitan76.easyapi.config.JsonConfig;

public class Config {
    public static File configDir;
    public static String fileName;
    public static JsonConfig config;
    public static boolean initialized;

    public static void init(File configDir) {
        if (initialized) {
            return;
        }
        initialized = true;
        Config.setConfigDir(configDir);
        Config.defaultConfig();
        if (FileControl.fileExists((File)Config.getConfigFile())) {
            config.load(Config.getConfigFile());
        } else {
            config.save(Config.getConfigFile());
        }
        Config.fixConfig();
    }

    public static File getConfigFile() {
        return new File(Config.getConfigDir(), fileName);
    }

    public static void setConfigDir(File configDir) {
        Config.configDir = configDir;
    }

    public static File getConfigDir() {
        return configDir;
    }

    public static boolean reload() {
        if (FileControl.fileExists((File)Config.getConfigFile())) {
            config.load(Config.getConfigFile());
            return true;
        }
        return false;
    }

    public static void defaultConfig() {
        config.setDouble("energy.rebornEnergyConversionRate", 1.0);
        config.setBoolean("chunkloader.enabled", true);
        config.setInt("chunkloader.radius", 2);
    }

    public static void fixConfig() {
        if (config.has("chunkloader")) {
            Config.config.configMap.remove("chunkloader");
        }
        if (!config.has("energy.rebornEnergyConversionRate")) {
            config.setDouble("energy.rebornEnergyConversionRate", 1.0);
        }
        if (!config.has("chunkloader.enabled")) {
            config.setBoolean("chunkloader.enabled", true);
        }
        if (!config.has("chunkloader.radius")) {
            config.setInt("chunkloader.radius", 2);
        }
    }

    public static void save() {
        config.save(Config.getConfigFile());
    }

    public static double getRebornEnergyConversionRate() {
        try {
            return config.getDouble("energy.rebornEnergyConversionRate");
        }
        catch (NullPointerException e) {
            config.setDouble("energy.rebornEnergyConversionRate", 1.0);
            config.save(Config.getConfigFile());
            return 1.0;
        }
    }

    public static boolean enabledChunkLoader() {
        try {
            return config.getBoolean("chunkloader.enabled");
        }
        catch (NullPointerException e) {
            config.setBoolean("chunkloader.enabled", true);
            config.save(Config.getConfigFile());
            return true;
        }
    }

    public static int getChunkLoaderRadius() {
        try {
            return config.getInt("chunkloader.radius");
        }
        catch (NullPointerException e) {
            config.setInt("chunkloader.radius", 2);
            config.save(Config.getConfigFile());
            return 2;
        }
    }

    static {
        fileName = "spacecube.json";
        config = new JsonConfig();
        initialized = false;
    }
}

