/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1792;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.pitan76.mcpitanlib.api.command.CommandRegistry;
import net.pitan76.mcpitanlib.api.command.LiteralCommand;
import net.pitan76.mcpitanlib.api.item.CreativeTabBuilder;
import net.pitan76.mcpitanlib.api.registry.v2.CompatRegistryV2;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.fabric.FabricFluidStorage;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.PlatformUtil;
import net.pitan76.mcpitanlib.fabric.ExtendModInitializer;
import net.pitan76.spacecube.BlockEntities;
import net.pitan76.spacecube.Blocks;
import net.pitan76.spacecube.Config;
import net.pitan76.spacecube.Items;
import net.pitan76.spacecube.api.tunnel.TunnelType;
import net.pitan76.spacecube.api.tunnel.def.FluidTunnel;
import net.pitan76.spacecube.api.tunnel.def.ITunnelDef;
import net.pitan76.spacecube.blockentity.SpaceCubeBlockEntity;
import net.pitan76.spacecube.blockentity.TunnelWallBlockEntity;
import net.pitan76.spacecube.cmd.SpaceCubeCommand;
import net.pitan76.spacecube.compat.RebornEnergyRegister;
import net.pitan76.spacecube.world.ChunkTicketTypes;

public class SpaceCube
extends ExtendModInitializer {
    public static final String MOD_ID = "spacecube";
    public static final String MOD_NAME = "Space Cube";
    public static SpaceCube INSTANCE;
    public static CompatRegistryV2 registry;
    public static final CreativeTabBuilder SPACE_CUBE_CREATIVE_TAB;
    public static final CompatIdentifier SPACE_CUBE_DIMENSION_WORLD_KEY;

    public void init() {
        INSTANCE = this;
        registry = ((ExtendModInitializer)this).registry;
        Config.init(PlatformUtil.getConfigFolder().toFile());
        registry.registerItemGroup(SPACE_CUBE_CREATIVE_TAB);
        Blocks.init();
        Items.init();
        BlockEntities.init();
        ChunkTicketTypes.init();
        SpaceCube.registerFluidStorage();
        SpaceCube.registerEnergyStorage();
        CommandRegistry.register((String)MOD_ID, (LiteralCommand)new SpaceCubeCommand());
    }

    public String getId() {
        return MOD_ID;
    }

    public String getName() {
        return MOD_NAME;
    }

    public static void registerEnergyStorage() {
        if (PlatformUtil.isModLoaded((String)"team_reborn_energy")) {
            RebornEnergyRegister.init();
        }
    }

    public static void registerFluidStorage() {
        FluidStorage.SIDED.registerForBlockEntity((blockEntity, dir) -> {
            ITunnelDef def;
            if (blockEntity instanceof TunnelWallBlockEntity && (def = ((TunnelWallBlockEntity)((Object)blockEntity)).getTunnelDef()) instanceof FluidTunnel) {
                return ((FabricFluidStorage)((FluidTunnel)def).getFluidStorage()).storage;
            }
            return null;
        }, (class_2591)BlockEntities.TUNNEL_WALL_BLOCK_ENTITY.getOrNull());
        FluidStorage.SIDED.registerForBlockEntity((blockEntity, dir) -> {
            SpaceCubeBlockEntity scBlockEntity;
            ITunnelDef def;
            if (blockEntity instanceof SpaceCubeBlockEntity && (def = (scBlockEntity = (SpaceCubeBlockEntity)((Object)blockEntity)).getTunnelDef(TunnelType.FLUID, (class_2350)dir)) instanceof FluidTunnel) {
                return ((FabricFluidStorage)((FluidTunnel)def).getFluidStorage()).storage;
            }
            return null;
        }, (class_2591)BlockEntities.SPACE_CUBE_BLOCK_ENTITY.getOrNull());
    }

    public static CompatIdentifier _id(String id) {
        return CompatIdentifier.of((String)MOD_ID, (String)id);
    }

    static {
        SPACE_CUBE_CREATIVE_TAB = CreativeTabBuilder.create((CompatIdentifier)SpaceCube._id("creative_tab")).setIcon(() -> ItemStackUtil.create((class_1792)Items.NORMAL_SPACE_CUBE, (int)1));
        SPACE_CUBE_DIMENSION_WORLD_KEY = SpaceCube._id("space_cube_dimension");
    }
}

