/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.api.list;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.collection.ItemStackList;
import net.pitan76.spacecube.api.tunnel.TunnelType;
import net.pitan76.spacecube.api.tunnel.def.ItemTunnel;
import net.pitan76.spacecube.blockentity.SpaceCubeBlockEntity;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TunnelIODefaultedList
extends ItemStackList {
    private final SpaceCubeBlockEntity blockEntity;

    protected TunnelIODefaultedList(List<class_1799> delegate, @Nullable class_1799 initialElement, SpaceCubeBlockEntity blockEntity) {
        super(delegate, initialElement);
        this.blockEntity = blockEntity;
    }

    public static TunnelIODefaultedList ofSize(SpaceCubeBlockEntity entity) {
        return TunnelIODefaultedList.ofSize(ItemTunnel.defaultSize * class_2350.values().length, ItemStackUtil.empty(), entity);
    }

    public static TunnelIODefaultedList ofSize(int size, class_1799 defaultValue, SpaceCubeBlockEntity entity) {
        Validate.notNull((Object)defaultValue);
        Object[] objects = new class_1799[size];
        Arrays.fill(objects, defaultValue);
        return new TunnelIODefaultedList(Arrays.asList(objects), defaultValue, entity);
    }

    public class_1799 set(int index, class_1799 stack) {
        if (!this.blockEntity.hasTunnelType(TunnelType.ITEM)) {
            return ItemStackUtil.empty();
        }
        class_2350 dir = SpaceCubeBlockEntity.indexToDir(Math.floorDiv(index, 2));
        ItemTunnel itemTunnel = (ItemTunnel)this.blockEntity.getTunnelDef(TunnelType.ITEM, dir);
        if (itemTunnel == null) {
            return ItemStackUtil.empty();
        }
        if (index % 2 == 0) {
            itemTunnel.setImportStack(stack);
        } else {
            itemTunnel.setExportStack(stack);
        }
        return (class_1799)super.set(index, (Object)stack);
    }

    @NotNull
    public class_1799 get(int index) {
        if (!this.blockEntity.hasTunnelType(TunnelType.ITEM)) {
            return ItemStackUtil.empty();
        }
        class_2350 dir = SpaceCubeBlockEntity.indexToDir(Math.floorDiv(index, 2));
        ItemTunnel itemTunnel = (ItemTunnel)this.blockEntity.getTunnelDef(TunnelType.ITEM, dir);
        if (itemTunnel == null) {
            return ItemStackUtil.empty();
        }
        if (index % 2 == 0) {
            return itemTunnel.getImportStack();
        }
        return itemTunnel.getExportStack();
    }
}

