/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.api.tunnel.def;

import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.util.nbt.v2.NbtRWUtil;
import net.pitan76.spacecube.api.tunnel.TunnelType;
import net.pitan76.spacecube.api.tunnel.def.ITunnelDef;
import net.pitan76.spacecube.blockentity.TunnelWallBlockEntity;
import net.pitan76.spacecube.compat.TunnelEnergyStorage;

public class EnergyTunnel
implements ITunnelDef {
    private TunnelWallBlockEntity blockEntity = null;
    public TunnelEnergyStorage energyStorage = null;
    public long energy = 0L;

    public EnergyTunnel(TunnelWallBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    public TunnelType getTunnelType() {
        return TunnelType.ENERGY;
    }

    @Override
    public TunnelWallBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public TunnelEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void setEnergyStorage(TunnelEnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    public boolean hasEnergyStorage() {
        return this.energyStorage != null;
    }

    public long getEnergy() {
        return this.energy;
    }

    public void setEnergy(long energy) {
        this.energy = energy;
    }

    public long getMaxEnergy() {
        return 10000L;
    }

    public long getUsableCapacity() {
        return this.getMaxEnergy() - this.energy;
    }

    public long insertEnergy(long amount) {
        long usableCapacity = this.getUsableCapacity();
        if (amount > usableCapacity) {
            this.energy += usableCapacity;
            return usableCapacity;
        }
        this.energy += amount;
        return amount;
    }

    public long extractEnergy(long amount) {
        if (amount > this.energy) {
            long energy = this.energy;
            this.energy = 0L;
            return energy;
        }
        this.energy -= amount;
        return amount;
    }

    public boolean isEmpty() {
        return this.energy == 0L;
    }

    public boolean isFull() {
        return this.energy == this.getMaxEnergy();
    }

    @Override
    public void writeNbt(WriteNbtArgs args) {
        NbtRWUtil.putLong((WriteNbtArgs)args, (String)"energy", (long)this.energy);
    }

    @Override
    public void readNbt(ReadNbtArgs args) {
        this.energy = NbtRWUtil.getLong((ReadNbtArgs)args, (String)"energy");
    }
}

