/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.api.util;

import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;
import net.pitan76.spacecube.SpaceCube;
import net.pitan76.spacecube.world.SpaceCubeState;
import org.jetbrains.annotations.Nullable;

public class SpaceCubeUtil {
    public static class_2338 getNewPos(SpaceCubeState state) {
        int scCount = state.getSpacePosWithSCBlockPath().size() + 1;
        int mod = Math.floorMod(scCount, 4);
        int div = Math.floorDiv(scCount, 4);
        switch (mod) {
            case 0: {
                return PosUtil.flooredBlockPos((double)(div * 1024), (double)64.0, (double)(div * 1024));
            }
            case 1: {
                return PosUtil.flooredBlockPos((double)(div * -1024), (double)64.0, (double)(div * 1024));
            }
            case 2: {
                return PosUtil.flooredBlockPos((double)(div * 1024 + 1024), (double)64.0, (double)(div * 1024));
            }
            case 3: {
                return PosUtil.flooredBlockPos((double)(div * 1024), (double)64.0, (double)(div * 1024 + 1024));
            }
        }
        return PosUtil.flooredBlockPos((double)0.0, (double)64.0, (double)0.0);
    }

    @Nullable
    public static class_2338 getNearestPos(SpaceCubeState state, class_2338 pos) {
        class_2338 nearestPos = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_2338 scRoomPos : state.getSpacePosWithSCBlockPath().keySet()) {
            double distance = PosUtil.getSquaredDistance((class_2338)pos, (double)PosUtil.x((class_2338)scRoomPos), (double)PosUtil.y((class_2338)scRoomPos), (double)PosUtil.z((class_2338)scRoomPos));
            if (!(distance < nearestDistance)) continue;
            nearestPos = scRoomPos;
            nearestDistance = distance;
        }
        if (nearestPos == null) {
            return null;
        }
        return PosUtil.flooredBlockPos((double)PosUtil.x(nearestPos), (double)64.0, (double)PosUtil.z(nearestPos));
    }

    @Nullable
    public static class_2338 getNearestPos(class_3218 world, class_2338 pos) {
        Optional optionalServer = WorldUtil.getServer((class_1937)world);
        return SpaceCubeUtil.getNearestPos(SpaceCubeState.getOrCreate((MinecraftServer)optionalServer.get()), pos);
    }

    @Nullable
    public static BlockPos getNearestPos(ServerWorld world, BlockPos pos) {
        class_2338 pos1 = SpaceCubeUtil.getNearestPos(world.getRaw(), pos.toMinecraft());
        if (pos1 == null) {
            return null;
        }
        return BlockPos.of((class_2338)pos1);
    }

    public static class_2338 getNewPos(class_3218 world) {
        Optional optionalServer = WorldUtil.getServer((class_1937)world);
        return SpaceCubeUtil.getNewPos(SpaceCubeState.getOrCreate((MinecraftServer)optionalServer.get()));
    }

    public static BlockPos getNewPos(ServerWorld world) {
        return BlockPos.of((class_2338)SpaceCubeUtil.getNewPos(world.getRaw()));
    }

    public static int getSpaceCubeCount(SpaceCubeState state) {
        return state.getSpacePosWithSCBlockPath().size();
    }

    public static int getSpaceCubeCount(class_3218 world) {
        Optional optionalServer = WorldUtil.getServer((class_1937)world);
        return SpaceCubeUtil.getSpaceCubeCount(SpaceCubeState.getOrCreate((MinecraftServer)optionalServer.get()));
    }

    public static int getSpaceCubeCount(ServerWorld world) {
        return SpaceCubeUtil.getSpaceCubeCount(world.getRaw());
    }

    @Nullable
    public static class_3218 getSpaceCubeWorld(class_3218 world) {
        Optional optionalWorld = WorldUtil.getWorld((class_1937)world, (CompatIdentifier)SpaceCube.SPACE_CUBE_DIMENSION_WORLD_KEY);
        return optionalWorld.orElse(null);
    }

    public static ServerWorld getSpaceCubeWorld(ServerWorld world) {
        Optional optionalWorld = world.getWorld(SpaceCube.SPACE_CUBE_DIMENSION_WORLD_KEY);
        return optionalWorld.orElse(null);
    }
}

