/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.block;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.block.ExtendBlockEntityProvider;
import net.pitan76.mcpitanlib.api.block.v2.CompatBlock;
import net.pitan76.mcpitanlib.api.block.v2.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.block.BlockBreakEvent;
import net.pitan76.mcpitanlib.api.event.block.BlockPlacedEvent;
import net.pitan76.mcpitanlib.api.event.block.BlockUseEvent;
import net.pitan76.mcpitanlib.api.event.block.PickStackEvent;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;
import net.pitan76.mcpitanlib.api.event.block.result.BlockBreakResult;
import net.pitan76.mcpitanlib.api.event.item.ItemAppendTooltipEvent;
import net.pitan76.mcpitanlib.api.tile.CompatBlockEntity;
import net.pitan76.mcpitanlib.api.util.BlockEntityDataUtil;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.entity.ItemEntityUtil;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.spacecube.Blocks;
import net.pitan76.spacecube.SpaceCube;
import net.pitan76.spacecube.api.data.SCBlockPath;
import net.pitan76.spacecube.api.util.SpaceCubeUtil;
import net.pitan76.spacecube.blockentity.SpaceCubeBlockEntity;
import net.pitan76.spacecube.item.PersonalShrinkingDevice;
import net.pitan76.spacecube.item.SpaceCubeUpgrader;
import net.pitan76.spacecube.world.SpaceCubeState;
import org.jetbrains.annotations.Nullable;

public class SpaceCubeBlock
extends CompatBlock
implements ExtendBlockEntityProvider {
    public final int size;

    public SpaceCubeBlock(CompatibleBlockSettings settings, int size) {
        super(settings);
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public static SpaceCubeBlock getSpaceCubeBlockFromSize(int size) {
        switch (size) {
            case 2: {
                return Blocks.TINY_SPACE_CUBE;
            }
            case 3: {
                return Blocks.SMALL_SPACE_CUBE;
            }
            case 4: {
                return Blocks.NORMAL_SPACE_CUBE;
            }
            case 5: {
                return Blocks.LARGE_SPACE_CUBE;
            }
            case 6: {
                return Blocks.GIANT_SPACE_CUBE;
            }
            case 7: {
                return Blocks.MAXIMUM_SPACE_CUBE;
            }
        }
        return Blocks.NORMAL_SPACE_CUBE;
    }

    public CompatActionResult onRightClick(BlockUseEvent e) {
        Player player = e.getPlayer();
        if (e.isSneaking()) {
            return e.pass();
        }
        if (e.isClient()) {
            return e.success();
        }
        class_1792 handItem = player.getMainHandStack().method_7909();
        if (handItem instanceof PersonalShrinkingDevice || handItem instanceof SpaceCubeUpgrader) {
            return e.pass();
        }
        return e.success();
    }

    @Nullable
    public class_2586 createBlockEntity(TileCreateEvent e) {
        return new SpaceCubeBlockEntity(e);
    }

    public BlockBreakResult onBreak(BlockBreakEvent e) {
        World world = e.getMidohraWorld();
        BlockPos pos = e.getMidohraPos();
        class_2586 blockEntity = e.getBlockEntity();
        if (!e.isClient() && blockEntity instanceof SpaceCubeBlockEntity) {
            SpaceCubeBlockEntity spaceCubeBlockEntity = (SpaceCubeBlockEntity)blockEntity;
            if (e.player.isCreative() && !spaceCubeBlockEntity.isScRoomPosNull()) {
                class_1799 stack = ItemStackUtil.create((class_1935)this);
                BlockEntityDataUtil.writeCompatBlockEntityNbtToStack((class_1799)stack, (CompatBlockEntity)spaceCubeBlockEntity);
                ItemEntityUtil.createWithSpawn((class_1937)world.getRaw(), (class_1799)stack, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5));
            }
        }
        return super.onBreak(e);
    }

    public void onPlaced(BlockPlacedEvent e) {
        class_2586 blockEntity;
        World world = e.getMidohraWorld();
        BlockPos pos = e.getMidohraPos();
        class_1799 stack = e.getStack();
        if (!e.isClient() && BlockEntityDataUtil.hasBlockEntityNbt((class_1799)stack) && (blockEntity = e.getBlockEntity()) instanceof SpaceCubeBlockEntity) {
            class_2338 scRoomPos;
            SpaceCubeBlockEntity spaceCubeBlockEntity = (SpaceCubeBlockEntity)blockEntity;
            BlockEntityDataUtil.readCompatBlockEntityNbtFromStack((class_1799)stack, (CompatBlockEntity)spaceCubeBlockEntity);
            class_3218 spaceCubeWorld = SpaceCubeUtil.getSpaceCubeWorld((class_3218)world.getRaw());
            if (spaceCubeWorld == null) {
                SpaceCube.INSTANCE.error("[SpaceCube] Error: spaceCubeWorld is null.");
                super.onPlaced(e);
                return;
            }
            Optional optionalServer = WorldUtil.getServer((class_1937)spaceCubeWorld);
            SpaceCubeState spaceCubeState = SpaceCubeState.getOrCreate((MinecraftServer)optionalServer.get());
            Map<class_2338, SCBlockPath> spacePosWithSCBlockPath = spaceCubeState.getSpacePosWithSCBlockPath();
            if (spacePosWithSCBlockPath.containsKey(scRoomPos = spaceCubeBlockEntity.getScRoomPos())) {
                SCBlockPath scBlockPath = spacePosWithSCBlockPath.get(scRoomPos);
                scBlockPath.setPos(pos.toMinecraft());
                scBlockPath.setDimension(world.getId());
            }
        }
        super.onPlaced(e);
    }

    public class_1799 getPickStack(PickStackEvent e) {
        class_1799 stack = super.getPickStack(e);
        try {
            if (e.getBlockEntity() instanceof SpaceCubeBlockEntity) {
                SpaceCubeBlockEntity spaceCubeBlockEntity = (SpaceCubeBlockEntity)e.getBlockEntity();
                BlockEntityDataUtil.writeCompatBlockEntityNbtToStack((class_1799)stack, (CompatBlockEntity)spaceCubeBlockEntity);
            }
        }
        catch (NullPointerException exception) {
            SpaceCube.INSTANCE.error("[SpaceCube] Error: SpaceCubeBlockEntity is null. BlockPos: " + e.pos.toString());
        }
        return stack;
    }

    public void appendTooltip(ItemAppendTooltipEvent e) {
        super.appendTooltip(e);
        int side = this.size * 2 - 1;
        e.addTooltip((class_2561)TextUtil.translatable((String)"tooltip.spacecube.space_cube_block.size", (Object[])new Object[]{side + "x" + side + "x" + side}));
    }
}

