/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.block;

import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.pitan76.mcpitanlib.api.block.ExtendBlockEntityProvider;
import net.pitan76.mcpitanlib.api.block.v2.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.event.block.AppendPropertiesArgs;
import net.pitan76.mcpitanlib.api.event.block.BlockBreakEvent;
import net.pitan76.mcpitanlib.api.event.block.BlockUseEvent;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;
import net.pitan76.mcpitanlib.api.event.block.result.BlockBreakResult;
import net.pitan76.mcpitanlib.api.state.property.BooleanProperty;
import net.pitan76.mcpitanlib.api.state.property.CompatProperties;
import net.pitan76.mcpitanlib.api.state.property.DirectionProperty;
import net.pitan76.mcpitanlib.api.state.property.IProperty;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.util.math.Direction;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.spacecube.Blocks;
import net.pitan76.spacecube.api.data.TunnelSideData;
import net.pitan76.spacecube.api.tunnel.TunnelType;
import net.pitan76.spacecube.block.WallBlock;
import net.pitan76.spacecube.blockentity.SpaceCubeBlockEntity;
import net.pitan76.spacecube.blockentity.TunnelWallBlockEntity;
import org.jetbrains.annotations.Nullable;

public class TunnelWallBlock
extends WallBlock
implements ExtendBlockEntityProvider {
    public static final DirectionProperty TUNNEL_SIDE = DirectionProperty.of((String)"tunnel_side");
    public static final DirectionProperty CONNECTED_SIDE = DirectionProperty.of((String)"connected_side");
    public static final BooleanProperty POWERED = CompatProperties.POWERED;

    public TunnelWallBlock(CompatibleBlockSettings settings) {
        super(settings);
        this.setDefaultState(this.getDefaultMidohraState().with(CONNECTED_SIDE, Direction.UP).with(TUNNEL_SIDE, Direction.UP).with((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public static TunnelType getTunnelType(World world, BlockPos pos) {
        return TunnelWallBlock.getTunnelType(world.getRaw(), pos.toMinecraft());
    }

    public static TunnelType getTunnelType(class_1937 world, class_2338 pos) {
        TunnelWallBlockEntity blockEntity = (TunnelWallBlockEntity)WorldUtil.getBlockEntity((class_1937)world, (class_2338)pos);
        return blockEntity == null ? TunnelType.NONE : blockEntity.getTunnelType();
    }

    public CompatActionResult onRightClick(BlockUseEvent e) {
        TunnelWallBlockEntity tunnelWallBlockEntity;
        World world = e.getMidohraWorld();
        BlockPos pos = e.getMidohraPos();
        if (e.isClient()) {
            return e.success();
        }
        BlockState state = e.getMidohraState();
        if (e.isSneaking()) {
            if (e.getBlockEntity() instanceof TunnelWallBlockEntity) {
                TunnelWallBlockEntity tunnelWallBlockEntity2 = (TunnelWallBlockEntity)e.getBlockEntity();
                Optional<class_1792> item = tunnelWallBlockEntity2.getTunnelItem();
                item.ifPresent(value -> e.getPlayer().giveStack(ItemStackUtil.create((class_1792)value, (int)1)));
                if (tunnelWallBlockEntity2.existSpaceCubeBlockEntity()) {
                    Optional<SpaceCubeBlockEntity> spaceCubeBlockEntity = tunnelWallBlockEntity2.getSpaceCubeBlockEntity();
                    TunnelType tunnelType = tunnelWallBlockEntity2.getTunnelType();
                    Direction dir = state.get(CONNECTED_SIDE);
                    if (spaceCubeBlockEntity.isPresent() && spaceCubeBlockEntity.get().hasTunnel(tunnelType, dir)) {
                        spaceCubeBlockEntity.get().removeTunnel(tunnelType, dir);
                    }
                }
            }
            world.setBlockState(pos, Blocks.SOLID_WALL.getDefaultMidohraState());
            return e.success();
        }
        if (e.getBlockEntity() instanceof TunnelWallBlockEntity && (tunnelWallBlockEntity = (TunnelWallBlockEntity)e.getBlockEntity()).existSpaceCubeBlockEntity()) {
            Optional<SpaceCubeBlockEntity> spaceCubeBlockEntity = tunnelWallBlockEntity.getSpaceCubeBlockEntity();
            if (!spaceCubeBlockEntity.isPresent()) {
                return e.fail();
            }
            if (state.contains(CONNECTED_SIDE)) {
                Direction dir = state.get(CONNECTED_SIDE);
                TunnelSideData tunnelSide = spaceCubeBlockEntity.get().getTunnelSide(tunnelWallBlockEntity.getTunnelType());
                if (spaceCubeBlockEntity.get().tunnelIsFull(tunnelWallBlockEntity.getTunnelType())) {
                    e.getPlayer().sendMessage((class_2561)TextUtil.translatable((String)"message.spacecube.tunnel_full"));
                    return e.fail();
                }
                Optional<Direction> nextDir = tunnelSide.getNextDir(dir);
                if (!nextDir.isPresent()) {
                    e.getPlayer().sendMessage((class_2561)TextUtil.literal((String)"[SpaceCube] Error: No next direction found"));
                    return e.fail();
                }
                Direction nextDirValue = nextDir.get();
                world.setBlockState(pos, world.getBlockState(pos).with(CONNECTED_SIDE, nextDirValue));
                if (!tunnelSide.hasTunnel(nextDirValue)) {
                    tunnelSide.removeTunnel(dir);
                    tunnelSide.addTunnel(nextDirValue, pos);
                }
            }
        }
        return super.onRightClick(e);
    }

    public void appendProperties(AppendPropertiesArgs args) {
        args.addProperty(new IProperty[]{TUNNEL_SIDE});
        args.addProperty(new IProperty[]{CONNECTED_SIDE});
        args.addProperty(new IProperty[]{POWERED});
        super.appendProperties(args);
    }

    @Nullable
    public class_2586 createBlockEntity(TileCreateEvent event) {
        return new TunnelWallBlockEntity(event);
    }

    public BlockBreakResult onBreak(BlockBreakEvent e) {
        TunnelWallBlockEntity tunnelWallBlockEntity;
        BlockState state = e.getMidohraState();
        if (e.getBlockEntity() instanceof TunnelWallBlockEntity && (tunnelWallBlockEntity = (TunnelWallBlockEntity)e.getBlockEntity()).existSpaceCubeBlockEntity()) {
            Optional<SpaceCubeBlockEntity> spaceCubeBlockEntity = tunnelWallBlockEntity.getSpaceCubeBlockEntity();
            if (!spaceCubeBlockEntity.isPresent()) {
                return super.onBreak(e);
            }
            TunnelType tunnelType = tunnelWallBlockEntity.getTunnelType();
            Direction dir = state.get(CONNECTED_SIDE);
            if (spaceCubeBlockEntity.get().hasTunnel(tunnelType, dir)) {
                spaceCubeBlockEntity.get().removeTunnel(tunnelType, dir);
            }
        }
        return super.onBreak(e);
    }
}

