/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.blockentity;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.gui.inventory.IInventory;
import net.pitan76.mcpitanlib.api.gui.inventory.sided.CompatSidedInventory;
import net.pitan76.mcpitanlib.api.gui.inventory.sided.args.AvailableSlotsArgs;
import net.pitan76.mcpitanlib.api.gui.inventory.sided.args.CanExtractArgs;
import net.pitan76.mcpitanlib.api.gui.inventory.sided.args.CanInsertArgs;
import net.pitan76.mcpitanlib.api.tile.CompatBlockEntity;
import net.pitan76.mcpitanlib.api.util.BlockEntityUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.collection.ItemStackList;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.util.math.Direction;
import net.pitan76.mcpitanlib.midohra.world.chunk.ChunkTicketType;
import net.pitan76.spacecube.BlockEntities;
import net.pitan76.spacecube.Config;
import net.pitan76.spacecube.api.data.TunnelSideData;
import net.pitan76.spacecube.api.list.TunnelIODefaultedList;
import net.pitan76.spacecube.api.tunnel.TunnelType;
import net.pitan76.spacecube.api.tunnel.def.ITunnelDef;
import net.pitan76.spacecube.api.tunnel.def.ItemTunnel;
import net.pitan76.spacecube.api.util.SpaceCubeUtil;
import net.pitan76.spacecube.blockentity.TunnelWallBlockEntity;
import net.pitan76.spacecube.world.ChunkTicketTypes;
import org.jetbrains.annotations.Nullable;

public class SpaceCubeBlockEntity
extends CompatBlockEntity
implements CompatSidedInventory,
IInventory {
    public class_2338 scRoomPos = null;
    private final Map<TunnelType, TunnelSideData> tunnelSides = new HashMap<TunnelType, TunnelSideData>();
    public boolean ticketedChunkSpaceCubeWorld = false;
    public boolean ticketedChunkMainWorld = false;

    public SpaceCubeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, new TileCreateEvent(pos, state));
    }

    public SpaceCubeBlockEntity(TileCreateEvent event) {
        super((class_2591)BlockEntities.SPACE_CUBE_BLOCK_ENTITY.getOrNull(), event);
    }

    public void setScRoomPos(class_2338 scRoomPos) {
        this.scRoomPos = scRoomPos;
    }

    public class_2338 getScRoomPos() {
        return this.scRoomPos;
    }

    public boolean isScRoomPosNull() {
        return this.scRoomPos == null;
    }

    public void writeNbt(WriteNbtArgs args) {
        super.writeNbt(args);
        class_2487 nbt = args.getNbt();
        if (!this.isScRoomPosNull()) {
            NbtUtil.setBlockPos((class_2487)nbt, (String)"scRoomPos", (class_2338)this.scRoomPos);
        }
        if (this.tunnelSides != null) {
            class_2487 tunnels_nbt = NbtUtil.create();
            for (TunnelType type : this.tunnelSides.keySet()) {
                TunnelSideData data = this.getTunnelSide(type);
                class_2487 data_nbt = NbtUtil.create();
                for (Map.Entry<class_2350, class_2338> entry : data.getTunnels().entrySet()) {
                    class_2487 tunnel_nbt = NbtUtil.create();
                    NbtUtil.setBlockPosDirect((class_2487)tunnel_nbt, (class_2338)entry.getValue());
                    NbtUtil.put((class_2487)data_nbt, (String)entry.getKey().toString(), (class_2487)tunnel_nbt);
                }
                NbtUtil.put((class_2487)tunnels_nbt, (String)type.getId().toString(), (class_2487)data_nbt);
            }
            NbtUtil.put((class_2487)nbt, (String)"tunnels", (class_2487)tunnels_nbt);
        }
    }

    public void readNbt(ReadNbtArgs args) {
        super.readNbt(args);
        class_2487 nbt = args.getNbt();
        if (NbtUtil.has((class_2487)nbt, (String)"scRoomPos")) {
            this.scRoomPos = NbtUtil.getBlockPos((class_2487)nbt, (String)"scRoomPos");
            this.addTicket();
        }
        if (NbtUtil.has((class_2487)nbt, (String)"tunnels")) {
            class_2487 tunnels_nbt = NbtUtil.get((class_2487)nbt, (String)"tunnels");
            for (String type : NbtUtil.getKeys((class_2487)tunnels_nbt)) {
                TunnelType tunnelType = TunnelType.fromString(type);
                class_2487 data_nbt = NbtUtil.get((class_2487)tunnels_nbt, (String)type);
                TunnelSideData data = new TunnelSideData();
                for (String direction : NbtUtil.getKeys((class_2487)data_nbt)) {
                    class_2487 tunnel_nbt = NbtUtil.get((class_2487)data_nbt, (String)direction);
                    data.addTunnel(class_2350.valueOf((String)direction.toUpperCase()), NbtUtil.getBlockPosDirect((class_2487)tunnel_nbt));
                }
                this.tunnelSides.put(tunnelType, data);
            }
        }
    }

    public void addTicket() {
        this.addTicketSpaceCubeWorld();
        this.addTicketMainWorld();
    }

    public void addTicketSpaceCubeWorld() {
        if (this.ticketedChunkSpaceCubeWorld) {
            return;
        }
        if (!Config.enabledChunkLoader()) {
            return;
        }
        if (!(BlockEntityUtil.getWorld((class_2586)this) instanceof class_3218)) {
            return;
        }
        class_3218 spaceCubeWorld = SpaceCubeUtil.getSpaceCubeWorld((class_3218)BlockEntityUtil.getWorld((class_2586)this));
        if (spaceCubeWorld == null) {
            return;
        }
        class_1923 chunkPos = new class_1923(this.getScRoomPos());
        WorldUtil.addTicket((class_3218)spaceCubeWorld, (ChunkTicketType)((ChunkTicketType)ChunkTicketTypes.CHUNK_LOADER.get()), (class_1923)chunkPos, (int)Config.getChunkLoaderRadius());
        this.ticketedChunkSpaceCubeWorld = true;
    }

    public void addTicketMainWorld() {
        if (this.ticketedChunkMainWorld) {
            return;
        }
        if (!Config.enabledChunkLoader()) {
            return;
        }
        if (!(BlockEntityUtil.getWorld((class_2586)this) instanceof class_3218)) {
            return;
        }
        class_1937 mainWorld = BlockEntityUtil.getWorld((class_2586)this);
        if (!(mainWorld instanceof class_3218)) {
            return;
        }
        class_1923 chunkPos = new class_1923(BlockEntityUtil.getPos((class_2586)this));
        WorldUtil.addTicket((class_3218)((class_3218)mainWorld), (ChunkTicketType)((ChunkTicketType)ChunkTicketTypes.CHUNK_LOADER.get()), (class_1923)chunkPos, (int)Config.getChunkLoaderRadius());
        this.ticketedChunkMainWorld = true;
    }

    public Map<TunnelType, TunnelSideData> getTunnelSides() {
        return this.tunnelSides;
    }

    public boolean hasTunnel(TunnelType type, class_2350 direction) {
        if (!this.hasTunnelType(type)) {
            return false;
        }
        return this.getTunnelSide(type).hasTunnel(direction);
    }

    public boolean addTunnel(TunnelType type, class_2350 direction, class_2338 pos) {
        if (!this.tunnelSides.containsKey(type)) {
            this.addTunnelType(type);
        }
        if (this.getTunnelSide(type).hasTunnel(direction)) {
            return false;
        }
        this.getTunnelSide(type).addTunnel(direction, pos);
        return true;
    }

    public void addTunnelType(TunnelType type) {
        this.tunnelSides.put(type, new TunnelSideData());
    }

    public void removeTunnel(TunnelType type, class_2350 direction) {
        if (!this.tunnelSides.containsKey(type)) {
            return;
        }
        this.getTunnelSide(type).removeTunnel(direction);
    }

    public TunnelSideData getTunnelSide(TunnelType type) {
        if (!this.tunnelSides.containsKey(type)) {
            this.addTunnelType(type);
        }
        return this.tunnelSides.get(type);
    }

    public boolean hasTunnelType(TunnelType type) {
        return this.tunnelSides.containsKey(type);
    }

    public boolean tunnelIsFull(TunnelType type) {
        if (!this.hasTunnelType(type)) {
            return false;
        }
        return this.getTunnelSide(type).isFull();
    }

    public Optional<class_2350> getRestDir(TunnelType type) {
        if (!this.tunnelSides.containsKey(type)) {
            this.addTunnelType(type);
        }
        TunnelSideData data = this.getTunnelSide(type);
        return data.getRestDir();
    }

    public Optional<class_2350> getDir(TunnelType type, class_2338 pos) {
        if (!this.hasTunnelType(type)) {
            return Optional.empty();
        }
        TunnelSideData data = this.getTunnelSide(type);
        return data.getDir(pos);
    }

    public Optional<class_2350> getNextDir(TunnelType type, class_2350 dir) {
        if (!this.hasTunnelType(type)) {
            return Optional.empty();
        }
        TunnelSideData data = this.getTunnelSide(type);
        return data.getNextDir(dir);
    }

    public int[] getAvailableSlots(AvailableSlotsArgs args) {
        class_2350 side = args.getSide();
        if (!this.hasTunnelType(TunnelType.ITEM)) {
            return new int[0];
        }
        TunnelSideData data = this.getTunnelSide(TunnelType.ITEM);
        if (!data.hasTunnel(side)) {
            return new int[0];
        }
        class_3218 spaceCubeWorld = SpaceCubeUtil.getSpaceCubeWorld((class_3218)this.field_11863);
        if (spaceCubeWorld == null) {
            return new int[0];
        }
        class_2586 blockEntity = WorldUtil.getBlockEntity((class_1937)spaceCubeWorld, (class_2338)data.getTunnel(side));
        if (!(blockEntity instanceof TunnelWallBlockEntity)) {
            return new int[0];
        }
        TunnelWallBlockEntity tunnelWallBlockEntity = (TunnelWallBlockEntity)blockEntity;
        ITunnelDef tunnelDef = tunnelWallBlockEntity.getTunnelDef();
        if (!(tunnelDef instanceof ItemTunnel)) {
            return new int[0];
        }
        int dirindex = SpaceCubeBlockEntity.dirToIndex(side);
        this.addTicket();
        return new int[]{dirindex * 2, dirindex * 2 + 1};
    }

    public boolean canInsert(CanInsertArgs args) {
        class_2350 dir = args.getDir();
        int slot = args.getSlot();
        if (!this.hasTunnelType(TunnelType.ITEM)) {
            return false;
        }
        TunnelSideData data = this.getTunnelSide(TunnelType.ITEM);
        if (dir == null) {
            return false;
        }
        int dirindex = SpaceCubeBlockEntity.dirToIndex(dir);
        return data.hasTunnel(dir) && slot == dirindex * 2 + 1;
    }

    public boolean canExtract(CanExtractArgs args) {
        class_2350 dir = args.getDir();
        int slot = args.getSlot();
        if (!this.hasTunnelType(TunnelType.ITEM)) {
            return false;
        }
        TunnelSideData data = this.getTunnelSide(TunnelType.ITEM);
        int dirindex = SpaceCubeBlockEntity.dirToIndex(dir);
        return data.hasTunnel(dir) && slot == dirindex * 2;
    }

    @Nullable
    public ITunnelDef getTunnelDef(TunnelType type, class_2350 dir) {
        if (!this.hasTunnelType(type)) {
            return null;
        }
        TunnelSideData data = this.getTunnelSide(type);
        if (!data.hasTunnel(dir)) {
            return null;
        }
        class_3218 serverWorld = SpaceCubeUtil.getSpaceCubeWorld((class_3218)this.field_11863);
        if (serverWorld == null) {
            return null;
        }
        class_2586 blockEntity = serverWorld.method_8321(data.getTunnel(dir));
        if (!(blockEntity instanceof TunnelWallBlockEntity)) {
            return null;
        }
        TunnelWallBlockEntity tunnelWallBlockEntity = (TunnelWallBlockEntity)blockEntity;
        return tunnelWallBlockEntity.getTunnelDef();
    }

    public class_1799 getImportStack(class_2350 dir) {
        return this.method_5438(SpaceCubeBlockEntity.dirToIndex(dir) * 2);
    }

    public class_1799 getExportStack(class_2350 dir) {
        return this.method_5438(SpaceCubeBlockEntity.dirToIndex(dir) * 2 + 1);
    }

    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        if (!this.hasTunnelType(TunnelType.ITEM)) {
            return;
        }
        class_2350 dir = SpaceCubeBlockEntity.indexToDir(Math.floorDiv(slot, 2));
        ItemTunnel itemTunnel = (ItemTunnel)this.getTunnelDef(TunnelType.ITEM, dir);
        if (itemTunnel == null) {
            return;
        }
        if (slot % 2 == 0) {
            itemTunnel.setImportStack(stack);
        } else {
            itemTunnel.setExportStack(stack);
        }
    }

    public class_1799 method_5438(int slot) {
        if (!this.hasTunnelType(TunnelType.ITEM)) {
            return super.method_5438(slot);
        }
        class_2350 dir = SpaceCubeBlockEntity.indexToDir(Math.floorDiv(slot, 2));
        ItemTunnel itemTunnel = (ItemTunnel)this.getTunnelDef(TunnelType.ITEM, dir);
        if (itemTunnel == null) {
            return super.method_5438(slot);
        }
        if (slot % 2 == 0) {
            return itemTunnel.getImportStack();
        }
        return itemTunnel.getExportStack();
    }

    public ItemStackList getItems() {
        TunnelIODefaultedList stacks = TunnelIODefaultedList.ofSize(this);
        if (!this.hasTunnelType(TunnelType.ITEM)) {
            return ItemStackList.ofSize((int)(ItemTunnel.defaultSize * class_2350.values().length), (class_1799)ItemStackUtil.empty());
        }
        return stacks;
    }

    public static int dirToIndex(class_2350 dir) {
        switch (dir) {
            case field_11036: {
                return 0;
            }
            case field_11033: {
                return 1;
            }
            case field_11043: {
                return 2;
            }
            case field_11035: {
                return 3;
            }
            case field_11034: {
                return 4;
            }
            case field_11039: {
                return 5;
            }
        }
        return -1;
    }

    public static class_2350 indexToDir(int index) {
        switch (index) {
            case 0: {
                return class_2350.field_11036;
            }
            case 1: {
                return class_2350.field_11033;
            }
            case 2: {
                return class_2350.field_11043;
            }
            case 3: {
                return class_2350.field_11035;
            }
            case 4: {
                return class_2350.field_11034;
            }
            case 5: {
                return class_2350.field_11039;
            }
        }
        return null;
    }

    public boolean hasTunnel(TunnelType type, Direction direction) {
        return this.hasTunnel(type, direction.toMinecraft());
    }

    public boolean addTunnel(TunnelType type, Direction direction, BlockPos pos) {
        return this.addTunnel(type, direction.toMinecraft(), pos.toMinecraft());
    }

    public void removeTunnel(TunnelType type, Direction direction) {
        this.removeTunnel(type, direction.toMinecraft());
    }
}

