/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.blockentity;

import java.util.Optional;
import net.minecraft.class_1278;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.gui.inventory.IInventory;
import net.pitan76.mcpitanlib.api.packet.UpdatePacketType;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.tile.CompatBlockEntity;
import net.pitan76.mcpitanlib.api.tile.RenderAttachmentBlockEntity;
import net.pitan76.mcpitanlib.api.util.BlockEntityUtil;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.collection.ItemStackList;
import net.pitan76.mcpitanlib.api.util.item.ItemUtil;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import net.pitan76.mcpitanlib.api.util.nbt.v2.NbtRWUtil;
import net.pitan76.mcpitanlib.api.util.world.ChunkManagerUtil;
import net.pitan76.spacecube.BlockEntities;
import net.pitan76.spacecube.Config;
import net.pitan76.spacecube.api.data.SCBlockPath;
import net.pitan76.spacecube.api.data.TunnelWallBlockEntityRenderAttachmentData;
import net.pitan76.spacecube.api.tunnel.TunnelType;
import net.pitan76.spacecube.api.tunnel.def.ITunnelDef;
import net.pitan76.spacecube.api.tunnel.def.ItemTunnel;
import net.pitan76.spacecube.blockentity.SpaceCubeBlockEntity;
import net.pitan76.spacecube.world.SpaceCubeState;
import org.jetbrains.annotations.Nullable;

public class TunnelWallBlockEntity
extends CompatBlockEntity
implements IInventory,
RenderAttachmentBlockEntity,
class_1278 {
    private class_2338 scRoomPos = PosUtil.flooredBlockPos((double)0.0, (double)0.0, (double)0.0);
    private TunnelType tunnelType = TunnelType.NONE;
    private CompatIdentifier tunnelItemId = CompatIdentifier.EMPTY;
    public ITunnelDef tunnelDef = null;

    public ITunnelDef getTunnelDef() {
        if (this.tunnelDef == null) {
            this.tunnelDef = this.getTunnelType().createTunnelDef(this);
        }
        return this.tunnelDef;
    }

    public TunnelWallBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, new TileCreateEvent(pos, state));
    }

    public TunnelWallBlockEntity(TileCreateEvent e) {
        super((class_2591)BlockEntities.TUNNEL_WALL_BLOCK_ENTITY.getOrNull(), e);
    }

    public UpdatePacketType getUpdatePacketType() {
        return UpdatePacketType.BLOCK_ENTITY_UPDATE_S2C;
    }

    public class_2487 toInitialChunkDataNbt(CompatRegistryLookup registryLookup) {
        class_2487 nbt = super.toInitialChunkDataNbt(registryLookup);
        this.writeNbt(new WriteNbtArgs(nbt, registryLookup));
        return nbt;
    }

    public void writeNbt(WriteNbtArgs args) {
        super.writeNbt(args);
        if (this.scRoomPos == null) {
            this.scRoomPos = PosUtil.flooredBlockPos((double)0.0, (double)0.0, (double)0.0);
        }
        NbtRWUtil.putBlockPos((WriteNbtArgs)args, (String)"scRoomPos", (class_2338)this.scRoomPos);
        NbtRWUtil.putString((WriteNbtArgs)args, (String)"tunnelType", (String)this.tunnelType.getId().toString());
        NbtRWUtil.putString((WriteNbtArgs)args, (String)"tunnelItem", (String)this.tunnelItemId.toString());
        this.getTunnelDef().writeNbt(args);
    }

    public void readNbt(ReadNbtArgs args) {
        super.readNbt(args);
        this.scRoomPos = NbtRWUtil.getBlockPosV((ReadNbtArgs)args, (String)"scRoomPos");
        this.tunnelType = TunnelType.fromString(NbtRWUtil.getStringOrDefault((ReadNbtArgs)args, (String)"tunnelType", (String)TunnelType.NONE.getId().toString()));
        this.tunnelItemId = CompatIdentifier.of((String)NbtRWUtil.getStringOrDefault((ReadNbtArgs)args, (String)"tunnelItem", (String)CompatIdentifier.EMPTY.toString()));
        this.getTunnelDef().readNbt(args);
    }

    public void addTicket() {
        if (!Config.enabledChunkLoader()) {
            return;
        }
        if (!(BlockEntityUtil.getWorld((class_2586)this) instanceof class_3218)) {
            return;
        }
        Optional<SpaceCubeBlockEntity> scBlockEntity = this.getSpaceCubeBlockEntity();
        scBlockEntity.ifPresent(SpaceCubeBlockEntity::addTicket);
    }

    public TunnelType getTunnelType() {
        if (this.tunnelType == null) {
            return TunnelType.NONE;
        }
        return this.tunnelType;
    }

    public void setTunnelType(TunnelType tunnelType) {
        this.tunnelType = tunnelType;
    }

    public void setScRoomPos(class_2338 scRoomPos) {
        this.scRoomPos = scRoomPos;
    }

    public Optional<class_2338> getScRoomPos() {
        if (this.scRoomPos == null) {
            return Optional.empty();
        }
        return Optional.of(this.scRoomPos);
    }

    public void setTunnelItem(class_1792 tunnelItem) {
        this.setTunnelItemId(ItemUtil.toId((class_1792)tunnelItem));
    }

    public Optional<class_1792> getTunnelItem() {
        if (!this.getTunnelItemId().isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(ItemUtil.fromId((CompatIdentifier)this.getTunnelItemId().get()));
    }

    public Optional<CompatIdentifier> getTunnelItemId() {
        if (this.tunnelItemId == null) {
            return Optional.empty();
        }
        return Optional.of(this.tunnelItemId);
    }

    public void setTunnelItemId(CompatIdentifier tunnelItemId) {
        this.tunnelItemId = tunnelItemId;
    }

    public void setTunnelItemId(class_2960 tunnelItemId) {
        this.setTunnelItemId(CompatIdentifier.fromMinecraft((class_2960)tunnelItemId));
    }

    @Nullable
    public Object getCompatRenderData() {
        return new TunnelWallBlockEntityRenderAttachmentData(this.getTunnelType());
    }

    public void sync() {
        class_1937 world = this.callGetWorld();
        if (world == null) {
            return;
        }
        if (WorldUtil.isClient((class_1937)world)) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        ChunkManagerUtil.markForUpdate((class_1937)world, (class_2338)BlockEntityUtil.getPos((class_2586)this));
    }

    public Optional<SpaceCubeBlockEntity> getSpaceCubeBlockEntity() {
        if (!this.getScRoomPos().isPresent()) {
            return Optional.empty();
        }
        if (BlockEntityUtil.getWorld((class_2586)this) == null) {
            return Optional.empty();
        }
        if (!WorldUtil.getServer((class_1937)BlockEntityUtil.getWorld((class_2586)this)).isPresent()) {
            return Optional.empty();
        }
        Optional optionalServer = WorldUtil.getServer((class_1937)this.callGetWorld());
        if (!optionalServer.isPresent()) {
            return Optional.empty();
        }
        SpaceCubeState spaceCubeState = SpaceCubeState.getOrCreate((MinecraftServer)optionalServer.get());
        SCBlockPath scBlockPath = spaceCubeState.getSpacePosWithSCBlockPath().get(this.getScRoomPos().get());
        Optional optionalWorld = WorldUtil.getWorld((class_1937)BlockEntityUtil.getWorld((class_2586)this), (CompatIdentifier)scBlockPath.getDimension());
        if (!optionalWorld.isPresent()) {
            return Optional.empty();
        }
        class_2586 blockEntity = WorldUtil.getBlockEntity((class_1937)((class_1937)optionalWorld.get()), (class_2338)scBlockPath.getPos());
        if (!(blockEntity instanceof SpaceCubeBlockEntity)) {
            return Optional.empty();
        }
        return Optional.of((SpaceCubeBlockEntity)blockEntity);
    }

    public boolean existSpaceCubeBlockEntity() {
        return this.getSpaceCubeBlockEntity().isPresent();
    }

    public class_1799 method_5438(int slot) {
        if (this.getTunnelDef() instanceof ItemTunnel) {
            ItemTunnel tunnelDef = (ItemTunnel)this.getTunnelDef();
            if (slot == 0) {
                return tunnelDef.getImportStack();
            }
            if (slot == 1) {
                return tunnelDef.getExportStack();
            }
        }
        return super.method_5438(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        if (this.getTunnelDef() instanceof ItemTunnel) {
            ItemTunnel tunnelDef = (ItemTunnel)this.getTunnelDef();
            if (slot == 0) {
                tunnelDef.setImportStack(stack);
            }
            if (slot == 1) {
                tunnelDef.setExportStack(stack);
            }
        }
    }

    public ItemStackList getItems() {
        if (this.getTunnelDef() instanceof ItemTunnel) {
            ItemTunnel tunnelDef = (ItemTunnel)this.getTunnelDef();
            return tunnelDef.getStacks();
        }
        return null;
    }

    public int[] method_5494(class_2350 side) {
        if (this.getTunnelDef() instanceof ItemTunnel) {
            return new int[]{0, 1};
        }
        this.addTicket();
        return new int[0];
    }

    public Optional<class_2350> getDirection() {
        Optional<SpaceCubeBlockEntity> scBlockEntity = this.getSpaceCubeBlockEntity();
        if (!scBlockEntity.isPresent()) {
            return Optional.empty();
        }
        return scBlockEntity.get().getDir(this.getTunnelType(), BlockEntityUtil.getPos((class_2586)this));
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (this.getTunnelType() != TunnelType.ITEM) {
            return false;
        }
        return slot == 0;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (this.getTunnelType() != TunnelType.ITEM) {
            return false;
        }
        return slot == 1;
    }
}

