/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.compat;

import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.pitan76.spacecube.Config;
import net.pitan76.spacecube.api.tunnel.def.EnergyTunnel;
import net.pitan76.spacecube.blockentity.TunnelWallBlockEntity;
import net.pitan76.spacecube.compat.TunnelEnergyStorage;
import team.reborn.energy.api.EnergyStorage;

public class TREnergyStorage
extends SnapshotParticipant<Long>
implements EnergyStorage,
TunnelEnergyStorage {
    public static final double CONVERSION_RATE = Config.getRebornEnergyConversionRate();
    private final EnergyTunnel tunnel;

    public TREnergyStorage(EnergyTunnel tunnel) {
        this.tunnel = tunnel;
    }

    public EnergyTunnel getTunnel() {
        return this.tunnel;
    }

    public TunnelWallBlockEntity getBlockEntity() {
        return this.tunnel.getBlockEntity();
    }

    public long getUsableCapacity() {
        return (long)((double)this.tunnel.getUsableCapacity() / CONVERSION_RATE);
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        if (maxAmount < this.getUsableCapacity()) {
            this.updateSnapshots(transaction);
            return (long)((double)this.tunnel.insertEnergy((long)((double)maxAmount * CONVERSION_RATE)) / CONVERSION_RATE);
        }
        return 0L;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        if (maxAmount < this.getAmount()) {
            this.updateSnapshots(transaction);
            return (long)((double)this.tunnel.extractEnergy((long)((double)maxAmount * CONVERSION_RATE)) / CONVERSION_RATE);
        }
        if (this.getAmount() > 0L) {
            this.updateSnapshots(transaction);
            return (long)((double)this.tunnel.extractEnergy(this.tunnel.getEnergy()) / CONVERSION_RATE);
        }
        return 0L;
    }

    public long getAmount() {
        return (long)((double)this.tunnel.getEnergy() / CONVERSION_RATE);
    }

    public long getCapacity() {
        return (long)((double)this.tunnel.getMaxEnergy() / CONVERSION_RATE);
    }

    protected Long createSnapshot() {
        return this.tunnel.getEnergy();
    }

    protected void readSnapshot(Long snapshot) {
        this.tunnel.setEnergy(snapshot);
    }
}

