/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.item;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.item.ItemAppendTooltipEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnBlockEvent;
import net.pitan76.mcpitanlib.api.item.v2.CompatItem;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvents;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.PersistentStateUtil;
import net.pitan76.mcpitanlib.api.util.StackActionResult;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.entity.ServerPlayerUtil;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.spacecube.Blocks;
import net.pitan76.spacecube.SpaceCube;
import net.pitan76.spacecube.api.data.SCBlockPath;
import net.pitan76.spacecube.api.util.CubeGenerator;
import net.pitan76.spacecube.api.util.SpaceCubeUtil;
import net.pitan76.spacecube.block.SpaceCubeBlock;
import net.pitan76.spacecube.blockentity.SpaceCubeBlockEntity;
import net.pitan76.spacecube.world.SpaceCubeState;

public class PersonalShrinkingDevice
extends CompatItem {
    public PersonalShrinkingDevice(CompatibleItemSettings settings) {
        super(settings);
    }

    public StackActionResult onRightClick(ItemUseEvent e) {
        Player player = e.getUser();
        World world = e.getMidohraWorld();
        if (e.isSneaking()) {
            return e.pass();
        }
        if (e.isClient()) {
            return e.success();
        }
        if (SpaceCube.SPACE_CUBE_DIMENSION_WORLD_KEY.equals(world.getId())) {
            CompatActionResult result = PersonalShrinkingDevice.tpPrevCubeOrWorld(world, player);
            return StackActionResult.create((CompatActionResult)result, (class_1799)e.stack);
        }
        return super.onRightClick(e);
    }

    public CompatActionResult onRightClickOnBlock(ItemUseOnBlockEvent e) {
        Player player = e.getPlayer();
        World world = e.getMidohraWorld();
        class_2680 state = e.getBlockState();
        if (player.isSneaking()) {
            return e.pass();
        }
        if (world.isClient()) {
            return e.success();
        }
        if (state.method_26204() instanceof SpaceCubeBlock) {
            class_3218 spaceCubeWorld = SpaceCubeUtil.getSpaceCubeWorld((class_3218)world.getRaw());
            if (spaceCubeWorld == null) {
                SpaceCube.INSTANCE.error("[SpaceCube] Error: spaceCubeWorld is null.");
                return e.fail();
            }
            class_3222 serverPlayer = (class_3222)player.getEntity();
            MinecraftServer server = spaceCubeWorld.method_8503();
            SpaceCubeState spaceCubeState = SpaceCubeState.getOrCreate(server);
            int size = ((SpaceCubeBlock)state.method_26204()).getSize();
            Map<class_2338, SCBlockPath> spacePosWithSCBlockPath = spaceCubeState.getSpacePosWithSCBlockPath();
            SpaceCubeBlockEntity spaceCubeBlockEntity = (SpaceCubeBlockEntity)e.getBlockEntity();
            if (spaceCubeBlockEntity == null) {
                SpaceCube.INSTANCE.error("[SpaceCube] Error: spaceCubeBlockEntity is null.");
                return e.fail();
            }
            if (WorldUtil.equals((class_1937)spaceCubeWorld, (class_1937)world.getRaw())) {
                class_2338 scRoomPos;
                if (!spaceCubeBlockEntity.isScRoomPosNull()) {
                    scRoomPos = spaceCubeBlockEntity.getScRoomPos();
                } else {
                    scRoomPos = SpaceCubeUtil.getNewPos(spaceCubeState);
                    spaceCubeBlockEntity.setScRoomPos(scRoomPos);
                    CubeGenerator.generateCube((class_1937)spaceCubeWorld, scRoomPos, (class_2248)Blocks.SOLID_WALL, size);
                    spacePosWithSCBlockPath.put(scRoomPos, new SCBlockPath(e.getBlockPos(), world.getId()));
                    spaceCubeBlockEntity.addTicket();
                }
                spaceCubeState.addEntryPos(serverPlayer.method_5667(), serverPlayer.method_24515());
                player.teleport((double)PosUtil.x((class_2338)scRoomPos), (double)PosUtil.y((class_2338)scRoomPos), (double)PosUtil.z((class_2338)scRoomPos));
            } else {
                class_2338 scRoomPos;
                if (!spaceCubeBlockEntity.isScRoomPosNull()) {
                    scRoomPos = spaceCubeBlockEntity.getScRoomPos();
                } else {
                    scRoomPos = SpaceCubeUtil.getNewPos(spaceCubeState);
                    spaceCubeBlockEntity.setScRoomPos(scRoomPos);
                    CubeGenerator.generateCube((class_1937)spaceCubeWorld, scRoomPos, (class_2248)Blocks.SOLID_WALL, size);
                    spacePosWithSCBlockPath.put(scRoomPos, new SCBlockPath(e.getBlockPos(), world.getId()));
                    spaceCubeBlockEntity.addTicket();
                }
                spaceCubeState.removeEntryPosList(serverPlayer.method_5667());
                spaceCubeState.addEntryPos(serverPlayer.method_5667(), serverPlayer.method_24515(), world.getId());
                PersistentStateUtil.markDirty((class_18)spaceCubeState);
                ServerPlayerUtil.teleport((class_3222)serverPlayer, (class_3218)spaceCubeWorld, (double)PosUtil.x((class_2338)scRoomPos), (double)PosUtil.y((class_2338)scRoomPos), (double)PosUtil.z((class_2338)scRoomPos), (float)player.getYaw(), (float)player.getPitch());
            }
            ServerPlayerUtil.playSound((class_3222)serverPlayer, (CompatSoundEvent)CompatSoundEvents.BLOCK_PORTAL_TRAVEL, (CompatSoundCategory)CompatSoundCategory.PLAYERS, (float)1.0f, (float)1.0f);
            return e.success();
        }
        if (SpaceCube.SPACE_CUBE_DIMENSION_WORLD_KEY.equals(world.getId())) {
            return PersonalShrinkingDevice.tpPrevCubeOrWorld(world, player);
        }
        return e.pass();
    }

    public static CompatActionResult tpPrevCubeOrWorld(World playerWorld, Player player) {
        class_3222 serverPlayer = (class_3222)player.getEntity();
        UUID uuid = serverPlayer.method_5667();
        MinecraftServer server = playerWorld.getServer();
        SpaceCubeState spaceCubeState = SpaceCubeState.getOrCreate(server);
        if (spaceCubeState.existPlayerData(uuid)) {
            if (spaceCubeState.hasEntryPos(uuid) && spaceCubeState.entryPosListSize(uuid) > 1) {
                class_2338 entryPos = spaceCubeState.getLastEntryPosWithRemove(uuid);
                int x = PosUtil.x((class_2338)entryPos);
                int y = PosUtil.y((class_2338)entryPos);
                int z = PosUtil.z((class_2338)entryPos);
                ServerPlayerUtil.teleport((class_3222)serverPlayer, (double)x, (double)y, (double)z);
            } else {
                int z;
                int y;
                int x;
                CompatIdentifier worldId = spaceCubeState.getWorldId(uuid);
                Optional returnWorldOptional = WorldUtil.getWorld((class_1937)playerWorld.getRaw(), (CompatIdentifier)worldId);
                if (!returnWorldOptional.isPresent()) {
                    SpaceCube.INSTANCE.error("[SpaceCube] Error: player's world is null.");
                    return CompatActionResult.PASS;
                }
                class_3218 returnWorld = (class_3218)returnWorldOptional.get();
                if (spaceCubeState.hasEntryPos(uuid)) {
                    class_2338 entryPos = spaceCubeState.getLastEntryPosWithRemove(uuid);
                    x = PosUtil.x((class_2338)entryPos);
                    y = PosUtil.y((class_2338)entryPos);
                    z = PosUtil.z((class_2338)entryPos);
                } else {
                    x = PosUtil.x((class_2338)WorldUtil.getSpawnPos((class_1937)returnWorld));
                    y = PosUtil.y((class_2338)WorldUtil.getSpawnPos((class_1937)returnWorld));
                    z = PosUtil.z((class_2338)WorldUtil.getSpawnPos((class_1937)returnWorld));
                }
                spaceCubeState.removeEntryPosList(uuid);
                ServerPlayerUtil.teleport((class_3222)serverPlayer, (class_3218)returnWorld, (double)x, (double)y, (double)z, (float)player.getYaw(), (float)player.getPitch());
            }
            player.playSound(CompatSoundEvents.BLOCK_PORTAL_TRAVEL, CompatSoundCategory.PLAYERS, 1.0f, 1.0f);
            return CompatActionResult.SUCCESS;
        }
        class_2338 pos = SpaceCubeUtil.getNearestPos(spaceCubeState, serverPlayer.method_24515());
        if (pos != null) {
            int z;
            int y;
            int x;
            Map<class_2338, SCBlockPath> spacePosWithSCBlockPath = spaceCubeState.getSpacePosWithSCBlockPath();
            SCBlockPath scBlockPath = spacePosWithSCBlockPath.get(pos);
            Optional returnWorldOptional = WorldUtil.getWorld((class_1937)playerWorld.getRaw(), (CompatIdentifier)scBlockPath.getDimension());
            if (!returnWorldOptional.isPresent()) {
                SpaceCube.INSTANCE.error("[SpaceCube] Error: player's world is null.");
                return CompatActionResult.PASS;
            }
            class_3218 returnWorld = (class_3218)returnWorldOptional.get();
            if (scBlockPath.pos != null) {
                class_2338 entryPos = scBlockPath.getPos();
                x = PosUtil.x((class_2338)entryPos);
                y = PosUtil.y((class_2338)entryPos);
                z = PosUtil.z((class_2338)entryPos);
            } else {
                x = PosUtil.x((class_2338)WorldUtil.getSpawnPos((class_1937)returnWorld));
                y = PosUtil.y((class_2338)WorldUtil.getSpawnPos((class_1937)returnWorld));
                z = PosUtil.z((class_2338)WorldUtil.getSpawnPos((class_1937)returnWorld));
            }
            ServerPlayerUtil.teleport((class_3222)serverPlayer, (class_3218)returnWorld, (double)x, (double)y, (double)z, (float)player.getYaw(), (float)player.getPitch());
            player.playSound(CompatSoundEvents.BLOCK_PORTAL_TRAVEL, CompatSoundCategory.PLAYERS, 1.0f, 1.0f);
            return CompatActionResult.SUCCESS;
        }
        return CompatActionResult.PASS;
    }

    public static CompatActionResult tpPrevCubeOrWorld(class_1937 world, Player player) {
        return PersonalShrinkingDevice.tpPrevCubeOrWorld(World.of((class_1937)world), player);
    }

    public void appendTooltip(ItemAppendTooltipEvent e) {
        super.appendTooltip(e);
        e.addTooltip((class_2561)TextUtil.translatable((String)"tooltip.spacecube.personal_shrinking_device"));
    }
}

