/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.item;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.item.ItemUseEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnBlockEvent;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.item.ExtendItem;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.StackActionResult;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.spacecube.Blocks;
import net.pitan76.spacecube.SpaceCube;
import net.pitan76.spacecube.api.data.SCBlockPath;
import net.pitan76.spacecube.api.util.CubeGenerator;
import net.pitan76.spacecube.api.util.SpaceCubeUtil;
import net.pitan76.spacecube.block.SpaceCubeBlock;
import net.pitan76.spacecube.blockentity.SpaceCubeBlockEntity;
import net.pitan76.spacecube.world.SpaceCubeState;

public class SpaceCubeUpgrader
extends ExtendItem {
    public final int size;

    public SpaceCubeUpgrader(CompatibleItemSettings settings, int size) {
        super((net.pitan76.mcpitanlib.api.item.CompatibleItemSettings)settings);
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public CompatActionResult onRightClickOnBlock(ItemUseOnBlockEvent e) {
        class_1937 world = e.getWorld();
        class_2338 pos = e.getBlockPos();
        class_2680 state = e.getBlockState();
        Player player = e.getPlayer();
        if (state.method_26204() instanceof SpaceCubeBlock) {
            if (player.isSneaking()) {
                return e.pass();
            }
            if (e.isClient()) {
                return e.success();
            }
            CompatActionResult result = this.upgradeSpaceCube(world, pos, state, e.getStack());
            if (result == CompatActionResult.CONSUME) {
                player.sendMessage((class_2561)TextUtil.literal((String)"[SpaceCube] Upgraded!"));
            }
            return result;
        }
        return e.pass();
    }

    public StackActionResult onRightClick(ItemUseEvent e) {
        class_1937 world = e.getWorld();
        Player player = e.getUser();
        class_1799 stack = e.getStack();
        if (e.isSneaking()) {
            return e.pass();
        }
        if (e.isClient()) {
            return e.success();
        }
        class_3218 spaceCubeWorld = SpaceCubeUtil.getSpaceCubeWorld((class_3218)world);
        if (spaceCubeWorld != null && WorldUtil.equals((class_1937)world, (class_1937)spaceCubeWorld)) {
            class_2338 spacePos = SpaceCubeUtil.getNearestPos((class_3218)world, player.getBlockPos());
            if (spacePos == null) {
                return e.fail();
            }
            Optional optionalServer = WorldUtil.getServer((class_1937)world);
            SpaceCubeState spaceCubeState = SpaceCubeState.getOrCreate((MinecraftServer)optionalServer.get());
            Map<class_2338, SCBlockPath> spacePosWithSCBlockPath = spaceCubeState.getSpacePosWithSCBlockPath();
            if (!spacePosWithSCBlockPath.containsKey(spacePos)) {
                return e.fail();
            }
            SCBlockPath scBlockPath = spacePosWithSCBlockPath.get(spacePos);
            class_2338 placedPos = scBlockPath.getPos();
            Optional optionalPlacedWorld = WorldUtil.getWorld((class_1937)world, (CompatIdentifier)scBlockPath.getDimension());
            if (!optionalPlacedWorld.isPresent()) {
                return e.fail();
            }
            class_1937 placedWorld = (class_1937)optionalPlacedWorld.get();
            class_2680 state = WorldUtil.getBlockState((class_1937)placedWorld, (class_2338)placedPos);
            if (state.method_26204() instanceof SpaceCubeBlock) {
                CompatActionResult result = this.upgradeSpaceCube(placedWorld, placedPos, state, stack);
                if (result == CompatActionResult.CONSUME) {
                    player.sendMessage((class_2561)TextUtil.literal((String)"[SpaceCube] Upgraded!"));
                }
                return StackActionResult.create((CompatActionResult)result, (class_1799)e.stack);
            }
        }
        return super.onRightClick(e);
    }

    public CompatActionResult upgradeSpaceCube(class_1937 world, class_2338 pos, class_2680 state, class_1799 stack) {
        SpaceCubeBlock spaceCubeBlock = (SpaceCubeBlock)state.method_26204();
        if (spaceCubeBlock.getSize() < this.size) {
            class_2487 nbt = NbtUtil.create();
            class_2586 blockEntity = WorldUtil.getBlockEntity((class_1937)world, (class_2338)pos);
            if (blockEntity instanceof SpaceCubeBlockEntity) {
                SpaceCubeBlockEntity scBlockEntity = (SpaceCubeBlockEntity)blockEntity;
                scBlockEntity.writeNbt(new WriteNbtArgs(nbt));
            }
            class_2680 newState = SpaceCubeBlock.getSpaceCubeBlockFromSize(this.size).getNewDefaultState();
            WorldUtil.setBlockState((class_1937)world, (class_2338)pos, (class_2680)newState);
            class_2586 newBlockEntity = WorldUtil.getBlockEntity((class_1937)world, (class_2338)pos);
            if (newBlockEntity instanceof SpaceCubeBlockEntity && !nbt.method_33133()) {
                SpaceCubeBlockEntity scBlockEntity = (SpaceCubeBlockEntity)newBlockEntity;
                scBlockEntity.readNbt(new ReadNbtArgs(nbt));
                if (scBlockEntity.scRoomPos != null) {
                    class_3218 spaceCubeWorld = SpaceCubeUtil.getSpaceCubeWorld((class_3218)world);
                    if (spaceCubeWorld == null) {
                        SpaceCube.INSTANCE.error("[SpaceCube] Error: spaceCubeWorld is null.");
                        return CompatActionResult.FAIL;
                    }
                    CubeGenerator.generateCube((class_1937)spaceCubeWorld, scBlockEntity.scRoomPos, class_2246.field_10124, spaceCubeBlock.getSize());
                    CubeGenerator.generateCube((class_1937)spaceCubeWorld, scBlockEntity.scRoomPos, (class_2248)Blocks.SOLID_WALL, this.size);
                }
            }
            ItemStackUtil.decrementCount((class_1799)stack, (int)1);
            return CompatActionResult.CONSUME;
        }
        return CompatActionResult.PASS;
    }
}

