/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.item;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnBlockEvent;
import net.pitan76.mcpitanlib.api.item.v2.CompatItem;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.util.BlockEntityUtil;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.util.math.Direction;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.spacecube.Blocks;
import net.pitan76.spacecube.api.data.TunnelSideData;
import net.pitan76.spacecube.api.tunnel.TunnelType;
import net.pitan76.spacecube.api.util.SpaceCubeUtil;
import net.pitan76.spacecube.block.TunnelWallBlock;
import net.pitan76.spacecube.blockentity.SpaceCubeBlockEntity;
import net.pitan76.spacecube.blockentity.TunnelWallBlockEntity;

public class TunnelItem
extends CompatItem {
    public TunnelItem(CompatibleItemSettings settings) {
        super(settings);
    }

    public CompatActionResult onRightClickOnBlock(ItemUseOnBlockEvent e) {
        World world = e.getMidohraWorld();
        class_2338 pos = e.getBlockPos();
        BlockState state = e.getMidohraState();
        if (state.getBlock().get() == Blocks.SOLID_WALL) {
            world.setBlockState(BlockPos.of((class_2338)pos), Blocks.TUNNEL_WALL.getDefaultMidohraState().with(TunnelWallBlock.CONNECTED_SIDE, Direction.UP));
            class_2586 blockEntity = e.getBlockEntity();
            if (blockEntity instanceof TunnelWallBlockEntity) {
                TunnelWallBlockEntity tunnelWallBlockEntity = (TunnelWallBlockEntity)blockEntity;
                tunnelWallBlockEntity.setTunnelType(this.getTunnelType());
                tunnelWallBlockEntity.setTunnelItem(e.getStack().method_7909());
                if (e.isClient()) {
                    return e.success();
                }
                class_2338 scRoomPos = SpaceCubeUtil.getNearestPos((class_3218)world.getRaw(), e.getBlockPos());
                tunnelWallBlockEntity.setScRoomPos(scRoomPos);
                BlockEntityUtil.markDirty((class_2586)tunnelWallBlockEntity);
                tunnelWallBlockEntity.sync();
                if (tunnelWallBlockEntity.existSpaceCubeBlockEntity()) {
                    Optional<SpaceCubeBlockEntity> spaceCubeBlockEntity = tunnelWallBlockEntity.getSpaceCubeBlockEntity();
                    if (!spaceCubeBlockEntity.isPresent()) {
                        return e.fail();
                    }
                    state = world.getBlockState(BlockPos.of((class_2338)pos));
                    Direction dir = state.get(TunnelWallBlock.CONNECTED_SIDE);
                    TunnelSideData tunnelSide = spaceCubeBlockEntity.get().getTunnelSide(this.getTunnelType());
                    if (tunnelSide.isFull()) {
                        e.player.sendMessage((class_2561)TextUtil.translatable((String)"message.spacecube.tunnel_full"));
                        world.setBlockState(BlockPos.of((class_2338)pos), Blocks.SOLID_WALL.getDefaultMidohraState());
                        return e.fail();
                    }
                    if (tunnelSide.hasTunnel(dir)) {
                        dir = tunnelSide.getRestMidohraDir().get();
                        world.setBlockState(BlockPos.of((class_2338)pos), state.with(TunnelWallBlock.CONNECTED_SIDE, dir));
                    }
                    tunnelSide.addTunnel(dir, BlockPos.of((class_2338)pos));
                }
                tunnelWallBlockEntity.addTicket();
            }
            ItemStackUtil.decrementCount((class_1799)e.getStack(), (int)1);
            return e.consume();
        }
        return e.pass();
    }

    public TunnelType getTunnelType() {
        return TunnelType.NONE;
    }
}

