/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.spacecube.world;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.PersistentStateUtil;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import net.pitan76.mcpitanlib.api.util.nbt.NbtListUtil;
import net.pitan76.mcpitanlib.api.world.CompatiblePersistentState;
import net.pitan76.spacecube.api.data.SCBlockPath;
import net.pitan76.spacecube.api.data.SCPlayerData;
import org.jetbrains.annotations.Nullable;

public class SpaceCubeState
extends CompatiblePersistentState {
    private final Map<UUID, SCPlayerData> playerDataMap = new HashMap<UUID, SCPlayerData>();
    private final Map<class_2338, SCBlockPath> spacePosWithSCBlockPath = new HashMap<class_2338, SCBlockPath>();

    public SpaceCubeState() {
        super("spacecube");
    }

    public void readNbt(ReadNbtArgs args) {
        class_2487 nbt = args.getNbt();
        class_2487 players_nbt = NbtUtil.get((class_2487)nbt, (String)"players");
        for (String key : NbtUtil.getKeys((class_2487)players_nbt)) {
            UUID uuid = UUID.fromString(key);
            ArrayList<class_2338> entryPosList = new ArrayList<class_2338>();
            class_2499 entryPosList_nbt = NbtUtil.getNbtCompoundList((class_2487)players_nbt, (String)"entryPosList");
            int size = NbtListUtil.size((class_2499)entryPosList_nbt);
            for (int i = 0; i < size; ++i) {
                class_2487 entryPos_nbt = NbtListUtil.getCompound((class_2499)entryPosList_nbt, (int)i);
                int x = NbtUtil.getInt((class_2487)entryPos_nbt, (String)"x");
                int y = NbtUtil.getInt((class_2487)entryPos_nbt, (String)"y");
                int z = NbtUtil.getInt((class_2487)entryPos_nbt, (String)"z");
                entryPosList.add(PosUtil.flooredBlockPos((double)x, (double)y, (double)z));
            }
            CompatIdentifier dimensionId = CompatIdentifier.fromMinecraft((class_2960)class_1937.field_25179.method_29177());
            if (NbtUtil.has((class_2487)players_nbt, (String)"dimension")) {
                dimensionId = CompatIdentifier.of((String)NbtUtil.getString((class_2487)players_nbt, (String)"dimension"));
            }
            SCPlayerData playerData = new SCPlayerData(uuid, entryPosList, dimensionId);
            this.playerDataMap.put(uuid, playerData);
        }
        class_2499 spacePosWithSCBlockPathList_nbt = NbtUtil.getList((class_2487)nbt, (String)"spacePosWithSCBlockPathList", (int)10);
        int size = NbtListUtil.size((class_2499)spacePosWithSCBlockPathList_nbt);
        for (int i = 0; i < size; ++i) {
            class_2487 spacePosWithSCBlockPath_nbt = NbtListUtil.getCompound((class_2499)spacePosWithSCBlockPathList_nbt, (int)i);
            if (!NbtUtil.has((class_2487)spacePosWithSCBlockPath_nbt, (String)"spacePos")) continue;
            class_2338 spacePos = NbtUtil.getBlockPos((class_2487)spacePosWithSCBlockPath_nbt, (String)"spacePos");
            SCBlockPath scBlockPath = new SCBlockPath();
            if (NbtUtil.has((class_2487)spacePosWithSCBlockPath_nbt, (String)"scBlockPath")) {
                class_2487 scBlockPath_nbt = NbtUtil.get((class_2487)spacePosWithSCBlockPath_nbt, (String)"scBlockPath");
                scBlockPath.setPos(NbtUtil.getBlockPos((class_2487)spacePosWithSCBlockPath_nbt, (String)"scBlockPath"));
                scBlockPath.setDimension(CompatIdentifier.of((String)((String)NbtUtil.get((class_2487)scBlockPath_nbt, (String)"dimension", String.class))));
            }
            this.spacePosWithSCBlockPath.put(spacePos, scBlockPath);
        }
    }

    public static SpaceCubeState create(ReadNbtArgs args) {
        return new SpaceCubeState(args);
    }

    public SpaceCubeState(ReadNbtArgs args) {
        this();
        this.readNbt(args);
    }

    public static SpaceCubeState create(class_2487 nbt) {
        return new SpaceCubeState(new ReadNbtArgs(nbt));
    }

    public class_2487 writeNbt(WriteNbtArgs args) {
        class_2487 nbt = args.getNbt();
        class_2487 players_nbt = NbtUtil.create();
        for (Map.Entry<UUID, SCPlayerData> entry : this.playerDataMap.entrySet()) {
            class_2487 player_nbt = NbtUtil.create();
            UUID uuid = entry.getKey();
            List<class_2338> entryPosList = entry.getValue().getEntryPosList();
            class_2499 entryPosList_nbt = new class_2499();
            for (class_2338 entryPos : entryPosList) {
                class_2487 entryPos_nbt = NbtUtil.create();
                NbtUtil.setBlockPosDirect((class_2487)entryPos_nbt, (class_2338)entryPos);
                NbtListUtil.add((class_2499)entryPosList_nbt, (class_2520)entryPos_nbt);
            }
            NbtUtil.put((class_2487)player_nbt, (String)"entryPosList", (class_2520)entryPosList_nbt);
            NbtUtil.putString((class_2487)player_nbt, (String)"dimension", (String)entry.getValue().getDimension().toString());
            NbtUtil.put((class_2487)players_nbt, (String)uuid.toString(), (class_2487)player_nbt);
        }
        NbtUtil.put((class_2487)nbt, (String)"players", (class_2487)players_nbt);
        class_2499 spacePosWithSCBlockPathList_nbt = new class_2499();
        for (Map.Entry<class_2338, SCBlockPath> entry : this.spacePosWithSCBlockPath.entrySet()) {
            class_2487 spacePosWithSCBlockPath_nbt = NbtUtil.create();
            class_2338 spacePos = entry.getKey();
            NbtUtil.setBlockPos((class_2487)spacePosWithSCBlockPath_nbt, (String)"spacePos", (class_2338)spacePos);
            if (entry.getValue().pos != null && entry.getValue().dimension != null) {
                class_2487 scBlockPath_nbt = NbtUtil.create();
                SCBlockPath scBlockPath = entry.getValue();
                class_2338 scBlockPathPos = scBlockPath.getPos();
                NbtUtil.setBlockPosDirect((class_2487)scBlockPath_nbt, (class_2338)scBlockPathPos);
                NbtUtil.putString((class_2487)scBlockPath_nbt, (String)"dimension", (String)scBlockPath.getDimension().toString());
                NbtUtil.put((class_2487)spacePosWithSCBlockPath_nbt, (String)"scBlockPath", (class_2487)scBlockPath_nbt);
            }
            NbtListUtil.add((class_2499)spacePosWithSCBlockPathList_nbt, (class_2520)spacePosWithSCBlockPath_nbt);
        }
        NbtUtil.put((class_2487)nbt, (String)"spacePosWithSCBlockPathList", (class_2520)spacePosWithSCBlockPathList_nbt);
        return nbt;
    }

    public static SpaceCubeState getOrCreate(MinecraftServer server) {
        class_26 manager = PersistentStateUtil.getManagerFromServer((MinecraftServer)server);
        return (SpaceCubeState)PersistentStateUtil.getOrCreate((class_26)manager, (String)"spacecube", SpaceCubeState::new, SpaceCubeState::create);
    }

    public Map<UUID, SCPlayerData> getPlayerDataMap() {
        return this.playerDataMap;
    }

    public Map<class_2338, SCBlockPath> getSpacePosWithSCBlockPath() {
        return this.spacePosWithSCBlockPath;
    }

    public void addEntryPos(UUID uuid, class_2338 blockPos) {
        if (this.playerDataMap.containsKey(uuid)) {
            List<class_2338> entryPosList = this.playerDataMap.get(uuid).getEntryPosList();
            entryPosList.add(blockPos);
        } else {
            SCPlayerData playerData = new SCPlayerData(uuid, new ArrayList<class_2338>(Collections.singletonList(blockPos)), CompatIdentifier.of((String)"overworld"));
            this.playerDataMap.put(uuid, playerData);
        }
    }

    public void addEntryPos(UUID uuid, class_2338 blockPos, CompatIdentifier worldId) {
        if (this.playerDataMap.containsKey(uuid)) {
            List<class_2338> entryPosList = this.getEntryPosList(uuid);
            entryPosList.add(blockPos);
        } else {
            SCPlayerData playerData = new SCPlayerData(uuid, new ArrayList<class_2338>(Collections.singletonList(blockPos)), worldId);
            this.playerDataMap.put(uuid, playerData);
        }
    }

    public List<class_2338> getEntryPosList(UUID uuid) {
        return this.playerDataMap.get(uuid).getEntryPosList();
    }

    @Nullable
    public class_2338 getLastEntryPos(UUID uuid) {
        if (this.hasEntryPos(uuid)) {
            List<class_2338> entryPosList = this.getEntryPosList(uuid);
            return entryPosList.get(entryPosList.size() - 1);
        }
        return null;
    }

    public class_2338 getLastEntryPosWithRemove(UUID uuid) {
        if (this.hasEntryPos(uuid)) {
            List<class_2338> entryPosList = this.getEntryPosList(uuid);
            class_2338 blockPos = entryPosList.get(entryPosList.size() - 1);
            entryPosList.remove(blockPos);
            return blockPos;
        }
        return null;
    }

    public boolean hasEntryPos(UUID uuid) {
        return this.existPlayerData(uuid) && !this.getEntryPosList(uuid).isEmpty();
    }

    public boolean existPlayerData(UUID uuid) {
        return this.playerDataMap.containsKey(uuid);
    }

    public void removeEntryPos(UUID uuid, class_2338 blockPos) {
        if (this.hasEntryPos(uuid)) {
            this.getEntryPosList(uuid).remove(blockPos);
        }
    }

    public void removeEntryPosList(UUID uuid) {
        if (this.existPlayerData(uuid)) {
            this.playerDataMap.remove(uuid);
        }
    }

    public int entryPosListSize(UUID uuid) {
        if (this.hasEntryPos(uuid)) {
            return this.getEntryPosList(uuid).size();
        }
        return 0;
    }

    public CompatIdentifier getWorldId(UUID uuid) {
        if (!this.existPlayerData(uuid)) {
            return CompatIdentifier.of((String)"overworld");
        }
        return this.playerDataMap.get(uuid).getDimension();
    }
}

