/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.Destination;
import one.oth3r.directionhud.common.Events;
import one.oth3r.directionhud.common.files.FileData;
import one.oth3r.directionhud.common.hud.Hud;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Dest;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Lang;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;
import one.oth3r.directionhud.utils.Utl;

public class DHud {
    public static final Lang LANG = new Lang("dhud.");
    public static CTxT RELOAD_BUTTON = ((CTxT)((CTxT)((CTxT)LANG.btn("reload", new Object[0]).btn(true)).color("#69ff29")).click(1, "/dhud reload")).hover(((CTxT)CTxT.of("/dhud reload").color("#69ff29")).append("\n").append(LANG.hover("reload", new Object[0])));

    public static void CMDExecutor(Player player, String[] args) {
        if (args.length == 0) {
            DHud.UI(player);
            return;
        }
        String type = args[0].toLowerCase();
        String[] trimmedArgs = Helper.trimStart(args, 1);
        switch (type) {
            case "inbox": {
                inbox.CMDExecutor(player, trimmedArgs);
                break;
            }
            case "color": {
                preset.colorCMDExecutor(player, trimmedArgs);
                break;
            }
            case "presets": 
            case "preset": {
                preset.CMDExecutor(player, trimmedArgs);
                break;
            }
            case "reload": {
                if (!Helper.checkEnabled(player).reload()) break;
                DHud.reload(player);
                break;
            }
            case "dest": 
            case "destination": {
                Destination.commandExecutor.logic(player, trimmedArgs);
                break;
            }
            case "hud": {
                Hud.CMDExecutor(player, trimmedArgs);
                break;
            }
            default: {
                player.sendMessage(CUtl.error("command", new Object[0]));
            }
        }
    }

    public static ArrayList<String> CMDSuggester(Player player, int pos, String[] args) {
        ArrayList<String> suggester = new ArrayList<String>();
        if (!Helper.checkEnabled(player).hud()) {
            return suggester;
        }
        if (pos == 1) {
            if (FileData.getConfig().getSocial().getEnabled().booleanValue()) {
                suggester.add("inbox");
            }
            if (Helper.checkEnabled(player).reload()) {
                suggester.add("reload");
            }
            if (Helper.checkEnabled(player).destination()) {
                suggester.add("dest");
            }
            if (Helper.checkEnabled(player).hud()) {
                suggester.add("hud");
            }
            if (Helper.checkEnabled(player).customPresets()) {
                suggester.add("preset");
            }
        }
        if (pos > 1) {
            String command = args[0].toLowerCase();
            String[] trimmedArgs = Helper.trimStart(args, 1);
            int fixedPos = pos - 2;
            switch (command) {
                case "dest": 
                case "destination": {
                    suggester.addAll(Destination.commandSuggester.logic(player, fixedPos + 1, trimmedArgs));
                    break;
                }
                case "hud": {
                    suggester.addAll(Hud.CMDSuggester(player, fixedPos + 1, trimmedArgs));
                    break;
                }
                case "preset": {
                    suggester.addAll(preset.CMDSuggester(player, fixedPos, trimmedArgs));
                    break;
                }
                case "color": {
                    if (fixedPos != 4) break;
                    suggester.addAll(Helper.Command.Suggester.colors(player, Helper.Command.Suggester.getCurrent(trimmedArgs, fixedPos), true));
                }
            }
        }
        return suggester;
    }

    public static void reload(Player player) {
        FileData.loadFiles();
        for (Player pl : Utl.getPlayers()) {
            Events.playerSoftLeave(pl);
            Events.playerJoin(pl);
        }
        if (player == null) {
            DirectionHUD.LOGGER.info(LANG.msg("reload", new Object[0]).toString());
        } else {
            player.sendMessage(CUtl.tag().append((CTxT)LANG.msg("reload", new Object[0]).color('a')));
        }
    }

    public static void UI(Player player) {
        CTxT msg = CTxT.of(" ");
        CTxT line = (CTxT)CTxT.of("\n                             ").strikethrough(true);
        msg.append((CTxT)((CTxT)CTxT.of("DirectionHUD").color(CUtl.p())).hover((CTxT)CTxT.of(DirectionHUD.getData().getVersion() + "\u29c9").color(CUtl.s())).click(3, "https://modrinth.com/mod/directionhud/changelog")).append(line).append("\n ");
        if (Helper.checkEnabled(player).hud()) {
            msg.append(Hud.BUTTON).append("  ");
        }
        if (Helper.checkEnabled(player).destination()) {
            msg.append(Destination.BUTTON);
        }
        msg.append("\n\n ");
        if (Helper.checkEnabled(player).customPresets()) {
            msg.append(preset.BUTTON).append(" ");
        }
        if (FileData.getConfig().getSocial().getEnabled().booleanValue()) {
            msg.append(inbox.BUTTON);
        }
        if (Helper.checkEnabled(player).reload()) {
            msg.append("\n\n ").append(RELOAD_BUTTON);
        }
        msg.append(line);
        player.sendMessage(msg);
    }

    public static class inbox {
        public static final int PER_PAGE = 3;
        public static final Lang LANG = new Lang("dhud.inbox.");
        public static CTxT BUTTON = ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#7a6ef0")).click(1, "/dhud inbox")).hover(((CTxT)CTxT.of("/dhud inbox").color("#7a6ef0")).append("\n").append(LANG.hover()));

        public static void CMDExecutor(Player player, String[] args) {
            if (!FileData.getConfig().getSocial().getEnabled().booleanValue()) {
                return;
            }
            if (args.length <= 1) {
                if (args.length == 0) {
                    inbox.UI(player, 1);
                } else {
                    inbox.UI(player, Helper.Num.toInt(args[0]));
                }
                return;
            }
            if (args[0].equalsIgnoreCase("clear") && args.length == 2) {
                inbox.delete(player, args[1], true);
                return;
            }
            player.sendMessage(CUtl.usage("/dhud inbox"));
        }

        public static void tick(Player player) {
            ArrayList<HashMap<String, String>> inbox2 = player.getPCache().getInbox();
            if (inbox2.isEmpty()) {
                return;
            }
            Iterator<HashMap<String, String>> iterator = inbox2.iterator();
            while (iterator.hasNext()) {
                Player target;
                HashMap<String, String> entry = iterator.next();
                int expire = Integer.parseInt(entry.get("expire"));
                entry.put("expire", String.valueOf(expire - 1));
                if (expire > 0) continue;
                iterator.remove();
                if (!entry.get("type").equals(Type.track_pending.name()) || !(target = new Player(entry.get("player_name"))).isValid()) continue;
                target.sendMessage(CUtl.tag().append(Destination.social.track.LANG.msg("expired.target", player.getHighlightedName())));
                player.sendMessage(CUtl.tag().append(Destination.social.track.LANG.msg("expired", target.getHighlightedName())));
            }
            player.getPCache().setInbox(inbox2);
        }

        public static void removeAllTracking(Player player) {
            ArrayList<HashMap<String, String>> inbox2 = player.getPCache().getInbox();
            Iterator<HashMap<String, String>> iterator = inbox2.iterator();
            while (iterator.hasNext()) {
                HashMap<String, String> entry = iterator.next();
                if (!entry.get("type").equals(Type.track_pending.name()) && !entry.get("type").equals(Type.track_request.name())) continue;
                Type type = entry.get("type").equals(Type.track_pending.name()) ? Type.track_request : Type.track_pending;
                Player target = new Player(entry.get("player_uuid"));
                if (!FileData.getConfig().getOnline().booleanValue()) {
                    target = new Player(entry.get("player_name"));
                }
                if (target.isValid()) {
                    inbox.removeEntry(target, inbox.search(target, type, "id", entry.get("id")));
                }
                iterator.remove();
            }
            player.getPCache().setInbox(inbox2);
        }

        public static HashMap<String, String> search(Player player, Type type, String key, String value) {
            ArrayList<HashMap<String, String>> inbox2 = player.getPCache().getInbox();
            for (HashMap<String, String> entry : inbox2) {
                if (type != null && !entry.get("type").equals(type.name()) || !entry.get(key).equals(value)) continue;
                return entry;
            }
            return null;
        }

        public static ArrayList<HashMap<String, String>> getAllType(Player player, Type type) {
            ArrayList<HashMap<String, String>> inbox2 = player.getPCache().getInbox();
            ArrayList<HashMap<String, String>> matches = new ArrayList<HashMap<String, String>>();
            for (HashMap<String, String> entry : inbox2) {
                if (!entry.get("type").equals(type.name())) continue;
                matches.add(0, entry);
            }
            if (!matches.isEmpty()) {
                return matches;
            }
            return null;
        }

        public static void addTracking(Player target, Player from, int time) {
            String ID = Helper.createID();
            ArrayList<HashMap<String, String>> inbox2 = target.getPCache().getInbox();
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("type", Type.track_request.toString());
            entry.put("player_name", from.getName());
            entry.put("player_uuid", from.getUUID());
            entry.put("id", ID);
            entry.put("expire", String.valueOf(time));
            inbox2.add(0, entry);
            target.getPCache().setInbox(inbox2);
            inbox2 = from.getPCache().getInbox();
            entry = new HashMap();
            entry.put("type", Type.track_pending.toString());
            entry.put("player_name", target.getName());
            entry.put("player_uuid", target.getUUID());
            entry.put("id", ID);
            entry.put("expire", String.valueOf(time));
            inbox2.add(0, entry);
            from.getPCache().setInbox(inbox2);
        }

        public static void addDest(Player target, Player from, int time, Dest dest2) {
            if (!dest2.hasXYZ() || dest2.getDimension() == null) {
                return;
            }
            ArrayList<HashMap<String, String>> inbox2 = target.getPCache().getInbox();
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("type", Type.destination.name());
            entry.put("player_name", from.getName());
            entry.put("player_uuid", from.getUUID());
            entry.put("id", Helper.createID());
            entry.put("expire", String.valueOf(time));
            entry.put("dest", dest2.toString());
            inbox2.add(0, entry);
        }

        public static void removeEntry(Player player, HashMap<String, String> entry) {
            if (entry == null) {
                return;
            }
            ArrayList<HashMap<String, String>> inbox2 = player.getPCache().getInbox();
            inbox2.remove(entry);
            player.getPCache().setInbox(inbox2);
        }

        public static void delete(Player player, String ID, boolean playerBased) {
            Helper.ListPage<HashMap<String, String>> listPage = new Helper.ListPage<HashMap<String, String>>(player.getPCache().getInbox(), 3);
            HashMap<String, String> entry = inbox.search(player, null, "id", ID);
            if (entry == null) {
                return;
            }
            inbox.removeEntry(player, entry);
            if (playerBased) {
                player.sendMessage(CUtl.tag().append(LANG.msg("cleared", CTxT.of(entry.get("player_name")).color(CUtl.s()))));
                inbox.UI(player, listPage.getPageOf(entry));
            }
        }

        public static CTxT getEntryTxT(Player player, HashMap<String, String> entry) {
            Player player_uuid;
            Type type = Helper.Enums.get(entry.get("type"), Type.class);
            String name = entry.get("player_name");
            if (FileData.getConfig().getOnline().booleanValue() && (player_uuid = new Player(entry.get("player_uuid"))).isValid()) {
                name = player_uuid.getName();
            }
            CTxT msg = CTxT.of("");
            CTxT time = (CTxT)LANG.ui("time", entry.get("expire")).color('7');
            CTxT from = LANG.ui("from", CTxT.of(name).color(CUtl.s()));
            CTxT to = LANG.ui("to", CTxT.of(name).color(CUtl.s()));
            switch (type.ordinal()) {
                case 1: {
                    msg.append((CTxT)LANG.ui("track_request", time).color(CUtl.p())).append(" ").append("\n  ").append(from).append("\n   ").append((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("accept", new Object[0]).btn(true)).color('a')).hover((CTxT)CUtl.LANG.hover("accept", new Object[0]).color('a')).click(1, "/dest track accept-r " + name)).append(" ").append((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("deny", new Object[0]).btn(true)).color('c')).hover((CTxT)CUtl.LANG.hover("deny", new Object[0]).color('c')).click(1, "/dest track deny-r " + name));
                    break;
                }
                case 0: {
                    msg.append((CTxT)LANG.ui("track_pending", time).color(CUtl.p())).append(" ").append("\n  ").append(to).append("\n   ").append((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("cancel", new Object[0]).btn(true)).color('c')).hover((CTxT)CUtl.LANG.hover("cancel", new Object[0]).color('c')).click(1, "/dest track cancel-r " + name));
                    break;
                }
                case 2: {
                    msg.append((CTxT)LANG.ui("destination", time).color(CUtl.p())).append(" ").append((CTxT)((CTxT)((CTxT)CTxT.of("\u2715").btn(true)).color('c')).hover((CTxT)LANG.hover("clear", new Object[0]).color('c')).click(1, "/dhud inbox clear " + entry.get("id"))).append("\n  ").append(from).append("\n   ").append(Destination.social.send.getSendTxt(player, new Dest(entry.get("dest"))));
                }
            }
            return msg;
        }

        public static void UI(Player player, int pg) {
            Helper.ListPage<HashMap<String, String>> listPage = new Helper.ListPage<HashMap<String, String>>(player.getPCache().getInbox(), 3);
            CTxT msg = CTxT.of(" ");
            CTxT line = (CTxT)CTxT.of("\n                                   ").strikethrough(true);
            msg.append((CTxT)LANG.ui().color("#7a6ef0")).append(line).append("\n ");
            for (HashMap<String, String> index : listPage.getPage(pg)) {
                msg.append(inbox.getEntryTxT(player, index)).append("\n ");
            }
            if (listPage.getList().isEmpty()) {
                msg.append("\n ").append((CTxT)((CTxT)LANG.ui("empty", new Object[0]).color('7')).italic(true)).append("\n");
            }
            msg.append("\n ").append(listPage.getNavButtons(pg, "/dhud inbox ")).append(" ").append(CUtl.CButton.back("/dhud")).append(line);
            player.sendMessage(msg);
        }

        public static enum Type {
            track_pending,
            track_request,
            destination;

        }
    }

    public static class preset {
        private static final int PER_PAGE = 7;
        public static final String DEFAULT_UI_SETTINGS = "normal";
        public static final Lang LANG = new Lang("dhud.preset.");
        public static CTxT BUTTON = ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#2dedff")).click(1, "/dhud preset")).hover(((CTxT)CTxT.of("/dhud presets").color("#2dedff")).append("\n").append(LANG.hover()));

        public static void colorCMDExecutor(Player player, String[] args) {
            if (args.length != 5) {
                return;
            }
            if (Helper.Enums.toStringList((Enum[])Type.values()).contains(args[1])) {
                Type type = Type.get(args[1]);
                if (args[3].equals("set")) {
                    preset.setColor(player, args[0], type, args[2], args[4]);
                }
                if (args[3].equals("preset")) {
                    preset.UI(player, args[0], type, args[2], args[4]);
                }
            }
        }

        public static void CMDExecutor(Player player, String[] args) {
            if (!Helper.checkEnabled(player).customPresets()) {
                return;
            }
            if (args.length <= 1) {
                if (args.length == 0) {
                    custom.UI(player, 1, null);
                } else if (Helper.Num.isNum(args[0])) {
                    custom.UI(player, Helper.Num.toInt(args[0]), null);
                } else {
                    ArrayList<Helper.ColorPreset> presets = player.getPData().getColorPresets();
                    Helper.ListPage<Helper.ColorPreset> listPage = new Helper.ListPage<Helper.ColorPreset>(presets, 7);
                    ArrayList<String> presetNames = custom.getNames(presets);
                    if (presetNames.contains(args[0])) {
                        custom.UI(player, listPage.getPageOf(presets.get(presetNames.indexOf(args[0]))), null);
                    }
                }
                return;
            }
            boolean Return = false;
            if (args[0].contains("-r")) {
                args[0] = args[0].replace("-r", "");
                Return = true;
            }
            if (args.length == 2 && args[0].equals("delete")) {
                custom.delete(player, args[1], Return);
            }
            if (args.length == 3) {
                if (args[0].equals("save")) {
                    custom.save(player, args[2], args[1], Return);
                }
                if (args[0].equals("rename")) {
                    custom.rename(player, args[1], args[2], Return);
                }
                if (args[0].equals("colorui")) {
                    custom.colorUI(player, args[2], args[1], null);
                }
                if (args[0].equals("color")) {
                    custom.setColor(player, "", args[1], args[2], Return);
                }
            }
        }

        public static ArrayList<String> CMDSuggester(Player player, int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (!Helper.checkEnabled(player).customPresets()) {
                return suggester;
            }
            if (pos == 0) {
                suggester.add("rename");
                suggester.add("save");
                suggester.add("color");
                suggester.add("delete");
                return suggester;
            }
            if (args[0].contains("-r")) {
                args[0] = args[0].replace("-r", "");
            }
            if (args[0].equals("save")) {
                if (pos == 1) {
                    return Helper.Command.Suggester.colors(player, Helper.Command.Suggester.getCurrent(args, pos), true);
                }
                if (pos == 2) {
                    suggester.add("name");
                }
            } else if (pos == 1) {
                suggester.addAll(Helper.Command.Suggester.wrapQuotes(custom.getNames(player.getPData().getColorPresets())));
            } else if (args[0].equals("rename")) {
                suggester.add("name");
            } else if (args[0].equals("color")) {
                return Helper.Command.Suggester.colors(player, Helper.Command.Suggester.getCurrent(args, pos), true);
            }
            return suggester;
        }

        public static void setColor(Player player, String UISettings, Type type, String subtype, String color2) {
            switch (type.ordinal()) {
                case 0: {
                    Hud.color.setColor(player, UISettings, subtype, color2, true);
                    break;
                }
                case 1: {
                    Destination.settings.setParticleColor(player, UISettings, Destination.Setting.get(subtype), color2, true);
                    break;
                }
                case 2: {
                    Destination.saved.setColor(player, new Destination.saved.DestEntry(player, subtype, false), UISettings, color2, true);
                    break;
                }
                case 3: {
                    custom.setColor(player, UISettings, subtype, color2, true);
                }
            }
        }

        public static CTxT colorEditor(String color2, String UISettings, Type type, String subtype, String stepCMD) {
            int i;
            CTxT presetsButton = CTxT.of("").append(((CTxT)((CTxT)((CTxT)CTxT.of("+").btn(true)).color('a')).click(2, String.format("/dhud preset save \"%s\" ", color2))).hover(LANG.hover("preset.plus", LANG.hover("preset.plus_2", new Object[0]).color(color2)))).append(((CTxT)((CTxT)((CTxT)LANG.btn().color("#2dedff")).click(1, String.format("/dhud color %s %s \"%s\" preset default", new Object[]{UISettings, type, subtype}))).btn(true)).hover(LANG.hover("preset.editor", LANG.hover("preset.editor_2", new Object[0]).color("#2dedff"))));
            CTxT customButton = ((CTxT)((CTxT)((CTxT)LANG.btn("custom", new Object[0]).btn(true)).color("#c4ff14")).click(2, String.format("/dhud color %s %s \"%s\" set ", new Object[]{UISettings, type, subtype}))).hover(LANG.hover("custom", LANG.hover("custom.2", new Object[0]).color("#c4ff14")));
            CTxT defaultSquare = ((CTxT)CTxT.of("\u2588").color(color2)).hover(CUtl.color.getBadge(color2));
            CTxT smallButton = preset.createSizeButton(stepCMD, "small");
            CTxT normalButton = preset.createSizeButton(stepCMD, DEFAULT_UI_SETTINGS);
            CTxT bigButton = preset.createSizeButton(stepCMD, "big");
            float[] changeAmounts = new float[3];
            if (UISettings == null || UISettings.equals(DEFAULT_UI_SETTINGS)) {
                ((CTxT)((CTxT)normalButton.color("#8d8d8d")).click(null)).hover(null);
                changeAmounts[0] = 0.02f;
                changeAmounts[1] = 0.05f;
                changeAmounts[2] = 0.1f;
            } else if (UISettings.equals("small")) {
                ((CTxT)((CTxT)smallButton.color("#8d8d8d")).click(null)).hover(null);
                changeAmounts[0] = 0.005f;
                changeAmounts[1] = 0.0125f;
                changeAmounts[2] = 0.025f;
            } else if (UISettings.equals("big")) {
                ((CTxT)((CTxT)bigButton.color("#8d8d8d")).click(null)).hover(null);
                changeAmounts[0] = 0.04f;
                changeAmounts[1] = 0.1f;
                changeAmounts[2] = 0.2f;
            }
            ArrayList<CTxT> hsbList = new ArrayList<CTxT>();
            for (i = 0; i < 3; ++i) {
                hsbList.add((CTxT)CTxT.of("-").btn(true));
                hsbList.add((CTxT)CTxT.of("+").btn(true));
            }
            i = 0;
            for (int changeAmt = 0; changeAmt < 3; ++changeAmt) {
                for (int plus = i; plus < i + 2; ++plus) {
                    String editedColor = CUtl.color.editHSB(changeAmt, color2, plus % 2 == 0 ? changeAmounts[changeAmt] * -1.0f : changeAmounts[changeAmt]);
                    ((CTxT)hsbList.get(plus)).color(editedColor.equals(color2) ? "#8d8d8d" : editedColor);
                    if (editedColor.equals(color2)) continue;
                    ((CTxT)hsbList.get(plus)).hover(LANG.get("color.hover.set", CUtl.color.getBadge(editedColor)));
                    ((CTxT)hsbList.get(plus)).click(1, String.format("/dhud color %s %s \"%s\" set \"%s\"", new Object[]{UISettings, type, subtype, editedColor}));
                }
                i += 2;
            }
            return CTxT.of(" ").append(presetsButton).append(" ").append(customButton).append("\n\n").append("  ").append((CTxT)hsbList.get(0)).append(" ").append(defaultSquare).append(" ").append((CTxT)hsbList.get(1)).append(" ").append(LANG.get("editor.hue", new Object[0])).append("\n  ").append((CTxT)hsbList.get(2)).append(" ").append(defaultSquare).append(" ").append((CTxT)hsbList.get(3)).append(" ").append(LANG.get("editor.saturation", new Object[0])).append("\n  ").append((CTxT)hsbList.get(4)).append(" ").append(defaultSquare).append(" ").append((CTxT)hsbList.get(5)).append(" ").append(LANG.get("editor.brightness", new Object[0])).append("\n\n ").append(smallButton).append(" ").append(normalButton).append(" ").append(bigButton);
        }

        private static CTxT createSizeButton(String stepCMD, String size) {
            CTxT buttonTxT = (CTxT)LANG.get("editor.step.button." + size, new Object[0]).color(CUtl.s());
            return (CTxT)((CTxT)new CTxT(buttonTxT).click(1, String.format(stepCMD, size))).hover(LANG.get("editor.step.hover", buttonTxT)).btn(true);
        }

        public static void UI(Player player, String UISettings, Type type, String subtype, String page) {
            String clickCMD = String.format("/dhud color %s %s \"%s\" ", new Object[]{UISettings, type, subtype});
            CTxT defaultBtn = (CTxT)((CTxT)((CTxT)LANG.btn("default", new Object[0]).color(CUtl.s())).click(1, clickCMD + "preset default")).btn(true);
            CTxT minecraftBtn = (CTxT)((CTxT)((CTxT)LANG.btn("minecraft", new Object[0]).color(CUtl.s())).click(1, clickCMD + "preset minecraft")).btn(true);
            CTxT customBtn = CTxT.of(" ").append((CTxT)((CTxT)((CTxT)LANG.btn("custom", new Object[0]).color(CUtl.s())).click(1, clickCMD + "preset custom")).btn(true));
            CTxT list = CTxT.of("");
            if (page.equals("default") || page.equals("minecraft")) {
                int rowAmt;
                List<String> colors;
                List<String> colorStrings;
                if (page.equals("default")) {
                    ((CTxT)((CTxT)defaultBtn.color("#8d8d8d")).click(1, null)).hover(null);
                    colorStrings = List.of("red", "orange", "yellow", "green", "blue", "purple", "gray");
                    colors = CUtl.color.DEFAULT_COLORS;
                    rowAmt = 3;
                } else {
                    ((CTxT)((CTxT)minecraftBtn.color("#8d8d8d")).click(1, null)).hover(null);
                    colorStrings = List.of("red", "yellow", "green", "aqua", "blue", "purple", "gray");
                    colors = List.of("#FF5555", "#AA0000", "#FFFF55", "#FFAA00", "#55FF55", "#00AA00", "#55FFFF", "#00AAAA", "#5555FF", "#0000AA", "#FF55FF", "#AA00AA", "#AAAAAA", "#555555");
                    rowAmt = 2;
                }
                int colorIndex = 0;
                for (String s : colorStrings) {
                    list.append("\n ");
                    for (int i = 0; i < rowAmt; ++i) {
                        String color2 = colors.get(colorIndex);
                        list.append(((CTxT)((CTxT)((CTxT)CTxT.of("\u2588").btn(true)).color(color2)).click(1, String.format(clickCMD + "set \"%s\"", color2))).hover(LANG.get("color.hover.set", CUtl.color.getBadge(color2))));
                        ++colorIndex;
                    }
                    list.append(" ").append(LANG.get("color." + s, new Object[0]));
                }
            } else {
                int pg = Helper.Num.toInt(page);
                Helper.ListPage<Helper.ColorPreset> listPage = new Helper.ListPage<Helper.ColorPreset>(player.getPData().getColorPresets(), 7);
                customBtn = listPage.getNavButtons(pg, clickCMD + "preset ");
                for (Helper.ColorPreset preset2 : listPage.getPage(pg)) {
                    String color3 = preset2.color();
                    String name = preset2.name();
                    list.append("\n ").append(((CTxT)((CTxT)((CTxT)CTxT.of("\u2588").color(color3)).btn(true)).click(1, String.format(clickCMD + "set \"%s\"", color3))).hover(LANG.get("color.hover.set", CUtl.color.getBadge(color3)))).append(" ").append((CTxT)CTxT.of(name).color(color3));
                }
                if (listPage.getPage(pg).size() != 7) {
                    for (int i = listPage.getPage(pg).size(); i < 7; ++i) {
                        list.append("\n   ");
                    }
                }
            }
            String backCMD = switch (type.ordinal()) {
                case 0 -> "/hud color " + subtype + " edit " + UISettings;
                case 1 -> "/dest settings colorui " + subtype + " " + UISettings;
                case 2 -> "/dest saved edit colorui \"" + subtype + "\" " + UISettings;
                case 3 -> "/dhud preset colorui \"" + subtype + "\" " + UISettings;
                default -> "/dhud";
            };
            CTxT msg = CTxT.of(" ").append((CTxT)LANG.ui().color("#2dedff")).append((CTxT)CTxT.of("\n                               \n").strikethrough(true)).append(" ").append(defaultBtn).append(" ").append(minecraftBtn).append("\n").append(list).append("\n\n   ").append(customBtn).append("  ").append(CUtl.CButton.back(backCMD)).append((CTxT)CTxT.of("\n                               ").strikethrough(true));
            player.sendMessage(msg);
        }

        public static enum Type {
            hud,
            dest,
            saved,
            preset,
            unknown;


            public static Type get(String s) {
                try {
                    return Type.valueOf(s);
                }
                catch (IllegalArgumentException e) {
                    return unknown;
                }
            }
        }

        public static class custom {
            public static ArrayList<String> updateTo1_7(ArrayList<String> oldList) {
                ArrayList<String> list = new ArrayList<String>();
                if (oldList.size() < 14) {
                    return list;
                }
                for (int i = 0; i < 14; i = (int)((byte)(i + 1))) {
                    String old = oldList.get(i);
                    if (old.equals("#ffffff")) continue;
                    list.add(i + 1 + "|" + old);
                }
                return list;
            }

            public static ArrayList<Helper.ColorPreset> updateTo2_0(ArrayList<String> list) {
                ArrayList<Helper.ColorPreset> output = new ArrayList<Helper.ColorPreset>();
                for (String preset2 : list) {
                    if (!preset2.contains("|#")) continue;
                    String name = preset2.substring(0, preset2.lastIndexOf("|#"));
                    String color2 = preset2.substring(preset2.lastIndexOf("|#") + 1);
                    if (name.length() > 16 || !color2.equals("#ffffff") && CUtl.color.format(color2).equals("#ffffff")) continue;
                    output.add(new Helper.ColorPreset(name, color2));
                }
                return output;
            }

            public static CTxT getBadge(Helper.ColorPreset preset2, boolean square) {
                return (CTxT)CTxT.of((square ? "\u2588 " : "") + preset2.name()).color(preset2.color());
            }

            public static ArrayList<String> getNames(ArrayList<Helper.ColorPreset> presets) {
                return presets.stream().map(Helper.ColorPreset::name).collect(Collectors.toCollection(ArrayList::new));
            }

            public static ArrayList<String> getColors(ArrayList<Helper.ColorPreset> presets) {
                return presets.stream().map(Helper.ColorPreset::color).collect(Collectors.toCollection(ArrayList::new));
            }

            public static void UI(Player player, int pg, CTxT aboveTxT) {
                CTxT msg = aboveTxT == null ? CTxT.of(" ") : aboveTxT.append("\n ");
                CTxT line = (CTxT)CTxT.of("\n                               ").strikethrough(true);
                msg.append((CTxT)LANG.ui("custom", new Object[0]).color("#2dedff")).append(line);
                CTxT addBtn = ((CTxT)((CTxT)((CTxT)CTxT.of("+").btn(true)).color('a')).click(2, "/dhud preset save-r ")).hover((CTxT)LANG.hover("save", new Object[0]).color('a'));
                if (player.getPData().getColorPresets().size() >= FileData.getConfig().getMaxColorPresets()) {
                    ((CTxT)((CTxT)addBtn.color('7')).click(1, null)).hover(null);
                }
                Helper.ListPage<Helper.ColorPreset> listPage = new Helper.ListPage<Helper.ColorPreset>(player.getPData().getColorPresets(), 7);
                for (Helper.ColorPreset preset2 : listPage.getPage(pg)) {
                    String color2 = preset2.color();
                    String name = preset2.name();
                    msg.append("\n ").append(((CTxT)((CTxT)((CTxT)CTxT.of("\u2715").color('c')).btn(true)).click(1, String.format("/dhud preset delete-r \"%s\"", name))).hover((CTxT)LANG.hover("delete", custom.getBadge(preset2, true)).color('c'))).append(" ").append(((CTxT)((CTxT)((CTxT)CTxT.of("\u2588").color(color2)).btn(true)).click(1, String.format("/dhud preset colorui \"%s\" normal", name))).hover(LANG.hover("color", CUtl.color.getBadge(color2)))).append(((CTxT)((CTxT)((CTxT)CTxT.of(name).color(color2)).btn(true)).click(2, String.format("/dhud preset rename-r \"%s\" ", name))).hover(LANG.hover("rename", custom.getBadge(preset2, false))));
                }
                if (listPage.getPage(pg).size() != 7) {
                    for (int i = listPage.getPage(pg).size(); i < 7; ++i) {
                        msg.append("\n");
                    }
                }
                msg.append("\n\n ").append(addBtn).append(" ").append(listPage.getNavButtons(pg, "/dhud preset ")).append(" ").append(CUtl.CButton.back("/dhud")).append(line);
                player.sendMessage(msg);
            }

            public static void colorUI(Player player, String UISettings, String name, CTxT aboveTxT) {
                ArrayList<Helper.ColorPreset> presets = player.getPData().getColorPresets();
                ArrayList<String> names = custom.getNames(presets);
                if (!names.contains(name)) {
                    return;
                }
                String currentColor = custom.getColors(presets).get(names.indexOf(name));
                CTxT line = (CTxT)CTxT.of("\n                               ").strikethrough(true);
                CTxT msg = CTxT.of("");
                if (aboveTxT != null) {
                    msg.append(aboveTxT).append("\n");
                }
                msg.append(" ").append((CTxT)LANG.ui("color", new Object[0]).color(currentColor)).append(line).append("\n").append(preset.colorEditor(currentColor, UISettings, Type.preset, name, "/dhud preset colorui \"" + name + "\" %s")).append("\n\n           ").append(CUtl.CButton.back(String.format("/dhud preset \"%s\"", name))).append(line);
                player.sendMessage(msg);
            }

            public static void setColor(Player player, String UISettings, String name, String color2, boolean Return) {
                ArrayList<Helper.ColorPreset> presets = player.getPData().getColorPresets();
                ArrayList<String> names = custom.getNames(presets);
                if (!names.contains(name)) {
                    player.sendMessage(LANG.error("invalid", new Object[0]));
                    return;
                }
                color2 = CUtl.color.colorHandler(player, color2);
                int index = names.indexOf(name);
                Helper.ColorPreset oldPreset = presets.get(index);
                Helper.ColorPreset preset2 = new Helper.ColorPreset(name, color2);
                presets.set(index, preset2);
                player.getPData().setColorPresets(presets);
                if (Return) {
                    custom.colorUI(player, UISettings, name, null);
                } else {
                    player.sendMessage(CUtl.tag().append(LANG.msg("color", custom.getBadge(oldPreset, false), CUtl.color.getBadge(color2))));
                }
            }

            public static void save(Player player, String name, String color2, boolean Return) {
                ArrayList<Helper.ColorPreset> presets = player.getPData().getColorPresets();
                if (custom.getNames(presets).contains(name)) {
                    player.sendMessage(LANG.error("duplicate", new Object[0]));
                    return;
                }
                if (name.length() > 16) {
                    player.sendMessage(CUtl.LANG.error("length", 16));
                    return;
                }
                if (presets.size() >= FileData.getConfig().getMaxColorPresets()) {
                    player.sendMessage(LANG.error("max", new Object[0]));
                    return;
                }
                color2 = CUtl.color.colorHandler(player, color2);
                Helper.ColorPreset entry = new Helper.ColorPreset(name, color2);
                presets.add(entry);
                player.getPData().setColorPresets(presets);
                Helper.ListPage<Helper.ColorPreset> listPage = new Helper.ListPage<Helper.ColorPreset>(presets, 7);
                CTxT msg = CUtl.tag().append(LANG.msg("save", custom.getBadge(entry, true)));
                if (Return) {
                    custom.UI(player, listPage.getPageOf(presets.get(presets.size() - 1)), msg);
                } else {
                    player.sendMessage(msg);
                }
            }

            public static void rename(Player player, String name, String newName, boolean Return) {
                ArrayList<Helper.ColorPreset> presets = player.getPData().getColorPresets();
                ArrayList<String> names = custom.getNames(presets);
                if (!names.contains(name)) {
                    player.sendMessage(LANG.error("invalid", new Object[0]));
                    return;
                }
                if (names.contains(newName)) {
                    player.sendMessage(LANG.error("duplicate", new Object[0]));
                    return;
                }
                if (newName.length() > 16) {
                    player.sendMessage(CUtl.LANG.error("length", 16));
                    return;
                }
                int index = names.indexOf(name);
                Helper.ColorPreset oldEntry = presets.get(index);
                Helper.ColorPreset newEntry = new Helper.ColorPreset(newName, oldEntry.color());
                presets.set(index, newEntry);
                player.getPData().setColorPresets(presets);
                CTxT msg = CUtl.tag().append(LANG.msg("rename", custom.getBadge(oldEntry, false), custom.getBadge(newEntry, false)));
                Helper.ListPage<String> listPage = new Helper.ListPage<String>(names, 7);
                if (Return) {
                    custom.UI(player, listPage.getPageOf(name), msg);
                } else {
                    player.sendMessage(msg);
                }
            }

            public static void delete(Player player, String name, boolean Return) {
                ArrayList<Helper.ColorPreset> presets = player.getPData().getColorPresets();
                ArrayList<String> names = custom.getNames(presets);
                if (!names.contains(name)) {
                    player.sendMessage(LANG.error("invalid", new Object[0]));
                    return;
                }
                Helper.ColorPreset entry = presets.get(names.indexOf(name));
                presets.remove(entry);
                player.getPData().setColorPresets(presets);
                CTxT msg = CUtl.tag().append(LANG.msg("delete", custom.getBadge(entry, true)));
                Helper.ListPage<String> listPage = new Helper.ListPage<String>(names, 7);
                if (Return) {
                    custom.UI(player, listPage.getPageOf(name), msg);
                } else {
                    player.sendMessage(msg);
                }
            }
        }
    }
}

