/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import one.oth3r.directionhud.common.Assets;
import one.oth3r.directionhud.common.DHud;
import one.oth3r.directionhud.common.files.FileData;
import one.oth3r.directionhud.common.files.GlobalDest;
import one.oth3r.directionhud.common.files.dimension.Dimension;
import one.oth3r.directionhud.common.files.playerdata.PlayerData;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Dest;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Lang;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;
import one.oth3r.directionhud.utils.Utl;

public class Destination {
    public static final Lang LANG = new Lang("destination.");
    public static CTxT BUTTON = ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#29a2ff")).click(1, "/dest")).hover(((CTxT)CTxT.of("/dest | /destination").color("#29a2ff")).append("\n").append(LANG.hover()));

    public static void UI(Player player) {
        CTxT msg = CTxT.of(" ");
        CTxT line = (CTxT)CTxT.of("\n                                  ").strikethrough(true);
        msg.append((CTxT)LANG.ui("commands", new Object[0]).color("#29a2ff")).append(line).append("\n ");
        boolean line1Free = false;
        boolean line2Free = !Helper.checkEnabled(player).lastdeath();
        boolean sendThird = Helper.checkEnabled(player).send();
        if (Helper.checkEnabled(player).saving() || Helper.checkEnabled(player).global()) {
            if (Helper.checkEnabled(player).saving()) {
                msg.append(saved.BUTTON).append(saved.ADD_BUTTON);
            } else if (Helper.checkEnabled(player).global()) {
                msg.append(saved.GLOBAL_BUTTON).append("  ");
            }
            if (!line2Free) {
                msg.append("        ");
            } else {
                msg.append("  ");
            }
        } else {
            line1Free = true;
        }
        msg.append(dest.SET_BUTTON()).append(dest.CLEAR_BUTTON(player));
        if (line1Free) {
            msg.append(" ");
        } else {
            msg.append("\n\n ");
        }
        if (Helper.checkEnabled(player).lastdeath()) {
            msg.append(lastdeath.BUTTON);
            if (line1Free) {
                line1Free = false;
                line2Free = true;
                msg.append("\n\n ");
            } else {
                msg.append("  ");
            }
        }
        msg.append(settings.BUTTON);
        if (line1Free) {
            msg.append("\n\n ");
        } else if (line2Free) {
            msg.append("  ");
        } else {
            msg.append("\n\n ");
        }
        if (Helper.checkEnabled(player).send()) {
            msg.append(social.send.BUTTON);
            if (line2Free && !line1Free) {
                msg.append("\n\n ");
                line2Free = false;
                sendThird = false;
            } else {
                msg.append(" ");
            }
        }
        if (Helper.checkEnabled(player).track()) {
            msg.append(social.track.BUTTON(social.track.hasTargetEntry(player)));
            if (line2Free && !line1Free) {
                msg.append("\n\n ");
            } else if (line2Free) {
                if (Helper.checkEnabled(player).send()) {
                    msg.append(" ");
                } else {
                    msg.append("   ");
                }
            } else if (sendThird) {
                msg.append(" ");
            } else {
                msg.append("   ");
            }
        }
        msg.append(CUtl.CButton.back("/dhud")).append(line);
        player.sendMessage(msg);
    }

    public static class saved {
        private static final int PER_PAGE = 7;
        public static final Lang LANG = new Lang("destination.saved.");
        public static CTxT BUTTON = ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#1ee16f")).click(1, "/dest saved")).hover(((CTxT)CTxT.of(Assets.cmdUsage.destSaved).color("#1ee16f")).append("\n").append(LANG.hover()));
        public static CTxT GLOBAL_BUTTON = ((CTxT)((CTxT)((CTxT)LANG.btn("global", new Object[0]).btn(true)).color("#60a4fc")).click(1, "/dest global")).hover(((CTxT)CTxT.of(Assets.cmdUsage.destGlobal).color("#60a4fc")).append("\n").append(LANG.hover()));
        public static CTxT ADD_BUTTON = ((CTxT)((CTxT)((CTxT)CTxT.of("+").btn(true)).color("#36ff89")).click(2, "/dest add ")).hover(((CTxT)CTxT.of("... add <name> (x) (y) (z) (dimension) (color)").color("#36ff89")).append("\n").append(LANG.hover("add", LANG.hover("add.2", new Object[0]).color("#36ff89"))));

        public static CTxT SAVE_BUTTON(String cmd) {
            return ((CTxT)((CTxT)((CTxT)CTxT.of("+").btn(true)).color("#36ff89")).click(2, cmd)).hover(LANG.hover("save", LANG.hover("save.2", new Object[0]).color("#36ff89")));
        }

        public static CTxT EDIT_BUTTON(int click, String cmd) {
            return (CTxT)((CTxT)((CTxT)((CTxT)CTxT.of("\u270e").btn(true)).color("#665dff")).click(click, cmd)).hover((CTxT)LANG.hover("edit", CUtl.LANG.get("destination", new Object[0])).color("#665dff")).color("#665dff");
        }

        public static void CMDExecutor(Player player, String[] args) {
            if (!Helper.checkEnabled(player).saving()) {
                return;
            }
            if (args.length == 0) {
                saved.UI(player, 1);
                return;
            }
            if (Helper.Num.isInt(args[0])) {
                saved.UI(player, Helper.Num.toInt(args[0]));
                return;
            }
            boolean Return = args[0].contains("-r");
            args[0] = args[0].replace("-r", "");
            switch (args[0]) {
                case "edit": {
                    saved.editCMDExecutor(player, Helper.trimStart(args, 1), false, Return);
                    break;
                }
                case "send": {
                    if (args.length == 2) {
                        player.sendMessage(CUtl.LANG.error("args", new Object[0]));
                    }
                    if (args.length != 3) break;
                    DestEntry dest2 = new DestEntry(player, args[1], false);
                    if (dest2.hasDestRequirements()) {
                        social.send.logic(player, args[2], dest2);
                        break;
                    }
                    player.sendMessage(LANG.error("invalid", new Object[0]));
                    break;
                }
                case "delete": {
                    if (args.length == 1) {
                        player.sendMessage(CUtl.LANG.error("args", new Object[0]));
                    }
                    if (args.length != 2) break;
                    saved.delete(Return, player, new DestEntry(player, args[1], false));
                    break;
                }
                case "set": {
                    boolean convert;
                    boolean bl = convert = args.length == 3 && args[2].equals("convert");
                    if (args.length < 2) break;
                    dest.setSaved(player, args[1], false, convert);
                    break;
                }
                case "add": {
                    saved.addCMDExecutor(player, Helper.trimStart(args, 1), false);
                    break;
                }
                default: {
                    player.sendMessage(CUtl.usage(Assets.cmdUsage.destSaved));
                }
            }
        }

        public static ArrayList<String> CMDSuggester(Player player, int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (!Helper.checkEnabled(player).saving()) {
                return suggester;
            }
            if (pos == 0) {
                suggester.add("add");
                suggester.add("edit");
                suggester.add("delete");
                suggester.add("send");
                suggester.add("set");
                return suggester;
            }
            if (args[0].contains("-r")) {
                args[0] = args[0].replace("-r", "");
            }
            switch (args[0]) {
                case "delete": 
                case "set": {
                    if (pos == 1) {
                        suggester.addAll(saved.getCMDNames(saved.getList(player)));
                    }
                    if (pos != 2 || !args[0].equals("set")) break;
                    suggester.add("convert");
                    break;
                }
                case "send": {
                    if (pos == 1) {
                        suggester.addAll(saved.getCMDNames(saved.getList(player)));
                    }
                    if (pos != 2) break;
                    for (Player s : Utl.getPlayers()) {
                        if (s.equals(player)) continue;
                        suggester.add(s.getName());
                    }
                    break;
                }
                case "add": {
                    suggester.addAll(saved.addCMDSuggester(player, pos - 1, Helper.trimStart(args, 1)));
                    break;
                }
                case "edit": {
                    suggester.addAll(saved.editCMDSuggester(player, false, pos - 1, Helper.trimStart(args, 1)));
                }
            }
            return suggester;
        }

        public static void globalCMDExecutor(Player player, String[] args) {
            if (!Helper.checkEnabled(player).global()) {
                return;
            }
            if (args.length == 0) {
                saved.globalUI(player, 1);
                return;
            }
            if (Helper.Num.isNum(args[0])) {
                saved.globalUI(player, Helper.Num.toInt(args[0]));
                return;
            }
            if (args[0].equals("set")) {
                boolean convert;
                boolean bl = convert = args.length == 3 && args[2].equals("convert");
                if (args.length >= 2) {
                    dest.setSaved(player, args[1], true, convert);
                } else {
                    player.sendMessage(CUtl.usage(Assets.cmdUsage.destGlobal));
                }
                return;
            }
            if (!Helper.checkEnabled(player).globalEditing()) {
                return;
            }
            switch (args[0]) {
                case "edit": {
                    saved.editCMDExecutor(player, Helper.trimStart(args, 1), true, false);
                    break;
                }
                case "delete": {
                    if (args.length == 1) {
                        player.sendMessage(CUtl.LANG.error("args", new Object[0]));
                    }
                    if (args.length != 2) break;
                    saved.delete(false, player, new DestEntry(player, args[1], true));
                    break;
                }
                case "add": {
                    saved.addCMDExecutor(player, Helper.trimStart(args, 1), true);
                    break;
                }
                default: {
                    player.sendMessage(CUtl.usage(Assets.cmdUsage.destGlobalPerms));
                }
            }
        }

        public static ArrayList<String> globalCMDSuggester(Player player, int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (pos == 0) {
                suggester.add("set");
                if (!Helper.checkEnabled(player).globalEditing()) {
                    return suggester;
                }
                suggester.add("add");
                suggester.add("edit");
                suggester.add("delete");
                return suggester;
            }
            if (args[0].equals("set")) {
                if (pos == 1) {
                    suggester.addAll(saved.getCMDNames(FileData.getGlobal().getDestinations()));
                }
                if (pos == 2) {
                    suggester.add("convert");
                }
            }
            if (!Helper.checkEnabled(player).globalEditing()) {
                return suggester;
            }
            switch (args[0]) {
                case "delete": {
                    if (pos != 1) break;
                    suggester.addAll(saved.getCMDNames(FileData.getGlobal().getDestinations()));
                    break;
                }
                case "add": {
                    return saved.addCMDSuggester(player, pos - 1, Helper.trimStart(args, 1));
                }
                case "edit": {
                    return saved.editCMDSuggester(player, true, pos - 1, Helper.trimStart(args, 1));
                }
            }
            return suggester;
        }

        public static void editCMDExecutor(Player player, String[] args, boolean global, boolean Return) {
            if (args.length == 0) {
                return;
            }
            if (args.length == 1) {
                saved.editUI(player, new DestEntry(player, args[0], global));
                return;
            }
            switch (args[0]) {
                case "name": {
                    if (args.length == 3) {
                        saved.editName(Return, player, new DestEntry(player, args[1], global), args[2]);
                        break;
                    }
                    player.sendMessage(LANG.error("invalid", new Object[0]));
                    break;
                }
                case "color": {
                    if (args.length == 3) {
                        saved.setColor(player, new DestEntry(player, args[1], global), "normal", args[2], Return);
                        break;
                    }
                    player.sendMessage(LANG.error("invalid", new Object[0]));
                    break;
                }
                case "colorui": {
                    if (args.length == 2) {
                        saved.colorUI(player, "normal", args[1]);
                    }
                    if (args.length != 3) break;
                    saved.colorUI(player, args[2], args[1]);
                    break;
                }
                case "order": {
                    if (args.length == 3) {
                        saved.editOrder(Return, player, new DestEntry(player, args[1], global), args[2]);
                        break;
                    }
                    player.sendMessage(LANG.error("invalid", new Object[0]));
                    break;
                }
                case "location": {
                    if (args.length == 2) {
                        player.sendMessage(LANG.error("invalid", new Object[0]));
                    }
                    if (args.length == 3 && !Helper.Num.isInt(args[2])) {
                        Loc loc = new Loc();
                        loc.setDimension(args[2]);
                        saved.editLocation(Return, player, new DestEntry(player, args[1], global), loc);
                    }
                    if (args.length == 4) {
                        saved.editLocation(Return, player, new DestEntry(player, args[1], global), new Loc(Helper.Num.toInt(args[2]), Helper.Num.toInt(args[3])));
                    }
                    if (args.length == 5) {
                        if (Helper.Num.isInt(args[4])) {
                            saved.editLocation(Return, player, new DestEntry(player, args[1], global), new Loc(Helper.Num.toInt(args[2]), Helper.Num.toInt(args[3]), Helper.Num.toInt(args[4])));
                        } else {
                            saved.editLocation(Return, player, new DestEntry(player, args[1], global), new Loc(Helper.Num.toInt(args[2]), Helper.Num.toInt(args[3]), args[4]));
                        }
                    }
                    if (args.length != 6) break;
                    saved.editLocation(Return, player, new DestEntry(player, args[1], global), new Loc(Helper.Num.toInt(args[2]), Helper.Num.toInt(args[3]), Helper.Num.toInt(args[4]), args[5]));
                }
            }
        }

        public static ArrayList<String> editCMDSuggester(Player player, boolean global, int pos, String[] args) {
            String current = Helper.Command.Suggester.getCurrent(args, pos);
            ArrayList<String> suggester = new ArrayList<String>();
            if (pos == 0) {
                suggester.add("location");
                suggester.add("color");
                suggester.add("name");
                suggester.add("order");
                return suggester;
            }
            if (pos == 1) {
                suggester.addAll(saved.getCMDNames(global ? FileData.getGlobal().getDestinations() : saved.getList(player)));
            }
            if (args[0].equalsIgnoreCase("location")) {
                if (pos == 2) {
                    suggester.addAll(Helper.Command.Suggester.xyz(player, current, 3));
                    suggester.addAll(Helper.Command.Suggester.dims(current, true));
                }
                if (pos == 3) {
                    suggester.addAll(Helper.Command.Suggester.xyz(player, current, 2));
                }
                if (pos == 4) {
                    suggester.addAll(Helper.Command.Suggester.xyz(player, current, 1));
                    suggester.addAll(Helper.Command.Suggester.dims(current, false));
                }
                if (pos == 5 && Helper.Num.isInt(args[4])) {
                    suggester.addAll(Helper.Command.Suggester.dims(current, true));
                }
                return suggester;
            }
            if (pos == 2) {
                if (args[0].equalsIgnoreCase("name")) {
                    suggester.add("\"name\"");
                    suggester.add(new DestEntry(player, args[1], global).getCMDName());
                }
                if (args[0].equalsIgnoreCase("color")) {
                    suggester.addAll(Helper.Command.Suggester.colors(player, current, true));
                }
                if (args[0].equalsIgnoreCase("order")) {
                    suggester.add(String.valueOf(new DestEntry(player, args[1], global).getOrder()));
                }
            }
            return suggester;
        }

        public static void addCMDExecutor(Player player, String[] args, boolean global) {
            if (!Helper.checkEnabled(player).saving() && !Helper.checkEnabled(player).globalEditing()) {
                return;
            }
            if (args.length < 1) {
                player.sendMessage(CUtl.usage("... add <name> (x) (y) (z) (dimension) (color)"));
                return;
            }
            saved.add(player, new DestEntry(player, dest.getDestArgs(player, args, true), global));
        }

        public static ArrayList<String> addCMDSuggester(Player player, int pos, String[] args) {
            if (!Helper.checkEnabled(player).saving() && !Helper.checkEnabled(player).globalEditing()) {
                return new ArrayList<String>();
            }
            return dest.destSuggester(player, pos, args, true);
        }

        public static ArrayList<Dest> getList(Player player) {
            return player.getPData().getDEST().getSaved();
        }

        public static ArrayList<String> getCMDNames(ArrayList<Dest> list) {
            return list.stream().map(dest2 -> Helper.Command.Suggester.wrapQuotes(dest2.getName())).collect(Collectors.toCollection(ArrayList::new));
        }

        public static ArrayList<String> getNames(ArrayList<Dest> list) {
            return list.stream().map(Dest::getName).collect(Collectors.toCollection(ArrayList::new));
        }

        public static void add(Player player, DestEntry destination) {
            destination.setColor(CUtl.color.colorHandler(player, destination.getColor()));
            if (destination.sendErrors()) {
                return;
            }
            if (destination.getList().size() >= FileData.getConfig().getDestination().getMaxSaved()) {
                player.sendMessage(LANG.error("max", new Object[0]));
                return;
            }
            if (saved.getNames(destination.getList()).contains(destination.getName())) {
                player.sendMessage(LANG.error("duplicate", CTxT.of(destination.getName()).color(CUtl.s())));
                return;
            }
            destination.add();
            String cmdName = destination.getCMDName();
            CTxT buttons = CTxT.of(" ");
            if (!destination.isGlobal()) {
                buttons.append(saved.EDIT_BUTTON(1, "/dest saved edit " + cmdName)).append(" ");
            }
            buttons.append(dest.setButtons(destination, Dimension.canConvert(player.getDimension(), destination.getDimension())));
            player.sendMessage(CUtl.tag().append(LANG.msg("add", destination.getBadge().append(buttons))));
        }

        public static void delete(boolean Return, Player player, DestEntry destination) {
            Helper.ListPage<Dest> listPage = new Helper.ListPage<Dest>(destination.getList(), 7);
            if (destination.sendErrors()) {
                return;
            }
            destination.remove();
            player.sendMessage(CUtl.tag().append(LANG.msg("delete", destination.getBadge())));
            if (Return) {
                player.performCommand("dest saved " + listPage.getPageOf(destination));
            }
        }

        public static void editName(boolean Return, Player player, DestEntry destination, String newName) {
            if (destination.sendErrors()) {
                return;
            }
            if (saved.getNames(destination.list).contains(newName)) {
                player.sendMessage(LANG.error("duplicate", CTxT.of(newName).color(CUtl.s())));
                return;
            }
            CTxT oldName = (CTxT)CTxT.of(destination.getName()).color(CUtl.s());
            destination.setName(newName);
            destination.update();
            player.sendMessage(CUtl.tag().append(LANG.msg("set", oldName, LANG.get("name", new Object[0]), CTxT.of(newName).color(CUtl.s()))));
            if (Return) {
                player.performCommand("dest saved edit " + destination.getCMDName());
            }
        }

        public static void editOrder(boolean Return, Player player, DestEntry destination, String newOrderString) {
            if (destination.sendErrors()) {
                return;
            }
            if (!Helper.Num.isInt(newOrderString)) {
                player.sendMessage(CUtl.LANG.error("number", new Object[0]));
                return;
            }
            CTxT name = (CTxT)CTxT.of(destination.getName()).color(CUtl.s());
            destination.setOrder(Helper.Num.toInt(newOrderString));
            player.sendMessage(CUtl.tag().append(LANG.msg("set", name, LANG.get("order", new Object[0]), CTxT.of(String.valueOf(destination.getOrder())).color(CUtl.s()))));
            if (Return) {
                player.performCommand("dest saved edit " + destination.getCMDName());
            }
        }

        public static void editLocation(boolean Return, Player player, DestEntry destination, Loc newLoc) {
            if (destination.sendErrors()) {
                return;
            }
            if (newLoc.hasXYZ()) {
                destination.setX(newLoc.getX());
                destination.setY(newLoc.getY());
                destination.setZ(newLoc.getZ());
            }
            if (newLoc.getDimension() != null) {
                destination.setDimension(newLoc.getDimension());
            }
            destination.update();
            CTxT name = (CTxT)CTxT.of(destination.getName()).color(CUtl.s());
            player.sendMessage(CUtl.tag().append(LANG.msg("set", name, LANG.get("location", new Object[0]), CTxT.of(destination.getNamelessBadge()))));
            if (Return) {
                player.performCommand("dest saved edit " + String.valueOf(name));
            }
        }

        public static void setColor(Player player, DestEntry destination, String UISettings, String newColor, boolean Return) {
            if (destination.sendErrors()) {
                return;
            }
            newColor = CUtl.color.colorHandler(player, newColor);
            destination.setColor(newColor);
            destination.update();
            CTxT name = (CTxT)CTxT.of(destination.getName()).color(CUtl.s());
            if (Return) {
                saved.colorUI(player, UISettings, destination.getName());
            } else {
                player.sendMessage(CUtl.tag().append(LANG.msg("set", name, LANG.get("color", new Object[0]), CUtl.color.getBadge(newColor))));
            }
        }

        public static void colorUI(Player player, String UISettings, String name) {
            DestEntry destination = new DestEntry(player, name, false);
            if (destination.sendErrors()) {
                return;
            }
            String currentColor = destination.getColor();
            CTxT msg = CTxT.of(" ");
            CTxT line = (CTxT)CTxT.of("\n                               ").strikethrough(true);
            msg.append((CTxT)LANG.ui("color", name).color(currentColor)).append(line).append("\n");
            String cmdName = destination.getCMDName();
            msg.append(DHud.preset.colorEditor(currentColor, UISettings, DHud.preset.Type.saved, name, "/dest saved edit colorui " + cmdName + " %s")).append("\n\n           ").append(CUtl.CButton.back("/dest saved edit " + cmdName)).append(line);
            player.sendMessage(msg);
        }

        public static void editUI(Player player, DestEntry destination) {
            if (destination.sendErrors()) {
                return;
            }
            Helper.ListPage<Dest> listPage = new Helper.ListPage<Dest>(new ArrayList<Dest>(destination.getList()), 7);
            String cmdName = destination.getCMDName();
            CTxT msg = CTxT.of(" ");
            CTxT line = (CTxT)CTxT.of("\n                                             ").strikethrough(true);
            msg.append((CTxT)LANG.ui("edit", new Object[0]).color("#1ee16f")).append(line).append("\n");
            msg.append(" ").append((CTxT)((CTxT)((CTxT)CTxT.of("#" + destination.getOrder()).btn(true)).color(CUtl.p())).hover(LANG.hover("edit", LANG.get("order", new Object[0]).color(CUtl.p()))).click(2, "/dest saved edit-r order " + cmdName + " ")).append(" ").append((CTxT)((CTxT)((CTxT)CTxT.of(destination.getName()).btn(true)).color(CUtl.s())).hover(LANG.hover("edit", LANG.get("name", new Object[0]).color(CUtl.s()))).click(2, "/dest saved edit-r name " + cmdName + " ")).append(" ").append((CTxT)((CTxT)((CTxT)CTxT.of("\u2588").btn(true)).color(destination.getColor())).hover(LANG.hover("edit", LANG.get("color", new Object[0]).color(destination.getColor()))).click(1, "/dest saved edit colorui " + cmdName)).append("\n\n ").append((CTxT)((CTxT)((CTxT)CTxT.of("\u270e").btn(true)).color("#665dff")).hover(LANG.hover("edit", LANG.get("location", new Object[0]).color("#665dff"))).click(2, "/dest saved edit-r location " + cmdName + " ")).append(" ").append(CTxT.of(destination.getNamelessBadge())).append("\n   ");
            if (Helper.checkEnabled(player).send()) {
                msg.append(((CTxT)((CTxT)((CTxT)social.send.LANG.btn().btn(true)).color("#52e1ff")).click(2, "/dest saved send " + cmdName + " ")).hover(((CTxT)CTxT.of("/dest saved send " + cmdName + " <player>").color("#52e1ff")).append("\n").append(social.send.LANG.hover("saved", new Object[0])))).append(" ");
            }
            msg.append(dest.setButtons(destination, Dimension.canConvert(player.getDimension(), destination.getDimension()))).append(" ").append("\n\n ").append(((CTxT)((CTxT)((CTxT)LANG.btn("delete", new Object[0]).btn(true)).color('c')).click(2, "/dest saved delete-r " + cmdName)).hover(LANG.hover("delete", LANG.btn("delete", new Object[0]).color('c')))).append(" ").append(CUtl.CButton.back("/dest saved " + listPage.getPageOf(destination))).append(line);
            player.sendMessage(msg);
        }

        public static void UI(Player player, int pg) {
            Helper.ListPage<Dest> listPage = new Helper.ListPage<Dest>(new ArrayList<Dest>(saved.getList(player)), 7);
            CTxT msg = CTxT.of(" ");
            CTxT line = (CTxT)CTxT.of("\n                                             ").strikethrough(true);
            msg.append((CTxT)LANG.ui().color("#1ee16f")).append(line).append("\n");
            for (Dest entry : listPage.getPage(pg)) {
                String cmdName = "\"" + entry.getName() + "\"";
                msg.append(" ").append(entry.getBadge()).append(" ").append(saved.EDIT_BUTTON(1, "/dest saved edit " + cmdName)).append(" ").append(dest.setButtons(entry, Dimension.canConvert(player.getDimension(), entry.getDimension()))).append("\n");
            }
            if (listPage.getPage(pg).isEmpty()) {
                msg.append(" ").append(LANG.ui("none", new Object[0])).append("\n ").append(LANG.ui("none.2", ADD_BUTTON)).append("\n");
            }
            msg.append("\n ");
            if (Helper.checkEnabled(player).global()) {
                msg.append((CTxT)((CTxT)((CTxT)CTxT.of("\ud83e\udded").btn(true)).color("#60a4fc")).hover((CTxT)LANG.hover("global", new Object[0]).color("#60a4fc")).click(1, "/dest global"));
            } else {
                msg.append(ADD_BUTTON);
            }
            msg.append(" ").append(listPage.getNavButtons(pg, "/dest saved ")).append(" ").append(CUtl.CButton.back("/dest")).append(line);
            player.sendMessage(msg);
        }

        public static void globalUI(Player player, int pg) {
            Helper.ListPage<Dest> listPage = new Helper.ListPage<Dest>(new ArrayList<Dest>(FileData.getGlobal().getDestinations()), 7);
            CTxT msg = CTxT.of(" ");
            CTxT line = (CTxT)CTxT.of("\n                                             ").strikethrough(true);
            msg.append((CTxT)LANG.ui("global", new Object[0]).color("#60a4fc")).append(line).append("\n");
            for (Dest entry : listPage.getPage(pg)) {
                msg.append(" ").append(entry.getBadge()).append(" ").append(dest.setButtons(entry, Dimension.canConvert(player.getDimension(), entry.getDimension()))).append("\n");
            }
            if (listPage.getPage(pg).isEmpty()) {
                msg.append(" ").append(LANG.ui("global.none", new Object[0])).append("\n");
            }
            msg.append("\n ").append((CTxT)((CTxT)((CTxT)CTxT.of("\ud83d\udcda").btn(true)).color("#1ee16f")).hover((CTxT)LANG.hover("local", new Object[0]).color("#1ee16f")).click(1, "/dest saved")).append(" ").append(listPage.getNavButtons(pg, "/dest global ")).append(" ").append(CUtl.CButton.back("/dest")).append(line);
            player.sendMessage(msg);
        }

        public static class DestEntry
        extends Dest {
            private final transient ArrayList<Dest> list;
            private final transient Player player;
            private transient Integer index;
            public final transient boolean global;

            public DestEntry(Player player, Dest dest2, boolean global) {
                super(dest2);
                this.global = global;
                this.list = DestEntry.getListType(player, global);
                this.index = this.list.indexOf(this.getThis());
                this.player = player;
            }

            public DestEntry(Player player, String name, boolean global) {
                this.global = global;
                this.list = DestEntry.getListType(player, global);
                this.player = player;
                for (Dest entry : this.list) {
                    if (!entry.getName().equals(name)) continue;
                    this.setDest(entry);
                    this.index = this.list.indexOf(entry);
                    break;
                }
            }

            private static ArrayList<Dest> getListType(Player player, boolean global) {
                return global ? FileData.getGlobal().getDestinations() : saved.getList(player);
            }

            public void setDest(Dest dest2) {
                this.setX(dest2.getX());
                this.setY(dest2.getY());
                this.setZ(dest2.getZ());
                this.setDimension(dest2.getDimension());
                this.setName(dest2.getName());
                this.setColor(dest2.getColor());
            }

            private void save() {
                if (this.global) {
                    GlobalDest globalDest = FileData.getGlobal();
                    globalDest.setDestinations(this.list);
                    FileData.setGlobalDestinations(globalDest, true);
                } else {
                    this.player.getPData().getDEST().setSaved(this.list);
                }
            }

            public void update() {
                if (this.index >= 0) {
                    this.list.set(this.index, this.getThis());
                    this.save();
                }
            }

            public void add() {
                if (!this.list.contains(this.getThis())) {
                    this.list.add(this.getThis());
                    this.index = this.list.indexOf(this.getThis());
                    this.save();
                }
            }

            public void remove() {
                this.list.remove(this.getThis());
                this.save();
            }

            public ArrayList<Dest> getList() {
                return this.list;
            }

            public String getCMDName() {
                return Helper.Command.Suggester.wrapQuotes(this.getName());
            }

            public int getOrder() {
                return this.index + 1;
            }

            public void setOrder(int order) {
                this.list.remove(this.getThis());
                if (--order < 0) {
                    order = 0;
                }
                if (order > this.list.size()) {
                    order = this.list.size();
                }
                this.index = order;
                if (this.list.isEmpty()) {
                    this.list.add(this.getThis());
                } else {
                    this.list.set(this.index, this.getThis());
                }
                this.update();
            }

            public Dest getThis() {
                return new Dest(this);
            }

            public boolean isGlobal() {
                return this.global;
            }

            public boolean sendErrors() {
                if (this.hasDestRequirements()) {
                    if (this.getName().length() > 16) {
                        this.player.sendMessage(CUtl.LANG.error("length", 16));
                        return true;
                    }
                    return false;
                }
                this.player.sendMessage(Destination.LANG.error("invalid", new Object[0]));
                return true;
            }
        }
    }

    public static class dest {
        public static CTxT SET_BUTTON() {
            return ((CTxT)((CTxT)((CTxT)LANG.btn("set", new Object[0]).btn(true)).color("#fff540")).click(2, "/dest set ")).hover(((CTxT)CTxT.of(Assets.cmdUsage.destSet).color("#fff540")).append("\n").append(LANG.hover("set_self", new Object[0])));
        }

        public static CTxT CLEAR_BUTTON(Player player) {
            boolean o = dest.get(player).hasXYZ();
            return ((CTxT)((CTxT)((CTxT)CTxT.of("\u2715").btn(true)).color(o ? (char)'c' : '7')).click(o ? 1 : 0, "/dest clear")).hover(((CTxT)CTxT.of("/dest clear").color(o ? (char)'c' : '7')).append("\n").append(LANG.hover("clear", new Object[0])));
        }

        public static Dest get(Player player) {
            Dest dest2 = player.getPCache().getDEST().getDestination();
            if (!dest2.hasXYZ()) {
                return new Dest();
            }
            if (player.getPCache().getDEST().getDestSettings().getYlevel().booleanValue()) {
                dest2.setY(player.getBlockY());
            }
            return new Dest(dest2);
        }

        public static boolean inAutoClearRadius(Player player, Loc loc) {
            if (((Boolean)player.getPData().getDEST().getSetting(Setting.autoclear)).booleanValue()) {
                return player.getVec().distanceTo(loc.getVec(player)) <= (double)((Integer)player.getPData().getDEST().getSetting(Setting.autoclear_rad)).intValue();
            }
            return false;
        }

        public static int getDist(Player player) {
            Dest dest2 = dest.get(player);
            if (!dest2.hasXYZ()) {
                return -1;
            }
            return (int)player.getVec().distanceTo(dest.get(player).getVec(player));
        }

        public static void clear(Player player) {
            player.getPData().getDEST().setDest(new Dest());
        }

        public static void clear(Player player, int reason) {
            if (!dest.get(player).hasXYZ()) {
                player.sendMessage(LANG.error("cleared", new Object[0]));
                return;
            }
            Dest current = dest.get(player);
            CTxT reasonTxT = LANG.msg("cleared." + (switch (reason) {
                case 2 -> "reached";
                case 3 -> "dimension";
                default -> "command";
            }), new Object[0]).append(" ");
            reasonTxT.append(dest.setButtons(current, reason == 3 && Dimension.canConvert(player.getDimension(), current.getDimension())));
            dest.clear(player);
            player.sendMessage(CUtl.tag().append(LANG.msg("cleared", reasonTxT.color('7'))));
        }

        public static void set(Player player, Dest loc) {
            if (!dest.inAutoClearRadius(player, loc)) {
                player.getPData().getDEST().setDest(loc);
            }
        }

        public static void setMSG(Player player, CTxT setLoc) {
            player.sendMessage(CUtl.tag().append(LANG.msg("set", setLoc)).append("\n ").append((CTxT)((CTxT)LANG.msg("set.info", CUtl.toggleTxT((Boolean)player.getPData().getDEST().getSetting(Setting.autoclear)), CUtl.toggleTxT((Boolean)player.getPData().getDEST().getSetting(Setting.autoconvert))).color('7')).italic(true)));
        }

        public static void playerSet(Player player, Dest dest2, boolean convert) {
            if (!dest2.hasXYZ()) {
                player.sendMessage(CUtl.error("coordinates", new Object[0]));
                return;
            }
            if (dest2.getDimension() == null) {
                player.sendMessage(CUtl.error("dimension", new Object[0]));
                return;
            }
            CTxT convertTag = CTxT.of("");
            if (convert && Dimension.canConvert(player.getDimension(), dest2.getDimension())) {
                convertTag.append(" ").append(((CTxT)((CTxT)LANG.msg("set.converted", new Object[0]).color('7')).italic(true)).hover(dest2.getBadge()));
                dest2.convertTo(player.getDimension());
            }
            if (dest.inAutoClearRadius(player, dest2)) {
                player.sendMessage(LANG.error("already_at", new Object[0]));
                return;
            }
            dest.set(player, dest2);
            dest.setMSG(player, dest2.getBadge().append(convertTag));
        }

        public static void setSaved(Player player, String name, boolean global, boolean convert) {
            saved.DestEntry destination = new saved.DestEntry(player, name, global);
            if (!destination.hasDestRequirements()) {
                player.sendMessage(CUtl.error("dest.invalid", new Object[0]));
                return;
            }
            CTxT convertTag = CTxT.of("");
            if (convert && Dimension.canConvert(player.getDimension(), destination.getDimension())) {
                convertTag.append(" ").append(((CTxT)((CTxT)LANG.msg("set.converted", new Object[0]).color('7')).italic(true)).hover(destination.getBadge()));
                destination.convertTo(player.getDimension());
            }
            if (dest.inAutoClearRadius(player, destination)) {
                player.sendMessage(LANG.error("already_at", new Object[0]));
                return;
            }
            dest.set(player, destination.getThis());
            dest.setMSG(player, destination.getBadge().append(convertTag));
        }

        public static CTxT setButtons(Dest destination, boolean convert) {
            CTxT out = CTxT.of("");
            if (!destination.isValid()) {
                return out;
            }
            String setCMD = "/dest set " + destination.toCMD();
            out.append(((CTxT)((CTxT)((CTxT)LANG.btn("set", new Object[0]).btn(true)).color("#fff540")).click(1, setCMD)).hover(((CTxT)LANG.btn("set", new Object[0]).color("#fff540")).append("\n").append(LANG.hover("set", new Object[0]))));
            if (convert) {
                out.append(" ").append(((CTxT)((CTxT)((CTxT)CTxT.of("\u2194").btn(true)).color("#ffa93f")).click(1, setCMD + " convert")).hover(((CTxT)LANG.btn("convert", new Object[0]).color("#ffa93f")).append("\n").append(LANG.hover("convert", new Object[0]))));
            }
            return out;
        }

        public static Dest getDestArgs(Player player, String[] args, boolean reqName) {
            String pDIM = player.getDimension();
            if (args.length > 1 && Helper.Num.isNum(args[0]) && reqName) {
                return new Dest();
            }
            boolean isNameContinue = false;
            if (args.length <= 2) {
                boolean bl = isNameContinue = !Helper.Num.isNum(args[0]);
            }
            if (args.length > 2) {
                boolean bl = isNameContinue = !Helper.Num.isNum(args[0]) && Helper.Num.isNum(args[1]);
            }
            if (args.length == 1 && isNameContinue) {
                return new Dest(player, args[0], null);
            }
            if (args.length == 2) {
                if (isNameContinue) {
                    return new Dest(player, args[0], args[1]);
                }
                return new Dest(Helper.Num.toInt(args[0]), null, Helper.Num.toInt(args[1]), pDIM, null, null);
            }
            if (args.length == 3) {
                if (isNameContinue) {
                    return new Dest(Helper.Num.toInt(args[1]), null, Helper.Num.toInt(args[2]), pDIM, args[0], null);
                }
                if (Dimension.getAllIDs().contains(args[2])) {
                    return new Dest(Helper.Num.toInt(args[0]), null, Helper.Num.toInt(args[1]), args[2], null, null);
                }
                return new Dest(Helper.Num.toInt(args[0]), Helper.Num.toInt(args[1]), Helper.Num.toInt(args[2]), pDIM, null, null);
            }
            if (args.length == 4) {
                if (isNameContinue) {
                    if (Dimension.getAllIDs().contains(args[3])) {
                        return new Dest(Helper.Num.toInt(args[1]), null, Helper.Num.toInt(args[2]), args[3], args[0], null);
                    }
                    if (!Helper.Num.isNum(args[3])) {
                        return new Dest(Helper.Num.toInt(args[1]), null, Helper.Num.toInt(args[2]), pDIM, args[0], CUtl.color.colorHandler(player, args[3]));
                    }
                    return new Dest(Helper.Num.toInt(args[1]), Helper.Num.toInt(args[2]), Helper.Num.toInt(args[3]), pDIM, args[0], null);
                }
                if (Dimension.getAllIDs().contains(args[3])) {
                    return new Dest(Helper.Num.toInt(args[0]), Helper.Num.toInt(args[1]), Helper.Num.toInt(args[2]), args[3], null, null);
                }
                return new Dest(Helper.Num.toInt(args[0]), Helper.Num.toInt(args[1]), Helper.Num.toInt(args[2]), pDIM, null, null);
            }
            if (args.length == 5 && isNameContinue) {
                if (Helper.Num.isNum(args[3])) {
                    if (Dimension.getAllIDs().contains(args[4])) {
                        return new Dest(Helper.Num.toInt(args[1]), Helper.Num.toInt(args[2]), Helper.Num.toInt(args[3]), args[4], args[0], null);
                    }
                    return new Dest(Helper.Num.toInt(args[1]), Helper.Num.toInt(args[2]), Helper.Num.toInt(args[3]), pDIM, args[0], CUtl.color.colorHandler(player, args[4]));
                }
                return new Dest(Helper.Num.toInt(args[1]), null, Helper.Num.toInt(args[2]), args[3], args[0], CUtl.color.colorHandler(player, args[4]));
            }
            if (args.length == 6 && isNameContinue) {
                return new Dest(Helper.Num.toInt(args[1]), Helper.Num.toInt(args[2]), Helper.Num.toInt(args[3]), args[4], args[0], args[5]);
            }
            return new Dest();
        }

        public static ArrayList<String> destSuggester(Player player, int pos, String[] args, boolean reqName) {
            String current = Helper.Command.Suggester.getCurrent(args, pos);
            ArrayList<String> suggester = new ArrayList<String>();
            if (pos == 0) {
                suggester.add(Helper.Command.Suggester.wrapQuotes("name"));
                if (!reqName) {
                    suggester.addAll(Helper.Command.Suggester.xyz(player, current, 3));
                }
            }
            if (pos > 0 && Helper.Num.isNum(args[0]) && reqName) {
                return suggester;
            }
            boolean isName = false;
            if (pos >= 1) {
                isName = !Helper.Num.isNum(args[0]);
            }
            boolean nameContinue = isName;
            if (pos > 1) {
                boolean bl = nameContinue = isName && Helper.Num.isNum(args[1]);
            }
            if (pos == 1) {
                if (isName) {
                    suggester.addAll(Helper.Command.Suggester.xyz(player, current, 3));
                    suggester.addAll(Helper.Command.Suggester.colors(player, current, false));
                } else {
                    suggester.addAll(Helper.Command.Suggester.xyz(player, current, 2));
                }
            }
            if (pos == 2) {
                if (isName) {
                    if (nameContinue) {
                        suggester.addAll(Helper.Command.Suggester.xyz(player, current, 3));
                    }
                } else {
                    suggester.addAll(Helper.Command.Suggester.xyz(player, current, 1));
                    suggester.addAll(Helper.Command.Suggester.dims(current, false));
                }
            }
            if (pos == 3) {
                if (isName) {
                    if (nameContinue) {
                        suggester.addAll(Helper.Command.Suggester.xyz(player, current, 1));
                        suggester.addAll(Helper.Command.Suggester.dims(current, false));
                        suggester.addAll(Helper.Command.Suggester.colors(player, current, false));
                    }
                } else if (Helper.Num.isNum(args[2])) {
                    suggester.addAll(Helper.Command.Suggester.dims(current, true));
                }
            }
            if (pos == 4 && isName && nameContinue) {
                if (Helper.Num.isInt(args[3])) {
                    suggester.addAll(Helper.Command.Suggester.dims(current, true));
                    suggester.addAll(Helper.Command.Suggester.colors(player, current, true));
                } else if (Dimension.getAllIDs().contains(args[3])) {
                    suggester.addAll(Helper.Command.Suggester.colors(player, current, true));
                }
            }
            if (pos == 5 && isName && nameContinue && Helper.Num.isNum(args[3]) && Dimension.getAllIDs().contains(args[4])) {
                suggester.addAll(Helper.Command.Suggester.colors(player, current, true));
            }
            return suggester;
        }

        public static void setCMDExecutor(Player player, String[] args) {
            if (args.length < 1) {
                player.sendMessage(CUtl.usage(Assets.cmdUsage.destSet));
                return;
            }
            boolean convert = false;
            String[] destArgs = args;
            if (args[args.length - 1].equals("convert")) {
                convert = true;
                destArgs = Arrays.copyOf(args, args.length - 1);
            }
            dest.playerSet(player, dest.getDestArgs(player, destArgs, false), convert);
        }

        public static ArrayList<String> setCMDSuggester(Player player, int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>(dest.destSuggester(player, pos, args, false));
            if (pos > 2 && !args[args.length - 1].equalsIgnoreCase("convert") && Arrays.stream(args).anyMatch(s -> Dimension.getAllIDs().contains(s))) {
                suggester.add("convert");
            }
            return suggester;
        }
    }

    public static class lastdeath {
        private static final int PER_PAGE = 4;
        public static final Lang LANG = new Lang("destination.lastdeath.");
        public static CTxT BUTTON = ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#ac4dff")).click(1, "/dest lastdeath")).hover(((CTxT)CTxT.of("/dest lastdeath").color("#ac4dff")).append("\n").append(LANG.hover()));

        public static void CMDExecutor(Player player, String[] args) {
            if (!Helper.checkEnabled(player).lastdeath()) {
                return;
            }
            if (args.length == 0) {
                lastdeath.UI(player, 1);
                return;
            }
            if (args.length == 1 && Helper.Num.isInt(args[0])) {
                lastdeath.UI(player, Integer.parseInt(args[0]));
                return;
            }
            player.sendMessage(CUtl.usage("/dest lastdeath"));
        }

        public static void add(Player player, Loc loc) {
            ArrayList deaths = (ArrayList)player.getPData().getDEST().getLastdeath();
            if (Dimension.checkValid(loc.getDimension())) {
                deaths.add(0, loc);
                while (deaths.size() > FileData.getConfig().getDestination().getLastDeath().getMaxDeaths()) {
                    deaths.remove(deaths.size() - 1);
                }
            }
            player.getPData().getDEST().setLastdeath(deaths);
        }

        public static void UI(Player player, int pg) {
            Helper.ListPage listPage = new Helper.ListPage((ArrayList)player.getPData().getDEST().getLastdeath(), 4);
            CTxT msg = CTxT.of("");
            CTxT line = (CTxT)CTxT.of("\n                                   ").strikethrough(true);
            msg.append(" ").append((CTxT)LANG.ui().color("#ac4dff")).append(line).append("\n ");
            for (Loc loc : listPage.getPage(pg)) {
                String dim2 = loc.getDimension();
                msg.append(loc.getBadge()).append("\n  ").append(saved.SAVE_BUTTON("/dest add \"" + Dimension.getName(dim2).toLowerCase() + "_death\" " + loc.toCMD() + " \"" + Dimension.getColor(dim2) + "\"")).append(" ").append(dest.setButtons(new Dest(loc, null, null), Dimension.canConvert(player.getDimension(), dim2)));
                msg.append("\n ");
            }
            if (listPage.getPage(pg).isEmpty()) {
                msg.append((CTxT)LANG.ui("no_deaths", new Object[0]).color('c')).append("\n");
            }
            msg.append("\n ");
            if (listPage.getList().size() > 4) {
                msg.append(listPage.getNavButtons(pg, "/dest lastdeath ")).append(" ");
            }
            msg.append(CUtl.CButton.back("/dest")).append(line);
            player.sendMessage(msg);
        }
    }

    public static class settings {
        public static final Lang LANG = new Lang("destination.setting.");
        public static CTxT BUTTON = ((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("settings", new Object[0]).btn(true)).color("#e9e9e9")).click(1, "/dest settings")).hover(((CTxT)CTxT.of("/dest settings").color("#e9e9e9")).append("\n").append(CUtl.LANG.hover("settings", CUtl.LANG.get("destination", new Object[0]))));

        public static void CMDExecutor(Player player, String[] args) {
            if (args.length == 0) {
                settings.UI(player, null);
                return;
            }
            boolean Return = args[0].contains("-r");
            args[0] = args[0].replace("-r", "");
            if (args[0].equals("reset")) {
                if (args.length == 1) {
                    settings.reset(player, Setting.none, Return);
                } else {
                    settings.reset(player, Setting.get(args[1]), Return);
                }
            }
            if (args[0].equals("set")) {
                if (args.length != 3) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                } else {
                    settings.change(player, Setting.get(args[1]), args[2], Return);
                }
            }
            if (args[0].equals("colorui") && args.length == 3) {
                settings.colorUI(player, args[2], Setting.get(args[1]));
            }
        }

        public static ArrayList<String> CMDSuggester(Player player, int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (pos == 0) {
                suggester.add("set");
                suggester.add("reset");
                return suggester;
            }
            args[0] = args[0].replaceAll("-r", "");
            if (pos == 1) {
                for (Setting s : Setting.values()) {
                    suggester.add(s.toString());
                }
                suggester.remove(Setting.none.toString());
            }
            if (pos == 2 && args[0].equalsIgnoreCase("set")) {
                Setting setting = Setting.get(args[1]);
                if (Setting.bool().contains((Object)setting)) {
                    suggester.add("on");
                    suggester.add("off");
                }
                if (Setting.colors().contains((Object)setting)) {
                    suggester.addAll(Helper.Command.Suggester.colors(player, Helper.Command.Suggester.getCurrent(args, pos), true));
                }
                if (setting.equals((Object)Setting.features__track_request_mode)) {
                    suggester.addAll(Helper.Enums.toStringList((Enum[])Setting.TrackingRequestMode.values()));
                }
                if (setting.equals((Object)Setting.autoclear_rad)) {
                    suggester.add("0");
                }
            }
            return suggester;
        }

        public static Object getConfig(Setting setting) {
            return PlayerData.getDefaults().getDEST().getSetting(setting);
        }

        public static void reset(Player player, Setting setting, boolean Return) {
            if (setting.equals((Object)Setting.none)) {
                for (Setting s : Setting.values()) {
                    player.getPData().getDEST().setSetting(s, settings.getConfig(s));
                }
            } else {
                player.getPData().getDEST().setSetting(setting, settings.getConfig(setting));
            }
            if (setting.equals((Object)Setting.autoclear)) {
                player.getPData().getDEST().setSetting(Setting.autoclear_rad, settings.getConfig(Setting.autoclear_rad));
            }
            if (Setting.particles().contains((Object)setting)) {
                player.getPData().getDEST().setSetting(Setting.get(String.valueOf((Object)setting) + "_color"), settings.getConfig(Setting.get(String.valueOf((Object)setting) + "_color")));
            }
            if (setting.equals((Object)Setting.features__track)) {
                player.getPData().getDEST().setSetting(Setting.features__track_request_mode, settings.getConfig(Setting.features__track_request_mode));
            }
            CTxT msg = CUtl.tag().append(CUtl.LANG.msg("reset", LANG.get(setting.toString(), new Object[0]).color(CUtl.s())));
            if (setting.equals((Object)Setting.none)) {
                msg = CUtl.tag().append(LANG.msg("reset_all", CUtl.LANG.btn("all", new Object[0]).color('c')));
            }
            if (Return) {
                settings.UI(player, msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static void change(Player player, Setting setting, String state, boolean Return) {
            boolean bool = state.equals("on");
            CTxT setTxT = CTxT.of("");
            if (setting.equals((Object)Setting.autoclear_rad)) {
                if (!Helper.Num.isInt(state)) {
                    player.sendMessage(CUtl.LANG.error("number", new Object[0]));
                    return;
                }
                int i = Math.max(Math.min(Helper.Num.toInt(state), 15), 1);
                player.getPData().getDEST().setSetting(Setting.autoclear_rad, i);
                setTxT.append((CTxT)CTxT.of(String.valueOf(i)).color((Boolean)player.getPData().getDEST().getSetting(Setting.autoclear) != false ? (char)'a' : 'c'));
            }
            if (setting.equals((Object)Setting.features__track_request_mode)) {
                player.getPData().getDEST().setSetting(setting, (Object)Helper.Enums.get(state, Setting.TrackingRequestMode.class));
                setTxT.append((CTxT)LANG.get(String.valueOf((Object)setting) + "." + String.valueOf((Object)Helper.Enums.get(state, Setting.TrackingRequestMode.class)), new Object[0]).color(CUtl.s()));
            }
            if (Setting.colors().contains((Object)setting)) {
                settings.setParticleColor(player, null, setting, state, false);
                setTxT.append(CUtl.color.getBadge((String)player.getPData().getDEST().getSetting(setting)));
            }
            if (Setting.bool().contains((Object)setting)) {
                player.getPData().getDEST().setSetting(setting, bool);
                setTxT.append(CUtl.toggleTxT(bool));
            }
            CTxT msg = CUtl.tag();
            if (Setting.particles().contains((Object)setting)) {
                msg.append(LANG.msg("set.toggle", LANG.get("particle", LANG.get(setting.toString(), new Object[0]).color(CUtl.s())), setTxT));
            } else if (Setting.bool().contains((Object)setting)) {
                msg.append(LANG.msg("set.toggle", LANG.get(setting.toString(), new Object[0]).color(CUtl.s()), setTxT));
            } else {
                msg.append(LANG.msg("set", LANG.get(setting.toString(), new Object[0]).color(CUtl.s()), setTxT));
            }
            if (Return) {
                settings.UI(player, msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static boolean canBeReset(Player player, Setting type) {
            boolean output = false;
            if (type.equals((Object)Setting.none)) {
                return false;
            }
            if (player.getPData().getDEST().getSetting(type) != settings.getConfig(type)) {
                output = true;
            }
            if (type.equals((Object)Setting.autoclear) && ((Integer)player.getPData().getDEST().getSetting(Setting.autoclear_rad)).intValue() != ((Integer)settings.getConfig(Setting.autoclear_rad)).intValue()) {
                output = true;
            }
            if (type.equals((Object)Setting.features__track) && !player.getPData().getDEST().getSetting(Setting.features__track_request_mode).equals(settings.getConfig(Setting.features__track_request_mode))) {
                output = true;
            }
            if (Setting.colors().contains((Object)Setting.get(String.valueOf((Object)type) + "_color")) && !player.getPData().getDEST().getSetting(Setting.get(String.valueOf((Object)type) + "_color")).equals(settings.getConfig(Setting.get(String.valueOf((Object)type) + "_color")))) {
                output = true;
            }
            return output;
        }

        public static CTxT resetBtn(Player player, Setting setting) {
            CTxT msg = (CTxT)((CTxT)CTxT.of("\u2715").btn(true)).color('7');
            if (settings.canBeReset(player, setting)) {
                ((CTxT)((CTxT)msg.color('c')).click(1, "/dest settings reset-r " + String.valueOf((Object)setting))).hover(CUtl.LANG.hover("reset.settings", CUtl.LANG.hover("reset.fill", new Object[0]).color('c'), LANG.get(setting.toString(), new Object[0]).color(CUtl.s())));
            }
            return msg;
        }

        public static CTxT getButtons(Player player, Setting setting) {
            boolean state = (Boolean)player.getPData().getDEST().getSetting(setting);
            CTxT button = CTxT.of("");
            if (setting.equals((Object)Setting.none)) {
                return button;
            }
            if (Setting.bool().contains((Object)setting)) {
                button.append(CUtl.toggleBtn(state, "/dest settings set-r " + String.valueOf((Object)setting) + " ")).append(" ");
            }
            if (setting.equals((Object)Setting.autoclear)) {
                button.append(((CTxT)((CTxT)((CTxT)CTxT.of(String.valueOf((Integer)player.getPData().getDEST().getSetting(Setting.get(String.valueOf((Object)setting) + "_rad")))).btn(true)).color(state ? (char)'a' : 'c')).click(2, "/dest settings set-r " + String.valueOf((Object)setting) + "_rad ")).hover(((CTxT)LANG.get(String.valueOf((Object)Setting.autoclear_rad) + ".ui", new Object[0]).color(state ? (char)'a' : 'c')).append("\n").append(LANG.hover("set.custom", LANG.get(Setting.autoclear_rad.toString(), new Object[0]))).append("\n").append((CTxT)LANG.get(String.valueOf((Object)setting) + "_rad.hover", new Object[0]).color('7'))));
            }
            if (setting.equals((Object)Setting.features__track)) {
                Setting type = Setting.features__track_request_mode;
                Setting.TrackingRequestMode mode = Helper.Enums.get(player.getPData().getDEST().getSetting(type), Setting.TrackingRequestMode.class);
                Setting.TrackingRequestMode nextMode = (Setting.TrackingRequestMode)Helper.Enums.next((Enum)mode, Setting.TrackingRequestMode.class, (Enum[])new Setting.TrackingRequestMode[0]);
                button.append(((CTxT)((CTxT)((CTxT)CTxT.of(mode.getSymbol()).btn(true)).color(CUtl.s())).click(1, "/dest settings set-r " + String.valueOf((Object)type) + " " + String.valueOf((Object)nextMode))).hover(((CTxT)LANG.get(String.valueOf((Object)type) + ".ui", new Object[0]).color(CUtl.s())).append(" - ").append(LANG.get(String.valueOf((Object)type) + "." + String.valueOf((Object)mode), new Object[0])).append("\n").append((CTxT)LANG.get(String.valueOf((Object)type) + "." + String.valueOf((Object)mode) + ".info", new Object[0]).color('7')).append("\n\n").append(LANG.hover("set", LANG.get(type.toString(), new Object[0]), LANG.get(String.valueOf((Object)type) + "." + String.valueOf((Object)nextMode), new Object[0]).color(CUtl.s())))));
            }
            if (Setting.particles().contains((Object)setting)) {
                String color2 = (String)player.getPData().getDEST().getSetting(Setting.get(String.valueOf((Object)setting) + "_color"));
                button.append(((CTxT)((CTxT)((CTxT)CTxT.of("\u270e").btn(true)).color(color2)).click(1, "/dest settings colorui " + String.valueOf((Object)setting) + "_color normal")).hover(LANG.hover("set.color", LANG.get(setting.toString(), new Object[0]).color(color2))));
            }
            return button;
        }

        public static void colorUI(Player player, String UISettings, Setting setting) {
            if (!Setting.colors().contains((Object)setting)) {
                return;
            }
            String currentColor = (String)player.getPData().getDEST().getSetting(setting);
            CTxT msg = CTxT.of("");
            CTxT line = (CTxT)CTxT.of("\n                               ").strikethrough(true);
            msg.append(" ").append((CTxT)LANG.ui("particle_color", LANG.get(setting.toString().replace("_color", "") + ".ui", new Object[0])).color(currentColor)).append(line).append("\n").append(DHud.preset.colorEditor(currentColor, UISettings, DHud.preset.Type.dest, setting.toString(), "/dest settings colorui " + String.valueOf((Object)setting) + " %s")).append("\n\n           ").append(CUtl.CButton.back("/dest settings")).append(line);
            player.sendMessage(msg);
        }

        public static void setParticleColor(Player player, String UISettings, Setting type, String color2, boolean Return) {
            color2 = CUtl.color.colorHandler(player, color2, (String)player.getPData().getDEST().getSetting(type));
            player.getPData().getDEST().setSetting(type, color2);
            if (Return) {
                settings.colorUI(player, UISettings, type);
            }
        }

        public static void UI(Player player, CTxT aboveTxT) {
            CTxT msg = CTxT.of("");
            CTxT line = (CTxT)CTxT.of("\n                                ").strikethrough(true);
            if (aboveTxT != null) {
                msg.append(aboveTxT).append("\n");
            }
            msg.append(" ").append((CTxT)LANG.ui().color("#e9e9e9")).append(line).append("\n");
            msg.append(" ").append((CTxT)LANG.ui("category.destination", new Object[0]).color(CUtl.p())).append(":\n  ");
            msg.append(settings.resetBtn(player, Setting.autoclear)).append(" ").append(LANG.get(Setting.autoclear.toString(), new Object[0]).hover(LANG.get(Setting.autoclear.toString(), new Object[0]).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.autoclear) + ".info", new Object[0]).color('7')).append("\n").append((CTxT)((CTxT)LANG.get(String.valueOf((Object)Setting.autoclear) + ".info.2", new Object[0]).color('7')).italic(true)).append("\n").append(LANG.get(String.valueOf((Object)Setting.autoclear_rad) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.autoclear_rad) + ".info", new Object[0]).color('7')))).append(": ").append(settings.getButtons(player, Setting.autoclear)).append("\n  ");
            msg.append(settings.resetBtn(player, Setting.autoconvert)).append(" ").append(LANG.get(Setting.autoconvert.toString(), new Object[0]).hover(LANG.get(Setting.autoconvert.toString(), new Object[0]).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.autoconvert) + ".info", new Object[0]).color('7')).append("\n ").append((CTxT)LANG.get(String.valueOf((Object)Setting.autoconvert) + ".info.2", new Object[0]).color('7')))).append(": ").append(settings.getButtons(player, Setting.autoconvert)).append("\n  ");
            msg.append(settings.resetBtn(player, Setting.ylevel)).append(" ").append(LANG.get(String.valueOf((Object)Setting.ylevel) + ".ui", new Object[0]).hover(LANG.get(String.valueOf((Object)Setting.ylevel) + ".ui", new Object[0]).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.autoconvert) + ".info", LANG.get(String.valueOf((Object)Setting.autoconvert) + ".info_2", new Object[0]).color(CUtl.s()), LANG.get(String.valueOf((Object)Setting.autoconvert) + ".info_2", new Object[0]).color(CUtl.s())).color('7')))).append(": ").append(settings.getButtons(player, Setting.ylevel)).append("\n ");
            msg.append((CTxT)LANG.ui("category.particles", new Object[0]).color(CUtl.p())).append(":\n  ");
            msg.append(settings.resetBtn(player, Setting.particles__dest)).append(" ").append(LANG.get(String.valueOf((Object)Setting.particles__dest) + ".ui", new Object[0]).hover(LANG.get(String.valueOf((Object)Setting.particles__dest) + ".ui", new Object[0]).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.particles__dest) + ".info", new Object[0]).color('7')))).append(": ").append(settings.getButtons(player, Setting.particles__dest)).append("\n  ");
            msg.append(settings.resetBtn(player, Setting.particles__line)).append(" ").append(LANG.get(String.valueOf((Object)Setting.particles__line) + ".ui", new Object[0]).hover(LANG.get(String.valueOf((Object)Setting.particles__line) + ".ui", new Object[0]).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.particles__line) + ".info", new Object[0]).color('7')))).append(": ").append(settings.getButtons(player, Setting.particles__line)).append("\n  ");
            msg.append(settings.resetBtn(player, Setting.particles__tracking)).append(" ").append(LANG.get(String.valueOf((Object)Setting.particles__tracking) + ".ui", new Object[0]).hover(LANG.get(String.valueOf((Object)Setting.particles__tracking) + ".ui", new Object[0]).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.particles__tracking) + ".info", new Object[0]).color('7')))).append(": ").append(settings.getButtons(player, Setting.particles__tracking)).append("\n ");
            if (FileData.getConfig().getSocial().getEnabled().booleanValue() || FileData.getConfig().getDestination().getLastDeath().getSaving().booleanValue()) {
                msg.append((CTxT)LANG.ui("category.features", new Object[0]).color(CUtl.p())).append(":\n  ");
                if (FileData.getConfig().getSocial().getEnabled().booleanValue()) {
                    msg.append(settings.resetBtn(player, Setting.features__send)).append(" ").append(LANG.get(String.valueOf((Object)Setting.features__send) + ".ui", new Object[0]).hover(LANG.get(String.valueOf((Object)Setting.features__send) + ".ui", new Object[0]).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.features__send) + ".info", new Object[0]).color('7')))).append(": ").append(settings.getButtons(player, Setting.features__send)).append("\n  ");
                    msg.append(settings.resetBtn(player, Setting.features__track)).append(" ").append(LANG.get(String.valueOf((Object)Setting.features__track) + ".ui", new Object[0]).hover(LANG.get(String.valueOf((Object)Setting.features__track) + ".ui", new Object[0]).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.features__track) + ".info", new Object[0]).color('7')).append("\n").append(LANG.get(String.valueOf((Object)Setting.features__track_request_mode) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.features__track_request_mode) + ".info", new Object[0]).color('7')))).append(": ").append(settings.getButtons(player, Setting.features__track)).append("\n  ");
                }
                if (FileData.getConfig().getDestination().getLastDeath().getSaving().booleanValue()) {
                    msg.append(settings.resetBtn(player, Setting.features__lastdeath)).append(" ").append(LANG.get(Setting.features__lastdeath.toString(), new Object[0]).hover(LANG.get(Setting.features__lastdeath.toString(), new Object[0]).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.features__lastdeath) + ".info", new Object[0]).color('7')))).append(": ").append(settings.getButtons(player, Setting.features__lastdeath)).append("\n ");
                }
            }
            CTxT reset = (CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('7');
            boolean resetOn = false;
            for (Setting t : Setting.base()) {
                if (resetOn) break;
                if (!FileData.getConfig().getDestination().getLastDeath().getSaving().booleanValue() && t.equals((Object)Setting.features__lastdeath) || !FileData.getConfig().getSocial().getEnabled().booleanValue() && (t.equals((Object)Setting.features__send) || t.equals((Object)Setting.features__track))) continue;
                resetOn = settings.canBeReset(player, t);
            }
            if (resetOn) {
                ((CTxT)((CTxT)reset.color('c')).click(1, "/dest settings reset-r all")).hover(CUtl.LANG.hover("reset.settings", CUtl.LANG.hover("reset.fill", new Object[0]).color('c'), CUtl.LANG.btn("all", new Object[0]).color(CUtl.s())));
            }
            msg.append("\n     ").append(reset).append("  ").append(CUtl.CButton.back("/dest")).append(line);
            player.sendMessage(msg);
        }
    }

    public static class social {
        public static boolean cooldown(Player player) {
            if (player.getPCache().getSocialCooldown() != null) {
                player.sendMessage(CUtl.LANG.error("social.cooldown", new Object[0]));
                return true;
            }
            return false;
        }

        public static class track {
            public static final Lang LANG = new Lang("destination.track.");

            public static CTxT BUTTON(boolean x) {
                return CTxT.of("").append(((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#ff6426")).click(2, "/dest track set")).hover(((CTxT)CTxT.of("/dest track (set, accept, deny, cancel) <IGN> | /dest track clear").color("#ff6426")).append("\n").append(LANG.hover()))).append(((CTxT)((CTxT)((CTxT)CTxT.of("\u2715").btn(true)).color(x ? (char)'c' : '7')).click(x ? 1 : 0, "/dest track clear")).hover(((CTxT)CTxT.of("/dest track clear").color(x ? (char)'c' : '7')).append("\n").append(LANG.hover("clear", new Object[0]))));
            }

            public static void CMDExecutor(Player player, String[] args) {
                if (!Helper.checkEnabled(player).track()) {
                    return;
                }
                if (args.length == 1 && args[0].equalsIgnoreCase("clear")) {
                    track.clear(player, 1);
                    return;
                }
                if (args.length == 2) {
                    boolean Return = args[0].contains("-r");
                    args[0] = args[0].replace("-r", "");
                    switch (args[0]) {
                        case "accept": {
                            track.process(player, args[1], ProcessType.accept, Return);
                            break;
                        }
                        case "deny": {
                            track.process(player, args[1], ProcessType.deny, Return);
                            break;
                        }
                        case "cancel": {
                            track.process(player, args[1], ProcessType.cancel, Return);
                            break;
                        }
                        case "set": {
                            track.initialize(player, args[1]);
                            break;
                        }
                        default: {
                            player.sendMessage(CUtl.usage("/dest track (set, accept, deny, cancel) <IGN> | /dest track clear"));
                            break;
                        }
                    }
                } else {
                    player.sendMessage(CUtl.usage("/dest track (set, accept, deny, cancel) <IGN> | /dest track clear"));
                }
            }

            public static ArrayList<String> CMDSuggester(Player player, int pos, String[] args) {
                ArrayList<String> suggester = new ArrayList<String>();
                if (pos == 0) {
                    if (track.hasTargetEntry(player)) {
                        suggester.add("clear");
                    }
                    suggester.add("set");
                    if (DHud.inbox.getAllType(player, DHud.inbox.Type.track_pending) != null) {
                        suggester.add("cancel");
                    }
                    if (DHud.inbox.getAllType(player, DHud.inbox.Type.track_request) != null) {
                        suggester.add("accept");
                        suggester.add("deny");
                    }
                }
                if (pos == 1) {
                    switch (args[0]) {
                        case "set": {
                            suggester.addAll(Helper.Command.Suggester.players(player));
                            break;
                        }
                        case "accept": 
                        case "deny": {
                            ArrayList<HashMap<String, String>> matches = DHud.inbox.getAllType(player, DHud.inbox.Type.track_request);
                            if (matches == null) break;
                            for (HashMap<String, String> entry : matches) {
                                suggester.add(entry.get("player_name"));
                            }
                            break;
                        }
                        case "cancel": {
                            ArrayList<HashMap<String, String>> matches = DHud.inbox.getAllType(player, DHud.inbox.Type.track_pending);
                            if (matches == null) break;
                            for (HashMap<String, String> entry : matches) {
                                suggester.add(entry.get("player_name"));
                            }
                            break;
                        }
                    }
                }
                return suggester;
            }

            public static Player getTarget(Player player) {
                String track2 = player.getPCache().getDEST().getTracking();
                if (track2 == null) {
                    return new Player();
                }
                return new Player(track2);
            }

            public static boolean hasTargetEntry(Player player) {
                return player.getPCache().getDEST().getTracking() != null;
            }

            public static void clear(Player player, int reason) {
                if (!track.hasTargetEntry(player)) {
                    player.sendMessage(LANG.error("cleared", new Object[0]));
                    return;
                }
                CTxT reasonTxT = (CTxT)LANG.msg("cleared." + (switch (reason) {
                    case 2 -> "tracking_off";
                    case 3 -> "tracking_off_target";
                    default -> "command";
                }), new Object[0]).color('7');
                track.clear(player);
                player.sendMessage(CUtl.tag().append(LANG.msg("cleared", reasonTxT)));
            }

            public static void clear(Player player) {
                for (String key : player.getPCache().getMsgKeys()) {
                    if (!key.contains("tracking")) continue;
                    player.getPCache().setMsg(key, 0);
                }
                player.getPData().getDEST().setTracking(null);
            }

            public static void set(Player player, Player target) {
                if (FileData.getConfig().getOnline().booleanValue()) {
                    player.getPData().getDEST().setTracking(target.getUUID());
                } else {
                    player.getPData().getDEST().setTracking(target.getName());
                }
                CTxT playerTxT = (CTxT)CTxT.of(player.getName()).color(CUtl.s());
                CTxT targetTxT = (CTxT)CTxT.of(target.getName()).color(CUtl.s());
                player.sendMessage(CUtl.tag().append(LANG.msg("set", targetTxT)));
                target.sendMessage(CUtl.tag().append(LANG.msg("accept", playerTxT)));
            }

            public static void initialize(Player player, String target_string) {
                Player target = new Player(target_string);
                if (social.cooldown(player)) {
                    return;
                }
                if (!target.isValid()) {
                    player.sendMessage(CUtl.LANG.error("player", CTxT.of(target_string).color(CUtl.s())));
                    return;
                }
                if (target.equals(player)) {
                    player.sendMessage(LANG.error("self", new Object[0]));
                    return;
                }
                if (!((Boolean)player.getPData().getDEST().getSetting(Setting.features__track)).booleanValue()) {
                    player.sendMessage(LANG.error("target_disabled", target.getHighlightedName()));
                    return;
                }
                if (DHud.inbox.search(player, DHud.inbox.Type.track_pending, "player_name", target_string) != null) {
                    player.sendMessage(LANG.error("pending", target.getHighlightedName()));
                    return;
                }
                if (track.getTarget(player).isValid() && Objects.equals(track.getTarget(player), target)) {
                    player.sendMessage(LANG.error("already_tracking", target.getHighlightedName()));
                    return;
                }
                player.getPCache().setSocialCooldown(FileData.getConfig().getSocial().getCooldown());
                if (Helper.Enums.get(player.getPData().getDEST().getSetting(Setting.features__track_request_mode), Setting.TrackingRequestMode.class).equals((Object)Setting.TrackingRequestMode.instant)) {
                    track.set(player, target);
                    return;
                }
                DHud.inbox.addTracking(target, player, 300);
                player.sendMessage(CUtl.tag().append(LANG.msg("request", target.getHighlightedName())).append("\n ").append((CTxT)((CTxT)LANG.msg("expire", 300).color('7')).italic(true)));
                target.sendMessage(CUtl.tag().append(LANG.msg("request_target", player.getHighlightedName())).append("\n ").append(((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("accept", new Object[0]).btn(true)).color('a')).click(1, "/dest track accept " + player.getName())).hover(CUtl.LANG.hover("accept", new Object[0]))).append(" ").append(((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("deny", new Object[0]).btn(true)).color('c')).click(1, "/dest track deny " + player.getName())).hover(CUtl.LANG.hover("deny", new Object[0]))));
            }

            public static void process(Player player, String tracker, ProcessType type, boolean Return) {
                Player target = new Player(tracker);
                if (!target.isValid()) {
                    player.sendMessage(CUtl.LANG.error("player", CTxT.of(tracker).color(CUtl.s())));
                    return;
                }
                if (player == target) {
                    player.sendMessage(LANG.error("self", new Object[0]));
                    return;
                }
                HashMap<String, String> entry = DHud.inbox.search(player, DHud.inbox.Type.track_request, "player_name", tracker);
                if (type.equals((Object)ProcessType.cancel)) {
                    entry = DHud.inbox.search(player, DHud.inbox.Type.track_pending, "player_name", tracker);
                }
                if (entry == null) {
                    player.sendMessage(LANG.error("none", target.getHighlightedName()));
                    return;
                }
                String ID = entry.get("id");
                if (DHud.inbox.search(target, null, "id", ID) == null) {
                    DHud.inbox.removeEntry(player, entry);
                    player.sendMessage(CUtl.tag().append("SYNC ERROR - REPORT IT! (ID-MISMATCH)"));
                    return;
                }
                if (!((Boolean)player.getPData().getDEST().getSetting(Setting.features__track)).booleanValue()) {
                    DHud.inbox.removeEntry(player, entry);
                    player.sendMessage(CUtl.tag().append("SYNC ERROR - REPORT IT! (TARGET-TRACK-OFF)"));
                    return;
                }
                DHud.inbox.delete(player, ID, false);
                DHud.inbox.delete(target, ID, false);
                if (type.equals((Object)ProcessType.accept)) {
                    track.set(target, player);
                } else if (type.equals((Object)ProcessType.deny)) {
                    target.sendMessage(CUtl.tag().append(LANG.msg("denied", player.getHighlightedName())));
                    player.sendMessage(CUtl.tag().append(LANG.msg("deny", target.getHighlightedName())));
                } else if (type.equals((Object)ProcessType.cancel)) {
                    player.sendMessage(CUtl.tag().append(LANG.msg("cancel", target.getHighlightedName())));
                    target.sendMessage(CUtl.tag().append(LANG.msg("canceled", player.getHighlightedName())));
                }
                if (Return) {
                    player.performCommand("dhud inbox");
                }
            }

            public static void logic(Player player) {
                if (!track.getTarget(player).isValid()) {
                    return;
                }
                if (!Helper.checkEnabled(player).track()) {
                    track.clear(player, 2);
                    return;
                }
                Player target = track.getTarget(player);
                if (target.equals(player)) {
                    track.clear(player);
                    return;
                }
                if (!target.isValid()) {
                    if (player.getPCache().getMsg("tracking.offline") == 0) {
                        player.sendMessage(CUtl.tag().append(LANG.msg("target_offline", new Object[0])));
                        player.getPCache().setMsg("tracking.offline", 1);
                        player.getPCache().setMsg("tracking.converted", 0);
                        player.getPCache().setMsg("tracking.dimension", 0);
                    }
                    return;
                }
                if (!Helper.checkEnabled(player).track()) {
                    track.clear(player, 3);
                    return;
                }
                if (player.getPCache().getMsg("tracking.offline") != 0) {
                    player.sendMessage(CUtl.tag().append(LANG.msg("resumed", new Object[0])));
                    player.getPCache().setMsg("tracking.offline", 0);
                }
                if (target.getDimension().equals(player.getDimension())) {
                    if (player.getPCache().getMsg("tracking.converted") != 0) {
                        player.sendMessage(CUtl.tag().append(LANG.msg("autoconvert.tracking", LANG.msg("autoconvert.tracking.2", ((CTxT)CTxT.of(Dimension.getName(target.getDimension())).italic(true)).color(Dimension.getColor(target.getDimension()))))));
                        player.getPCache().setMsg("tracking.converted", 0);
                    }
                    if (player.getPCache().getMsg("tracking.dimension") != 0) {
                        player.sendMessage(CUtl.tag().append(LANG.msg("resumed", new Object[0])));
                        player.getPCache().setMsg("tracking.dimension", 0);
                    }
                    return;
                }
                if (player.getPCache().getDEST().getDestSettings().getAutoconvert().booleanValue() && Dimension.canConvert(player.getDimension(), target.getDimension())) {
                    if (player.getPCache().getMsg("tracking.dimension") != 0) {
                        player.sendMessage(CUtl.tag().append(LANG.msg("resumed", new Object[0])));
                        player.getPCache().setMsg("tracking.dimension", 0);
                    }
                    if (player.getPCache().getMsg("tracking.converted") == 0) {
                        player.sendMessage(CUtl.tag().append(LANG.msg("autoconvert.tracking", LANG.msg("autoconvert.tracking.2", ((CTxT)CTxT.of(Dimension.getName(target.getDimension())).italic(true)).color(Dimension.getColor(target.getDimension()))))));
                        player.getPCache().setMsg("tracking.converted", 1);
                    }
                } else if (player.getPCache().getMsg("tracking.dimension") == 0) {
                    player.sendMessage(CUtl.tag().append(LANG.msg("target_dimension", LANG.msg("autoconvert.tracking.2", ((CTxT)CTxT.of(Dimension.getName(target.getDimension())).italic(true)).color(Dimension.getColor(target.getDimension()))))));
                    player.getPCache().setMsg("tracking.dimension", 1);
                    player.getPCache().setMsg("tracking.converted", 0);
                }
            }

            public static enum ProcessType {
                accept,
                deny,
                cancel;

            }
        }

        public static class send {
            public static final Lang LANG = new Lang("destination.send.");
            public static CTxT BUTTON = ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#52e1ff")).click(2, "/dest send ")).hover(((CTxT)CTxT.of("/dest send <IGN> (name) (x) (y) (z) (dimension) (color)").color("#52e1ff")).append("\n").append(LANG.hover()));

            public static void CMDExecutor(Player player, String[] args) {
                if (!Helper.checkEnabled(player).send()) {
                    return;
                }
                if (args.length == 1) {
                    send.logic(player, args[0], new Dest(player, null, null));
                    return;
                }
                if (args.length == 2) {
                    send.logic(player, args[0], new Dest(player, args[1], null));
                    return;
                }
                if (args[1].equalsIgnoreCase("saved")) {
                    if (!Helper.checkEnabled(player).saving()) {
                        return;
                    }
                    if (args.length == 3) {
                        saved.DestEntry dest2 = new saved.DestEntry(player, args[2], false);
                        send.logic(player, args[0], dest2);
                        return;
                    }
                }
                String[] destArgs = Helper.trimStart(args, 1);
                send.logic(player, args[0], dest.getDestArgs(player, destArgs, false));
            }

            public static ArrayList<String> CMDSuggester(Player player, int pos, String[] args) {
                ArrayList<String> suggester = new ArrayList<String>();
                if (!Helper.checkEnabled(player).send()) {
                    return suggester;
                }
                if (pos == 0) {
                    suggester.addAll(Helper.Command.Suggester.players(player));
                } else {
                    suggester.addAll(dest.destSuggester(player, pos - 1, Helper.trimStart(args, 1), false));
                }
                return suggester;
            }

            public static void logic(Player player, String targetPlayer, Dest dest2) {
                Player target = new Player(targetPlayer);
                if (social.cooldown(player)) {
                    return;
                }
                if (!target.isValid()) {
                    player.sendMessage(CUtl.LANG.error("player", CTxT.of(targetPlayer).color(CUtl.s())));
                    return;
                }
                if (target == player) {
                    player.sendMessage(LANG.error("self", new Object[0]));
                    return;
                }
                if (!Helper.checkEnabled(player).send()) {
                    player.sendMessage(LANG.error("target_disabled", CTxT.of(target.getName()).color(CUtl.s())));
                    return;
                }
                if (dest2.getName() != null && dest2.getName().length() > 16) {
                    player.sendMessage(CUtl.LANG.error("length", 16));
                    return;
                }
                if (!dest2.hasXYZ()) {
                    player.sendMessage(CUtl.LANG.error("coordinates", new Object[0]));
                    return;
                }
                if (!Dimension.checkValid(dest2.getDimension())) {
                    player.sendMessage(CUtl.LANG.error("dimension", new Object[0]));
                    return;
                }
                player.getPCache().setSocialCooldown(FileData.getConfig().getSocial().getCooldown());
                player.sendMessage(CUtl.tag().append(LANG.msg("sent", CTxT.of(target.getName()).color(CUtl.s()), CTxT.of("\n ").append(dest2.getBadge()))));
                target.sendMessage(CUtl.tag().append(LANG.msg("sent_target", CTxT.of(player.getName()).color(CUtl.s()), send.getSendTxt(target, dest2))));
                DHud.inbox.addDest(target, player, 999, dest2);
            }

            public static CTxT getSendTxt(Player player, Dest dest2) {
                CTxT txt = CTxT.of("").append(dest2.getBadge()).append(" ");
                String colorCMD = dest2.getColor() == null ? "" : "\"" + dest2.getColor() + "\"";
                String nameCMD = dest2.getName() == null ? Helper.Command.Suggester.wrapQuotes(LANG.get("default_save_name", new Object[0])) : Helper.Command.Suggester.wrapQuotes(dest2.getName());
                String dimCMD = Helper.Command.Suggester.wrapQuotes(dest2.getDimension());
                if (Helper.checkEnabled(player).saving()) {
                    txt.append(saved.SAVE_BUTTON("/dest saved add " + nameCMD + " " + dest2.getXYZ() + " " + dimCMD + " " + colorCMD)).append(" ");
                }
                txt.append(dest.setButtons(dest2, Dimension.canConvert(player.getDimension(), dest2.getDimension())));
                return txt;
            }
        }
    }

    public static class commandSuggester {
        public static ArrayList<String> logic(Player player, int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (!Helper.checkEnabled(player).destination()) {
                return suggester;
            }
            if (pos == 1) {
                pos = 0;
                if (Helper.checkEnabled(player).lastdeath()) {
                    suggester.add("lastdeath");
                }
                if (Helper.checkEnabled(player).saving()) {
                    suggester.add("add");
                    suggester.add("saved");
                }
                if (Helper.checkEnabled(player).global()) {
                    suggester.add("global");
                }
                suggester.add("set");
                if (dest.get(player).hasXYZ()) {
                    suggester.add("clear");
                }
                suggester.add("settings");
                if (Helper.checkEnabled(player).send()) {
                    suggester.add("send");
                }
                if (Helper.checkEnabled(player).track()) {
                    suggester.add("track");
                }
            }
            if (pos > 1) {
                String command = args[0].toLowerCase();
                args = Helper.trimStart(args, 1);
                pos -= 2;
                switch (command) {
                    case "saved": {
                        suggester.addAll(saved.CMDSuggester(player, pos, args));
                        break;
                    }
                    case "add": {
                        suggester.addAll(saved.addCMDSuggester(player, pos, args));
                        break;
                    }
                    case "global": {
                        suggester.addAll(saved.globalCMDSuggester(player, pos, args));
                        break;
                    }
                    case "settings": {
                        suggester.addAll(settings.CMDSuggester(player, pos, args));
                        break;
                    }
                    case "color": {
                        if (pos != 3 || !args[0].equals("set")) break;
                        suggester.addAll(Helper.Command.Suggester.colors(player, Helper.Command.Suggester.getCurrent(args, pos), true));
                        break;
                    }
                    case "set": {
                        suggester.addAll(dest.setCMDSuggester(player, pos, args));
                        break;
                    }
                    case "send": {
                        suggester.addAll(social.send.CMDSuggester(player, pos, args));
                        break;
                    }
                    case "track": {
                        suggester.addAll(social.track.CMDSuggester(player, pos, args));
                    }
                }
            }
            String current = Helper.Command.Suggester.getCurrent(args, pos);
            return Helper.Command.Suggester.filter(suggester, current);
        }
    }

    public static class commandExecutor {
        public static void logic(Player player, String[] args) {
            if (!Helper.checkEnabled(player).destination()) {
                return;
            }
            if (args.length == 0) {
                Destination.UI(player);
                return;
            }
            String type = args[0].toLowerCase();
            String[] trimmedArgs = Helper.trimStart(args, 1);
            switch (type) {
                case "set": {
                    dest.setCMDExecutor(player, trimmedArgs);
                    break;
                }
                case "clear": {
                    dest.clear(player, 1);
                    break;
                }
                case "saved": {
                    saved.CMDExecutor(player, trimmedArgs);
                    break;
                }
                case "add": {
                    saved.addCMDExecutor(player, trimmedArgs, false);
                    break;
                }
                case "global": {
                    saved.globalCMDExecutor(player, trimmedArgs);
                    break;
                }
                case "lastdeath": {
                    lastdeath.CMDExecutor(player, trimmedArgs);
                    break;
                }
                case "settings": {
                    settings.CMDExecutor(player, trimmedArgs);
                    break;
                }
                case "send": {
                    social.send.CMDExecutor(player, trimmedArgs);
                    break;
                }
                case "track": {
                    social.track.CMDExecutor(player, trimmedArgs);
                    break;
                }
                default: {
                    player.sendMessage(CUtl.error("command", new Object[0]));
                }
            }
        }
    }

    public static enum Setting {
        autoclear,
        autoclear_rad,
        autoconvert,
        ylevel,
        particles__dest,
        particles__dest_color,
        particles__line,
        particles__line_color,
        particles__tracking,
        particles__tracking_color,
        features__send,
        features__track,
        features__track_request_mode,
        features__lastdeath,
        none;


        public String toString() {
            return this.name().replace("__", ".");
        }

        public static Setting get(String s) {
            try {
                return Setting.valueOf(s.replace(".", "__"));
            }
            catch (IllegalArgumentException e) {
                return none;
            }
        }

        public static ArrayList<Setting> colors() {
            return new ArrayList<Setting>(Arrays.asList(particles__dest_color, particles__line_color, particles__tracking_color));
        }

        public static ArrayList<Setting> base() {
            ArrayList<Setting> list = new ArrayList<Setting>(Arrays.asList(Setting.values()));
            list.remove((Object)features__track_request_mode);
            list.remove((Object)autoclear_rad);
            list.remove((Object)none);
            list.removeAll(Setting.colors());
            return list;
        }

        public static ArrayList<Setting> bool() {
            return Setting.base();
        }

        public static ArrayList<Setting> dest() {
            ArrayList<Setting> list = new ArrayList<Setting>();
            list.add(autoclear);
            list.add(autoconvert);
            list.add(ylevel);
            return list;
        }

        public static ArrayList<Setting> particles() {
            ArrayList<Setting> list = new ArrayList<Setting>();
            list.add(particles__line);
            list.add(particles__dest);
            list.add(particles__tracking);
            return list;
        }

        public static ArrayList<Setting> features() {
            ArrayList<Setting> list = new ArrayList<Setting>();
            list.add(features__track);
            list.add(features__send);
            list.add(features__lastdeath);
            return list;
        }

        public static enum TrackingRequestMode {
            request,
            instant;


            public String getSymbol() {
                if (this.equals((Object)request)) {
                    return "\u2709";
                }
                return "\u26a1";
            }
        }
    }
}

