/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.DHud;
import one.oth3r.directionhud.common.Destination;
import one.oth3r.directionhud.common.files.FileData;
import one.oth3r.directionhud.common.files.dimension.Dimension;
import one.oth3r.directionhud.common.files.dimension.DimensionSettings;
import one.oth3r.directionhud.common.files.playerdata.DefaultPData;
import one.oth3r.directionhud.common.files.playerdata.PDDestination;
import one.oth3r.directionhud.common.files.playerdata.PDHud;
import one.oth3r.directionhud.common.files.playerdata.PlayerData;
import one.oth3r.directionhud.common.hud.Hud;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.modules.ModuleAngle;
import one.oth3r.directionhud.common.hud.module.modules.ModuleCoordinates;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDestination;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDirection;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDistance;
import one.oth3r.directionhud.common.hud.module.modules.ModuleSpeed;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTime;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTracking;
import one.oth3r.directionhud.common.hud.module.modules.ModuleWeather;
import one.oth3r.directionhud.common.template.CustomFile;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Helper;
import org.jetbrains.annotations.NotNull;

public class Config
implements CustomFile<Config> {
    private transient boolean legacyCheck = false;
    @SerializedName(value="version")
    private Double version = 1.6;
    @SerializedName(value="lang")
    private String lang = "en_us";
    @SerializedName(value="lang-options")
    private final String[] lang_options = new String[]{"en_us (100%)", "ru_ru (88%)", "zh_cn (76%)", "zh_tw (76%)"};
    @SerializedName(value="online-mode")
    private Boolean online = true;
    @SerializedName(value="location")
    private Location location = new Location();
    @SerializedName(value="hud")
    private Hud hud = new Hud();
    @SerializedName(value="destination")
    private Destination destination = new Destination();
    @SerializedName(value="social")
    private Social social = new Social();
    @SerializedName(value="max-color-presets")
    private Integer maxColorPresets = 14;

    public Config() {
    }

    public Config(Config config) {
        this.version = config.version;
        this.lang = config.lang;
        this.location = new Location(config.location);
        this.online = config.online;
        this.hud = new Hud(config.hud);
        this.destination = new Destination(config.destination);
        this.social = new Social(config.social);
        this.maxColorPresets = config.maxColorPresets;
    }

    public Social getSocial() {
        return this.social;
    }

    public void setSocial(Social social2) {
        this.social = social2;
    }

    public Double getVersion() {
        return this.version;
    }

    public void setVersion(Double version) {
        this.version = version;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Boolean getOnline() {
        return this.online;
    }

    public void setOnline(Boolean online) {
        this.online = online;
    }

    public Hud getHud() {
        return this.hud;
    }

    public void setHud(Hud hud) {
        this.hud = hud;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Integer getMaxColorPresets() {
        return this.maxColorPresets;
    }

    public void setMaxColorPresets(Integer maxColorPresets) {
        this.maxColorPresets = maxColorPresets;
    }

    @Override
    public void fileNotExist() {
        Legacy legacy2 = new Legacy();
        if (!this.legacyCheck && legacy2.getLegacyFile().exists()) {
            DirectionHUD.LOGGER.info("Updating DirectionHUD.properties to directionhud/config.json");
            legacy2.run();
            this.copyFileData(legacy2.getConfig());
        }
        this.legacyCheck = true;
        CustomFile.super.fileNotExist();
    }

    @Override
    public void reset() {
        this.copyFileData(new Config());
    }

    @Override
    @NotNull
    public Class<Config> getFileClass() {
        return Config.class;
    }

    @Override
    public void copyFileData(Config newFile) {
        this.version = newFile.version;
        this.lang = newFile.lang;
        this.online = newFile.online;
        this.location = new Location(newFile.location);
        this.hud = new Hud(newFile.hud);
        this.destination = new Destination(newFile.destination);
        this.social = new Social(newFile.social);
        this.maxColorPresets = newFile.maxColorPresets;
    }

    @Override
    public void update(JsonElement json) {
    }

    @Override
    public String getFileName() {
        return "config.json";
    }

    @Override
    public String getDirectory() {
        return DirectionHUD.getData().getConfigDirectory();
    }

    public static class Location {
        @SerializedName(value="max-y")
        private int maxY = 512;
        @SerializedName(value="max-xz")
        private int maxXZ = 30000000;

        public Location(Location location) {
            this.maxY = location.maxY;
            this.maxXZ = location.maxXZ;
        }

        public Location() {
        }

        public int getMaxY() {
            return this.maxY;
        }

        public void setMaxY(int maxY) {
            this.maxY = maxY;
        }

        public int getMaxXZ() {
            return this.maxXZ;
        }

        public void setMaxXZ(int maxXZ) {
            this.maxXZ = maxXZ;
        }
    }

    public static class Hud {
        @SerializedName(value="editing")
        private Boolean editing = true;
        @SerializedName(value="loop-ticks")
        private Integer loop = 1;

        public Hud() {
        }

        public Hud(Hud hud) {
            this.editing = hud.editing;
            this.loop = hud.loop;
        }

        public Boolean getEditing() {
            return this.editing;
        }

        public void setEditing(Boolean editing) {
            this.editing = editing;
        }

        public Integer getLoop() {
            return this.loop;
        }

        public void setLoop(Integer loop) {
            this.loop = loop;
        }
    }

    public static class Destination {
        @SerializedName(value="saving")
        private Boolean saving = true;
        @SerializedName(value="max-saved")
        private Integer maxSaved = 50;
        @SerializedName(value="global")
        private Boolean global = false;
        @SerializedName(value="lastdeath")
        private LastDeath lastDeath = new LastDeath();
        @SerializedName(value="loop-ticks")
        private Integer loop = 20;

        public Destination() {
        }

        public Destination(Destination destination) {
            this.saving = destination.saving;
            this.maxSaved = destination.maxSaved;
            this.global = destination.global;
            this.lastDeath = new LastDeath(destination.lastDeath);
            this.loop = destination.loop;
        }

        public Boolean getSaving() {
            return this.saving;
        }

        public void setSaving(Boolean saving) {
            this.saving = saving;
        }

        public Integer getMaxSaved() {
            return this.maxSaved;
        }

        public void setMaxSaved(Integer maxSaved) {
            this.maxSaved = maxSaved;
        }

        public Boolean getGlobal() {
            return this.global;
        }

        public void setGlobal(Boolean global) {
            this.global = global;
        }

        public LastDeath getLastDeath() {
            return this.lastDeath;
        }

        public void setLastDeath(LastDeath lastDeath) {
            this.lastDeath = lastDeath;
        }

        public Integer getLoop() {
            return this.loop;
        }

        public void setLoop(Integer loop) {
            this.loop = loop;
        }

        public static class LastDeath {
            @SerializedName(value="saving")
            private Boolean saving = true;
            @SerializedName(value="max-deaths")
            private Integer maxDeaths = 4;

            public LastDeath() {
            }

            public LastDeath(LastDeath lastDeath) {
                this.saving = lastDeath.saving;
                this.maxDeaths = lastDeath.maxDeaths;
            }

            public Boolean getSaving() {
                return this.saving;
            }

            public void setSaving(Boolean saving) {
                this.saving = saving;
            }

            public Integer getMaxDeaths() {
                return this.maxDeaths;
            }

            public void setMaxDeaths(Integer maxDeaths) {
                this.maxDeaths = maxDeaths;
            }
        }
    }

    public static class Social {
        private Boolean enabled = true;
        private Integer cooldown = 10;

        public Social() {
        }

        public Social(Social social2) {
            this.enabled = social2.enabled;
            this.cooldown = social2.cooldown;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Integer getCooldown() {
            return this.cooldown;
        }

        public void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }
    }

    public static class Legacy {
        Config config = new Config();

        public Config getConfig() {
            return this.config;
        }

        public File getLegacyFile() {
            String configDirectory = DirectionHUD.getData().getConfigDirectory();
            if (!DirectionHUD.getData().isMod()) {
                return new File(configDirectory + "DirectionHUD.properties");
            }
            return new File(configDirectory.substring(0, configDirectory.length() - 13) + "DirectionHUD.properties");
        }

        public void run() {
            File file = this.getLegacyFile();
            if (!file.exists()) {
                return;
            }
            try (FileInputStream fileStream = new FileInputStream(file);){
                Properties properties = new Properties();
                properties.load(fileStream);
                String version = (String)properties.computeIfAbsent("version", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(1.5f)));
                if (version.contains("v")) {
                    version = version.substring(1);
                }
                this.loadVersion(properties, Float.parseFloat(version));
            }
            catch (Exception e) {
                DirectionHUD.LOGGER.info("ERROR LOADING LEGACY CONFIG: " + e.getMessage());
                e.printStackTrace();
            }
            try {
                Files.delete(file.toPath());
                DirectionHUD.LOGGER.info("Deleted " + file.getName());
            }
            catch (Exception e) {
                DirectionHUD.LOGGER.info("Failed to delete the old DirectionHUD config.");
            }
        }

        public void loadVersion(Properties properties, float version) {
            Config config = FileData.getConfig();
            DefaultPData DEFAULTS = PlayerData.getDefaults();
            PDDestination.Settings destSettings = DEFAULTS.getDEST().getSetting();
            PDDestination.Settings.Particles destSParticles = destSettings.getParticles();
            PDDestination.Settings.Features destSFeatures = destSettings.getFeatures();
            PDHud hud = DEFAULTS.getHud();
            PDHud.Settings hudSettings = hud.getSetting();
            PDHud.Settings.Bossbar hudSBossbar = hudSettings.getBossbar();
            try {
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                Type arrayListMap = new TypeToken<ArrayList<String>>(){}.getType();
                config.getLocation().setMaxXZ(Integer.parseInt((String)properties.computeIfAbsent("max-xz", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getLocation().getMaxXZ())))));
                config.getLocation().setMaxY(Integer.parseInt((String)properties.computeIfAbsent("max-y", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getLocation().getMaxY())))));
                config.getDestination().setGlobal(Boolean.parseBoolean((String)properties.computeIfAbsent("global-destinations", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getDestination().getGlobal())))));
                config.getDestination().setSaving(Boolean.parseBoolean((String)properties.computeIfAbsent("destination-saving", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getDestination().getSaving())))));
                config.getDestination().setMaxSaved(Integer.parseInt((String)properties.computeIfAbsent("destination-max", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getDestination().getMaxSaved())))));
                config.getDestination().getLastDeath().setSaving(Boolean.parseBoolean((String)properties.computeIfAbsent("lastdeath-saving", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getDestination().getLastDeath().getSaving())))));
                config.getDestination().getLastDeath().setMaxDeaths(Integer.parseInt((String)properties.computeIfAbsent("lastdeath-max", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getDestination().getLastDeath().getMaxDeaths())))));
                config.getHud().setEditing(Boolean.parseBoolean((String)properties.computeIfAbsent("hud-editing", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getHud().getEditing())))));
                config.setOnline(Boolean.parseBoolean((String)properties.computeIfAbsent("online-mode", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getOnline())))));
                config.getSocial().setEnabled(Boolean.parseBoolean((String)properties.computeIfAbsent("social-commands", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getSocial().getEnabled())))));
                config.getSocial().setCooldown(Integer.parseInt((String)properties.computeIfAbsent("social-cooldown", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getSocial().getCooldown())))));
                config.getDestination().setLoop(Math.min(20, Math.max(1, Integer.parseInt((String)properties.computeIfAbsent("particle-loop", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getDestination().getLoop())))))));
                config.getHud().setLoop(Math.min(20, Math.max(1, Integer.parseInt((String)properties.computeIfAbsent("hud-loop", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getHud().getLoop())))))));
                try {
                    DEFAULTS.setColorPresets(DHud.preset.custom.updateTo2_0((ArrayList)gson.fromJson((String)properties.computeIfAbsent("color-presets", (Function<? super Object, ?>)((Function<Object, Object>)a -> gson.toJson(DEFAULTS.getColorPresets()))), arrayListMap)));
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
                config.setMaxColorPresets(Integer.parseInt((String)properties.computeIfAbsent("max-color-presets", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getMaxColorPresets())))));
                DimensionSettings dimensionSettings = Dimension.getDimensionSettings();
                try {
                    dimensionSettings.setDimensions(Dimension.convertLegacyDimensions((List)gson.fromJson((String)properties.computeIfAbsent("dimensions", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), arrayListMap)));
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
                try {
                    dimensionSettings.setRatios(Dimension.convertLegacyRatios((List)gson.fromJson((String)properties.computeIfAbsent("dimension-ratios", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), arrayListMap)));
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
                Dimension.setDimensionSettings(dimensionSettings, true);
                ArrayList order = new ArrayList();
                try {
                    order = (ArrayList)gson.fromJson((String)properties.computeIfAbsent("hud.order", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), arrayListMap);
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
                ArrayList<BaseModule> hudModules = new ArrayList<BaseModule>();
                int i = 1;
                for (String module : order) {
                    Module mod = Module.fromString(module);
                    if (mod.equals((Object)Module.UNKNOWN)) continue;
                    hudModules.add(switch (mod) {
                        case Module.COORDINATES -> new ModuleCoordinates(i, Boolean.parseBoolean(properties.getProperty("hud.module.coordinates", String.valueOf(true))), true);
                        case Module.DESTINATION -> new ModuleDestination(i, Boolean.parseBoolean(properties.getProperty("hud.module.destination", String.valueOf(true))));
                        case Module.DISTANCE -> new ModuleDistance(i, Boolean.parseBoolean(properties.getProperty("hud.module.distance", String.valueOf(true))));
                        case Module.TRACKING -> new ModuleTracking(i, Boolean.parseBoolean(properties.getProperty("hud.module.tracking", String.valueOf(false))), Boolean.parseBoolean(properties.getProperty("hud.settings.module.tracking_hybrid", String.valueOf(true))), Helper.Enums.get(properties.getProperty("hud.settings.module.tracking_target", ModuleTracking.Target.player.toString()), ModuleTracking.Target.class), Helper.Enums.get(properties.getProperty("hud.settings.module.tracking_type", ModuleTracking.Type.simple.toString()), ModuleTracking.Type.class), false);
                        case Module.DIRECTION -> new ModuleDirection(i, Boolean.parseBoolean(properties.getProperty("hud.module.direction", String.valueOf(true))));
                        case Module.WEATHER -> new ModuleWeather(i, Boolean.parseBoolean(properties.getProperty("hud.module.weather", String.valueOf(true))));
                        case Module.TIME -> new ModuleTime(i, Boolean.parseBoolean(properties.getProperty("hud.module.time", String.valueOf(true))), Boolean.parseBoolean(properties.getProperty("hud.settings.module.time_24hr", String.valueOf(false))));
                        case Module.ANGLE -> new ModuleAngle(i, Boolean.parseBoolean(properties.getProperty("hud.module.angle", String.valueOf(false))), Helper.Enums.get(properties.getProperty("hud.settings.module.angle_display", ModuleAngle.Display.both.toString()), ModuleAngle.Display.class));
                        case Module.SPEED -> new ModuleSpeed(i, Boolean.parseBoolean(properties.getProperty("hud.module.speed", String.valueOf(false))), !Boolean.parseBoolean(properties.getProperty("hud.settings.module.speed_3d", String.valueOf(false))), properties.getProperty("hud.settings.module.speed_pattern", "0.00"));
                        default -> new ModuleCoordinates();
                    });
                    ++i;
                }
                hud.setModules(hudModules);
                hud.setPrimary(new PDHud.Color(CUtl.color.format((String)properties.computeIfAbsent("hud.color.primary", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), hud.getPrimary().getColor()), Boolean.parseBoolean((String)properties.computeIfAbsent("hud.color.primary-bold", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getPrimary().getBold())))), Boolean.parseBoolean((String)properties.computeIfAbsent("hud.color.primary-italics", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getPrimary().getItalics())))), Boolean.parseBoolean((String)properties.computeIfAbsent("hud.color.primary-rainbow", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getPrimary().getRainbow()))))));
                hud.setSecondary(new PDHud.Color(CUtl.color.format((String)properties.computeIfAbsent("hud.color.secondary", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), hud.getSecondary().getColor()), Boolean.parseBoolean((String)properties.computeIfAbsent("hud.color.secondary-bold", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getSecondary().getBold())))), Boolean.parseBoolean((String)properties.computeIfAbsent("hud.color.secondary-italics", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getSecondary().getItalics())))), Boolean.parseBoolean((String)properties.computeIfAbsent("hud.color.secondary-rainbow", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getSecondary().getRainbow()))))));
                hudSettings.setState(Boolean.parseBoolean((String)properties.computeIfAbsent("hud.settings.state", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hudSettings.getState())))));
                hudSettings.setType(Hud.Setting.DisplayType.get((String)properties.computeIfAbsent("hud.settings.type", (Function<? super Object, ?>)((Function<Object, Object>)a -> hudSettings.getType()))).toString());
                hudSBossbar.setColor(Helper.Enums.get(properties.computeIfAbsent("hud.settings.bossbar.color", (Function<? super Object, ?>)((Function<Object, Object>)a -> hudSBossbar.getColor())), Hud.Setting.BarColor.class).toString());
                hudSBossbar.setDistance(Boolean.parseBoolean((String)properties.computeIfAbsent("hud.settings.bossbar.distance", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hudSBossbar.getDistance())))));
                hudSBossbar.setDistanceMax(Integer.parseInt((String)properties.computeIfAbsent("hud.settings.bossbar.distance_max", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hudSBossbar.getDistanceMax())))));
                destSettings.setAutoclear(Boolean.parseBoolean((String)properties.computeIfAbsent("dest.settings.autoclear", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSettings.getAutoclear())))));
                destSettings.setAutoclearRad(Math.min(15, Math.max(1, Integer.parseInt((String)properties.computeIfAbsent("dest.settings.autoclear_rad", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSettings.getAutoclearRad())))))));
                destSettings.setAutoconvert(Boolean.parseBoolean((String)properties.computeIfAbsent("dest.settings.autoconvert", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSettings.getAutoconvert())))));
                destSettings.setYlevel(Boolean.parseBoolean((String)properties.computeIfAbsent("dest.settings.ylevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSettings.getYlevel())))));
                destSParticles.setDest(Boolean.parseBoolean((String)properties.computeIfAbsent("dest.settings.particles.dest", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSParticles.getDest())))));
                destSParticles.setDestColor(CUtl.color.format((String)properties.computeIfAbsent("dest.settings.particles.dest_color", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), destSParticles.getDestColor()));
                destSParticles.setLine(Boolean.parseBoolean((String)properties.computeIfAbsent("dest.settings.particles.line", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSParticles.getLine())))));
                destSParticles.setLineColor(CUtl.color.format((String)properties.computeIfAbsent("dest.settings.particles.line_color", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), destSParticles.getLineColor()));
                destSParticles.setTracking(Boolean.parseBoolean((String)properties.computeIfAbsent("dest.settings.particles.tracking", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSParticles.getTracking())))));
                destSParticles.setTrackingColor(CUtl.color.format((String)properties.computeIfAbsent("dest.settings.particles.tracking_color", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), destSParticles.getTrackingColor()));
                destSFeatures.setSend(Boolean.parseBoolean((String)properties.computeIfAbsent("dest.settings.features.send", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSFeatures.getSend())))));
                destSFeatures.setTrack(Boolean.parseBoolean((String)properties.computeIfAbsent("dest.settings.features.track", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSFeatures.getTrack())))));
                destSFeatures.setTrackRequestMode(Helper.Enums.get(properties.computeIfAbsent("dest.settings.features.track_request_mode", (Function<? super Object, ?>)((Function<Object, Object>)a -> destSFeatures.getTrackRequestMode())), Destination.Setting.TrackingRequestMode.class).toString());
                destSFeatures.setLastdeath(Boolean.parseBoolean((String)properties.computeIfAbsent("dest.settings.features.lastdeath", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSFeatures.getLastdeath())))));
                if (version <= 1.4f) {
                    try {
                        DEFAULTS.setColorPresets(DHud.preset.custom.updateTo2_0(DHud.preset.custom.updateTo1_7((ArrayList)gson.fromJson((String)properties.computeIfAbsent("color-presets", (Function<? super Object, ?>)((Function<Object, Object>)a -> gson.toJson(new ArrayList()))), arrayListMap))));
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {
                        // empty catch block
                    }
                }
                if (version <= 1.3f) {
                    config.getDestination().setMaxSaved(Integer.parseInt((String)properties.computeIfAbsent("destination-max-saved", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getDestination().getMaxSaved())))));
                    config.getDestination().getLastDeath().setSaving(Boolean.parseBoolean((String)properties.computeIfAbsent("death-saving", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getDestination().getLastDeath().getSaving())))));
                    hudSettings.setState(Boolean.parseBoolean((String)properties.computeIfAbsent("hud.enabled", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hudSettings.getState())))));
                    config.getHud().setLoop(Math.min(20, Math.max(1, Integer.parseInt((String)properties.computeIfAbsent("hud-refresh", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(config.getHud().getLoop())))))));
                }
                if (version <= 1.21f) {
                    hud.getPrimary().setColor(CUtl.color.updateOld((String)properties.computeIfAbsent("primary-color", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), hud.getPrimary().getColor()));
                    hud.getSecondary().setColor(CUtl.color.updateOld((String)properties.computeIfAbsent("secondary-color", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), hud.getSecondary().getColor()));
                    destSParticles.setLineColor(CUtl.color.updateOld((String)properties.computeIfAbsent("line-particle-color", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), destSParticles.getLineColor()));
                    destSParticles.setDestColor(CUtl.color.updateOld((String)properties.computeIfAbsent("dest-particle-color", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), destSParticles.getDestColor()));
                    hudSettings.setState(Boolean.parseBoolean((String)properties.computeIfAbsent("enabled", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hudSettings.getState())))));
                    List<String> orderList = List.of(((String)properties.computeIfAbsent("order", (Function<? super Object, ?>)((Function<Object, Object>)a -> ""))).split(" "));
                    hudModules = new ArrayList();
                    i = 1;
                    for (String module : orderList) {
                        Module mod = Module.fromString(module);
                        if (mod.equals((Object)Module.UNKNOWN)) continue;
                        hudModules.add(switch (mod) {
                            case Module.COORDINATES -> new ModuleCoordinates(i, Boolean.parseBoolean(properties.getProperty("coordinates", String.valueOf(true))), true);
                            case Module.DESTINATION -> new ModuleDestination(i, Boolean.parseBoolean(properties.getProperty("destination", String.valueOf(true))));
                            case Module.DISTANCE -> new ModuleDistance(i, Boolean.parseBoolean(properties.getProperty("distance", String.valueOf(true))));
                            case Module.TRACKING -> new ModuleTracking(i, Boolean.parseBoolean(properties.getProperty("tracking", String.valueOf(false))), true, ModuleTracking.Target.player, ModuleTracking.Type.simple, false);
                            case Module.DIRECTION -> new ModuleDirection(i, Boolean.parseBoolean(properties.getProperty("direction", String.valueOf(true))));
                            case Module.WEATHER -> new ModuleWeather(i, Boolean.parseBoolean(properties.getProperty("weather", String.valueOf(true))));
                            case Module.TIME -> new ModuleTime(i, Boolean.parseBoolean(properties.getProperty("time", String.valueOf(true))), Boolean.parseBoolean(properties.getProperty("time24hr", String.valueOf(false))));
                            case Module.ANGLE -> new ModuleAngle(i, false, ModuleAngle.Display.both);
                            case Module.SPEED -> new ModuleSpeed(i, false, false, "0.00");
                            default -> new ModuleCoordinates();
                        });
                        ++i;
                    }
                    hud.setModules(hudModules);
                    hud.getPrimary().setBold(Boolean.parseBoolean((String)properties.computeIfAbsent("primary-bold", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getPrimary().getBold())))));
                    hud.getPrimary().setItalics(Boolean.parseBoolean((String)properties.computeIfAbsent("primary-italics", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getPrimary().getItalics())))));
                    hud.getPrimary().setRainbow(Boolean.parseBoolean((String)properties.computeIfAbsent("primary-rainbow", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getPrimary().getRainbow())))));
                    hud.getSecondary().setBold(Boolean.parseBoolean((String)properties.computeIfAbsent("secondary-bold", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getSecondary().getBold())))));
                    hud.getSecondary().setItalics(Boolean.parseBoolean((String)properties.computeIfAbsent("secondary-italics", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getSecondary().getItalics())))));
                    hud.getSecondary().setRainbow(Boolean.parseBoolean((String)properties.computeIfAbsent("secondary-rainbow", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(hud.getSecondary().getRainbow())))));
                    destSettings.setAutoclear(Boolean.parseBoolean((String)properties.computeIfAbsent("autoclear", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSettings.getAutoclear())))));
                    destSettings.setAutoclearRad(Math.min(15, Math.max(1, Integer.parseInt((String)properties.computeIfAbsent("autoclear-radius", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSettings.getAutoclearRad())))))));
                    destSettings.setYlevel(Boolean.parseBoolean((String)properties.computeIfAbsent("y-level", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSettings.getYlevel())))));
                    destSettings.setAutoconvert(Boolean.parseBoolean((String)properties.computeIfAbsent("autoconvert", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSettings.getAutoconvert())))));
                    destSFeatures.setSend(Boolean.parseBoolean((String)properties.computeIfAbsent("send", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSFeatures.getSend())))));
                    destSFeatures.setTrack(Boolean.parseBoolean((String)properties.computeIfAbsent("track", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSFeatures.getTrack())))));
                    destSFeatures.setLastdeath(Boolean.parseBoolean((String)properties.computeIfAbsent("lastdeath", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSFeatures.getLastdeath())))));
                    destSParticles.setLine(Boolean.parseBoolean((String)properties.computeIfAbsent("line-particles", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSParticles.getLine())))));
                    destSParticles.setDest(Boolean.parseBoolean((String)properties.computeIfAbsent("dest-particles", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSParticles.getDest())))));
                    destSParticles.setTracking(Boolean.parseBoolean((String)properties.computeIfAbsent("tracking-particles", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(destSParticles.getTracking())))));
                    destSParticles.setTrackingColor(CUtl.color.updateOld((String)properties.computeIfAbsent("tracking-particle-color", (Function<? super Object, ?>)((Function<Object, Object>)a -> "")), destSParticles.getTrackingColor()));
                }
                if (version == 1.1f) {
                    ArrayList<BaseModule> modules2 = hud.getModules();
                    if (BaseModule.findInArrayList(modules2, Module.TRACKING).isPresent()) {
                        ((BaseModule)hud.getModule(Module.TRACKING)).setState(Boolean.parseBoolean(properties.getProperty("compass", String.valueOf(((BaseModule)hud.getModule(Module.TRACKING)).isEnabled()))));
                    } else {
                        modules2.add(new ModuleTracking(9, Boolean.parseBoolean(properties.getProperty("compass", String.valueOf(false))), true, ModuleTracking.Target.player, ModuleTracking.Type.simple, false));
                    }
                }
                this.config.copyFileData(config);
                PlayerData.setDefaults(DEFAULTS, true);
            }
            catch (Exception e) {
                DirectionHUD.LOGGER.info("ERROR LOADING CONFIG - PLEASE REPORT WITH THE ERROR LOG");
                e.printStackTrace();
            }
        }
    }
}

