/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.template.CustomFile;
import one.oth3r.directionhud.common.utils.Dest;
import one.oth3r.directionhud.common.utils.Loc;
import org.jetbrains.annotations.NotNull;

public class GlobalDest
implements CustomFile<GlobalDest> {
    private Double version = 1.0;
    private ArrayList<Dest> destinations = new ArrayList();

    public GlobalDest() {
    }

    public GlobalDest(GlobalDest globalDest) {
        this.copyFileData(globalDest);
    }

    public Double getVersion() {
        return this.version;
    }

    public void setVersion(Double version) {
        this.version = version;
    }

    public ArrayList<Dest> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(ArrayList<Dest> destinations) {
        this.destinations = destinations;
    }

    @Override
    @NotNull
    public Class<GlobalDest> getFileClass() {
        return GlobalDest.class;
    }

    @Override
    public void copyFileData(GlobalDest newFile) {
        this.version = newFile.version;
        ArrayList<Dest> dests = new ArrayList<Dest>();
        for (Dest dest2 : newFile.destinations) {
            dests.add(new Dest(dest2));
        }
        this.destinations = dests;
    }

    @Override
    public void update(JsonElement json) {
        if (json.isJsonArray() && this.version == 1.0) {
            JsonArray DestArray = json.getAsJsonArray();
            ArrayList<Dest> updated = new ArrayList<Dest>();
            for (JsonElement element : DestArray) {
                if (!element.isJsonArray()) continue;
                List destJson = element.getAsJsonArray().asList();
                Dest dest2 = new Dest(new Loc(true, ((JsonElement)destJson.get(1)).getAsString()), ((JsonElement)destJson.get(0)).getAsString(), ((JsonElement)destJson.get(2)).getAsString());
                updated.add(dest2);
            }
            this.destinations = updated;
        }
    }

    @Override
    public String getFileName() {
        return "global-dest.json";
    }

    @Override
    public String getDirectory() {
        return DirectionHUD.getData().getDataDirectory();
    }

    @Override
    public void reset() {
        this.copyFileData(new GlobalDest());
    }
}

