/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files;

import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.template.CustomFile;
import org.jetbrains.annotations.NotNull;

public class ModuleText
implements CustomFile<ModuleText> {
    @SerializedName(value="version")
    private Double version = 1.01;
    @SerializedName(value="coordinates")
    private ModuleCoordinates coordinates = new ModuleCoordinates();
    @SerializedName(value="destination")
    private ModuleDestination destination = new ModuleDestination();
    @SerializedName(value="distance")
    private ModuleDistance distance = new ModuleDistance();
    @SerializedName(value="tracking")
    private ModuleTracking tracking = new ModuleTracking();
    @SerializedName(value="direction")
    private ModuleDirection direction = new ModuleDirection();
    @SerializedName(value="weather")
    private ModuleWeather weather = new ModuleWeather();
    @SerializedName(value="time")
    private ModuleTime time = new ModuleTime();
    @SerializedName(value="angle")
    private ModuleAngle angle = new ModuleAngle();
    @SerializedName(value="speed")
    private ModuleSpeed speed = new ModuleSpeed();

    public ModuleCoordinates getCoordinates() {
        return this.coordinates;
    }

    public ModuleDestination getDestination() {
        return this.destination;
    }

    public ModuleDistance getDistance() {
        return this.distance;
    }

    public ModuleTracking getTracking() {
        return this.tracking;
    }

    public ModuleDirection getDirection() {
        return this.direction;
    }

    public ModuleWeather getWeather() {
        return this.weather;
    }

    public ModuleTime getTime() {
        return this.time;
    }

    public ModuleAngle getAngle() {
        return this.angle;
    }

    public ModuleSpeed getSpeed() {
        return this.speed;
    }

    @Override
    public void reset() {
        this.coordinates = new ModuleCoordinates();
        this.destination = new ModuleDestination();
        this.distance = new ModuleDistance();
        this.tracking = new ModuleTracking();
        this.direction = new ModuleDirection();
        this.weather = new ModuleWeather();
        this.time = new ModuleTime();
        this.angle = new ModuleAngle();
        this.speed = new ModuleSpeed();
    }

    @Override
    @NotNull
    public Class<ModuleText> getFileClass() {
        return ModuleText.class;
    }

    @Override
    public void copyFileData(ModuleText newFile) {
        this.coordinates = new ModuleCoordinates(newFile.coordinates);
        this.destination = new ModuleDestination(newFile.destination);
        this.distance = new ModuleDistance(newFile.distance);
        this.tracking = new ModuleTracking(newFile.tracking);
        this.direction = new ModuleDirection(newFile.direction);
        this.weather = new ModuleWeather(newFile.weather);
        this.time = new ModuleTime(newFile.time);
        this.angle = new ModuleAngle(newFile.angle);
        this.speed = new ModuleSpeed(newFile.speed);
    }

    @Override
    public void update(JsonElement json) {
        if (this.version < 1.01) {
            String brokenDestinationName = "&2[&1%s&2]";
            String fixedDestinationName = new ModuleDestination().name;
            if (this.destination.name.equals("&2[&1%s&2]")) {
                this.destination.name = fixedDestinationName;
            }
            if (this.destination.name_xz.equals("&2[&1%s&2]")) {
                this.destination.name_xz = fixedDestinationName;
            }
            this.version = 1.01;
        }
    }

    @Override
    public String getFileName() {
        return "module-text.json";
    }

    @Override
    public String getDirectory() {
        return DirectionHUD.getData().getConfigDirectory();
    }

    public static class ModuleCoordinates {
        @SerializedName(value="xyz")
        private String xyz = "&1XYZ: &2%s %s %s";
        @SerializedName(value="xz")
        private String xz = "&1XZ: &2%s %s";

        public ModuleCoordinates() {
        }

        public ModuleCoordinates(ModuleCoordinates coordinates) {
            this.xyz = coordinates.xyz;
            this.xz = coordinates.xz;
        }

        public String getXyz() {
            return this.xyz;
        }

        public String getXz() {
            return this.xz;
        }
    }

    public static class ModuleDestination {
        @SerializedName(value="xyz")
        private String xyz = "&1[&2%s %s %s&1]";
        @SerializedName(value="xz")
        private String xz = "&1[&2%s %s&1]";
        @SerializedName(value="name")
        private String name = "&1[&2%s&1]";
        @SerializedName(value="name_xz")
        private String name_xz = "&1[&2%s&1]";

        public ModuleDestination() {
        }

        public ModuleDestination(ModuleDestination destination) {
            this.xyz = destination.xyz;
            this.xz = destination.xz;
            this.name = destination.name;
            this.name_xz = destination.name_xz;
        }

        public String getXyz() {
            return this.xyz;
        }

        public String getXz() {
            return this.xz;
        }

        public String getName() {
            return this.name;
        }

        public String getNameXz() {
            return this.name_xz;
        }
    }

    public static class ModuleDistance {
        @SerializedName(value="number")
        private String number = "&1[&2%s&1]";

        public ModuleDistance() {
        }

        public ModuleDistance(ModuleDistance distance) {
            this.number = distance.number;
        }

        public String getNumber() {
            return this.number;
        }
    }

    public static class ModuleTracking {
        @SerializedName(value="assets")
        private Assets assets = new Assets();
        @SerializedName(value="tracking")
        private String tracking = "&1&s[&r&2%s&1&s]";
        @SerializedName(value="elevation_tracking")
        private String elevationTracking = "&1&s[&r&2%s&1|&2%s&1&s]";

        public ModuleTracking() {
        }

        public ModuleTracking(ModuleTracking moduleTracking) {
            this.assets = new Assets(moduleTracking.assets);
            this.tracking = moduleTracking.tracking;
            this.elevationTracking = moduleTracking.elevationTracking;
        }

        public Assets getAssets() {
            return this.assets;
        }

        public String getTracking() {
            return this.tracking;
        }

        public String getElevationTracking() {
            return this.elevationTracking;
        }

        public static class Assets {
            @SerializedName(value="simple")
            private Simple simple = new Simple();
            @SerializedName(value="compact")
            private Compact compact = new Compact();
            @SerializedName(value="elevation")
            private Elevation elevation = new Elevation();

            public Assets() {
            }

            public Assets(Assets assets) {
                this.simple = new Simple(assets.simple);
                this.compact = new Compact(assets.compact);
                this.elevation = new Elevation(assets.elevation);
            }

            public Simple getSimple() {
                return this.simple;
            }

            public Compact getCompact() {
                return this.compact;
            }

            public Elevation getElevation() {
                return this.elevation;
            }

            public static class Simple
            extends Directions {
                public Simple() {
                    this.northEast = "-\u25b2\u25b6";
                    this.north = "-\u25b2-";
                    this.northWest = "\u25c0\u25b2-";
                    this.west = "\u25c0--";
                    this.southWest = "\u25c0\u25bc-";
                    this.south = "-\u25bc-";
                    this.southEast = "-\u25bc\u25b6";
                    this.east = "--\u25b6";
                }

                public Simple(Simple directions) {
                    super(directions);
                }
            }

            public static class Compact
            extends Directions {
                public Compact() {
                    this.northEast = "\u2b08";
                    this.north = "\u2b06";
                    this.northWest = "\u2b09";
                    this.west = "\u2b05";
                    this.southWest = "\u2b0b";
                    this.south = "\u2b07";
                    this.southEast = "\u2b0a";
                    this.east = "\u2b95";
                }

                public Compact(Compact directions) {
                    super(directions);
                }
            }

            public static class Elevation {
                @SerializedName(value="above")
                protected String above = "\u2b06";
                @SerializedName(value="same")
                protected String same = "-";
                @SerializedName(value="below")
                protected String below = "\u2b07";

                public Elevation() {
                }

                public Elevation(Elevation elevation) {
                    this.above = elevation.above;
                    this.same = elevation.same;
                    this.below = elevation.below;
                }

                public String getAbove() {
                    return this.above;
                }

                public String getSame() {
                    return this.same;
                }

                public String getBelow() {
                    return this.below;
                }
            }
        }
    }

    public static class ModuleDirection {
        @SerializedName(value="assets")
        private Assets assets = new Assets();
        @SerializedName(value="facing")
        private String facing = "&1%s";

        public ModuleDirection() {
        }

        public ModuleDirection(ModuleDirection direction) {
            this.assets = new Assets(direction.assets);
            this.facing = direction.facing;
        }

        public Assets getAssets() {
            return this.assets;
        }

        public String getFacing() {
            return this.facing;
        }

        public static class Assets {
            @SerializedName(value="cardinal")
            private Cardinal cardinal = new Cardinal();

            public Assets() {
            }

            public Assets(Assets assets) {
                this.cardinal = new Cardinal(assets.cardinal);
            }

            public Cardinal getCardinal() {
                return this.cardinal;
            }

            public static class Cardinal
            extends Directions {
                public Cardinal() {
                    this.northEast = "NE";
                    this.north = "N";
                    this.northWest = "NW";
                    this.west = "W";
                    this.southWest = "SW";
                    this.south = "S";
                    this.southEast = "SE";
                    this.east = "E";
                }

                public Cardinal(Cardinal directions) {
                    super(directions);
                }
            }
        }
    }

    public static class ModuleWeather {
        @SerializedName(value="weather_single")
        private String weatherSingle = "&1%s";
        @SerializedName(value="weather")
        private String weather = "&1%s%s";

        public ModuleWeather() {
        }

        public ModuleWeather(ModuleWeather weather) {
            this.weatherSingle = weather.weatherSingle;
            this.weather = weather.weather;
        }

        public String getWeatherSingle() {
            return this.weatherSingle;
        }

        public String getWeather() {
            return this.weather;
        }
    }

    public static class ModuleTime {
        @SerializedName(value="hour_AM")
        private String hourAM = "&2%s&1:&2%s &1AM";
        @SerializedName(value="hour_PM")
        private String hourPM = "&2%s&1:&2%s &1PM";
        @SerializedName(value="hour_24")
        private String hour24 = "&2%s&1:&2%s";

        public ModuleTime() {
        }

        public ModuleTime(ModuleTime time) {
            this.hourAM = time.hourAM;
            this.hourPM = time.hourPM;
            this.hour24 = time.hour24;
        }

        public String getHourAM() {
            return this.hourAM;
        }

        public String getHourPM() {
            return this.hourPM;
        }

        public String getHour24() {
            return this.hour24;
        }
    }

    public static class ModuleAngle {
        @SerializedName(value="yaw")
        private String yaw = "&2%s";
        @SerializedName(value="pitch")
        private String pitch = "&2%s";
        @SerializedName(value="both")
        private String both = "&2%s&1/&2%s";

        public ModuleAngle() {
        }

        public ModuleAngle(ModuleAngle angle) {
            this.yaw = angle.yaw;
            this.pitch = angle.pitch;
            this.both = angle.both;
        }

        public String getYaw() {
            return this.yaw;
        }

        public String getPitch() {
            return this.pitch;
        }

        public String getBoth() {
            return this.both;
        }
    }

    public static class ModuleSpeed {
        @SerializedName(value="xz_speed")
        private String xzSpeed = "&2%s &1B/S";
        @SerializedName(value="xyz_speed")
        private String xyzSpeed = "&2%s &1B/S";

        public ModuleSpeed() {
        }

        public ModuleSpeed(ModuleSpeed speed) {
            this.xzSpeed = speed.xzSpeed;
            this.xyzSpeed = speed.xyzSpeed;
        }

        public String getXzSpeed() {
            return this.xzSpeed;
        }

        public String getXyzSpeed() {
            return this.xyzSpeed;
        }
    }

    private static abstract class Directions {
        @SerializedName(value="north_east")
        protected String northEast;
        @SerializedName(value="north")
        protected String north;
        @SerializedName(value="north_west")
        protected String northWest;
        @SerializedName(value="west")
        protected String west;
        @SerializedName(value="south_west")
        protected String southWest;
        @SerializedName(value="south")
        protected String south;
        @SerializedName(value="south_east")
        protected String southEast;
        @SerializedName(value="east")
        protected String east;

        public Directions() {
        }

        public Directions(Directions directions) {
            this.northEast = directions.northEast;
            this.north = directions.north;
            this.northWest = directions.northWest;
            this.west = directions.west;
            this.southWest = directions.southWest;
            this.south = directions.south;
            this.southEast = directions.southEast;
            this.east = directions.east;
        }

        public String getNorthEast() {
            return this.northEast;
        }

        public String getNorth() {
            return this.north;
        }

        public String getNorthWest() {
            return this.northWest;
        }

        public String getWest() {
            return this.west;
        }

        public String getSouthWest() {
            return this.southWest;
        }

        public String getSouth() {
            return this.south;
        }

        public String getSouthEast() {
            return this.southEast;
        }

        public String getEast() {
            return this.east;
        }
    }
}

