/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files.playerdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.stream.Collectors;
import one.oth3r.directionhud.common.files.playerdata.PDDestination;
import one.oth3r.directionhud.common.files.playerdata.PDHud;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.modules.ModuleAngle;
import one.oth3r.directionhud.common.hud.module.modules.ModuleCoordinates;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDestination;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDirection;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDistance;
import one.oth3r.directionhud.common.hud.module.modules.ModuleSpeed;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTime;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTracking;
import one.oth3r.directionhud.common.hud.module.modules.ModuleWeather;
import one.oth3r.directionhud.common.utils.Helper;

public abstract class BasePData {
    @SerializedName(value="version")
    protected Double version = 2.1;
    @SerializedName(value="hud")
    protected PDHud hud = new PDHud();
    @SerializedName(value="destination")
    protected PDDestination destination = new PDDestination();
    @SerializedName(value="color_presets")
    protected ArrayList<Helper.ColorPreset> colorPresets = new ArrayList();

    public BasePData() {
    }

    public BasePData(BasePData newFile) {
        this.copyBaseFileData(newFile);
    }

    protected void copyBaseFileData(BasePData newFile) {
        this.version = newFile.version;
        this.hud = new PDHud(newFile.hud);
        this.destination = new PDDestination(newFile.destination);
        this.colorPresets = newFile.colorPresets.stream().map(record -> new Helper.ColorPreset(record.name(), record.color())).collect(Collectors.toCollection(ArrayList::new));
    }

    public PDHud getHud() {
        return this.hud;
    }

    public PDDestination getDEST() {
        return this.destination;
    }

    public Double getVersion() {
        return this.version;
    }

    public void setVersion(Double version) {
        this.version = version;
    }

    public ArrayList<Helper.ColorPreset> getColorPresets() {
        return this.colorPresets;
    }

    public void setColorPresets(ArrayList<Helper.ColorPreset> colorPresets) {
        this.colorPresets = colorPresets;
    }

    public void baseUpdater(JsonElement json) {
        if (this.version.equals(2.0)) {
            ArrayList<BaseModule> newModules = new ArrayList<BaseModule>();
            JsonObject hud = json.getAsJsonObject().getAsJsonObject("hud");
            JsonArray order = hud.getAsJsonArray("order");
            JsonObject moduleSettings = hud.getAsJsonObject("setting").getAsJsonObject("module");
            JsonObject modules2 = hud.getAsJsonObject("module");
            int i = 0;
            for (JsonElement element : order) {
                Module module = Module.fromString(element.getAsString());
                if (module.equals((Object)Module.UNKNOWN)) continue;
                boolean state = modules2.getAsJsonPrimitive(module.getName()).getAsBoolean();
                switch (module) {
                    case COORDINATES: {
                        newModules.add(new ModuleCoordinates(i, state, true));
                        break;
                    }
                    case DESTINATION: {
                        newModules.add(new ModuleDestination(i, state));
                        break;
                    }
                    case DISTANCE: {
                        newModules.add(new ModuleDistance(i, state));
                        break;
                    }
                    case TRACKING: {
                        newModules.add(new ModuleTracking(i, state, moduleSettings.getAsJsonPrimitive("tracking_hybrid").getAsBoolean(), moduleSettings.getAsJsonPrimitive("tracking_target").getAsString().equals("player") ? ModuleTracking.Target.player : ModuleTracking.Target.dest, moduleSettings.getAsJsonPrimitive("tracking_type").getAsString().equals("simple") ? ModuleTracking.Type.simple : ModuleTracking.Type.compact, false));
                        break;
                    }
                    case DIRECTION: {
                        newModules.add(new ModuleDirection(i, state));
                        break;
                    }
                    case WEATHER: {
                        newModules.add(new ModuleWeather(i, state));
                        break;
                    }
                    case TIME: {
                        newModules.add(new ModuleTime(i, state, moduleSettings.getAsJsonPrimitive("time_24hr").getAsBoolean()));
                        break;
                    }
                    case ANGLE: {
                        newModules.add(new ModuleAngle(i, state, Helper.Enums.get(moduleSettings.getAsJsonPrimitive("angle_display").getAsString(), ModuleAngle.Display.class)));
                        break;
                    }
                    case SPEED: {
                        newModules.add(new ModuleSpeed(i, state, !moduleSettings.getAsJsonPrimitive("speed_3d").getAsBoolean(), moduleSettings.getAsJsonPrimitive("speed_pattern").getAsString()));
                    }
                }
                ++i;
            }
            this.hud.setModules(newModules);
            this.version = 2.1;
        }
    }
}

