/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files.playerdata;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.Destination;
import one.oth3r.directionhud.common.utils.Dest;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.utils.Player;

public class PDDestination {
    private transient Player player;
    @SerializedName(value="saved")
    private ArrayList<Dest> saved = new ArrayList();
    @SerializedName(value="dest")
    private Dest dest = new Dest();
    @SerializedName(value="tracking")
    private String tracking = null;
    @SerializedName(value="lastdeath")
    private List<Loc> lastdeath = new ArrayList<Loc>();
    @SerializedName(value="setting")
    private Settings setting = new Settings();

    public void setPlayer(Player player) {
        this.player = player;
    }

    private void save() {
        if (this.player == null) {
            return;
        }
        this.player.getPData().queueSave();
    }

    public PDDestination() {
    }

    public PDDestination(PDDestination destination) {
        ArrayList<Dest> saved2 = new ArrayList<Dest>();
        for (Dest dest2 : destination.saved) {
            saved2.add(new Dest(dest2));
        }
        this.saved = saved2;
        this.dest = new Dest(destination.dest);
        this.tracking = destination.tracking;
        ArrayList<Loc> lastdeath2 = new ArrayList<Loc>();
        for (Loc loc : destination.lastdeath) {
            lastdeath2.add(new Loc(loc));
        }
        this.lastdeath = lastdeath2;
        this.setting = new Settings(destination.setting);
    }

    public ArrayList<Dest> getSaved() {
        return new ArrayList<Dest>(this.saved);
    }

    public void setSaved(ArrayList<Dest> saved2) {
        this.saved = saved2;
        this.save();
    }

    public List<Loc> getLastdeath() {
        return new ArrayList<Loc>(this.lastdeath);
    }

    public void setLastdeath(List<Loc> lastdeath2) {
        this.lastdeath = lastdeath2;
        this.save();
    }

    public Dest getDest() {
        return this.dest;
    }

    public void setDest(Dest dest2) {
        this.dest = dest2;
        this.save();
    }

    public String getTracking() {
        return this.tracking;
    }

    public void setTracking(String tracking) {
        this.tracking = tracking;
        this.save();
    }

    public Settings getSetting() {
        return this.setting;
    }

    public Object getSetting(Destination.Setting setting) {
        return switch (setting) {
            case Destination.Setting.ylevel -> this.getSetting().getYlevel();
            case Destination.Setting.autoclear -> this.getSetting().getAutoclear();
            case Destination.Setting.autoclear_rad -> this.getSetting().getAutoclearRad();
            case Destination.Setting.autoconvert -> this.getSetting().getAutoconvert();
            case Destination.Setting.features__send -> this.getSetting().getFeatures().getSend();
            case Destination.Setting.features__track -> this.getSetting().getFeatures().getTrack();
            case Destination.Setting.features__track_request_mode -> this.getSetting().getFeatures().getTrackRequestMode();
            case Destination.Setting.features__lastdeath -> this.getSetting().getFeatures().getLastdeath();
            case Destination.Setting.particles__dest -> this.getSetting().getParticles().getDest();
            case Destination.Setting.particles__dest_color -> this.getSetting().getParticles().getDestColor();
            case Destination.Setting.particles__line -> this.getSetting().getParticles().getLine();
            case Destination.Setting.particles__line_color -> this.getSetting().getParticles().getLineColor();
            case Destination.Setting.particles__tracking -> this.getSetting().getParticles().getTracking();
            case Destination.Setting.particles__tracking_color -> this.getSetting().getParticles().getTrackingColor();
            default -> null;
        };
    }

    public void setSetting(Destination.Setting setting, Object state) {
        switch (setting) {
            case ylevel: {
                this.getSetting().setYlevel((Boolean)state);
                break;
            }
            case autoclear: {
                this.getSetting().setAutoclear((Boolean)state);
                break;
            }
            case autoclear_rad: {
                this.getSetting().setAutoclearRad((int)((Integer)state));
                break;
            }
            case autoconvert: {
                this.getSetting().setAutoconvert((Boolean)state);
                break;
            }
            case features__send: {
                this.getSetting().getFeatures().setSend((Boolean)state);
                break;
            }
            case features__track: {
                this.getSetting().getFeatures().setTrack((Boolean)state);
                break;
            }
            case features__track_request_mode: {
                this.getSetting().getFeatures().setTrackRequestMode(state.toString());
                break;
            }
            case features__lastdeath: {
                this.getSetting().getFeatures().setLastdeath((Boolean)state);
                break;
            }
            case particles__dest: {
                this.getSetting().getParticles().setDest((Boolean)state);
                break;
            }
            case particles__dest_color: {
                this.getSetting().getParticles().setDestColor(state.toString());
                break;
            }
            case particles__line: {
                this.getSetting().getParticles().setLine((Boolean)state);
                break;
            }
            case particles__line_color: {
                this.getSetting().getParticles().setLineColor(state.toString());
                break;
            }
            case particles__tracking: {
                this.getSetting().getParticles().setTracking((Boolean)state);
                break;
            }
            case particles__tracking_color: {
                this.getSetting().getParticles().setTrackingColor(state.toString());
            }
        }
        this.save();
    }

    public void setSetting(Settings setting) {
        this.setting = setting;
        this.save();
    }

    public static class Settings {
        @SerializedName(value="ylevel")
        private Boolean ylevel = false;
        @SerializedName(value="autoclear")
        private Boolean autoclear = true;
        @SerializedName(value="autoclear_rad")
        private Integer autoclearRad = 2;
        @SerializedName(value="autoconvert")
        private Boolean autoconvert = false;
        @SerializedName(value="features")
        private Features features = new Features();
        @SerializedName(value="particles")
        private Particles particles = new Particles();

        public Settings() {
        }

        public Settings(Settings settings2) {
            this.ylevel = settings2.ylevel;
            this.autoclear = settings2.autoclear;
            this.autoclearRad = settings2.autoclearRad;
            this.autoconvert = settings2.autoconvert;
            this.features = new Features(settings2.features);
            this.particles = new Particles(settings2.particles);
        }

        public Boolean getYlevel() {
            return this.ylevel;
        }

        public void setYlevel(Boolean ylevel) {
            this.ylevel = ylevel;
        }

        public Boolean getAutoconvert() {
            return this.autoconvert;
        }

        public void setAutoconvert(Boolean autoconvert) {
            this.autoconvert = autoconvert;
        }

        public Features getFeatures() {
            return this.features;
        }

        public void setFeatures(Features features) {
            this.features = features;
        }

        public Boolean getAutoclear() {
            return this.autoclear;
        }

        public void setAutoclear(Boolean autoclear) {
            this.autoclear = autoclear;
        }

        public Integer getAutoclearRad() {
            return this.autoclearRad;
        }

        public void setAutoclearRad(Integer autoclearRad) {
            this.autoclearRad = autoclearRad;
        }

        public Particles getParticles() {
            return this.particles;
        }

        public void setParticles(Particles particles) {
            this.particles = particles;
        }

        public static class Features {
            @SerializedName(value="track")
            private Boolean track = true;
            @SerializedName(value="track_request_mode")
            private Destination.Setting.TrackingRequestMode trackRequestMode = Destination.Setting.TrackingRequestMode.request;
            @SerializedName(value="send")
            private Boolean send = true;
            @SerializedName(value="lastdeath")
            private Boolean lastdeath = true;

            public Features() {
            }

            public Features(Features features) {
                this.trackRequestMode = features.trackRequestMode;
                this.track = features.track;
                this.send = features.send;
                this.lastdeath = features.lastdeath;
            }

            public String getTrackRequestMode() {
                return this.trackRequestMode.toString();
            }

            public void setTrackRequestMode(String trackRequestMode) {
                this.trackRequestMode = Helper.Enums.get(trackRequestMode, Destination.Setting.TrackingRequestMode.class);
            }

            public Boolean getTrack() {
                return this.track;
            }

            public void setTrack(Boolean track2) {
                this.track = track2;
            }

            public Boolean getSend() {
                return this.send;
            }

            public void setSend(Boolean send2) {
                this.send = send2;
            }

            public Boolean getLastdeath() {
                return this.lastdeath;
            }

            public void setLastdeath(Boolean lastdeath2) {
                this.lastdeath = lastdeath2;
            }
        }

        public static class Particles {
            @SerializedName(value="dest")
            private Boolean dest = true;
            @SerializedName(value="dest_color")
            private String destColor = DirectionHUD.getData().getPrimary();
            @SerializedName(value="line")
            private Boolean line = true;
            @SerializedName(value="line_color")
            private String lineColor = DirectionHUD.getData().getSecondary();
            @SerializedName(value="tracking")
            private Boolean tracking = true;
            @SerializedName(value="tracking_color")
            private String trackingColor = "#ff6426";

            public Particles() {
            }

            public Particles(Particles particles) {
                this.dest = particles.dest;
                this.destColor = particles.destColor;
                this.line = particles.line;
                this.lineColor = particles.lineColor;
                this.tracking = particles.tracking;
                this.trackingColor = particles.trackingColor;
            }

            public Boolean getLine() {
                return this.line;
            }

            public void setLine(Boolean line) {
                this.line = line;
            }

            public String getTrackingColor() {
                return this.trackingColor;
            }

            public void setTrackingColor(String trackingColor) {
                this.trackingColor = trackingColor;
            }

            public String getDestColor() {
                return this.destColor;
            }

            public void setDestColor(String destColor) {
                this.destColor = destColor;
            }

            public Boolean getDest() {
                return this.dest;
            }

            public void setDest(Boolean dest2) {
                this.dest = dest2;
            }

            public Boolean getTracking() {
                return this.tracking;
            }

            public void setTracking(Boolean tracking) {
                this.tracking = tracking;
            }

            public String getLineColor() {
                return this.lineColor;
            }

            public void setLineColor(String lineColor) {
                this.lineColor = lineColor;
            }
        }
    }
}

