/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files.playerdata;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.hud.Hud;
import one.oth3r.directionhud.common.hud.HudColor;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.modules.ModuleAngle;
import one.oth3r.directionhud.common.hud.module.modules.ModuleCoordinates;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDestination;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDirection;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDistance;
import one.oth3r.directionhud.common.hud.module.modules.ModuleSpeed;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTime;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTracking;
import one.oth3r.directionhud.common.hud.module.modules.ModuleWeather;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.utils.Player;

public class PDHud {
    private transient Player player;
    @SerializedName(value="modules")
    private ArrayList<BaseModule> modules = new ArrayList<BaseModule>(){
        {
            this.add(new ModuleCoordinates(0, true, true));
            this.add(new ModuleDestination(1, true));
            this.add(new ModuleDistance(2, true));
            this.add(new ModuleTracking(3, false, true, ModuleTracking.Target.player, ModuleTracking.Type.simple, false));
            this.add(new ModuleDirection(4, true));
            this.add(new ModuleWeather(5, true));
            this.add(new ModuleTime(6, true, false));
            this.add(new ModuleAngle(7, false, ModuleAngle.Display.both));
            this.add(new ModuleSpeed(8, false, false, "0.00"));
        }
    };
    @SerializedName(value="setting")
    private Settings setting = new Settings();
    @SerializedName(value="primary")
    private Color primary = new Color(DirectionHUD.getData().getPrimary(), false, false, false);
    @SerializedName(value="secondary")
    private Color secondary = new Color("#ffffff", false, false, false);

    public void setPlayer(Player player) {
        this.player = player;
        this.primary.setPlayer(player);
        this.secondary.setPlayer(player);
    }

    private void save() {
        if (this.player == null) {
            return;
        }
        this.player.getPData().queueSave();
    }

    public PDHud() {
    }

    public PDHud(PDHud hud) {
        ArrayList<BaseModule> baseModules = new ArrayList<BaseModule>();
        for (BaseModule module : hud.modules) {
            baseModules.add(module.clone());
        }
        this.modules = baseModules;
        this.setting = new Settings(hud.setting);
        this.primary = new Color(hud.getPrimary());
        this.secondary = new Color(hud.getSecondary());
    }

    public ArrayList<BaseModule> getModules() {
        return this.modules;
    }

    public <T extends BaseModule> T getModule(Module module) {
        return (T)BaseModule.findInArrayList(this.modules, module).orElseThrow(() -> new RuntimeException("Invalid HUD Module playerdata for " + (this.player == null ? "a file with no player set" : this.player.getName()) + "!"));
    }

    public void setModule(BaseModule setModule) {
        for (int i = 0; i < this.modules.size(); ++i) {
            if (!setModule.getModuleType().equals((Object)this.modules.get(i).getModuleType())) continue;
            this.modules.set(i, setModule);
        }
        this.save();
    }

    public void setModules(ArrayList<BaseModule> module) {
        this.modules = module;
        this.save();
    }

    public Settings getSetting() {
        return this.setting;
    }

    public Object getSetting(Hud.Setting type) {
        return switch (type) {
            case Hud.Setting.type -> this.getSetting().getType();
            case Hud.Setting.state -> this.getSetting().getState();
            case Hud.Setting.bossbar__color -> this.getSetting().getBossbar().getColor();
            case Hud.Setting.bossbar__distance -> this.getSetting().getBossbar().getDistance();
            case Hud.Setting.bossbar__distance_max -> this.getSetting().getBossbar().getDistanceMax();
            default -> null;
        };
    }

    public void setSetting(Hud.Setting type, Object setting) {
        switch (type) {
            case type: {
                this.getSetting().setType(setting.toString());
                break;
            }
            case state: {
                this.getSetting().setState((Boolean)setting);
                break;
            }
            case bossbar__color: {
                this.getSetting().getBossbar().setColor(setting.toString());
                break;
            }
            case bossbar__distance: {
                this.getSetting().getBossbar().setDistance((Boolean)setting);
                break;
            }
            case bossbar__distance_max: {
                this.getSetting().getBossbar().setDistanceMax((int)((Integer)setting));
            }
        }
        this.save();
    }

    public void setSetting(Settings setting) {
        this.setting = setting;
        this.save();
    }

    public Color getColor(HudColor color2) {
        return color2.equals((Object)HudColor.PRIMARY) ? this.primary : this.secondary;
    }

    public Color getPrimary() {
        return this.primary;
    }

    public void setPrimary(Color primary) {
        this.primary = primary;
        this.save();
    }

    public Color getSecondary() {
        return this.secondary;
    }

    public void setSecondary(Color secondary) {
        this.secondary = secondary;
        this.save();
    }

    public static class Color {
        private transient Player player;
        @SerializedName(value="color")
        private String color;
        @SerializedName(value="bold")
        private Boolean bold;
        @SerializedName(value="italics")
        private Boolean italics;
        @SerializedName(value="rainbow")
        private Boolean rainbow;

        public void setPlayer(Player player) {
            this.player = player;
        }

        private void save() {
            if (this.player == null) {
                return;
            }
            this.player.getPData().queueSave();
        }

        public Color(Color color2) {
            this.color = color2.color;
            this.bold = color2.bold;
            this.italics = color2.italics;
            this.rainbow = color2.rainbow;
            this.player = color2.player;
        }

        public Color(Player player, String color2, Boolean bold, Boolean italics, Boolean rainbow) {
            this.color = color2;
            this.bold = bold;
            this.italics = italics;
            this.rainbow = rainbow;
            this.player = player;
        }

        public Color(String color2, Boolean bold, Boolean italics, Boolean rainbow) {
            this.color = color2;
            this.bold = bold;
            this.italics = italics;
            this.rainbow = rainbow;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color2) {
            this.color = color2;
            this.save();
        }

        public Boolean getBold() {
            return this.bold;
        }

        public void setBold(Boolean bold) {
            this.bold = bold;
            this.save();
        }

        public Boolean getItalics() {
            return this.italics;
        }

        public void setItalics(Boolean italics) {
            this.italics = italics;
            this.save();
        }

        public Boolean getRainbow() {
            return this.rainbow;
        }

        public void setRainbow(Boolean rainbow) {
            this.rainbow = rainbow;
            this.save();
        }
    }

    public static class Settings {
        @SerializedName(value="bossbar")
        private Bossbar bossbar = new Bossbar();
        @SerializedName(value="state")
        private Boolean state = true;
        @SerializedName(value="type")
        private Hud.Setting.DisplayType type = Hud.Setting.DisplayType.actionbar;

        public Settings() {
        }

        public Settings(Settings settings2) {
            this.bossbar = new Bossbar(settings2.getBossbar());
            this.state = settings2.state;
            this.type = settings2.type;
        }

        public Bossbar getBossbar() {
            return this.bossbar;
        }

        public void setBossbar(Bossbar bossbar) {
            this.bossbar = bossbar;
        }

        public Boolean getState() {
            return this.state;
        }

        public void setState(Boolean state) {
            this.state = state;
        }

        public String getType() {
            return this.type.toString();
        }

        public void setType(String type) {
            this.type = Helper.Enums.get(type, Hud.Setting.DisplayType.class);
        }

        public static class Bossbar {
            @SerializedName(value="color")
            private Hud.Setting.BarColor color = Hud.Setting.BarColor.white;
            @SerializedName(value="distance")
            private Boolean distance = true;
            @SerializedName(value="distance_max")
            private Integer distanceMax = 0;

            public Bossbar() {
            }

            public Bossbar(Bossbar bossbar) {
                this.color = bossbar.color;
                this.distance = bossbar.distance;
                this.distanceMax = bossbar.distanceMax;
            }

            public String getColor() {
                return this.color.toString();
            }

            public void setColor(String color2) {
                this.color = Helper.Enums.get(color2, Hud.Setting.BarColor.class);
            }

            public Boolean getDistance() {
                return this.distance;
            }

            public void setDistance(Boolean distance) {
                this.distance = distance;
            }

            public Integer getDistanceMax() {
                return this.distanceMax;
            }

            public void setDistanceMax(Integer distanceMax) {
                this.distanceMax = distanceMax;
            }
        }
    }
}

