/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.files.playerdata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.common.DHud;
import one.oth3r.directionhud.common.files.FileData;
import one.oth3r.directionhud.common.files.playerdata.BasePData;
import one.oth3r.directionhud.common.files.playerdata.CachedPData;
import one.oth3r.directionhud.common.files.playerdata.PDDestination;
import one.oth3r.directionhud.common.files.playerdata.PDHud;
import one.oth3r.directionhud.common.files.playerdata.PlayerData;
import one.oth3r.directionhud.common.hud.Hud;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.template.CustomFile;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Dest;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.utils.Player;
import one.oth3r.directionhud.utils.Utl;
import org.jetbrains.annotations.NotNull;

public class PData
extends BasePData
implements CustomFile<PData> {
    @SerializedName(value="name")
    protected String name;
    @SerializedName(value="inbox")
    protected ArrayList<HashMap<String, String>> inbox = new ArrayList();
    @SerializedName(value="social_cooldown")
    protected Integer socialCooldown;
    protected transient Player player;

    public PData(Player player) {
        this.name = player.getName();
        this.hud = PlayerData.getDefaults().getHud();
        this.destination = PlayerData.getDefaults().getDEST();
        this.colorPresets = PlayerData.getDefaults().getColorPresets();
        this.setPlayer(player);
    }

    public PData(Player player, PData pData) {
        this.copyFileData(pData);
        this.setPlayer(player);
    }

    public PData(PData pData) {
        this.copyFileData(pData);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setColorPresets(ArrayList<Helper.ColorPreset> colorPresets) {
        super.setColorPresets(colorPresets);
        this.queueSave();
    }

    public void queueSave() {
        if (this.player == null) {
            return;
        }
        PlayerData.Queue.addSavePlayer(this.player);
        CachedPData cachedPData = PlayerData.getPCache(this.player);
        this.inbox = cachedPData.getInbox();
        this.socialCooldown = cachedPData.getSocialCooldown();
        cachedPData.update(this);
        this.player.sendPDataPackets();
    }

    public void setPlayer(Player player) {
        this.player = player;
        this.name = player.getName();
        this.hud.setPlayer(player);
        this.destination.setPlayer(player);
    }

    public Player getPlayer() {
        return this.player;
    }

    public ArrayList<HashMap<String, String>> getInbox() {
        return this.inbox;
    }

    public Integer getSocialCooldown() {
        return this.socialCooldown;
    }

    @Override
    public void reset() {
        PData pData = new PData(this.player);
        this.copyFileData(pData);
    }

    @Override
    @NotNull
    public Class<PData> getFileClass() {
        return PData.class;
    }

    @Override
    public void copyFileData(PData newFile) {
        super.copyBaseFileData(newFile);
        this.name = newFile.name;
        this.inbox = newFile.inbox.stream().map(HashMap::new).collect(Collectors.toCollection(ArrayList::new));
        this.socialCooldown = newFile.socialCooldown;
        if (newFile.player != null) {
            this.player = newFile.player;
        }
        this.setPlayer(this.player);
    }

    @Override
    public String getFileName() {
        if (FileData.getConfig().getOnline().booleanValue()) {
            return this.player.getUUID() + ".json";
        }
        return this.player.getName() + ".json";
    }

    @Override
    public String getDirectory() {
        return DirectionHUD.getData().getDataDirectory() + "playerdata/";
    }

    @Override
    public void updateFromReader(BufferedReader reader) {
        PData file;
        JsonElement json = JsonParser.parseReader((Reader)reader);
        try {
            file = (PData)Helper.getGson().fromJson(json, PData.class);
        }
        catch (Exception e) {
            throw new NullPointerException();
        }
        if (file == null) {
            this.update(json);
        } else {
            file.player = this.player;
            file.update(json);
            this.copyFileData(file);
        }
    }

    @Override
    public void update(JsonElement json) {
        if (this.version == null || this.version < 2.0) {
            DirectionHUD.LOGGER.info("Pre 2.0 PlayerData version detected! Trying to load from legacy...");
            new legacy(this.getFile()).update();
            this.load();
            return;
        }
        this.baseUpdater(json);
        Hud.modules.fixOrder(this.hud.getModules());
    }

    public static class legacy {
        private final File file;

        public legacy(File file) {
            this.file = file;
        }

        public void update() {
            this.mapUpdate(this.fileToMap());
        }

        private Map<String, Object> fileToMap() {
            Map map;
            block8: {
                BufferedReader reader = Files.newBufferedReader(this.file.toPath());
                try {
                    Gson gson = new GsonBuilder().create();
                    map = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        DirectionHUD.LOGGER.info("ERROR READING PLAYER DATA (LEGACY) - PLEASE REPORT WITH THE ERROR LOG");
                        DirectionHUD.LOGGER.info(e.getMessage());
                        return new HashMap<String, Object>();
                    }
                }
                reader.close();
            }
            return map;
        }

        private void mapToFile(Map<String, Object> map) {
            try (BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), new OpenOption[0]);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                writer.write(gson.toJson(map));
            }
            catch (Exception e) {
                DirectionHUD.LOGGER.info("ERROR WRITING PLAYER DATA - PLEASE REPORT WITH THE ERROR LOG");
                DirectionHUD.LOGGER.info(e.getMessage());
            }
        }

        private Map<String, Object> saveLoad(Map<String, Object> map) {
            this.mapToFile(map);
            return this.fileToMap();
        }

        private void mapUpdate(Map<String, Object> base) {
            Map hudSetting;
            Map dest2;
            Map hud;
            Map dest3;
            PDDestination DESTINATION = PlayerData.getDefaults().getDEST();
            PDDestination.Settings DESTSETTINGS = DESTINATION.getSetting();
            PDHud HUD_defaults = PlayerData.getDefaults().getHud();
            PDHud.Settings HUDSETTINGS = HUD_defaults.getSetting();
            if (base.get("version").equals(1.0)) {
                base.put("version", 1.1);
                dest3 = (Map)base.get("destination");
                Map dSet = (Map)dest3.get("setting");
                dSet.put("lastdeath", DESTINATION.getSetting().getFeatures().getLastdeath());
                dest3.put("setting", dSet);
                base.put("destination", dest3);
                base = this.saveLoad(base);
            }
            if (base.get("version").equals(1.1)) {
                base.put("version", 1.2);
                hud = (Map)base.get("hud");
                dest2 = (Map)base.get("destination");
                Iterator death = (String)dest2.get("lastdeath");
                String[] deaths = ((String)((Object)death)).split(" ");
                ArrayList<CallSite> newDeaths = new ArrayList<CallSite>();
                for (int i = 0; i < deaths.length; ++i) {
                    if (deaths[i].equals("f")) continue;
                    String xyz = deaths[i].replace("_", " ");
                    if (i == 0) {
                        newDeaths.add((CallSite)((Object)("minecraft.overworld|" + xyz)));
                    }
                    if (i == 1) {
                        newDeaths.add((CallSite)((Object)("minecraft.the_nether|" + xyz)));
                    }
                    if (i != 2) continue;
                    newDeaths.add((CallSite)((Object)("minecraft.the_end|" + xyz)));
                }
                Object pri = (String)hud.get("primary");
                Object sec = (String)hud.get("secondary");
                String[] priS = ((String)pri).split("-");
                String[] secS = ((String)sec).split("-");
                pri = priS[0].equals("rainbow") ? "white-" + priS[1] + "-" + priS[2] + "-true" : (String)pri + "-false";
                sec = secS[0].equals("rainbow") ? "white-" + secS[1] + "-" + secS[2] + "-true" : (String)sec + "-false";
                hud.put("primary", pri);
                hud.put("secondary", sec);
                dest2.put("lastdeath", newDeaths);
                base.put("destination", dest2);
                base.put("hud", hud);
                base = this.saveLoad(base);
            }
            if (base.get("version").equals(1.2)) {
                base.put("version", 1.3);
                dest3 = (Map)base.get("destination");
                dest3.computeIfAbsent("saved", k -> new ArrayList());
                if (!((ArrayList)dest3.get("saved")).isEmpty()) {
                    ArrayList saved2 = (ArrayList)dest3.get("saved");
                    for (String s : saved2) {
                        String[] split = s.split(" ");
                        switch (split[2]) {
                            case "overworld": {
                                saved2.set(saved2.indexOf(s), split[0] + " " + split[1] + " minecraft.overworld " + split[3]);
                                break;
                            }
                            case "the_nether": {
                                saved2.set(saved2.indexOf(s), split[0] + " " + split[1] + " minecraft.the_nether " + split[3]);
                                break;
                            }
                            case "the_end": {
                                saved2.set(saved2.indexOf(s), split[0] + " " + split[1] + " minecraft.the_end " + split[3]);
                            }
                        }
                    }
                    dest3.put("saved", saved2);
                }
                dest3.computeIfAbsent("lastdeath", k -> new ArrayList());
                ArrayList lastdeath2 = (ArrayList)dest3.get("lastdeath");
                for (String s : new ArrayList(lastdeath2)) {
                    if (!s.startsWith("overworld|") && !s.startsWith("the_nether|")) continue;
                    String prefix = s.startsWith("overworld|") ? "overworld|" : "the_nether|";
                    int count = 0;
                    for (String z : lastdeath2) {
                        if (!z.startsWith("minecraft." + prefix)) continue;
                        ++count;
                    }
                    if (count == 0) {
                        lastdeath2.set(lastdeath2.indexOf(s), "minecraft." + s);
                        continue;
                    }
                    lastdeath2.remove(s);
                }
                dest3.put("lastdeath", lastdeath2);
                base.put("destination", dest3);
                base = this.saveLoad(base);
            }
            if (base.get("version").equals(1.3)) {
                base.put("version", 1.4);
                base.remove("lastdeath");
                dest3 = (Map)base.get("destination");
                Map hud2 = (Map)base.get("hud");
                Map hudModule = (Map)hud2.get("module");
                hudModule.put("tracking", hudModule.get("compass"));
                hudModule.put("compass", null);
                hud2.put("module", hudModule);
                String order = (String)hud2.get("order");
                hud2.put("order", order.replace("compass", "tracking"));
                base.put("hud", hud2);
                dest3.put("tracking", null);
                String xyz = (String)dest3.get("xyz");
                if (xyz.equals("f")) {
                    dest3.put("dest", "null");
                } else if (xyz.split(" ").length == 1) {
                    dest3.put("dest", "null");
                    dest3.put("tracking", xyz);
                } else {
                    String[] sp = xyz.split(" ");
                    Loc loc = new Loc(true, xyz);
                    if (sp[1].equals("n")) {
                        loc = new Loc(sp[0] + " " + sp[2]);
                    }
                    dest3.put("dest", loc.toString());
                }
                dest3.remove("xyz");
                Map suspended = (Map)dest3.get("suspended");
                if (suspended != null) {
                    dest3.put("tracking", suspended.get("target"));
                }
                dest3.remove("suspended");
                ArrayList saved3 = (ArrayList)dest3.get("saved");
                ArrayList<List<String>> savedN = new ArrayList<List<String>>();
                for (Object s : saved3) {
                    String[] split = ((String)s).split(" ");
                    String[] coordS = split[1].split("_");
                    Loc loc = new Loc(Helper.Num.toInt(coordS[0]), Helper.Num.toInt(coordS[1]), Helper.Num.toInt(coordS[2]), Utl.dim.updateLegacy(split[2]));
                    savedN.add(saved3.indexOf(s), Arrays.asList(split[0], loc.toString(), split[3]));
                }
                dest3.put("saved", savedN);
                ArrayList lastdeath3 = (ArrayList)dest3.get("lastdeath");
                for (String s : lastdeath3) {
                    String[] split = s.split("\\|");
                    String[] xyzArray = split[1].split(" ");
                    lastdeath3.set(lastdeath3.indexOf(s), new Loc(Integer.valueOf(xyzArray[0]), Integer.valueOf(xyzArray[1]), Integer.valueOf(xyzArray[2]), Utl.dim.updateLegacy(split[0])).toString());
                }
                dest3.put("lastdeath", lastdeath3);
                Map setting = (Map)dest3.get("setting");
                Map particles = (Map)setting.get("particles");
                particles.put("tracking", DESTSETTINGS.getParticles().getTracking());
                particles.put("trackingcolor", DESTSETTINGS.getParticles().getTrackingColor());
                setting.put("autoconvert", DESTSETTINGS.getAutoconvert());
                setting.put("particles", particles);
                dest3.put("setting", setting);
                base.put("destination", dest3);
                base = this.saveLoad(base);
            }
            if (base.get("version").equals(1.4)) {
                base.put("version", 1.5);
                HashMap temp = new HashMap();
                dest2 = (Map)base.get("destination");
                if (dest2.get("track") != null) {
                    temp.put("track", dest2.get("track"));
                }
                base.put("temp", temp);
                Map destSetting = (Map)dest2.get("setting");
                Map particles = (Map)destSetting.get("particles");
                particles.put("dest_color", CUtl.color.updateOld((String)particles.get("destcolor"), DESTSETTINGS.getParticles().getDestColor()));
                particles.put("line_color", CUtl.color.updateOld((String)particles.get("linecolor"), DESTSETTINGS.getParticles().getLineColor()));
                particles.put("tracking_color", CUtl.color.updateOld((String)particles.get("trackingcolor"), DESTSETTINGS.getParticles().getTrackingColor()));
                particles.remove("destcolor");
                particles.remove("linecolor");
                particles.remove("trackingcolor");
                destSetting.put("particles", particles);
                destSetting.put("autoclear_rad", destSetting.get("autoclearradius"));
                destSetting.remove("autoclearradius");
                HashMap destFeatures = new HashMap();
                destFeatures.put("send", destSetting.get("send"));
                destFeatures.put("track", destSetting.get("track"));
                destFeatures.put("track_request_mode", DESTSETTINGS.getFeatures().getTrackRequestMode());
                destFeatures.put("lastdeath", destSetting.get("lastdeath"));
                destSetting.remove("send");
                destSetting.remove("track");
                destSetting.remove("lastdeath");
                destSetting.put("features", destFeatures);
                dest2.put("setting", destSetting);
                List destSaved = (List)dest2.get("saved");
                for (List list : destSaved) {
                    list.set(2, CUtl.color.updateOld((String)list.get(2), "#ffffff"));
                    destSaved.set(destSaved.indexOf(list), list);
                }
                dest2.put("saved", destSaved);
                Map hud3 = (Map)base.get("hud");
                CharSequence[] primary = ((String)hud3.get("primary")).split("-");
                primary[0] = CUtl.color.updateOld(primary[0], HUD_defaults.getPrimary().getColor());
                hud3.put("primary", String.join((CharSequence)"-", primary));
                CharSequence[] secondary = ((String)hud3.get("secondary")).split("-");
                secondary[0] = CUtl.color.updateOld(secondary[0], HUD_defaults.getSecondary().getColor());
                hud3.put("secondary", String.join((CharSequence)"-", secondary));
                Map hudSetting2 = (Map)hud3.get("setting");
                hudSetting2.put("type", HUDSETTINGS.getType());
                hudSetting2.put("bossbar", HUDSETTINGS.getBossbar());
                HashMap hudSettingModule = new HashMap();
                hudSettingModule.put("time_24hr", hudSetting2.get("time24h"));
                hudSetting2.put("time24h", null);
                hudSettingModule.put("tracking_target", "player");
                hudSetting2.put("module", hudSettingModule);
                hud3.put("order", Helper.Enums.toEnumList((a, b) -> Module.fromString(b), new ArrayList<String>(List.of(((String)hud3.get("order")).split(" "))), Module.class));
                hud3.put("setting", hudSetting2);
                base.put("destination", dest2);
                base.put("hud", hud3);
                base.put("color_presets", PlayerData.getDefaults().getColorPresets());
                base = this.saveLoad(base);
            }
            if (base.get("version").equals(1.5)) {
                base.put("version", 1.6);
                base.put("temp", null);
                base.put("inbox", new ArrayList());
                hud = (Map)base.get("hud");
                hudSetting = (Map)hud.get("setting");
                hudSetting.put("state", hud.get("enabled"));
                hud.put("setting", hudSetting);
                hud.put("enabled", null);
                base.put("hud", hud);
                base = this.saveLoad(base);
            }
            if (base.get("version").equals(1.6)) {
                base.put("version", 1.7);
                hud = (Map)base.get("hud");
                hudSetting = (Map)hud.get("setting");
                Map hudModuleSetting = (Map)hudSetting.get("module");
                hudModuleSetting.put("tracking_hybrid", true);
                hudModuleSetting.put("tracking_type", "simple");
                hudModuleSetting.put("speed_pattern", "0.00");
                hudModuleSetting.put("speed_3d", true);
                hudModuleSetting.put("angle_display", "both");
                hudSetting.put("module", hudModuleSetting);
                hud.put("setting", hudSetting);
                Map hudModule = (Map)hud.get("module");
                hudModule.put("speed", ((BaseModule)HUD_defaults.getModule(Module.SPEED)).isEnabled());
                hudModule.put("angle", ((BaseModule)HUD_defaults.getModule(Module.ANGLE)).isEnabled());
                hud.put("module", hudModule);
                base.put("hud", hud);
                base.put("color_presets", DHud.preset.custom.updateTo1_7((ArrayList)base.get("color_presets")));
                base = this.saveLoad(base);
            }
            if (base.get("version").equals(1.71)) {
                base.put("version", 1.7);
                base.put("order", null);
            }
            if (base.get("version").equals(1.7)) {
                base.put("version", 1.72);
                hud = (Map)base.get("hud");
                hud.put("order", Helper.Enums.toEnumList((a, b) -> Module.fromString(b.toLowerCase()), (ArrayList)hud.get("order"), Module.class));
                base.put("hud", hud);
                base.put("module", null);
                base = this.saveLoad(base);
            }
            if (base.get("version").equals(1.72)) {
                base.put("version", 2.0);
                base.put("color_presets", DHud.preset.custom.updateTo2_0((ArrayList)base.get("color_presets")));
                base.put("inbox", new ArrayList());
                hud = (Map)base.get("hud");
                String[] primary = ((String)hud.get("primary")).split("-");
                String[] secondary = ((String)hud.get("secondary")).split("-");
                hud.put("primary", new PDHud.Color(primary[0], primary[1].equals("true"), primary[2].equals("true"), primary[3].equals("true")));
                hud.put("secondary", new PDHud.Color(secondary[0], secondary[1].equals("true"), secondary[2].equals("true"), secondary[3].equals("true")));
                Map dest4 = (Map)base.get("destination");
                Loc destination = new Loc(true, (String)dest4.get("dest"));
                if (destination.getDimension() != null) {
                    destination.setDimension(Utl.dim.updateLegacy(destination.getDimension()));
                }
                dest4.put("dest", destination);
                ArrayList lastdeath4 = (ArrayList)dest4.get("lastdeath");
                ArrayList newLastdeath = lastdeath4.stream().map(string -> {
                    Loc loc = new Loc(true, (String)string);
                    if (loc.getDimension() != null) {
                        loc.setDimension(Utl.dim.updateLegacy(loc.getDimension()));
                    }
                    return loc;
                }).collect(Collectors.toCollection(ArrayList::new));
                dest4.put("lastdeath", newLastdeath);
                ArrayList saved4 = (ArrayList)dest4.get("saved");
                ArrayList newSaved = saved4.stream().map(entry -> {
                    Loc loc = new Loc(true, (String)entry.get(1));
                    Dest destLoc = new Dest(loc, (String)entry.get(0), (String)entry.get(2));
                    destLoc.setDimension(Utl.dim.updateLegacy(loc.getDimension()));
                    return destLoc;
                }).collect(Collectors.toCollection(ArrayList::new));
                dest4.put("saved", newSaved);
                dest4.put("tracking", dest4.get("track"));
                dest4.put("track", null);
            }
            this.mapToFile(base);
        }
    }
}

