/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import one.oth3r.directionhud.common.Assets;
import one.oth3r.directionhud.common.DHud;
import one.oth3r.directionhud.common.Destination;
import one.oth3r.directionhud.common.LoopManager;
import one.oth3r.directionhud.common.files.FileData;
import one.oth3r.directionhud.common.files.ModuleText;
import one.oth3r.directionhud.common.files.dimension.Dimension;
import one.oth3r.directionhud.common.files.dimension.DimensionEntry;
import one.oth3r.directionhud.common.files.playerdata.PDHud;
import one.oth3r.directionhud.common.files.playerdata.PlayerData;
import one.oth3r.directionhud.common.hud.HudColor;
import one.oth3r.directionhud.common.hud.module.BaseModule;
import one.oth3r.directionhud.common.hud.module.Module;
import one.oth3r.directionhud.common.hud.module.ModuleInstructions;
import one.oth3r.directionhud.common.hud.module.modules.ModuleAngle;
import one.oth3r.directionhud.common.hud.module.modules.ModuleCoordinates;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDestination;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDirection;
import one.oth3r.directionhud.common.hud.module.modules.ModuleDistance;
import one.oth3r.directionhud.common.hud.module.modules.ModuleSpeed;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTime;
import one.oth3r.directionhud.common.hud.module.modules.ModuleTracking;
import one.oth3r.directionhud.common.hud.module.modules.ModuleWeather;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Dest;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Lang;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.common.utils.Rainbow;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;

public class Hud {
    public static final Lang LANG = new Lang("hud.");
    public static CTxT BUTTON = ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#29ff69")).click(1, "/hud")).hover(((CTxT)CTxT.of("/hud").color("#29ff69")).append("\n").append(LANG.hover()));

    public static void CMDExecutor(Player player, String[] args) {
        if (!Helper.checkEnabled(player).hud()) {
            return;
        }
        if (args.length == 0) {
            Hud.UI(player, null);
            return;
        }
        String type = args[0].toLowerCase();
        String[] trimmedArgs = Helper.trimStart(args, 1);
        switch (type) {
            case "modules": {
                modules.CMDExecutor(player, trimmedArgs);
                break;
            }
            case "settings": {
                settings.CMDExecutor(player, trimmedArgs);
                break;
            }
            case "color": {
                color.cmdExecutor(player, trimmedArgs);
                break;
            }
            case "toggle": {
                settings.change(player, Setting.state, (Boolean)player.getPCache().getHud().getSetting(Setting.state) != false ? "off" : "on", false);
                break;
            }
            default: {
                player.sendMessage(CUtl.error("command", new Object[0]));
            }
        }
    }

    public static ArrayList<String> CMDSuggester(Player player, int pos, String[] args) {
        ArrayList<String> suggester = new ArrayList<String>();
        if (!Helper.checkEnabled(player).hud()) {
            return suggester;
        }
        if (pos == 1) {
            suggester.add("modules");
            suggester.add("color");
            suggester.add("toggle");
            suggester.add("settings");
        }
        if (pos > 1) {
            String command = args[0].toLowerCase();
            String[] trimmedArgs = Helper.trimStart(args, 1);
            int fixedPos = pos - 2;
            switch (command) {
                case "modules": {
                    suggester.addAll(modules.CMDSuggester(player, fixedPos, trimmedArgs));
                    break;
                }
                case "settings": {
                    suggester.addAll(settings.CMDSuggester(fixedPos, trimmedArgs));
                    break;
                }
                case "color": {
                    suggester.addAll(color.cmdSuggester(player, fixedPos, trimmedArgs));
                }
            }
        }
        return suggester;
    }

    public static void UI(Player player, CTxT aboveTxT) {
        CTxT msg = CTxT.of("");
        CTxT line = (CTxT)CTxT.of("\n                            ").strikethrough(true);
        if (aboveTxT != null) {
            msg.append(aboveTxT).append("\n");
        }
        msg.append(" ").append((CTxT)LANG.ui("commands", new Object[0]).color(CUtl.p())).append(line).append("\n ");
        msg.append(color.button()).append(" ");
        msg.append(settings.button()).append("\n\n ");
        msg.append(modules.button()).append(" ");
        msg.append(CUtl.CButton.back("/dhud"));
        msg.append(line);
        player.sendMessage(msg);
    }

    public static class modules {
        public static final String SETTING_ON = "on";
        public static final String SETTING_OFF = "off";
        public static final List<String> SUGGESTER_ON_OFF = List.of("on", "off");
        public static final Lang LANG = new Lang("hud.module.");
        public static final String STATE_GREEN = "#19ff21";
        public static final String STATE_YELLOW = "#fff419";
        public static final String STATE_GRAY = "#8d8d8d";

        public static CTxT button() {
            return ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).color("#665dff")).click(1, "/hud modules")).hover(((CTxT)CTxT.of("/hud modules (order, toggle, reset)").color("#665dff")).append("\n").append(LANG.hover()));
        }

        public static void CMDExecutor(Player player, String[] args) {
            if (args.length == 0) {
                modules.UI(player, null);
                return;
            }
            boolean Return = args[0].contains("-r");
            args[0] = args[0].replace("-r", "");
            if (args[0].equals("reset")) {
                if (args.length == 1) {
                    modules.reset(player, Module.UNKNOWN, Return);
                } else {
                    modules.reset(player, Module.fromString(args[1]), Return);
                }
            }
            if (args[0].equals("toggle")) {
                if (args.length < 2) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                } else {
                    modules.toggle(player, Module.fromString(args[1]), null, Return);
                }
            }
            if (args[0].equals("edit")) {
                if (args.length < 2) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                } else {
                    Edit.UI(player, null, Module.fromString(args[1]));
                }
            }
            if (args[0].equals("setting")) {
                if (args.length < 4) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                } else {
                    Setting.setSetting(player, Module.fromString(args[1]), args[2], args[3], Return);
                }
            }
            if (args[0].equals("order")) {
                if (args.length < 2) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                } else if (args.length == 3 && Helper.Num.isInt(args[2])) {
                    modules.move(player, Module.fromString(args[1]), Integer.parseInt(args[2]), Return);
                } else {
                    player.sendMessage(CUtl.error("number", new Object[0]));
                }
            }
        }

        public static ArrayList<String> CMDSuggester(Player player, int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (pos == 0) {
                suggester.add("order");
                suggester.add("toggle");
                suggester.add("reset");
                suggester.add("edit");
                suggester.add("setting");
                return suggester;
            }
            args[0] = args[0].replaceAll("-r", "");
            if (pos == 1) {
                if (args[0].equals("setting")) {
                    suggester.addAll(PlayerData.getDefaults().getHud().getModules().stream().filter(BaseModule::hasExtraSettings).map(mod -> mod.getModuleType().getName()).toList());
                } else {
                    suggester.addAll(PlayerData.getDefaults().getHud().getModules().stream().map(mod -> mod.getModuleType().getName()).toList());
                }
            }
            if (pos == 2 && args[0].equalsIgnoreCase("order")) {
                suggester.add(String.valueOf(((BaseModule)player.getPCache().getHud().getModule(Module.fromString(args[1]))).getOrder()));
            }
            if (args[0].equalsIgnoreCase("setting")) {
                if (pos == 2) {
                    Module module = Module.fromString(args[1]);
                    if (module.equals((Object)Module.UNKNOWN)) {
                        return suggester;
                    }
                    Object mod2 = player.getPCache().getHud().getModule(module);
                    String[] settingIDs = ((BaseModule)mod2).getSettingIDs();
                    if (settingIDs.length == 0) {
                        return suggester;
                    }
                    suggester.addAll(Arrays.asList(settingIDs));
                }
                if (pos == 3) {
                    String settingID;
                    switch (settingID = args[2]) {
                        case "xyz-display": {
                            suggester.addAll(SUGGESTER_ON_OFF);
                            break;
                        }
                        case "display": {
                            suggester.addAll(Helper.Enums.toStringList((Enum[])ModuleAngle.Display.values()));
                            break;
                        }
                        case "24hr-clock": {
                            suggester.addAll(SUGGESTER_ON_OFF);
                            break;
                        }
                        case "2d-calculation": {
                            suggester.addAll(SUGGESTER_ON_OFF);
                            break;
                        }
                        case "display-pattern": {
                            suggester.addAll(List.of("0.00", "0.##", "0.00##"));
                            break;
                        }
                        case "hybrid": {
                            suggester.addAll(SUGGESTER_ON_OFF);
                            break;
                        }
                        case "display-type": {
                            suggester.addAll(Helper.Enums.toStringList((Enum[])ModuleTracking.Type.values()));
                            break;
                        }
                        case "target": {
                            suggester.addAll(Helper.Enums.toStringList((Enum[])ModuleTracking.Target.values()));
                            break;
                        }
                        case "show-elevation": {
                            suggester.addAll(SUGGESTER_ON_OFF);
                        }
                    }
                }
            }
            return suggester;
        }

        public static void reset(Player player, Module module, boolean Return) {
            CTxT msg = CUtl.tag();
            if (module.equals((Object)Module.UNKNOWN)) {
                player.getPData().getHud().setModules(PlayerData.getDefaults().getHud().getModules());
                msg.append(LANG.msg("reset_all", CUtl.LANG.btn("all", new Object[0]).color('c')));
            } else {
                Object resetModule = PlayerData.getDefaults().getHud().getModule(module);
                Object mod = player.getPData().getHud().getModule(module);
                ArrayList<BaseModule> list = player.getPData().getHud().getModules();
                Helper.moveTo(list, ((BaseModule)mod).getOrder() - 1, ((BaseModule)resetModule).getOrder() - 1);
                modules.setOrder(list);
                player.getPData().getHud().setModule((BaseModule)resetModule);
                msg.append(LANG.msg("reset", CTxT.of(module.toString()).color(CUtl.s())));
                if (Return) {
                    Edit.UI(player, msg, module);
                    return;
                }
            }
            if (Return) {
                modules.UI(player, msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static void move(Player player, Module module, int pos, boolean Return) {
            if (module.equals((Object)Module.UNKNOWN)) {
                player.sendMessage(CUtl.error("hud.module", new Object[0]));
                return;
            }
            ArrayList<BaseModule> list = player.getPData().getHud().getModules();
            Helper.moveTo(list, ((BaseModule)player.getPData().getHud().getModule(module)).getOrder() - 1, --pos);
            modules.setOrder(list);
            player.getPData().queueSave();
            int order = BaseModule.findInArrayList(list, module).orElse((BaseModule)player.getPData().getHud().getModule(module)).getOrder();
            CTxT msg = CUtl.tag().append(LANG.msg("order", CTxT.of(module.toString()).color(CUtl.s()), CTxT.of(String.valueOf(order)).color(CUtl.s())));
            if (Return) {
                Edit.UI(player, msg, module);
            } else {
                player.sendMessage(msg);
            }
        }

        public static void toggle(Player player, Module module, Boolean toggle, boolean Return) {
            if (module.equals((Object)Module.UNKNOWN)) {
                player.sendMessage(CUtl.error("hud.module", new Object[0]));
                return;
            }
            Object mod = player.getPData().getHud().getModule(module);
            if (toggle == null) {
                toggle = !((BaseModule)mod).isEnabled();
            }
            ((BaseModule)mod).setState(toggle);
            player.getPData().queueSave();
            CTxT msg = CUtl.tag().append(LANG.msg("state", CTxT.of(module.toString()).color(CUtl.s()), CUtl.toggleTxT(toggle)));
            if (Return) {
                Edit.UI(player, msg, module);
            } else {
                player.sendMessage(msg);
            }
        }

        public static void fixOrder(ArrayList<BaseModule> list) {
            modules.fixOrder(list, false);
        }

        public static void fixOrder(ArrayList<BaseModule> list, boolean getFactoryDefault) {
            ArrayList<BaseModule> defaultList = getFactoryDefault ? new PDHud().getModules() : PlayerData.getDefaults().getHud().getModules();
            Helper.removeDuplicateSubclasses(list);
            if (list.size() > defaultList.size()) {
                list.clear();
                list.addAll(defaultList);
                return;
            }
            list.sort(Comparator.comparingInt(BaseModule::getOrder));
            modules.setOrder(list);
            defaultList.stream().filter(mod -> list.stream().noneMatch(module -> module.getClass().equals(mod.getClass()))).forEach(list::add);
        }

        public static void setOrder(ArrayList<BaseModule> list) {
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).setOrder(i + 1);
            }
        }

        public static ArrayList<BaseModule> getEnabled(Player player) {
            return player.getPCache().getHud().getModules().stream().filter(BaseModule::isEnabled).collect(Collectors.toCollection(ArrayList::new));
        }

        public static CTxT moduleExample(Player player, Module module) {
            Object mod = player.getPData().getHud().getModule(module);
            Random random = new Random();
            Loc randomLoc = new Loc((Integer)random.nextInt(5000), (Integer)random.nextInt(-64, 200), random.nextInt(5000));
            float randomRotation = random.nextFloat(0.0f, 360.0f);
            DimensionEntry.Time.Weather.Icons defaultIcons = DimensionEntry.Time.Weather.Icons.defaultIcons();
            return CUtl.parse(player, switch (module) {
                case Module.DISTANCE -> build.getDistanceModule((ModuleDistance)mod, random.nextInt(50, 250));
                case Module.DESTINATION -> build.getDestinationModule((ModuleDestination)mod, new Dest(randomLoc, "a", "#ffffff"));
                case Module.DIRECTION -> build.getDirectionModule((ModuleDirection)mod, randomRotation);
                case Module.TRACKING -> build.getTrackingModule((ModuleTracking)mod, randomRotation, player.getLoc(), randomLoc);
                case Module.TIME -> build.getTimeModule((ModuleTime)mod, random.nextInt(1, 25), random.nextInt(0, 60));
                case Module.WEATHER -> build.getWeatherModule((ModuleWeather)mod, random.nextBoolean() ? defaultIcons.day() : defaultIcons.night(), random.nextBoolean() ? null : (random.nextBoolean() ? defaultIcons.storm() : defaultIcons.thunderstorm()));
                case Module.SPEED -> build.getSpeedModule((ModuleSpeed)mod, random.nextFloat(1.0f, 12.0f));
                case Module.ANGLE -> build.getAngleModule((ModuleAngle)mod, random.nextFloat(-180.0f, 180.1f), random.nextFloat(-90.0f, 90.1f));
                default -> build.getCoordinatesModule((ModuleCoordinates)mod, randomLoc);
            });
        }

        public static CTxT moduleInfo(Module module) {
            return LANG.get("info." + module.getName(), new Object[0]);
        }

        public static String stateColor(Player player, Module module) {
            if (module.equals((Object)Module.UNKNOWN)) {
                return "#ff4646";
            }
            Object mod = player.getPCache().getHud().getModule(module);
            if (!((BaseModule)mod).isEnabled()) {
                return STATE_GRAY;
            }
            String color2 = STATE_GREEN;
            if (!Destination.dest.get(player).hasXYZ() && (module.equals((Object)Module.DESTINATION) || module.equals((Object)Module.DISTANCE))) {
                color2 = STATE_YELLOW;
            }
            if (module.equals((Object)Module.TRACKING)) {
                boolean hasPlayer = Destination.social.track.getTarget(player).isValid();
                boolean hasDest = Destination.dest.get(player).hasXYZ();
                ModuleTracking.Target target = ((ModuleTracking)mod).getTarget();
                if (((ModuleTracking)mod).isHybrid()) {
                    if (!hasPlayer && !hasDest) {
                        color2 = STATE_YELLOW;
                    }
                } else if (target.equals((Object)ModuleTracking.Target.player)) {
                    if (!hasPlayer) {
                        color2 = STATE_YELLOW;
                    }
                } else if (target.equals((Object)ModuleTracking.Target.dest) && !hasDest) {
                    color2 = STATE_YELLOW;
                }
            }
            return color2;
        }

        public static boolean canReset(BaseModule module) {
            Object defaultModule = PlayerData.getDefaults().getHud().getModule(module.getModuleType());
            return !((BaseModule)defaultModule).equals(module);
        }

        public static void UI(Player player, CTxT aboveTxT) {
            CTxT msg = CTxT.of("");
            CTxT line = CUtl.makeLine(45);
            if (aboveTxT != null) {
                msg.append(aboveTxT).append("\n");
            }
            msg.append(" ").append((CTxT)LANG.ui().color("#665dff")).append(line);
            HashMap<Module, CTxT> modules2 = new HashMap<Module, CTxT>();
            for (Module module : Module.values()) {
                if (module.equals((Object)Module.UNKNOWN)) continue;
                String name = module.getName();
                CTxT moduleButton = ((CTxT)((CTxT)((CTxT)new CTxT(name).btn(true)).color(modules.stateColor(player, module))).click(1, "/hud modules edit " + name)).hover(new CTxT().append((CTxT)CTxT.of(name).color("#665dff")).append(": ").append(modules.moduleExample(player, module)).append("\n").append((CTxT)modules.moduleInfo(module).color('7')).append("\n\n").append(Edit.LANG.hover("cycle", new CTxT(name).color(CUtl.s()))));
                modules2.put(module, moduleButton);
            }
            msg.append("\n ");
            msg.append((CTxT)modules2.get((Object)Module.COORDINATES)).append(" ");
            msg.append((CTxT)modules2.get((Object)Module.WEATHER)).append(" ");
            msg.append((CTxT)modules2.get((Object)Module.TIME)).append(" ");
            msg.append("\n\n ");
            msg.append((CTxT)modules2.get((Object)Module.DESTINATION)).append(" ");
            msg.append((CTxT)modules2.get((Object)Module.DISTANCE)).append(" ");
            msg.append((CTxT)modules2.get((Object)Module.TRACKING)).append(" ");
            msg.append("\n\n ");
            msg.append((CTxT)modules2.get((Object)Module.DIRECTION)).append(" ");
            msg.append((CTxT)modules2.get((Object)Module.ANGLE)).append(" ");
            msg.append((CTxT)modules2.get((Object)Module.SPEED)).append(" ");
            CTxT reset = (CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('7');
            if (player.getPData().getHud().getModules().stream().anyMatch(modules::canReset)) {
                ((CTxT)((CTxT)reset.color('c')).click(1, "/hud modules reset-r")).hover(((CTxT)CUtl.LANG.hover("reset", new Object[0]).color('c')).append("\n").append(LANG.hover("reset.all", CUtl.LANG.hover("reset.fill", new Object[0]).color('c'), LANG.hover("reset.all.fill", new Object[0]).color(CUtl.s()))));
            }
            msg.append("\n\n ").append(reset).append("  ").append(CUtl.CButton.back("/hud")).append(line);
            player.sendMessage(msg);
        }

        public static class Edit {
            public static final Lang LANG = new Lang("hud.module.edit.");

            public static void UI(Player player, CTxT aboveTxT, Module module) {
                CTxT msg = CTxT.of("");
                CTxT line = CUtl.makeLine(37);
                if (aboveTxT != null) {
                    msg.append(aboveTxT).append("\n");
                }
                Object mod = player.getPCache().getHud().getModule(module);
                boolean state = ((BaseModule)mod).isEnabled();
                CTxT toggle = ((CTxT)((CTxT)((CTxT)CTxT.of("\u21c4").btn(true)).color(CUtl.toggleColor(state))).click(1, "/hud modules toggle-r " + String.valueOf((Object)module))).hover(((CTxT)LANG.hover("toggle", new Object[0]).color("#665dff")).append("\n").append(LANG.hover("toggle.click", CTxT.of(module.getName()).color(CUtl.s()), CUtl.LANG.btn(!state ? modules.SETTING_ON : modules.SETTING_OFF, new Object[0]).color(!state ? (char)'a' : 'c'))));
                msg.append(" ").append((CTxT)LANG.ui().color("#665dff"));
                msg.append(line);
                msg.append("\n ").append(Edit.createPreviewBar(player, module));
                msg.append(line);
                msg.append("\n ").append(toggle).append(" ").append(Edit.createModuleOrderUI(player, module)).append(" ");
                CTxT extraSettings = Setting.getSettingButtons(player, module);
                if (!extraSettings.isEmpty()) {
                    msg.append("\n\n ").append(extraSettings);
                }
                msg.append("\n\n ").append(Edit.createModuleSwitcher(player, module));
                CTxT reset = (CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('7');
                if (modules.canReset(mod)) {
                    ((CTxT)((CTxT)reset.color('c')).click(1, "/hud modules reset-r " + module.getName())).hover(new CTxT((CTxT)CUtl.LANG.hover("reset", new Object[0]).color('c')).append("\n").append(LANG.hover("reset.click", CUtl.LANG.hover("reset.fill", new Object[0]).color('c'), new CTxT(module.getName()).color(CUtl.s()))));
                }
                msg.append("\n\n ").append(reset);
                msg.append("  ").append(CUtl.CButton.back("/hud modules"));
                msg.append(line);
                player.sendMessage(msg);
            }

            private static CTxT createPreviewBar(Player player, Module module) {
                CTxT refresh = ((CTxT)((CTxT)((CTxT)new CTxT("\ud83d\udd01").btn(true)).color('a')).click(1, "/hud modules edit " + String.valueOf((Object)module))).hover(((CTxT)LANG.hover("refresh", new Object[0]).color('a')).append("\n").append(LANG.hover("refresh.click", LANG.hover("refresh.click.fill", new Object[0]).color('a'))));
                CTxT preview = modules.moduleExample(player, module).hover(((CTxT)LANG.hover("preview", new Object[0]).color("#665dff")).append("\n").append((CTxT)LANG.hover("preview.info", new Object[0]).color('7')));
                return new CTxT().append(refresh).append(" ").append(preview);
            }

            private static CTxT createModuleSwitcher(Player player, Module module) {
                String stateColor;
                ArrayList<BaseModule> modules2 = player.getPCache().getHud().getModules();
                Object mod = player.getPCache().getHud().getModule(module);
                int moduleIndex = ((BaseModule)mod).getOrder() - 1;
                boolean leftEnabled = moduleIndex > 0;
                boolean rightEnabled = moduleIndex < modules2.size() - 1;
                CTxT leftArrow = (CTxT)((CTxT)CTxT.of("\u25c0").btn(true)).color(modules.STATE_GRAY);
                CTxT rightArrow = (CTxT)((CTxT)CTxT.of("\u25b6").btn(true)).color(modules.STATE_GRAY);
                CTxT hover = ((CTxT)LANG.hover().color("#665dff")).append("\n");
                if (leftEnabled) {
                    ((CTxT)leftArrow.color("#665dff")).hover(CTxT.of(hover).append(LANG.hover("cycle", LANG.hover("cycle.previous", new Object[0]).color(CUtl.s())))).click(1, "/hud modules edit " + modules2.get(moduleIndex - 1).getModuleType().getName());
                }
                if (rightEnabled) {
                    ((CTxT)rightArrow.color("#665dff")).hover(CTxT.of(hover).append(LANG.hover("cycle", LANG.hover("cycle.next", new Object[0]).color(CUtl.s())))).click(1, "/hud modules edit " + modules2.get(moduleIndex + 1).getModuleType().getName());
                }
                CTxT status = LANG.hover("status." + (switch (stateColor = modules.stateColor(player, module)) {
                    case modules.STATE_GREEN -> "enabled";
                    case modules.STATE_YELLOW -> "no_data";
                    default -> "disabled";
                }), new Object[0]);
                status.color(stateColor);
                CTxT moduleTxT = (CTxT)((CTxT)((CTxT)CTxT.of(module.getName()).btn(true)).color(modules.stateColor(player, module))).hover(new CTxT().append((CTxT)CTxT.of(module.getName()).color("#665dff")).append("\n").append(LANG.hover("status", status)).append("\n").append((CTxT)LANG.get("info." + module.getName(), new Object[0]).color('7')).append("\n\n").append(LANG.hover("change", new Object[0]))).click(2, "/hud modules edit ");
                return new CTxT().append(leftArrow).append(" ").append(moduleTxT).append(" ").append(rightArrow);
            }

            private static CTxT createOrderMoveButton(String text, boolean enabled, String hoverKey, String hoverKeySecondary, String setCMD) {
                String enabledColor = CUtl.s();
                String disabledColor = modules.STATE_GRAY;
                CTxT button = (CTxT)((CTxT)LANG.btn().text(text).btn(true)).color(enabled ? enabledColor : modules.STATE_GRAY);
                if (!enabled) {
                    return button;
                }
                ((CTxT)button.click(1, setCMD)).hover(((CTxT)LANG.hover("order", new Object[0]).color("#665dff")).append("\n").append(LANG.hover("order.move." + hoverKey, LANG.hover("order.move." + hoverKey + "." + hoverKeySecondary, new Object[0]).color(CUtl.s()))));
                return button;
            }

            private static CTxT createModuleOrderUI(Player player, Module module) {
                int currentOrder = ((BaseModule)player.getPCache().getHud().getModule(module)).getOrder();
                int moduleIndex = currentOrder - 1;
                boolean leftEnabled = moduleIndex > 0;
                boolean rightEnabled = moduleIndex < player.getPCache().getHud().getModules().size() - 1;
                String cmd = "/hud modules order-r " + module.getName() + " ";
                CTxT moveLeftMost = Edit.createOrderMoveButton("\u23ee", leftEnabled, "most", "first", cmd + "1");
                CTxT moveLeft = Edit.createOrderMoveButton("\u25c0", leftEnabled, "one", "up", cmd + (currentOrder - 1));
                CTxT moveRight = Edit.createOrderMoveButton("\u25b6", rightEnabled, "one", "down", cmd + (currentOrder + 1));
                CTxT moveRightMost = Edit.createOrderMoveButton("\u23ed", rightEnabled, "most", "last", cmd + "100");
                CTxT currentPosition = (CTxT)((CTxT)((CTxT)new CTxT(String.valueOf(currentOrder)).btn(true)).color("#665dff")).hover(((CTxT)LANG.hover("order", new Object[0]).color("#665dff")).append("\n").append((CTxT)LANG.hover("order.info", new Object[0]).color('7')).append("\n\n").append(LANG.hover("order.set", new Object[0]))).click(2, cmd);
                return new CTxT().append(moveLeftMost).append(moveLeft).append(currentPosition).append(moveRight).append(moveRightMost);
            }
        }

        public static class Setting {
            public static final Lang LANG = new Lang("hud.module.setting.");

            public static void setSetting(Player player, Module module, String settingID, String value, boolean Return) {
                Object mod = player.getPData().getHud().getModule(module);
                if (!((BaseModule)mod).hasExtraSettings()) {
                    player.sendMessage(LANG.error("no_settings", CTxT.of(module.getName()).color(CUtl.s())));
                    return;
                }
                if (Arrays.stream(((BaseModule)mod).getSettingIDs()).noneMatch(settingID::equals)) {
                    player.sendMessage(LANG.error("invalid", CTxT.of(module.getName()).color(CUtl.s())));
                    return;
                }
                CTxT msg = CUtl.tag();
                CTxT invalidSettingValue = LANG.error("invalid.setting_value", LANG.get(module.getName() + "." + settingID, new Object[0]).color(CUtl.s()));
                boolean state = value.equals(modules.SETTING_ON);
                switch (module) {
                    case COORDINATES: {
                        ModuleCoordinates coordinatesModule = (ModuleCoordinates)mod;
                        coordinatesModule.setXyz(state);
                        player.getPData().getHud().setModule(coordinatesModule);
                        msg.append(SetMSG.customToggle(module, settingID, state));
                        break;
                    }
                    case TIME: {
                        ModuleTime timeModule = (ModuleTime)mod;
                        timeModule.setHour24(state);
                        player.getPData().getHud().setModule(timeModule);
                        msg.append(SetMSG.customToggle(module, settingID, state));
                        break;
                    }
                    case TRACKING: {
                        ModuleTracking trackingModule = (ModuleTracking)mod;
                        switch (settingID) {
                            case "hybrid": {
                                trackingModule.setHybrid(state);
                                msg.append(SetMSG.toggle(module, settingID, state));
                                break;
                            }
                            case "target": {
                                ModuleTracking.Target newTarget = Helper.Enums.search(value, ModuleTracking.Target.class).orElse(null);
                                if (newTarget == null) {
                                    player.sendMessage(invalidSettingValue);
                                    return;
                                }
                                trackingModule.setTarget(newTarget);
                                msg.append(SetMSG.enumString(module, settingID, newTarget.name()));
                                break;
                            }
                            case "display-type": {
                                ModuleTracking.Type newType = Helper.Enums.search(value, ModuleTracking.Type.class).orElse(null);
                                if (newType == null) {
                                    player.sendMessage(invalidSettingValue);
                                    return;
                                }
                                trackingModule.setType(newType);
                                msg.append(SetMSG.enumString(module, settingID, newType.name()));
                                break;
                            }
                            case "show-elevation": {
                                trackingModule.setElevation(state);
                                msg.append(SetMSG.toggle(module, settingID, state));
                                break;
                            }
                            default: {
                                player.sendMessage(LANG.error("invalid", CTxT.of(module.getName()).color(CUtl.s())));
                                return;
                            }
                        }
                        player.getPData().getHud().setModule(trackingModule);
                        break;
                    }
                    case SPEED: {
                        ModuleSpeed speedModule = (ModuleSpeed)mod;
                        switch (settingID) {
                            case "2d-calculation": {
                                speedModule.setCalculation2D(state);
                                msg.append(SetMSG.customToggle(module, settingID, state));
                                break;
                            }
                            case "display-pattern": {
                                try {
                                    new DecimalFormat(value);
                                    speedModule.setDisplayPattern(value);
                                }
                                catch (IllegalArgumentException ignored) {
                                    player.sendMessage(invalidSettingValue);
                                    return;
                                }
                                msg.append(SetMSG.custom(module, settingID, CTxT.of(value)));
                                break;
                            }
                            default: {
                                player.sendMessage(LANG.error("invalid", CTxT.of(module.getName()).color(CUtl.s())));
                                return;
                            }
                        }
                        player.getPData().getHud().setModule(speedModule);
                        break;
                    }
                    case ANGLE: {
                        ModuleAngle angleModule = (ModuleAngle)mod;
                        ModuleAngle.Display newDisplay = Helper.Enums.search(value, ModuleAngle.Display.class).orElse(null);
                        if (newDisplay == null) {
                            player.sendMessage(invalidSettingValue);
                            return;
                        }
                        angleModule.setDisplay(newDisplay);
                        msg.append(SetMSG.enumString(module, settingID, newDisplay.name()));
                        player.getPData().getHud().setModule(angleModule);
                    }
                }
                if (Return) {
                    Edit.UI(player, msg, module);
                } else {
                    player.sendMessage(msg);
                }
            }

            public static CTxT getSettingButtons(Player player, Module module) {
                boolean state;
                String settingID;
                Lang lang = new Lang("hud.module.setting.");
                Lang moduleLang = new Lang("hud.module.setting." + module.getName() + ".");
                Object mod = player.getPCache().getHud().getModule(module);
                String setCMD = "/hud modules setting-r " + module.getName() + " ";
                CTxT button = CTxT.of("");
                if (module.equals((Object)Module.COORDINATES)) {
                    ModuleCoordinates coordinatesModule = (ModuleCoordinates)mod;
                    settingID = "xyz-display";
                    state = coordinatesModule.isXyz();
                    button.append((CTxT)((CTxT)((CTxT)moduleLang.get(settingID + "." + (state ? modules.SETTING_ON : modules.SETTING_OFF), new Object[0]).btn(true)).color(CUtl.s())).hover(CTxT.of("").append((CTxT)moduleLang.get(settingID + ".ui", new Object[0]).color('e')).append("\n").append((CTxT)moduleLang.get(settingID + ".info", new Object[0]).color('7')).append("\n\n").append(lang.hover("set", moduleLang.get(settingID, new Object[0]), moduleLang.get(settingID + "." + (state ? modules.SETTING_OFF : modules.SETTING_ON), new Object[0]).color(CUtl.s())))).click(1, setCMD + settingID + " " + (state ? modules.SETTING_OFF : modules.SETTING_ON)));
                }
                if (module.equals((Object)Module.TIME)) {
                    ModuleTime timeModule = (ModuleTime)mod;
                    settingID = "24hr-clock";
                    state = timeModule.isHour24();
                    button.append((CTxT)((CTxT)((CTxT)moduleLang.get(settingID + "." + (state ? modules.SETTING_ON : modules.SETTING_OFF), new Object[0]).btn(true)).color(CUtl.s())).hover(CTxT.of("").append((CTxT)moduleLang.get(settingID + ".ui", new Object[0]).color('e')).append("\n").append((CTxT)moduleLang.get(settingID + ".info", new Object[0]).color('7')).append("\n\n").append(lang.hover("set", moduleLang.get(settingID, new Object[0]), moduleLang.get(settingID + "." + (state ? modules.SETTING_OFF : modules.SETTING_ON), new Object[0]).color(CUtl.s())))).click(1, setCMD + settingID + " " + (state ? modules.SETTING_OFF : modules.SETTING_ON)));
                }
                if (module.equals((Object)Module.TRACKING)) {
                    ModuleTracking trackingModule = (ModuleTracking)mod;
                    String hybridID = "hybrid";
                    boolean hybrid = trackingModule.isHybrid();
                    button.append((CTxT)((CTxT)((CTxT)CTxT.of("\ud83d\udd00").btn(true)).color(hybrid ? (char)'a' : 'c')).hover(CTxT.of("").append((CTxT)moduleLang.get(hybridID + ".ui", new Object[0]).color('e')).append("\n").append((CTxT)moduleLang.get(hybridID + ".info", new Object[0]).color('7')).append("\n\n").append(lang.hover("set.toggle", moduleLang.get(hybridID, new Object[0]), CUtl.toggleTxT(!hybrid)))).click(1, setCMD + hybridID + " " + (hybrid ? modules.SETTING_OFF : modules.SETTING_ON)));
                    button.append(" ");
                    String targetID = "target";
                    ModuleTracking.Target currentTarget = trackingModule.getTarget();
                    ModuleTracking.Target nextTarget = (ModuleTracking.Target)Helper.Enums.next((Enum)currentTarget, ModuleTracking.Target.class, (Enum[])new ModuleTracking.Target[0]);
                    button.append((CTxT)((CTxT)((CTxT)moduleLang.get(targetID + "." + String.valueOf((Object)currentTarget), new Object[0]).btn(true)).color(CUtl.s())).hover(CTxT.of("").append((CTxT)moduleLang.get(targetID + ".ui", new Object[0]).color('e')).append("\n").append((CTxT)moduleLang.get(targetID + ".info", new Object[0]).color('7')).append("\n\n").append(lang.hover("set", moduleLang.get(targetID, new Object[0]), moduleLang.get(targetID + "." + String.valueOf((Object)nextTarget), new Object[0]).color(CUtl.s())))).click(1, setCMD + targetID + " " + String.valueOf((Object)nextTarget)));
                    button.append(" ");
                    String typeID = "display-type";
                    ModuleTracking.Type currentType = trackingModule.getType();
                    ModuleTracking.Type nextType = (ModuleTracking.Type)Helper.Enums.next((Enum)currentType, ModuleTracking.Type.class, (Enum[])new ModuleTracking.Type[0]);
                    button.append((CTxT)((CTxT)((CTxT)CTxT.of(currentType.equals((Object)ModuleTracking.Type.simple) ? "\u25b2" : "\u2b06").btn(true)).color(CUtl.s())).hover(CTxT.of("").append((CTxT)moduleLang.get(typeID + ".ui", new Object[0]).color('e')).append(" - ").append((CTxT)modules.moduleExample(player, Module.TRACKING).color(CUtl.s())).append("\n").append((CTxT)moduleLang.get(typeID + "." + String.valueOf((Object)currentType) + ".info", new Object[0]).color('7')).append("\n\n").append(lang.hover("set", moduleLang.get(typeID, new Object[0]), moduleLang.get(typeID + "." + String.valueOf((Object)nextType), new Object[0]).color(CUtl.s())))).click(1, setCMD + typeID + " " + String.valueOf((Object)nextType)));
                    button.append(" ");
                    String elevationID = "show-elevation";
                    boolean elevation = trackingModule.hasElevation();
                    button.append((CTxT)((CTxT)((CTxT)CTxT.of("\u26f0").btn(true)).color(elevation ? (char)'a' : 'c')).hover(CTxT.of("").append((CTxT)moduleLang.get(elevationID + ".ui", new Object[0]).color('e')).append("\n").append((CTxT)moduleLang.get(elevationID + ".info", new Object[0]).color('7')).append("\n\n").append(lang.hover("set.toggle", moduleLang.get(elevationID, new Object[0]), CUtl.toggleTxT(!elevation)))).click(1, setCMD + elevationID + " " + (elevation ? modules.SETTING_OFF : modules.SETTING_ON)));
                }
                if (module.equals((Object)Module.SPEED)) {
                    ModuleSpeed speedModule = (ModuleSpeed)mod;
                    String calculation2DID = "2d-calculation";
                    boolean is2D = speedModule.isCalculation2D();
                    button.append((CTxT)((CTxT)((CTxT)moduleLang.get(calculation2DID + "." + (is2D ? modules.SETTING_ON : modules.SETTING_OFF), new Object[0]).btn(true)).color(CUtl.s())).hover(CTxT.of("").append((CTxT)moduleLang.get(calculation2DID + ".ui", new Object[0]).color(CUtl.s())).append("\n").append((CTxT)moduleLang.get(calculation2DID + "." + (is2D ? modules.SETTING_ON : modules.SETTING_OFF) + ".info", new Object[0]).color('7')).append("\n\n").append(lang.hover("set", moduleLang.get(calculation2DID, new Object[0]), moduleLang.get(calculation2DID + "." + (is2D ? modules.SETTING_OFF : modules.SETTING_ON), new Object[0]).color(CUtl.s())))).click(1, setCMD + calculation2DID + " " + (is2D ? modules.SETTING_OFF : modules.SETTING_ON)));
                    button.append(" ");
                    String patternID = "display-pattern";
                    button.append((CTxT)((CTxT)((CTxT)CTxT.of(speedModule.getDisplayPattern()).btn(true)).color(CUtl.s())).hover(CTxT.of("").append((CTxT)moduleLang.get(patternID + ".ui", new Object[0]).color(CUtl.s())).append(" - ").append((CTxT)modules.moduleExample(player, Module.SPEED).color(CUtl.s())).append("\n").append((CTxT)moduleLang.get(patternID + ".info", new Object[0]).color('7')).append("\n").append((CTxT)((CTxT)moduleLang.get(patternID + ".example", new Object[0]).color('7')).italic(true)).append("\n\n").append(lang.hover("set.custom", moduleLang.get(patternID, new Object[0])))).click(2, setCMD + patternID + " "));
                }
                if (module.equals((Object)Module.ANGLE)) {
                    ModuleAngle angleModule = (ModuleAngle)mod;
                    String displayID = "display";
                    ModuleAngle.Display currentType = angleModule.getDisplay();
                    ModuleAngle.Display nextType = (ModuleAngle.Display)Helper.Enums.next((Enum)currentType, ModuleAngle.Display.class, (Enum[])new ModuleAngle.Display[0]);
                    String buttonIcon = switch (currentType) {
                        case ModuleAngle.Display.yaw -> "\u2b0c";
                        case ModuleAngle.Display.pitch -> "\u2b0d";
                        default -> "\u2b0c\u2b0d";
                    };
                    button.append((CTxT)((CTxT)((CTxT)CTxT.of(buttonIcon).btn(true)).color(CUtl.s())).hover(CTxT.of("").append((CTxT)moduleLang.get(displayID + ".ui", new Object[0]).color('e')).append(" - ").append(moduleLang.get(displayID + "." + String.valueOf((Object)currentType), new Object[0])).append("\n").append((CTxT)moduleLang.get(displayID + "." + String.valueOf((Object)currentType) + ".info", new Object[0]).color('7')).append("\n\n").append(lang.hover("set", moduleLang.get(displayID, new Object[0]), moduleLang.get(displayID + "." + String.valueOf((Object)nextType), new Object[0]).color(CUtl.s())))).click(1, setCMD + displayID + " " + String.valueOf((Object)nextType)));
                }
                return button;
            }

            public static class SetMSG {
                public static CTxT customToggle(Module module, String settingID, boolean state) {
                    Lang settingsLang = new Lang(LANG, module.getName() + "." + settingID + ".");
                    return SetMSG.setMSGBuilder("set", module, settingID, (CTxT)settingsLang.get(state ? modules.SETTING_ON : modules.SETTING_OFF, new Object[0]).color(CUtl.s()));
                }

                public static CTxT toggle(Module module, String settingID, boolean state) {
                    return SetMSG.setMSGBuilder("set.toggle", module, settingID, CUtl.toggleTxT(state));
                }

                public static CTxT enumString(Module module, String settingID, String enumString) {
                    Lang settingsLang = new Lang(LANG, module.getName() + "." + settingID + ".");
                    return SetMSG.setMSGBuilder("set", module, settingID, (CTxT)settingsLang.get(enumString, new Object[0]).color(CUtl.s()));
                }

                public static CTxT custom(Module module, String settingID, CTxT customSetMSG) {
                    return SetMSG.setMSGBuilder("set", module, settingID, (CTxT)customSetMSG.color(CUtl.s()));
                }

                private static CTxT setMSGBuilder(String setLang, Module module, String settingID, CTxT setMSG) {
                    return LANG.msg(setLang, LANG.get(module.getName() + "." + settingID, new Object[0]).color(CUtl.s()), setMSG);
                }
            }
        }
    }

    public static class settings {
        public static final Lang LANG = new Lang("hud.setting.");

        public static CTxT button() {
            return ((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("settings", new Object[0]).btn(true)).color("#e9e9e9")).click(1, "/hud settings")).hover(((CTxT)CTxT.of("/hud settings").color("#e9e9e9")).append("\n").append(CUtl.LANG.hover("settings", CUtl.LANG.get("hud", new Object[0]))));
        }

        public static void CMDExecutor(Player player, String[] args) {
            if (args.length == 0) {
                settings.UI(player, null);
                return;
            }
            boolean Return = args[0].contains("-r");
            args[0] = args[0].replace("-r", "");
            if (args[0].equals("reset")) {
                if (args.length == 1) {
                    settings.reset(player, Setting.none, Return);
                } else {
                    settings.reset(player, Setting.get(args[1]), Return);
                }
            }
            if (args[0].equals("set")) {
                if (args.length != 3) {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                }
                settings.change(player, Setting.get(args[1]), args[2], Return);
            }
        }

        public static ArrayList<String> CMDSuggester(int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (pos == 0) {
                suggester.add("set");
                suggester.add("reset");
                return suggester;
            }
            args[0] = args[0].replaceAll("-[rm]", "");
            if (pos == 1) {
                for (Setting s : Setting.values()) {
                    suggester.add(s.toString());
                }
                suggester.remove(Setting.none.toString());
                if (args[0].equals("reset")) {
                    suggester.remove(Setting.bossbar__distance_max.toString());
                }
            }
            if (pos == 2 && args[0].equalsIgnoreCase("set")) {
                if (Helper.Enums.toStringList(Setting.boolSettings()).contains(args[1])) {
                    suggester.add("on");
                    suggester.add("off");
                }
                if (args[1].equalsIgnoreCase(Setting.type.toString())) {
                    suggester.addAll(Helper.Enums.toStringList((Enum[])Setting.DisplayType.values()));
                }
                if (args[1].equalsIgnoreCase(Setting.bossbar__color.toString())) {
                    suggester.addAll(Helper.Enums.toStringList((Enum[])Setting.BarColor.values()));
                }
                if (args[1].equalsIgnoreCase(Setting.bossbar__distance_max.toString())) {
                    suggester.add("0");
                }
            }
            return suggester;
        }

        public static Object getConfig(Setting setting) {
            return PlayerData.getDefaults().getHud().getSetting(setting);
        }

        public static void reset(Player player, Setting setting, boolean Return) {
            if (setting.equals((Object)Setting.bossbar__distance_max)) {
                return;
            }
            if (setting.equals((Object)Setting.none)) {
                for (Setting s : Setting.baseSettings()) {
                    player.getPData().getHud().setSetting(s, settings.getConfig(s));
                }
            } else {
                player.getPData().getHud().setSetting(setting, settings.getConfig(setting));
            }
            if (setting.equals((Object)Setting.bossbar__distance)) {
                player.getPData().getHud().setSetting(Setting.get(String.valueOf((Object)setting) + "_max"), settings.getConfig(Setting.get(String.valueOf((Object)setting) + "_max")));
            }
            player.updateHUD();
            CTxT msg = CUtl.tag().append(LANG.msg("reset", LANG.get("category", LANG.get("category." + (setting.toString().startsWith("bossbar") ? "bossbar" : "hud"), new Object[0]), LANG.get(setting.toString(), new Object[0]).color(CUtl.s()))));
            if (setting.equals((Object)Setting.none)) {
                msg = CUtl.tag().append(LANG.msg("reset_all", CUtl.LANG.btn("all", new Object[0]).color('c')));
            }
            if (Return) {
                settings.UI(player, msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static void change(Player player, Setting setting, String state, boolean Return) {
            boolean bool = state.equals("on");
            CTxT setTxT = CTxT.of("");
            if (setting.equals((Object)Setting.bossbar__distance) || setting.equals((Object)Setting.state)) {
                player.getPData().getHud().setSetting(setting, bool);
                setTxT.append(CUtl.toggleTxT(bool));
            }
            if (setting.equals((Object)Setting.type)) {
                Setting.DisplayType displayType = Setting.DisplayType.get(state);
                player.getPData().getHud().setSetting(setting, (Object)displayType);
                setTxT.append((CTxT)LANG.get(String.valueOf((Object)setting) + "." + String.valueOf((Object)displayType), new Object[0]).color(CUtl.s()));
            }
            if (setting.equals((Object)Setting.bossbar__color)) {
                Setting.BarColor barColor = Helper.Enums.get(state, Setting.BarColor.class);
                player.getPData().getHud().setSetting(setting, (Object)barColor);
                setTxT.append((CTxT)LANG.get(String.valueOf((Object)setting) + "." + String.valueOf((Object)barColor), new Object[0]).color(Assets.barColor(barColor)));
            }
            if (setting.equals((Object)Setting.bossbar__distance_max)) {
                int i = Math.max(Helper.Num.toInt(state), 0);
                player.getPData().getHud().setSetting(setting, i);
                setTxT.append((CTxT)CTxT.of(String.valueOf(i)).color((Boolean)player.getPData().getHud().getSetting(Setting.bossbar__distance) != false ? (char)'a' : 'c'));
            }
            player.updateHUD();
            CTxT msg = CUtl.tag();
            CTxT typeTxT = (CTxT)LANG.get(setting.toString(), new Object[0]).color(CUtl.s());
            String extra = "";
            if (Setting.boolSettings().contains((Object)setting)) {
                extra = ".toggle";
            }
            if (setting.toString().startsWith("bossbar.")) {
                typeTxT = LANG.get("category", LANG.get("category.bossbar", new Object[0]), typeTxT);
            } else if (!setting.toString().startsWith("module.")) {
                typeTxT = LANG.get("category", LANG.get("category.hud", new Object[0]), typeTxT);
            }
            msg.append(LANG.msg("set" + extra, typeTxT, setTxT));
            if (Return) {
                settings.UI(player, msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static boolean canBeReset(Player player, Setting setting) {
            boolean output = false;
            if (setting.equals((Object)Setting.none) || setting.equals((Object)Setting.bossbar__distance_max)) {
                return false;
            }
            if (!player.getPCache().getHud().getSetting(setting).equals(settings.getConfig(setting))) {
                output = true;
            }
            if (setting.equals((Object)Setting.bossbar__distance) && ((Integer)player.getPCache().getHud().getSetting(Setting.bossbar__distance_max)).intValue() != ((Integer)settings.getConfig(Setting.bossbar__distance_max)).intValue()) {
                output = true;
            }
            return output;
        }

        public static CTxT resetBtn(Player player, Setting setting) {
            CTxT msg = (CTxT)((CTxT)CTxT.of("\u2715").btn(true)).color('7');
            if (settings.canBeReset(player, setting)) {
                ((CTxT)((CTxT)msg.color('c')).click(1, "/hud settings reset-r " + String.valueOf((Object)setting))).hover(LANG.hover("reset", CUtl.LANG.hover("reset.fill", new Object[0]).color('c'), LANG.get("category." + (setting.toString().startsWith("bossbar") ? "bossbar" : "hud"), new Object[0]), LANG.get(setting.toString(), new Object[0]).color(CUtl.s())));
            }
            return msg;
        }

        public static CTxT getButtons(Player player, Setting setting) {
            CTxT button = CTxT.of("");
            if (setting.equals((Object)Setting.state)) {
                button.append(CUtl.toggleBtn((Boolean)player.getPCache().getHud().getSetting(setting), "/hud settings set-r " + String.valueOf((Object)setting) + " ")).append(" ");
            }
            if (setting.equals((Object)Setting.type)) {
                Setting.DisplayType nextType = Setting.DisplayType.valueOf((String)player.getPCache().getHud().getSetting(setting)).next();
                button.append(((CTxT)((CTxT)((CTxT)LANG.get(String.valueOf((Object)setting) + "." + String.valueOf(player.getPCache().getHud().getSetting(setting)), new Object[0]).btn(true)).color(CUtl.s())).click(1, "/hud settings set-r " + String.valueOf((Object)setting) + " " + String.valueOf((Object)nextType))).hover(LANG.hover("set", LANG.get("category", LANG.get("category.hud", new Object[0]), LANG.get(setting.toString(), new Object[0])), LANG.get(String.valueOf((Object)setting) + "." + String.valueOf((Object)nextType), new Object[0]).color(CUtl.s()))));
            }
            if (setting.equals((Object)Setting.bossbar__color)) {
                button.append(((CTxT)((CTxT)((CTxT)LANG.get(String.valueOf((Object)setting) + "." + String.valueOf(player.getPCache().getHud().getSetting(setting)), new Object[0]).btn(true)).color(Assets.barColor(Setting.BarColor.valueOf((String)player.getPCache().getHud().getSetting(setting))))).click(2, "/hud settings set-r " + String.valueOf((Object)setting) + " ")).hover(LANG.hover("set.custom", LANG.get("category", LANG.get("category.bossbar", new Object[0]), LANG.get(setting.toString(), new Object[0])))));
            }
            if (setting.equals((Object)Setting.bossbar__distance)) {
                boolean state = (Boolean)player.getPCache().getHud().getSetting(setting);
                button.append(CUtl.toggleBtn(state, "/hud settings set-r " + String.valueOf((Object)setting) + " ")).append(" ");
                button.append(((CTxT)((CTxT)((CTxT)CTxT.of(String.valueOf((Integer)player.getPCache().getHud().getSetting(Setting.bossbar__distance_max))).btn(true)).color((Boolean)player.getPCache().getHud().getSetting(setting) != false ? (char)'a' : 'c')).click(2, "/hud settings set-r " + String.valueOf((Object)Setting.bossbar__distance_max) + " ")).hover(LANG.hover("set.custom", LANG.get("category", LANG.get("category.bossbar", new Object[0]), LANG.get(Setting.bossbar__distance_max.toString(), new Object[0]))).append("\n").append((CTxT)((CTxT)LANG.get(String.valueOf((Object)setting) + "_max.hover", new Object[0]).italic(true)).color('7'))));
            }
            return button;
        }

        public static void UI(Player player, CTxT aboveTxT) {
            CTxT msg = CTxT.of("");
            if (aboveTxT != null) {
                msg.append(aboveTxT).append("\n");
            }
            msg.append(" ").append((CTxT)LANG.ui().color("#e9e9e9")).append((CTxT)CTxT.of("\n                              \n").strikethrough(true));
            msg.append(" ").append((CTxT)LANG.get("category.hud", new Object[0]).color(CUtl.p())).append(":\n  ");
            msg.append(settings.resetBtn(player, Setting.state)).append(" ").append(LANG.get(String.valueOf((Object)Setting.state) + ".ui", new Object[0]).hover(CTxT.of(LANG.get(String.valueOf((Object)Setting.state) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.hover("info.toggle", LANG.get("category.hud", new Object[0]), LANG.get(Setting.state.toString(), new Object[0])).color('7')))).append(": ").append(settings.getButtons(player, Setting.state)).append("\n  ");
            msg.append(settings.resetBtn(player, Setting.type)).append(" ").append(LANG.get(String.valueOf((Object)Setting.type) + ".ui", new Object[0]).hover(CTxT.of(LANG.get(String.valueOf((Object)Setting.type) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.hover("info", LANG.get("category.hud", new Object[0]), LANG.get(Setting.type.toString(), new Object[0])).color('7')))).append(": ").append(settings.getButtons(player, Setting.type)).append("\n");
            msg.append(" ").append((CTxT)LANG.get("category.bossbar", new Object[0]).color(CUtl.p())).append(":\n  ");
            msg.append(settings.resetBtn(player, Setting.bossbar__color)).append(" ").append(LANG.get(String.valueOf((Object)Setting.bossbar__color) + ".ui", new Object[0]).hover(CTxT.of(LANG.get(String.valueOf((Object)Setting.bossbar__color) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.hover("info", LANG.get("category.bossbar", new Object[0]), LANG.get(Setting.bossbar__color.toString(), new Object[0])).color('7')))).append(": ").append(settings.getButtons(player, Setting.bossbar__color)).append("\n  ");
            msg.append(settings.resetBtn(player, Setting.bossbar__distance)).append(" ").append(LANG.get(String.valueOf((Object)Setting.bossbar__distance) + ".ui", new Object[0]).hover(CTxT.of(LANG.get(String.valueOf((Object)Setting.bossbar__distance) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.bossbar__distance) + ".info", new Object[0]).color('7')).append("\n").append(LANG.get(String.valueOf((Object)Setting.bossbar__distance_max) + ".ui", new Object[0])).append("\n").append((CTxT)LANG.get(String.valueOf((Object)Setting.bossbar__distance) + ".info.2", new Object[0]).color('7')))).append(": ").append(settings.getButtons(player, Setting.bossbar__distance)).append("\n");
            CTxT reset = (CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('7');
            boolean resetOn = false;
            for (Setting t : Setting.baseSettings()) {
                if (resetOn) break;
                resetOn = settings.canBeReset(player, t);
            }
            if (resetOn) {
                ((CTxT)((CTxT)reset.color('c')).click(1, "/hud settings reset-r all")).hover(CUtl.LANG.hover("reset.settings", CUtl.LANG.hover("reset.fill", new Object[0]), CUtl.LANG.btn("all", new Object[0]).color(CUtl.s())));
            }
            msg.append("\n    ").append(reset).append("  ").append(CUtl.CButton.back("/hud")).append("\n").append((CTxT)CTxT.of("                              ").strikethrough(true));
            player.sendMessage(msg);
        }
    }

    public static class color {
        public static final Lang LANG = new Lang("hud.color.");

        public static CTxT button() {
            return ((CTxT)((CTxT)((CTxT)LANG.btn().btn(true)).rainbow(new Rainbow(15.0f, 45.0f))).click(1, "/hud color")).hover(((CTxT)CTxT.of("/hud color").rainbow(new Rainbow(15.0f, 45.0f))).append("\n").append(LANG.hover()));
        }

        public static void cmdExecutor(Player player, String[] args) {
            if (args.length == 0) {
                color.UI(player, null);
                return;
            }
            boolean Return = args[0].contains("-r");
            args[0] = args[0].replace("-r", "");
            if (args[0].equals("reset")) {
                if (args.length == 2) {
                    color.reset(player, null, args[1], Return);
                }
                if (args.length == 3) {
                    color.reset(player, args[2], args[1], Return);
                }
            }
            if (Helper.Enums.contains(args[0], HudColor.class)) {
                if (args.length == 1) {
                    color.changeUI(player, "normal", HudColor.fromName(args[0]), null);
                    return;
                }
                if (args[1].equals("edit")) {
                    color.changeUI(player, args.length == 3 ? args[2] : "normal", HudColor.fromName(args[0]), null);
                    return;
                }
                if (args.length < 3) {
                    return;
                }
                if (args[1].equals("set")) {
                    color.setColor(player, null, args[0], args[2], false);
                } else {
                    color.setToggle(player, args.length == 4 ? args[3] : "normal", args[0], ColorToggle.get(args[1]), args[2].equals("on"), Return);
                }
            }
        }

        public static ArrayList<String> cmdSuggester(Player player, int pos, String[] args) {
            ArrayList<String> suggester = new ArrayList<String>();
            if (pos == 0) {
                suggester.add("reset");
                suggester.add("primary");
                suggester.add("secondary");
                return suggester;
            }
            args[0] = args[0].replaceAll("-r", "");
            if (pos == 1) {
                if (args[0].equals("reset")) {
                    suggester.add("all");
                    suggester.add("primary");
                    suggester.add("secondary");
                } else {
                    suggester.add("set");
                    suggester.add("bold");
                    suggester.add("italics");
                    suggester.add("rainbow");
                }
            }
            if (pos == 2) {
                if (args[1].equals("set")) {
                    return Helper.Command.Suggester.colors(player, Helper.Command.Suggester.getCurrent(args, pos), true);
                }
                if (Helper.Enums.contains(args[0], HudColor.class)) {
                    suggester.add("on");
                    suggester.add("off");
                }
            }
            return suggester;
        }

        public static PDHud.Color defaultEntry(Player player, int typ) {
            PDHud.Color color2 = typ == 1 ? PlayerData.getDefaults().getHud().getPrimary() : PlayerData.getDefaults().getHud().getSecondary();
            color2.setPlayer(player);
            return color2;
        }

        public static PDHud.Color getEntry(Player player, int typ) {
            if (typ == 1) {
                return player.getPCache().getHud().getPrimary();
            }
            return player.getPCache().getHud().getSecondary();
        }

        public static void setEntry(Player player, int typ, PDHud.Color entry) {
            if (typ == 1) {
                player.getPData().getHud().setPrimary(entry);
            } else {
                player.getPData().getHud().setSecondary(entry);
            }
        }

        public static void reset(Player player, String UISettings, String type, boolean Return) {
            switch (type) {
                case "all": {
                    player.getPData().getHud().setPrimary(color.defaultEntry(player, 1));
                    player.getPData().getHud().setSecondary(color.defaultEntry(player, 2));
                    break;
                }
                case "primary": {
                    player.getPData().getHud().setPrimary(color.defaultEntry(player, 1));
                    break;
                }
                case "secondary": {
                    player.getPData().getHud().setSecondary(color.defaultEntry(player, 2));
                    break;
                }
                default: {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                    return;
                }
            }
            CTxT msg = CUtl.tag().append(LANG.msg("reset", LANG.get(type, new Object[0]).color('c')));
            if (Return && type.equals("all")) {
                color.UI(player, msg);
            } else if (Return) {
                color.changeUI(player, UISettings, HudColor.fromName(type), msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static void setColor(Player player, String UISettings, String type, String color2, boolean Return) {
            int typ = type.equals("primary") ? 1 : 2;
            PDHud.Color colorEntry = color.getEntry(player, typ);
            colorEntry.setColor(CUtl.color.colorHandler(player, color2, color.defaultEntry(player, typ).getColor()));
            color.setEntry(player, typ, colorEntry);
            if (Return) {
                color.changeUI(player, UISettings, HudColor.fromName(type), null);
            } else {
                player.sendMessage(CUtl.tag().append(LANG.msg("set", LANG.get(type, new Object[0]), CUtl.color.getBadge(colorEntry.getColor()))));
            }
        }

        public static void setToggle(Player player, String UISettings, String colorType, ColorToggle colorToggle, boolean state, boolean Return) {
            int typ = colorType.equals("primary") ? 1 : 2;
            PDHud.Color colorEntry = color.getEntry(player, typ);
            switch (colorToggle.ordinal()) {
                case 0: {
                    colorEntry.setBold(state);
                    break;
                }
                case 1: {
                    colorEntry.setItalics(state);
                    break;
                }
                case 2: {
                    colorEntry.setRainbow(state);
                    break;
                }
                case 3: {
                    player.sendMessage(CUtl.error("args", new Object[0]));
                    return;
                }
            }
            color.setEntry(player, typ, colorEntry);
            CTxT msg = CUtl.tag().append(LANG.msg("toggle", CUtl.toggleTxT(state), LANG.get(colorType, new Object[0]), LANG.get(colorToggle.toString(), new Object[0])));
            if (Return) {
                color.changeUI(player, UISettings, HudColor.fromName(colorType), msg);
            } else {
                player.sendMessage(msg);
            }
        }

        public static CTxT addColor(Player player, String txt, HudColor color2, Rainbow rainbow) {
            PDHud.Color colorSettings = color2.getSettings(player);
            CTxT output = (CTxT)((CTxT)CTxT.of(txt).italic(colorSettings.getItalics())).bold(colorSettings.getBold());
            if (colorSettings.getRainbow().booleanValue()) {
                return (CTxT)output.rainbow(rainbow);
            }
            return (CTxT)output.color(colorSettings.getColor());
        }

        public static CTxT addColor(Player player, CTxT txt, HudColor color2, Rainbow rainbow) {
            return color.addColor(player, txt.toString(), color2, rainbow);
        }

        public static void changeUI(Player player, String setting, HudColor color2, CTxT aboveTxT) {
            if (color2 == null) {
                player.sendMessage(CUtl.error("args", new Object[0]));
                return;
            }
            CTxT msg = CTxT.of("");
            CTxT line = CUtl.makeLine(31);
            if (aboveTxT != null) {
                msg.append(aboveTxT).append("\n");
            }
            PDHud.Color colorData = color2.getSettings(player);
            msg.append(" ").append(color.addColor(player, LANG.btn(color2.toString(), new Object[0]), color2, new Rainbow(15.0f, 20.0f))).append(line).append("\n");
            CTxT reset = ((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('c')).click(1, "/hud color reset-r " + setting + " " + setting)).hover(LANG.hover("reset", color.addColor(player, LANG.get(setting, new Object[0]), color2, new Rainbow(15.0f, 20.0f))));
            CTxT boldButton = ((CTxT)((CTxT)((CTxT)LANG.btn("bold", new Object[0]).btn(true)).color(CUtl.toggleColor(colorData.getBold()))).click(1, String.format("/hud color %s-r bold %s %s", new Object[]{color2, colorData.getBold() != false ? "off" : "on", setting}))).hover(LANG.hover("toggle", CUtl.toggleTxT(colorData.getBold() == false), LANG.get("bold", new Object[0]).bold(true)));
            CTxT italicsButton = ((CTxT)((CTxT)((CTxT)LANG.btn("italics", new Object[0]).btn(true)).color(CUtl.toggleColor(colorData.getItalics()))).click(1, String.format("/hud color %s-r italics %s %s", new Object[]{color2, colorData.getItalics() != false ? "off" : "on", setting}))).hover(LANG.hover("toggle", CUtl.toggleTxT(colorData.getItalics() == false), LANG.get("italics", new Object[0]).italic(true)));
            CTxT rgbButton = ((CTxT)((CTxT)((CTxT)LANG.btn("rgb", new Object[0]).btn(true)).color(CUtl.toggleColor(colorData.getRainbow()))).click(1, String.format("/hud color %s-r rainbow %s %s", new Object[]{color2, colorData.getRainbow() != false ? "off" : "on", setting}))).hover(LANG.hover("toggle", CUtl.toggleTxT(colorData.getRainbow() == false), LANG.get("rainbow", new Object[0]).rainbow(new Rainbow(15.0f, 20.0f))));
            msg.append(DHud.preset.colorEditor(colorData.getColor(), setting, DHud.preset.Type.hud, color2.toString(), "/hud color " + String.valueOf((Object)color2) + " edit %s")).append("\n\n ").append(boldButton).append(" ").append(italicsButton).append(" ").append(rgbButton).append("\n\n     ").append(reset).append(" ").append(CUtl.CButton.back("/hud color")).append(line);
            player.sendMessage(msg);
        }

        public static void UI(Player player, CTxT aboveTxT) {
            CTxT msg = CTxT.of("");
            CTxT line = (CTxT)CTxT.of("\n                                ").strikethrough(true);
            if (aboveTxT != null) {
                msg.append(aboveTxT).append("\n");
            }
            msg.append(" ").append((CTxT)LANG.ui().rainbow(new Rainbow(15.0f, 45.0f))).append(line).append("\n ").append(((CTxT)((CTxT)color.addColor(player, LANG.btn("primary", new Object[0]), HudColor.PRIMARY, new Rainbow(15.0f, 20.0f)).btn(true)).click(1, "/hud color primary edit")).hover(LANG.hover("edit", color.addColor(player, LANG.get("primary", new Object[0]), HudColor.PRIMARY, new Rainbow(15.0f, 20.0f))))).append(" ").append(((CTxT)((CTxT)color.addColor(player, LANG.btn("secondary", new Object[0]), HudColor.SECONDARY, new Rainbow(15.0f, 20.0f)).btn(true)).click(1, "/hud color secondary edit")).hover(LANG.hover("edit", color.addColor(player, LANG.get("secondary", new Object[0]), HudColor.SECONDARY, new Rainbow(15.0f, 20.0f))))).append("\n\n      ").append(((CTxT)((CTxT)((CTxT)CUtl.LANG.btn("reset", new Object[0]).btn(true)).color('c')).click(1, "/hud color reset-r all")).hover(LANG.hover("reset", LANG.get("all", new Object[0]).color('c')))).append("  ").append(CUtl.CButton.back("/hud")).append(line);
            player.sendMessage(msg);
        }

        public static enum ColorToggle {
            bold,
            italics,
            rainbow,
            unknown;


            public static ColorToggle get(String s) {
                try {
                    return ColorToggle.valueOf(s);
                }
                catch (IllegalArgumentException e) {
                    return unknown;
                }
            }
        }
    }

    public static enum Setting {
        state,
        type,
        bossbar__color,
        bossbar__distance,
        bossbar__distance_max,
        none;


        public String toString() {
            return this.name().replace("__", ".");
        }

        public static Setting get(String s) {
            try {
                return Setting.valueOf(s.replace(".", "__"));
            }
            catch (IllegalArgumentException e) {
                return none;
            }
        }

        public static ArrayList<Setting> baseSettings() {
            ArrayList<Setting> list = new ArrayList<Setting>(Arrays.asList(Setting.values()));
            list.remove((Object)none);
            return list;
        }

        public static ArrayList<Setting> boolSettings() {
            ArrayList<Setting> list = new ArrayList<Setting>();
            list.add(state);
            list.add(bossbar__distance);
            return list;
        }

        public static enum BarColor {
            pink,
            blue,
            red,
            green,
            yellow,
            purple,
            white;

        }

        public static enum DisplayType {
            actionbar,
            bossbar;

            private static final DisplayType[] values;

            public DisplayType next() {
                return values[(this.ordinal() + 1) % values.length];
            }

            public static DisplayType get(String s) {
                try {
                    return DisplayType.valueOf(s);
                }
                catch (IllegalArgumentException e) {
                    return DisplayType.valueOf(PlayerData.getDefaults().getHud().getSetting().getType());
                }
            }

            static {
                values = DisplayType.values();
            }
        }
    }

    public static class build {
        public static CTxT compile(Player player, ModuleInstructions instructions) {
            player.getPCache().getRainbow(HudColor.PRIMARY).setPosition(LoopManager.rainbowF);
            CTxT msg = CTxT.of("");
            int count = 0;
            for (BaseModule mod : modules.getEnabled(player)) {
                Module module = mod.getModuleType();
                ++count;
                if (instructions.get(module).isEmpty()) continue;
                msg.append(CUtl.parse(player, instructions.get(module)));
                if (count >= modules.getEnabled(player).size()) continue;
                msg.append(" ");
            }
            if (msg.isEmpty()) {
                return msg;
            }
            msg.click(3, "https://modrinth.com/mod/directionhud");
            return msg;
        }

        public static ModuleInstructions getModuleInstructions(Player player) {
            ModuleInstructions instructions = new ModuleInstructions();
            instructions.put(Module.COORDINATES, build.getCoordinatesModule(player));
            instructions.put(Module.DESTINATION, build.getDestinationModule(player));
            instructions.put(Module.DISTANCE, build.getDistanceModule(player));
            instructions.put(Module.TRACKING, build.getTrackingModule(player));
            instructions.put(Module.DIRECTION, build.getDirectionModule(player));
            instructions.put(Module.WEATHER, build.getWeatherModule(player));
            instructions.put(Module.TIME, build.getTimeModule(player));
            instructions.put(Module.ANGLE, build.getAngleModule(player));
            instructions.put(Module.SPEED, build.getSpeedModule(player));
            return instructions;
        }

        public static String getCoordinatesModule(Player player) {
            ModuleCoordinates module = (ModuleCoordinates)player.getPCache().getHud().getModule(Module.COORDINATES);
            if (!module.isEnabled()) {
                return "";
            }
            return build.getCoordinatesModule(module, player.getLoc());
        }

        public static String getCoordinatesModule(ModuleCoordinates coordinatesModule, Loc loc) {
            if (coordinatesModule.isXyz()) {
                return String.format(FileData.getModuleText().getCoordinates().getXyz(), loc.getX(), loc.getY(), loc.getZ());
            }
            return String.format(FileData.getModuleText().getCoordinates().getXz(), loc.getX(), loc.getZ());
        }

        public static String getDestinationModule(Player player) {
            ModuleDestination module = (ModuleDestination)player.getPCache().getHud().getModule(Module.DESTINATION);
            if (!module.isEnabled()) {
                return "";
            }
            Dest dest2 = Destination.dest.get(player);
            if (!dest2.hasXYZ()) {
                return "";
            }
            return build.getDestinationModule(module, dest2);
        }

        public static String getDestinationModule(ModuleDestination destinationModule, Dest dest2) {
            ModuleText.ModuleDestination moduleDestination = FileData.getModuleText().getDestination();
            if (dest2.getName() != null && dest2.hasY()) {
                return String.format(moduleDestination.getName(), dest2.getName(), dest2.getX(), dest2.getY(), dest2.getZ());
            }
            if (dest2.getName() != null) {
                return String.format(moduleDestination.getNameXz(), dest2.getName(), dest2.getX(), dest2.getZ());
            }
            if (dest2.hasY()) {
                return String.format(moduleDestination.getXyz(), dest2.getX(), dest2.getY(), dest2.getZ(), dest2.getZ());
            }
            return String.format(moduleDestination.getXz(), dest2.getX(), dest2.getZ());
        }

        public static String getDistanceModule(Player player) {
            ModuleDistance module = (ModuleDistance)player.getPCache().getHud().getModule(Module.DISTANCE);
            if (!module.isEnabled()) {
                return "";
            }
            int distance = Destination.dest.getDist(player);
            if (distance == -1) {
                return "";
            }
            return build.getDistanceModule(module, distance);
        }

        public static String getDistanceModule(ModuleDistance distanceModule, int distance) {
            return String.format(FileData.getModuleText().getDistance().getNumber(), distance);
        }

        public static String getTrackingModule(Player player) {
            Player target;
            ModuleTracking module = (ModuleTracking)player.getPCache().getHud().getModule(Module.TRACKING);
            if (!module.isEnabled()) {
                return "";
            }
            Loc pointLoc = null;
            ModuleTracking tracking = (ModuleTracking)player.getPCache().getHud().getModule(Module.TRACKING);
            ModuleTracking.Target trackingTarget = tracking.getTarget();
            boolean hybrid = tracking.isHybrid();
            if ((trackingTarget.equals((Object)ModuleTracking.Target.player) || hybrid) && (target = Destination.social.track.getTarget(player)).isValid()) {
                Loc plLoc = new Loc(target);
                if (!player.getDimension().equals(target.getDimension())) {
                    if (Dimension.canConvert(player.getDimension(), target.getDimension()) && player.getPCache().getDEST().getDestSettings().getAutoconvert().booleanValue()) {
                        plLoc.convertTo(player.getDimension());
                    } else {
                        plLoc = null;
                    }
                }
                pointLoc = plLoc;
            }
            if ((trackingTarget.equals((Object)ModuleTracking.Target.dest) || hybrid && pointLoc == null) && Destination.dest.get(player).hasXYZ()) {
                pointLoc = Destination.dest.get(player);
            }
            if (pointLoc == null) {
                return "";
            }
            double rotation = player.getYaw() + 180.0f;
            return build.getTrackingModule(module, rotation, player.getLoc(), pointLoc);
        }

        public static String getTrackingModule(ModuleTracking trackingModule, double originRotation, Loc originLoc, Loc targetLoc) {
            String data;
            int z;
            boolean simple = trackingModule.getType().equals((Object)ModuleTracking.Type.simple);
            ModuleText.ModuleTracking.Assets assets = FileData.getModuleText().getTracking().getAssets();
            ModuleText.ModuleTracking.Assets.Simple simpleArrows = assets.getSimple();
            ModuleText.ModuleTracking.Assets.Compact compactArrows = assets.getCompact();
            ModuleText.ModuleTracking.Assets.Elevation elevationArrows = assets.getElevation();
            int x = targetLoc.getX() - originLoc.getX();
            double target = Math.toDegrees(Math.atan2(x, z = (targetLoc.getZ() - originLoc.getZ()) * -1));
            if (target < 0.0) {
                target += 360.0;
            }
            if (Helper.Num.inBetween(originRotation, Helper.Num.wSubtract(target, 15.0, 360.0), Helper.Num.wAdd(target, 15.0, 360.0))) {
                data = simple ? simpleArrows.getNorth() : compactArrows.getNorth();
            } else if (Helper.Num.inBetween(originRotation, target, Helper.Num.wAdd(target, 65.0, 360.0))) {
                data = simple ? simpleArrows.getNorthWest() : compactArrows.getNorthWest();
            } else if (Helper.Num.inBetween(originRotation, target, Helper.Num.wAdd(target, 115.0, 360.0))) {
                data = simple ? simpleArrows.getWest() : compactArrows.getWest();
            } else if (Helper.Num.inBetween(originRotation, target, Helper.Num.wAdd(target, 165.0, 360.0))) {
                data = simple ? simpleArrows.getSouthWest() : compactArrows.getSouthWest();
            } else if (Helper.Num.inBetween(originRotation, Helper.Num.wSubtract(target, 65.0, 360.0), target)) {
                data = simple ? simpleArrows.getNorthEast() : compactArrows.getNorthEast();
            } else if (Helper.Num.inBetween(originRotation, Helper.Num.wSubtract(target, 115.0, 360.0), target)) {
                data = simple ? simpleArrows.getEast() : compactArrows.getEast();
            } else if (Helper.Num.inBetween(originRotation, Helper.Num.wSubtract(target, 165.0, 360.0), target)) {
                data = simple ? simpleArrows.getSouthEast() : compactArrows.getSouthEast();
            } else {
                String string = data = simple ? simpleArrows.getSouth() : compactArrows.getSouth();
            }
            if (trackingModule.hasElevation()) {
                int originY = originLoc.getY();
                int targetY = targetLoc.getY();
                String elevation = !targetLoc.hasY() || originY - 2 < targetY && targetY < originY + 2 ? elevationArrows.getSame() : (originY > targetY ? elevationArrows.getBelow() : elevationArrows.getAbove());
                return String.format(FileData.getModuleText().getTracking().getElevationTracking(), data, elevation);
            }
            return String.format(FileData.getModuleText().getTracking().getTracking(), data);
        }

        public static String getDirectionModule(Player player) {
            ModuleDirection module = (ModuleDirection)player.getPCache().getHud().getModule(Module.DIRECTION);
            if (!module.isEnabled()) {
                return "";
            }
            double rotation = player.getYaw() + 180.0f;
            return build.getDirectionModule(module, rotation);
        }

        public static String getDirectionModule(ModuleDirection directionModule, double rotation) {
            ModuleText.ModuleDirection.Assets.Cardinal cardinals = FileData.getModuleText().getDirection().getAssets().getCardinal();
            String cardinal = Helper.Num.inBetween(rotation, 22.5, 67.5) ? cardinals.getNorthEast() : (Helper.Num.inBetween(rotation, 67.5, 112.5) ? cardinals.getEast() : (Helper.Num.inBetween(rotation, 112.5, 157.5) ? cardinals.getSouthEast() : (Helper.Num.inBetween(rotation, 157.5, 202.5) ? cardinals.getSouth() : (Helper.Num.inBetween(rotation, 202.5, 247.5) ? cardinals.getSouthWest() : (Helper.Num.inBetween(rotation, 247.5, 292.5) ? cardinals.getWest() : (Helper.Num.inBetween(rotation, 292.5, 337.5) ? cardinals.getNorthWest() : cardinals.getNorth()))))));
            return String.format(FileData.getModuleText().getDirection().getFacing(), cardinal);
        }

        public static String getWeatherModule(Player player) {
            boolean night;
            ModuleWeather module = (ModuleWeather)player.getPCache().getHud().getModule(Module.WEATHER);
            DimensionEntry.Time timeSettings = Dimension.getTimeSettings(player.getDimension());
            DimensionEntry.Time.Weather weatherSettings = timeSettings.getWeather();
            if (!(module.isEnabled() && timeSettings.getEnabled().booleanValue() && weatherSettings.getEnabled().booleanValue())) {
                return "";
            }
            int timeTicks = player.getTimeOfDay();
            DimensionEntry.Time.Weather.NightTicks nightTicks = weatherSettings.getNightTicks();
            DimensionEntry.Time.Weather.Icons weatherIcons = weatherSettings.getIcons();
            String extraIcons = null;
            if (player.hasThunderstorm()) {
                extraIcons = weatherIcons.thunderstorm();
                night = Helper.Num.inBetween(timeTicks, nightTicks.thunderstorm().startTick().intValue(), nightTicks.thunderstorm().endTick().intValue());
            } else if (player.hasStorm()) {
                extraIcons = weatherIcons.storm();
                night = Helper.Num.inBetween(timeTicks, nightTicks.storm().startTick().intValue(), nightTicks.storm().endTick().intValue());
            } else {
                night = Helper.Num.inBetween(timeTicks, nightTicks.normal().startTick().intValue(), nightTicks.normal().endTick().intValue());
            }
            String weatherIcon = night ? weatherIcons.night() : weatherIcons.day();
            return build.getWeatherModule(module, weatherIcon, extraIcons);
        }

        public static String getWeatherModule(ModuleWeather weatherModule, String weatherIcon, String extraIcons) {
            if (extraIcons == null) {
                return String.format(FileData.getModuleText().getWeather().getWeatherSingle(), weatherIcon);
            }
            return String.format(FileData.getModuleText().getWeather().getWeather(), weatherIcon, extraIcons);
        }

        public static String getTimeModule(Player player) {
            ModuleTime module = (ModuleTime)player.getPCache().getHud().getModule(Module.TIME);
            DimensionEntry.Time timeSettings = Dimension.getTimeSettings(player.getDimension());
            if (!module.isEnabled() || !timeSettings.getEnabled().booleanValue()) {
                return "";
            }
            int timeTicks = player.getTimeOfDay();
            int hour = (timeTicks / 1000 + 6) % 24;
            int minute = timeTicks % 1000 * 60 / 1000;
            return build.getTimeModule(module, hour, minute);
        }

        public static String getTimeModule(ModuleTime timeModule, int hour, int minute) {
            int hourMod;
            boolean time12;
            boolean bl = time12 = !timeModule.isHour24();
            String hr = time12 ? ((hourMod = hour % 12) == 0 ? String.valueOf(12) : String.valueOf(hourMod)) : Helper.Num.formatToTwoDigits(hour);
            String min = Helper.Num.formatToTwoDigits(minute);
            ModuleText.ModuleTime time = FileData.getModuleText().getTime();
            String formatString = time12 ? (hour >= 12 ? time.getHourPM() : time.getHourAM()) : time.getHour24();
            return String.format(formatString, hr, min);
        }

        public static String getAngleModule(Player player) {
            ModuleAngle module = (ModuleAngle)player.getPCache().getHud().getModule(Module.ANGLE);
            if (!module.isEnabled()) {
                return "";
            }
            return build.getAngleModule(module, player.getYaw(), player.getPitch());
        }

        public static String getAngleModule(ModuleAngle angleModule, float yaw, float pitch) {
            DecimalFormat df = new DecimalFormat("0.0");
            String y = df.format(yaw);
            String p = df.format(pitch);
            return switch (angleModule.getDisplay()) {
                default -> throw new IncompatibleClassChangeError();
                case ModuleAngle.Display.yaw -> String.format(FileData.getModuleText().getAngle().getYaw(), y);
                case ModuleAngle.Display.pitch -> String.format(FileData.getModuleText().getAngle().getPitch(), p);
                case ModuleAngle.Display.both -> String.format(FileData.getModuleText().getAngle().getBoth(), y, p);
            };
        }

        public static String getSpeedModule(Player player) {
            ModuleSpeed module = (ModuleSpeed)player.getPCache().getHud().getModule(Module.SPEED);
            if (!module.isEnabled()) {
                return "";
            }
            return build.getSpeedModule(module, player.getPCache().getSpeedData().getSpeed());
        }

        public static String getSpeedModule(ModuleSpeed speedModule, double speed) {
            boolean speed2D = speedModule.isCalculation2D();
            DecimalFormat df = new DecimalFormat(speedModule.getDisplayPattern());
            String data = df.format(speed);
            if (speed2D) {
                return String.format(FileData.getModuleText().getSpeed().getXzSpeed(), data);
            }
            return String.format(FileData.getModuleText().getSpeed().getXyzSpeed(), data);
        }
    }
}

