/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud;

import java.util.Arrays;
import one.oth3r.directionhud.common.files.playerdata.PDHud;
import one.oth3r.directionhud.utils.Player;

public enum HudColor {
    PRIMARY("primary", 1),
    SECONDARY("secondary", 2);

    private final String name;
    private final int id;

    private HudColor(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public PDHud.Color getSettings(Player player) {
        return player.getPCache().getHud().getColor(this);
    }

    public static HudColor fromId(int id) {
        return Arrays.stream(HudColor.values()).filter(color2 -> color2.getId() == id).findFirst().orElse(null);
    }

    public static HudColor fromName(String name) {
        return Arrays.stream(HudColor.values()).filter(color2 -> color2.getName().equals(name)).findFirst().orElse(null);
    }

    public String toString() {
        return this.name;
    }
}

