/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.common.hud.module;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import one.oth3r.directionhud.common.hud.module.Module;

public abstract class BaseModule
implements Cloneable {
    @SerializedName(value="module")
    protected final Module moduleType;
    @SerializedName(value="order")
    protected int order;
    @SerializedName(value="state")
    protected boolean state;

    public BaseModule(Module moduleType) {
        this.moduleType = moduleType;
    }

    public BaseModule(Module moduleType, int order, boolean state) {
        this.moduleType = moduleType;
        this.order = order;
        this.state = state;
    }

    public int getOrder() {
        return this.order;
    }

    public String[] getSettingIDs() {
        return new String[0];
    }

    public boolean hasExtraSettings() {
        return this.getSettingIDs().length > 0;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isEnabled() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public Module getModuleType() {
        return this.moduleType;
    }

    public abstract BaseModule clone();

    public String toString() {
        return this.moduleType.getName();
    }

    public static Optional<BaseModule> findInArrayList(ArrayList<BaseModule> modules2, Module moduleType) {
        return modules2.stream().filter(baseModule -> baseModule.getModuleType().equals((Object)moduleType)).findFirst();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BaseModule)) {
            return false;
        }
        BaseModule that = (BaseModule)o;
        return this.order == that.order && this.state == that.state && this.moduleType == that.moduleType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.moduleType, this.order, this.state});
    }
}

